/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;

public class ObservationGroup {
    private int groupId;
    private List<Observation> observations = new ArrayList<Observation>();
    private final Epoch epoch;
    private final double sigmaA;
    private final double sigmaB;
    private final double sigmaC;
    private Set<Observation> excludedObservationsDuringAvaraging = null;

    public ObservationGroup(int id, double sigmaA, double sigmaB, double sigmaC, Epoch epoch) {
        if (sigmaA <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " Fehler, Gruppen ID oder Standardabweichung unzulassig!");
        }
        this.groupId = id;
        this.sigmaA = sigmaA;
        this.sigmaB = sigmaB > 0.0 ? sigmaB : 0.0;
        this.sigmaC = sigmaC > 0.0 ? sigmaC : 0.0;
        this.epoch = epoch;
    }

    public int getId() {
        return this.groupId;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public void add(Observation observation) {
        if (observation.getStd() <= 0.0) {
            observation.setStd(this.getStd(observation));
            observation.useGroupUncertainty(true);
        }
        if (this.getId() >= 0 && (observation.getObservationGroup() == null || observation.getObservationGroup().getId() < 0)) {
            observation.setObservationGroup(this);
        }
        this.observations.add(observation);
    }

    public Observation get(int index) {
        return this.observations.get(index);
    }

    public int size() {
        return this.observations.size();
    }

    double getStdA() {
        return this.sigmaA;
    }

    double getStdB() {
        return this.sigmaB;
    }

    double getStdC() {
        return this.sigmaC;
    }

    public double getStdA(Observation observation) {
        return this.getStdA();
    }

    public double getStdB(Observation observation) {
        return this.getStdB();
    }

    public double getStdC(Observation observation) {
        return this.getStdC();
    }

    public double getStd(Observation observation) {
        double sigmaA = this.getStdA(observation);
        double sigmaB = this.getStdB(observation);
        double sigmaC = this.getStdC(observation);
        return Math.sqrt(sigmaA * sigmaA + sigmaB * sigmaB + sigmaC * sigmaC);
    }

    public int numberOfAdditionalUnknownParameter() {
        return 0;
    }

    protected boolean removeObservation(Observation observation) {
        return this.observations.remove(observation);
    }

    protected void clearObservations() {
        this.observations.clear();
    }

    public AdditionalUnknownParameter setApproximatedValue(AdditionalUnknownParameter param) {
        return param;
    }

    public void averageDetermination(double threshold) {
        this.excludedObservationsDuringAvaraging = new LinkedHashSet<Observation>(Math.max(10, this.size() / 4));
        int i = 0;
        while (i < this.size()) {
            Observation avgObs = this.get(i);
            String startPointId = avgObs.getStartPoint().getName();
            String endPointId = avgObs.getEndPoint().getName();
            ArrayList<Observation> avgObservations = new ArrayList<Observation>(Math.max(10, this.size() / 4));
            double ih = avgObs.getStartPointHeight();
            double th = avgObs.getEndPointHeight();
            avgObservations.add(avgObs);
            ObservationType avgType = avgObs.getObservationType();
            ComponentType avgSubType = null;
            if (avgType == ObservationType.GNSS1D || avgType == ObservationType.GNSS2D || avgType == ObservationType.GNSS3D) {
                avgSubType = ((GNSSBaseline)avgObs).getComponentType();
            }
            int j = i + 1;
            while (j < this.size()) {
                Observation obs = this.get(j);
                String obsStartPointId = obs.getStartPoint().getName();
                String obsEndPointId = obs.getEndPoint().getName();
                ObservationType obsType = obs.getObservationType();
                ComponentType obsSubType = null;
                if (obsType == ObservationType.GNSS1D || obsType == ObservationType.GNSS2D || obsType == ObservationType.GNSS3D) {
                    obsSubType = ((GNSSBaseline)obs).getComponentType();
                }
                double obsIh = obs.getStartPointHeight();
                double obsTh = obs.getEndPointHeight();
                if (obsStartPointId.equals(startPointId) && obsEndPointId.equals(endPointId) && obsIh == ih && obsTh == th && (obsSubType == null && avgSubType == null || obsSubType != null && avgSubType != null && obsSubType == avgSubType)) {
                    avgObservations.add(obs);
                    this.removeObservation(obs);
                    --j;
                }
                ++j;
            }
            if (avgObservations.size() > 1) {
                Collections.sort(avgObservations, new Comparator<Observation>(){

                    @Override
                    public int compare(Observation o1, Observation o2) {
                        return o1.getValueApriori() > o2.getValueApriori() ? 1 : -1;
                    }
                });
                double avgDist = 0.0;
                double avgValue = 0.0;
                Observation medianObs = (Observation)avgObservations.get((avgObservations.size() - 1) / 2);
                double median = medianObs.getValueApriori();
                if (avgObs != medianObs) {
                    double value = avgObs.getValueApriori();
                    medianObs.setValueApriori(value);
                    avgObs.setValueApriori(median);
                }
                int counter = 0;
                for (Observation obs : avgObservations) {
                    double value = obs.getValueApriori();
                    if (obs.getObservationType() == ObservationType.DIRECTION && Math.abs(value - median) > Math.abs(Math.abs(value - median) - Math.PI * 2)) {
                        value = value > median ? (value -= Math.PI * 2) : (value += Math.PI * 2);
                    }
                    if (Math.abs(value - median) <= threshold) {
                        avgValue += value;
                        avgDist += obs.getDistanceForUncertaintyModel();
                        ++counter;
                        continue;
                    }
                    obs.setGrossError(value - median);
                    this.excludedObservationsDuringAvaraging.add(obs);
                }
                avgValue /= (double)counter;
                avgDist /= (double)counter;
                if (avgObs.getObservationType() == ObservationType.DIRECTION || avgObs.getObservationType() == ObservationType.ZENITH_ANGLE) {
                    avgValue = MathExtension.MOD(avgValue, Math.PI * 2);
                }
                avgObs.setValueApriori(avgValue);
                if (avgDist > 0.0) {
                    avgObs.setDistanceForUncertaintyModel(avgDist);
                }
            }
            ++i;
        }
        if (this.excludedObservationsDuringAvaraging.size() == 0) {
            this.excludedObservationsDuringAvaraging = null;
        }
    }

    public boolean isEmpty() {
        return this.observations.isEmpty();
    }

    public Set<Observation> getExcludedObservationsDuringAvaraging() {
        return this.excludedObservationsDuringAvaraging;
    }

    public String toString() {
        return new String(String.valueOf(this.getClass()) + " Observation-Id: " + this.getId() + " Number of Observations " + this.size());
    }
}

