/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation.group;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline3D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaX3D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaY3D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaZ3D;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.RotationX;
import org.applied_geodesy.adjustment.network.parameter.RotationY;
import org.applied_geodesy.adjustment.network.parameter.RotationZ;
import org.applied_geodesy.adjustment.network.parameter.Scale;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.adjustment.network.point.Point3D;
import org.applied_geodesy.adjustment.network.point.group.PointGroup;

public class GNSSBaseline3DGroup
extends ObservationGroup {
    private Scale scale = new Scale();
    private RotationX rx = new RotationX();
    private RotationY ry = new RotationY();
    private RotationZ rz = new RotationZ();
    private boolean hasApproxValues = false;
    private double scaleParam = 1.0;
    private double rxParam = 0.0;
    private double ryParam = 0.0;
    private double rzParam = 0.0;

    public GNSSBaseline3DGroup(int id) {
        this(id, DefaultUncertainty.getUncertaintyGNSSZeroPointOffset(), DefaultUncertainty.getUncertaintyGNSSSquareRootDistanceDependent(), DefaultUncertainty.getUncertaintyGNSSDistanceDependent(), Epoch.REFERENCE);
    }

    public GNSSBaseline3DGroup(int id, double sigmaA, double sigmaB, double sigmaC, Epoch epoch) {
        super(id, sigmaA, sigmaB, sigmaC, epoch);
        this.scale.setObservationGroup(this);
        this.rx.setObservationGroup(this);
        this.ry.setObservationGroup(this);
        this.rz.setObservationGroup(this);
    }

    @Override
    public void add(Observation gnss3D) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " Fehler, GNSS-Basislinien bestehen nicht aus 3D-Beobachtungen!");
    }

    private void add(GNSSBaseline3D gnss3D) {
        gnss3D.setScale(this.scale);
        gnss3D.setRotationX(this.rx);
        gnss3D.setRotationY(this.ry);
        gnss3D.setRotationZ(this.rz);
        super.add(gnss3D);
    }

    public void add(GNSSBaselineDeltaX3D gnssX3D, GNSSBaselineDeltaY3D gnssY3D, GNSSBaselineDeltaZ3D gnssZ3D) {
        if (gnssX3D.getId() == gnssY3D.getId() && gnssX3D.getId() == gnssZ3D.getId() && gnssX3D.getStartPoint().getName().equals(gnssY3D.getStartPoint().getName()) && gnssX3D.getEndPoint().getName().equals(gnssY3D.getEndPoint().getName()) && gnssX3D.getStartPoint().getName().equals(gnssZ3D.getStartPoint().getName()) && gnssX3D.getEndPoint().getName().equals(gnssZ3D.getEndPoint().getName())) {
            this.add(gnssX3D);
            this.add(gnssY3D);
            this.add(gnssZ3D);
            gnssX3D.addAssociatedBaselineComponent(gnssY3D);
            gnssX3D.addAssociatedBaselineComponent(gnssZ3D);
            gnssY3D.addAssociatedBaselineComponent(gnssX3D);
            gnssY3D.addAssociatedBaselineComponent(gnssZ3D);
            gnssZ3D.addAssociatedBaselineComponent(gnssX3D);
            gnssZ3D.addAssociatedBaselineComponent(gnssY3D);
        }
    }

    @Override
    public double getStdA(Observation observation) {
        return this.getStdA();
    }

    @Override
    public double getStdB(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = Math.abs(observation.getValueApriori());
        }
        return this.getStdB() * Math.sqrt(dist / 1000.0);
    }

    @Override
    public double getStdC(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = Math.abs(observation.getValueApriori());
        }
        return this.getStdC() * dist;
    }

    public Scale getScale() {
        return this.scale;
    }

    public RotationX getRotationX() {
        return this.rx;
    }

    public RotationY getRotationY() {
        return this.ry;
    }

    public RotationZ getRotationZ() {
        return this.rz;
    }

    @Override
    public int numberOfAdditionalUnknownParameter() {
        int num = 0;
        if (this.rx.isEnable()) {
            ++num;
        }
        if (this.ry.isEnable()) {
            ++num;
        }
        if (this.rz.isEnable()) {
            ++num;
        }
        if (this.scale.isEnable()) {
            ++num;
        }
        return num;
    }

    @Override
    public AdditionalUnknownParameter setApproximatedValue(AdditionalUnknownParameter param) {
        if (!this.hasApproxValues) {
            double SQRT_EPS = Math.sqrt(Constant.EPS);
            PointGroup sourceSystem = new PointGroup(1);
            PointGroup targetSystem = new PointGroup(1);
            int i = 0;
            while (i < this.size()) {
                GNSSBaseline baseline = (GNSSBaseline)this.get(i);
                String id = String.valueOf(baseline.getId());
                Point trgPoint = targetSystem.get(id);
                if (trgPoint == null) {
                    trgPoint = new Point3D(id, 0.0, 0.0, 0.0);
                    targetSystem.add(trgPoint);
                }
                if (baseline.getComponentType() == ComponentType.X) {
                    trgPoint.setX(baseline.getValueApriori());
                } else if (baseline.getComponentType() == ComponentType.Y) {
                    trgPoint.setY(baseline.getValueApriori());
                } else if (baseline.getComponentType() == ComponentType.Z) {
                    trgPoint.setZ(baseline.getValueApriori() + baseline.getEndPointHeight() - baseline.getStartPointHeight());
                }
                Point srcPoint = sourceSystem.get(id);
                if (srcPoint == null) {
                    Point pS = baseline.getStartPoint();
                    Point pE = baseline.getEndPoint();
                    srcPoint = new Point3D(id, pE.getX() - pS.getX(), pE.getY() - pS.getY(), pE.getZ() - pS.getZ());
                    sourceSystem.add(srcPoint);
                }
                ++i;
            }
            int nop = sourceSystem.size();
            DenseMatrix S = new DenseMatrix(3, 3);
            double[] q = new double[4];
            int k = 0;
            while (k < nop) {
                Point pS = sourceSystem.get(k);
                Point pT = targetSystem.get(pS.getName());
                if (pT != null) {
                    int i2 = 0;
                    while (i2 < 3) {
                        int j = 0;
                        while (j < 3) {
                            double a = 0.0;
                            double b = 0.0;
                            a = i2 == 0 ? pS.getX() : (i2 == 1 ? pS.getY() : pS.getZ());
                            b = j == 0 ? pT.getX() : (j == 1 ? pT.getY() : pT.getZ());
                            S.set(i2, j, S.get(i2, j) + a * b);
                            ++j;
                        }
                        ++i2;
                    }
                }
                ++k;
            }
            DenseMatrix N = new DenseMatrix(4, 4);
            N.set(0, 0, S.get(0, 0) + S.get(1, 1) + S.get(2, 2));
            N.set(0, 1, S.get(1, 2) - S.get(2, 1));
            N.set(0, 2, S.get(2, 0) - S.get(0, 2));
            N.set(0, 3, S.get(0, 1) - S.get(1, 0));
            N.set(1, 0, S.get(1, 2) - S.get(2, 1));
            N.set(1, 1, S.get(0, 0) - S.get(1, 1) - S.get(2, 2));
            N.set(1, 2, S.get(0, 1) + S.get(1, 0));
            N.set(1, 3, S.get(2, 0) + S.get(0, 2));
            N.set(2, 0, S.get(2, 0) - S.get(0, 2));
            N.set(2, 1, S.get(0, 1) + S.get(1, 0));
            N.set(2, 2, -S.get(0, 0) + S.get(1, 1) - S.get(2, 2));
            N.set(2, 3, S.get(1, 2) + S.get(2, 1));
            N.set(3, 0, S.get(0, 1) - S.get(1, 0));
            N.set(3, 1, S.get(2, 0) + S.get(0, 2));
            N.set(3, 2, S.get(1, 2) + S.get(2, 1));
            N.set(3, 3, -S.get(0, 0) - S.get(1, 1) + S.get(2, 2));
            EVD evd = new EVD(4);
            try {
                evd.factor(N);
                if (evd.hasRightEigenvectors()) {
                    DenseMatrix eigVec = evd.getRightEigenvectors();
                    double[] eigVal = evd.getRealEigenvalues();
                    int indexMaxEigVal = 0;
                    double maxEigVal = eigVal[indexMaxEigVal];
                    int i3 = indexMaxEigVal + 1;
                    while (i3 < eigVal.length) {
                        if (maxEigVal < eigVal[i3]) {
                            maxEigVal = eigVal[i3];
                            indexMaxEigVal = i3;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < eigVal.length) {
                        q[i3] = eigVec.get(i3, indexMaxEigVal);
                        ++i3;
                    }
                }
            }
            catch (NotConvergedException e) {
                e.printStackTrace();
            }
            double m1 = 0.0;
            double m2 = 0.0;
            double q0 = q[0];
            double q1 = q[1];
            double q2 = q[2];
            double q3 = q[3];
            double r13 = 2.0 * (q1 * q3 + q0 * q2);
            double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
            double r12 = 2.0 * (q1 * q2 - q0 * q3);
            double r23 = 2.0 * (q2 * q3 - q0 * q1);
            double r21 = 2.0 * (q1 * q2 + q0 * q3);
            double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
            double r31 = 2.0 * (q1 * q3 - q0 * q2);
            double r32 = 2.0 * (q2 * q3 + q0 * q1);
            double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
            int k2 = 0;
            while (k2 < nop) {
                Point pS = sourceSystem.get(k2);
                Point pT = targetSystem.get(pS.getName());
                if (pT != null) {
                    m1 += pT.getX() * (r11 * pS.getX() + r12 * pS.getY() + r13 * pS.getZ());
                    m1 += pT.getY() * (r21 * pS.getX() + r22 * pS.getY() + r23 * pS.getZ());
                    m1 += pT.getZ() * (r31 * pS.getX() + r32 * pS.getY() + r33 * pS.getZ());
                    m2 += pS.getX() * pS.getX();
                    m2 += pS.getY() * pS.getY();
                    m2 += pS.getZ() * pS.getZ();
                }
                ++k2;
            }
            this.scaleParam = Math.abs(m1) > SQRT_EPS && Math.abs(m2) > SQRT_EPS ? Math.abs(m1 / m2) : 1.0;
            this.rxParam = MathExtension.MOD(Math.atan2(-r32, r33), Math.PI * 2);
            this.ryParam = MathExtension.MOD(Math.asin(r31), Math.PI * 2);
            this.rzParam = MathExtension.MOD(Math.atan2(-r21, r11), Math.PI * 2);
            this.hasApproxValues = true;
        }
        if (param == this.scale) {
            param.setValue(this.scaleParam);
        } else if (param == this.rx) {
            param.setValue(this.rxParam);
        } else if (param == this.ry) {
            param.setValue(this.ryParam);
        } else if (param == this.rz) {
            param.setValue(this.rzParam);
        }
        return param;
    }
}

