/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation.group;

import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline2D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaX2D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaselineDeltaY2D;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.RotationZ;
import org.applied_geodesy.adjustment.network.parameter.Scale;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.adjustment.network.point.Point2D;
import org.applied_geodesy.adjustment.network.point.group.PointGroup;

public class GNSSBaseline2DGroup
extends ObservationGroup {
    private Scale scale = new Scale();
    private RotationZ rz = new RotationZ();
    private boolean hasApproxValues = false;
    private double scaleParam = 1.0;
    private double rzParam = 0.0;

    public GNSSBaseline2DGroup(int id) {
        this(id, DefaultUncertainty.getUncertaintyGNSSZeroPointOffset(), DefaultUncertainty.getUncertaintyGNSSSquareRootDistanceDependent(), DefaultUncertainty.getUncertaintyGNSSDistanceDependent(), Epoch.REFERENCE);
    }

    public GNSSBaseline2DGroup(int id, double sigmaA, double sigmaB, double sigmaC, Epoch epoch) {
        super(id, sigmaA, sigmaB, sigmaC, epoch);
        this.scale.setObservationGroup(this);
        this.rz.setObservationGroup(this);
    }

    @Override
    public void add(Observation gnss2D) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " Fehler, GPS-Basislinien bestehen nicht aus 2D-Beobachtungen!");
    }

    private void add(GNSSBaseline2D gnss2D) {
        gnss2D.setScale(this.scale);
        gnss2D.setRotationZ(this.rz);
        super.add(gnss2D);
    }

    public void add(GNSSBaselineDeltaX2D gpsX2D, GNSSBaselineDeltaY2D gpsY2D) {
        if (gpsX2D.getId() == gpsY2D.getId() && gpsX2D.getStartPoint().getName().equals(gpsY2D.getStartPoint().getName()) && gpsX2D.getEndPoint().getName().equals(gpsY2D.getEndPoint().getName())) {
            this.add(gpsX2D);
            this.add(gpsY2D);
            gpsX2D.addAssociatedBaselineComponent(gpsY2D);
            gpsY2D.addAssociatedBaselineComponent(gpsX2D);
        }
    }

    @Override
    public double getStdA(Observation observation) {
        return this.getStdA();
    }

    @Override
    public double getStdB(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = Math.abs(observation.getValueApriori());
        }
        return this.getStdB() * Math.sqrt(dist / 1000.0);
    }

    @Override
    public double getStdC(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = Math.abs(observation.getValueApriori());
        }
        return this.getStdC() * dist;
    }

    public Scale getScale() {
        return this.scale;
    }

    public RotationZ getRotationZ() {
        return this.rz;
    }

    @Override
    public int numberOfAdditionalUnknownParameter() {
        int num = 0;
        if (this.rz.isEnable()) {
            ++num;
        }
        if (this.scale.isEnable()) {
            ++num;
        }
        return num;
    }

    @Override
    public AdditionalUnknownParameter setApproximatedValue(AdditionalUnknownParameter param) {
        if (!this.hasApproxValues) {
            double SQRT_EPS = Math.sqrt(Constant.EPS);
            PointGroup sourceSystem = new PointGroup(1);
            PointGroup targetSystem = new PointGroup(1);
            int i = 0;
            while (i < this.size()) {
                GNSSBaseline baseline = (GNSSBaseline)this.get(i);
                String id = String.valueOf(baseline.getId());
                Point trgPoint = targetSystem.get(id);
                if (trgPoint == null) {
                    trgPoint = new Point2D(id, 0.0, 0.0);
                    targetSystem.add(trgPoint);
                }
                if (baseline.getComponentType() == ComponentType.X) {
                    trgPoint.setX(baseline.getValueApriori());
                } else if (baseline.getComponentType() == ComponentType.Y) {
                    trgPoint.setY(baseline.getValueApriori());
                }
                Point srcPoint = sourceSystem.get(id);
                if (srcPoint == null) {
                    Point pS = baseline.getStartPoint();
                    Point pE = baseline.getEndPoint();
                    srcPoint = new Point2D(id, pE.getX() - pS.getX(), pE.getY() - pS.getY());
                    sourceSystem.add(srcPoint);
                }
                ++i;
            }
            double o = 0.0;
            double a = 0.0;
            double oa = 0.0;
            int i2 = 0;
            while (i2 < sourceSystem.size()) {
                Point pS = sourceSystem.get(i2);
                Point pT = targetSystem.get(pS.getName());
                if (pT != null) {
                    o += pS.getX() * pT.getY() - pS.getY() * pT.getX();
                    a += pS.getX() * pT.getX() + pS.getY() * pT.getY();
                    oa += pS.getX() * pS.getX() + pS.getY() * pS.getY();
                }
                ++i2;
            }
            if (oa > SQRT_EPS) {
                this.scaleParam = Math.hypot(o /= oa, a /= oa);
                this.scaleParam = this.scaleParam > SQRT_EPS ? this.scaleParam : 1.0;
                this.rzParam = MathExtension.MOD(-Math.atan2(o, a), Math.PI * 2);
            } else {
                this.scaleParam = 1.0;
            }
            this.hasApproxValues = true;
        }
        if (param == this.scale) {
            param.setValue(this.scaleParam);
        } else if (param == this.rz) {
            param.setValue(this.rzParam);
        }
        return param;
    }
}

