/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation.group;

import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.observation.DeltaZ;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.parameter.Scale;

public class DeltaZGroup
extends ObservationGroup {
    private Scale scale = new Scale();

    public DeltaZGroup(int id) {
        this(id, DefaultUncertainty.getUncertaintyLevelingZeroPointOffset(), DefaultUncertainty.getUncertaintyLevelingSquareRootDistanceDependent(), DefaultUncertainty.getUncertaintyLevelingDistanceDependent(), Epoch.REFERENCE);
    }

    public DeltaZGroup(int id, double sigmaA, double sigmaB, double sigmaC, Epoch epoch) {
        super(id, sigmaA, sigmaB, sigmaC, epoch);
    }

    @Override
    public void add(Observation deltaZ) {
        DeltaZ obs = (DeltaZ)deltaZ;
        obs.setScale(this.scale);
        super.add(obs);
    }

    public Scale getScale() {
        return this.scale;
    }

    @Override
    public double getStdA(Observation observation) {
        return this.getStdA();
    }

    @Override
    public double getStdB(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = observation.getApproximatedCalculatedDistance2D();
        }
        return this.getStdB() * Math.sqrt(dist / 1000.0);
    }

    @Override
    public double getStdC(Observation observation) {
        double dist = observation.getDistanceForUncertaintyModel();
        if (dist < Constant.EPS) {
            dist = observation.getApproximatedCalculatedDistance2D();
        }
        return this.getStdC() * dist;
    }

    @Override
    public int numberOfAdditionalUnknownParameter() {
        return this.scale.isEnable() ? 1 : 0;
    }
}

