/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation;

import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.observation.FaceType;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.reduction.ProjectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.Reduction;
import org.applied_geodesy.adjustment.network.observation.reduction.ReductionTaskType;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.RefractionCoefficient;
import org.applied_geodesy.adjustment.network.point.Point;

public class ZenithAngle
extends Observation {
    private FaceType face = FaceType.ONE;
    private RefractionCoefficient refractionCoefficient = new RefractionCoefficient();

    public ZenithAngle(int id, Point startPoint, Point endPoint, double startPointHeight, double endPointHeight, double measuringElement, double sigma, double distanceForUncertaintyModel) {
        super(id, startPoint, endPoint, startPointHeight, endPointHeight, measuringElement, sigma, distanceForUncertaintyModel);
        if (Math.abs(Math.PI * 2 - this.getValueApriori() - this.getValueAposteriori()) < Math.abs(this.getValueApriori() - this.getValueAposteriori())) {
            this.setValueApriori(Math.PI * 2 - this.getValueApriori());
            this.setFace(FaceType.TWO);
        }
    }

    @Override
    public double diffXs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return -(v * (crxs * srys * v + w * srxs * srys) + u * (crxs * srys * u + w * crys)) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffYs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return -(v * (crxs * w - srxs * v) - srxs * u * u) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffZs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return (v * (crxs * crys * v + w * crys * srxs) + u * (crxs * crys * u - w * srys)) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffVerticalDeflectionXs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return -v * (u * u + v * v + w * w + w * ih) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffVerticalDeflectionYs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        double tmp11 = crys * (xe - xs) + srys * (ze - zs) - th * crxe * crys * srye + th * crxe * crye * srys;
        double tmp21 = crys * (ze - zs) - srys * (xe - xs) + th * crxe * crye * crys + th * crxe * srye * srys;
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return (tmp11 * crxs * (u * u + v * v) + w * (tmp11 * srxs * v + tmp21 * u)) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffVerticalDeflectionXe() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        double tmp12 = th * (crxs * crye * crys * srxe - crxe * srxs + crxs * srxe * srye * srys);
        double tmp22 = th * (crxe * crxs + crye * crys * srxe * srxs + srxe * srxs * srye * srys);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return (w * (tmp22 * v + th * u * Math.sin(rye - rys) * srxe) + tmp12 * (u * u + v * v)) / dist2D_times_distSqr3D;
    }

    @Override
    public double diffVerticalDeflectionYe() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D_times_distSqr3D = Math.hypot(u, v) * (u * u + v * v + w * w);
        if (dist2D_times_distSqr3D == 0.0) {
            return 0.0;
        }
        return th * crxe * (Math.sin(rye - rys) * crxs * (u * u + v * v) - w * (Math.cos(rye - rys) * u - Math.sin(rye - rys) * srxs * v)) / dist2D_times_distSqr3D;
    }

    @Override
    public double getValueAposteriori() {
        Reduction reductions = this.getReductions();
        double R = reductions.getEarthRadius();
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double dist2D = Math.hypot(u, v);
        double corr = dist2D / (2.0 * R);
        double k = this.refractionCoefficient.getValue();
        double geoCorr = -k * corr;
        if (reductions.applyReductionTask(ReductionTaskType.EARTH_CURVATURE)) {
            geoCorr += corr;
        }
        return MathExtension.MOD(Math.atan2(dist2D, w) + geoCorr, Math.PI * 2);
    }

    @Override
    public double getObservationalError() {
        double calAngle = this.getValueAposteriori();
        double obsAngle = this.getValueApriori();
        if (Math.abs(Math.PI * 2 - obsAngle - calAngle) < Math.abs(obsAngle - calAngle)) {
            obsAngle = Math.PI * 2 - obsAngle;
        }
        return obsAngle - calAngle;
    }

    @Override
    public double diffRefCoeff() {
        Reduction reductions = this.getReductions();
        double R = reductions.getEarthRadius();
        double dist2D = this.getCalculatedDistance2D();
        return -dist2D / (2.0 * R);
    }

    public FaceType getFace() {
        return this.face;
    }

    public void setFace(FaceType face) {
        this.face = face;
    }

    public void setRefractionCoefficient(RefractionCoefficient k) {
        this.refractionCoefficient = k;
        this.refractionCoefficient.setObservation(this);
    }

    public AdditionalUnknownParameter getRefractionCoefficient() {
        return this.refractionCoefficient;
    }

    @Override
    public int getColInJacobiMatrixFromRefCoeff() {
        return this.refractionCoefficient.getColInJacobiMatrix();
    }

    @Override
    public ObservationType getObservationType() {
        return ObservationType.ZENITH_ANGLE;
    }
}

