/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.parameter.RotationZ;
import org.applied_geodesy.adjustment.network.parameter.Scale;
import org.applied_geodesy.adjustment.network.point.Point;

public abstract class GNSSBaseline
extends Observation {
    private Map<ComponentType, GNSSBaseline> baselineComponents = new LinkedHashMap<ComponentType, GNSSBaseline>(3);
    private Scale scale = new Scale();
    private RotationZ rz = new RotationZ();
    private Matrix subR;

    public GNSSBaseline(int id, Point startPoint, Point endPoint, double startPointHeight, double endPointHeight, double observation, double sigma) {
        super(id, startPoint, endPoint, startPointHeight, endPointHeight, observation, sigma, Math.abs(observation));
        this.baselineComponents.put(this.getComponentType(), this);
    }

    public void addAssociatedBaselineComponent(GNSSBaseline baseline) {
        if (this.getId() == baseline.getId() && !this.baselineComponents.containsKey((Object)baseline.getComponentType()) && !this.baselineComponents.containsValue(baseline)) {
            this.baselineComponents.put(baseline.getComponentType(), baseline);
        }
    }

    public void setScale(Scale newScale) {
        this.scale = newScale;
        this.scale.setObservation(this);
    }

    public Scale getScale() {
        return this.scale;
    }

    @Override
    public int getColInJacobiMatrixFromScale() {
        return this.scale.getColInJacobiMatrix();
    }

    public void setRotationZ(RotationZ r) {
        this.rz = r;
        this.rz.setObservation(this);
    }

    public RotationZ getRotationZ() {
        return this.rz;
    }

    @Override
    public int getColInJacobiMatrixFromRotationZ() {
        return this.rz.getColInJacobiMatrix();
    }

    public void setBaselineRedundancyMatrix(Matrix R) {
        for (GNSSBaseline baseline : this.baselineComponents.values()) {
            baseline.setRedundancyMatrix(R);
        }
    }

    protected void setRedundancyMatrix(Matrix R) {
        this.subR = R;
    }

    public Matrix getBaselineRedundancyMatrix() {
        return this.subR;
    }

    public List<Observation> getBaselineComponents() {
        return new ArrayList<Observation>(this.baselineComponents.values());
    }

    public GNSSBaseline getBaselineComponent(ComponentType type) {
        return this.baselineComponents.get((Object)type);
    }

    public abstract int getDimension();

    public abstract ComponentType getComponentType();

    @Override
    public double diffVerticalDeflectionXs() {
        return 0.0;
    }

    @Override
    public double diffVerticalDeflectionYs() {
        return 0.0;
    }

    @Override
    public double diffVerticalDeflectionXe() {
        return 0.0;
    }

    @Override
    public double diffVerticalDeflectionYe() {
        return 0.0;
    }
}

