/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation;

import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.observation.FaceType;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.reduction.ProjectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.Reduction;
import org.applied_geodesy.adjustment.network.observation.reduction.ReductionTaskType;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.Orientation;
import org.applied_geodesy.adjustment.network.point.Point;

public class Direction
extends Observation {
    private FaceType face = FaceType.ONE;
    private Orientation orientation = new Orientation(true);

    public Direction(int id, Point startPoint, Point endPoint, double startPointHeight, double endPointHeight, double measuringElement, double sigma, double distanceForUncertaintyModel) {
        super(id, startPoint, endPoint, startPointHeight, endPointHeight, measuringElement, sigma, distanceForUncertaintyModel);
    }

    @Override
    public double diffXs() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return (crxs * (crys * ye - crys * ys + crys * srxe * th) - srxs * (ze - zs + crxe * crye * th)) / distSqr2D;
    }

    @Override
    public double diffYs() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return -(u * crxs) / distSqr2D;
    }

    @Override
    public double diffZs() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return (crxs * (srys * (ye - ys) + srxe * srys * th) - srxs * (xs - xe + crxe * srye * th)) / distSqr2D;
    }

    @Override
    public double diffVerticalDeflectionXs() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double ih = this.getStartPointHeight();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double w = th * (srxe * srxs + crxe * crxs * crye * crys + crxe * crxs * srye * srys) - ih + srxs * (ye - ys) + crxs * crys * (ze - zs) - crxs * srys * (xe - xs);
        double distSqr2D = u * u + v * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return -(w + ih) * u / distSqr2D;
    }

    @Override
    public double diffVerticalDeflectionYs() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return (srxs * u * u - v * (crys * (ze - zs) - srys * (xe - xs)) - th * v * Math.cos(rye - rys) * crxe) / distSqr2D;
    }

    @Override
    public double diffVerticalDeflectionXe() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return th * (u * (crxe * crxs + crye * crys * srxe * srxs + srxe * srxs * srye * srys) - v * Math.sin(rye - rys) * srxe) / distSqr2D;
    }

    @Override
    public double diffVerticalDeflectionYe() {
        double v;
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double distSqr2D = u * u + (v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs)) * v;
        if (distSqr2D == 0.0) {
            return 0.0;
        }
        return th * crxe * (v * Math.cos(rye - rys) + u * Math.sin(rye - rys) * srxs) / distSqr2D;
    }

    @Override
    public double diffOri() {
        return -1.0;
    }

    public FaceType getFace() {
        return this.face;
    }

    public void setFace(FaceType face) {
        this.face = face;
    }

    @Override
    public double getObservationalError() {
        double diffDir;
        Reduction reductions = this.getReductions();
        double calDir = this.getValueAposteriori();
        double obsDir = this.getValueApriori();
        if ((reductions.getProjectionType() == ProjectionType.GAUSS_KRUEGER || reductions.getProjectionType() == ProjectionType.UTM) && reductions.applyReductionTask(ReductionTaskType.DIRECTION)) {
            double R = reductions.getEarthRadius();
            double scale = reductions.getProjectionType() == ProjectionType.UTM ? 0.9996 : 1.0;
            double yS = this.getStartPoint().getY();
            double xS = this.getStartPoint().getX();
            double yE = this.getEndPoint().getY();
            double xE = this.getEndPoint().getX();
            yS = yS / 1000000.0 % 1.0 * 1000000.0 - 500000.0;
            yE = yE / 1000000.0 % 1.0 * 1000000.0 - 500000.0;
            double k = -(xE - xS) * (2.0 * yS + yE) / (6.0 * R * R * scale * scale);
            obsDir = MathExtension.MOD(obsDir + k, Math.PI * 2);
        }
        if (Math.PI * 2 - Math.abs(diffDir = obsDir - calDir) < Math.abs(diffDir)) {
            calDir = calDir < obsDir ? (calDir += Math.PI * 2) : (calDir -= Math.PI * 2);
        }
        return obsDir - calDir;
    }

    @Override
    public double getValueAposteriori() {
        double xs = this.getStartPoint().getX();
        double ys = this.getStartPoint().getY();
        double zs = this.getStartPoint().getZ();
        double xe = this.getEndPoint().getX();
        double ye = this.getEndPoint().getY();
        double ze = this.getEndPoint().getZ();
        double th = this.getEndPointHeight();
        double rxs = this.getStartPoint().getVerticalDeflectionX().getValue();
        double rys = this.getStartPoint().getVerticalDeflectionY().getValue();
        double rxe = this.getEndPoint().getVerticalDeflectionX().getValue();
        double rye = this.getEndPoint().getVerticalDeflectionY().getValue();
        if (this.getReductions().getProjectionType() == ProjectionType.LOCAL_ELLIPSOIDAL) {
            rxs += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rys += this.getStartPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
            rxe += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionX();
            rye += this.getEndPoint().getSphericalDeflectionParameter().getSphericalDeflectionY();
        }
        double srxs = Math.sin(rxs);
        double srys = Math.sin(rys);
        double crxs = Math.cos(rxs);
        double crys = Math.cos(rys);
        double crxe = Math.cos(rxe);
        double crye = Math.cos(rye);
        double srye = Math.sin(rye);
        double srxe = Math.sin(rxe);
        double u = crys * (xe - xs) + srys * (ze - zs) - th * Math.sin(rye - rys) * crxe;
        double v = crxs * (ye - ys) - th * (crxe * crye * crys * srxs - crxs * srxe + crxe * srxs * srye * srys) - crys * srxs * (ze - zs) + srxs * srys * (xe - xs);
        double ori = this.orientation.getValue();
        return MathExtension.MOD(Math.atan2(v, u) - ori, Math.PI * 2);
    }

    public void setOrientation(Orientation newOrientation) {
        this.orientation = newOrientation;
        this.orientation.setObservation(this);
    }

    public AdditionalUnknownParameter getOrientation() {
        return this.orientation;
    }

    @Override
    public int getColInJacobiMatrixFromOrientation() {
        return this.orientation.getColInJacobiMatrix();
    }

    @Override
    public ObservationType getObservationType() {
        return ObservationType.DIRECTION;
    }
}

