/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.congruence.strain;

import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.congruence.strain.CoordinateComponent;
import org.applied_geodesy.adjustment.network.congruence.strain.Equation;
import org.applied_geodesy.adjustment.network.congruence.strain.RestrictionType;
import org.applied_geodesy.adjustment.network.congruence.strain.StrainAnalysisEquations;
import org.applied_geodesy.adjustment.network.congruence.strain.parameter.StrainParameter;
import org.applied_geodesy.adjustment.network.congruence.strain.parameter.StrainParameterScaleZ;
import org.applied_geodesy.adjustment.network.congruence.strain.parameter.StrainParameterTranslationZ;
import org.applied_geodesy.adjustment.network.point.Point;

public class StrainAnalysisEquations1D
extends StrainAnalysisEquations {
    @Override
    StrainParameter[] initStrainParameters() {
        return new StrainParameter[]{new StrainParameterTranslationZ(), new StrainParameterScaleZ()};
    }

    @Override
    public boolean isSupportedRestriction(RestrictionType restriction) {
        return restriction == RestrictionType.FIXED_TRANSLATION_Z || restriction == RestrictionType.FIXED_SCALE_Z;
    }

    @Override
    public double diff(StrainParameter parameter, Point p1, Equation equation) {
        double z1;
        double elmA = 0.0;
        double zP = z1 = p1.getZ();
        if (equation == Equation.Z) {
            switch (parameter.getParameterType()) {
                case STRAIN_TRANSLATION_Z: {
                    elmA = 1.0;
                    break;
                }
                case STRAIN_SCALE_Z: {
                    elmA = zP;
                    break;
                }
                default: {
                    elmA = 0.0;
                }
            }
        }
        return elmA;
    }

    @Override
    public double diff(Point p1, Point p2, CoordinateComponent component, Equation equation) {
        double mz = this.getParameterByType(ParameterType.STRAIN_SCALE_Z).getValue();
        double elmB = 0.0;
        if (equation == Equation.Z) {
            switch (component) {
                case Z1: {
                    elmB = mz;
                    break;
                }
                case Z2: {
                    elmB = -1.0;
                    break;
                }
                default: {
                    elmB = 0.0;
                }
            }
        }
        return elmB;
    }

    @Override
    public double getContradiction(Point p1, Point p2, Equation equation) {
        double z1 = p1.getZ();
        double z2 = p2.getZ();
        double zP = z1;
        double ZP = z2;
        double z0 = this.getParameterByType(ParameterType.STRAIN_TRANSLATION_Z).getValue();
        double mz = this.getParameterByType(ParameterType.STRAIN_SCALE_Z).getValue();
        return z0 + mz * zP - ZP;
    }

    @Override
    public double diff(StrainParameter parameter, RestrictionType restriction) {
        double elmR = 0.0;
        if (restriction == RestrictionType.FIXED_TRANSLATION_Z) {
            switch (parameter.getParameterType()) {
                case STRAIN_TRANSLATION_Z: {
                    elmR = 1.0;
                    break;
                }
                default: {
                    elmR = 0.0;
                    break;
                }
            }
        } else if (restriction == RestrictionType.FIXED_SCALE_Z) {
            switch (parameter.getParameterType()) {
                case STRAIN_SCALE_Z: {
                    elmR = 1.0;
                    break;
                }
                default: {
                    elmR = 0.0;
                }
            }
        }
        return elmR;
    }

    @Override
    public double getContradiction(RestrictionType restriction) {
        double z0 = this.getParameterByType(ParameterType.STRAIN_TRANSLATION_Z).getValue();
        double mz = this.getParameterByType(ParameterType.STRAIN_SCALE_Z).getValue();
        switch (restriction) {
            case FIXED_TRANSLATION_Z: {
                return z0;
            }
            case FIXED_SCALE_Z: {
                return mz - 1.0;
            }
        }
        return 0.0;
    }

    @Override
    void initDefaultRestictions() {
    }

    @Override
    public void expandParameters(double sigma2apost, Matrix Quu, boolean applyAposterioriVarianceOfUnitWeight) {
        int i = 0;
        while (i < this.strainParameters.length) {
            StrainParameter param = this.strainParameters[i];
            this.setStochasticParameters(param, sigma2apost, Quu.get(i, i), applyAposterioriVarianceOfUnitWeight);
            ++i;
        }
    }

    @Override
    public int numberOfExpandedParameters() {
        return 0;
    }
}

