/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.congruence.strain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.congruence.strain.CoordinateComponent;
import org.applied_geodesy.adjustment.network.congruence.strain.Equation;
import org.applied_geodesy.adjustment.network.congruence.strain.RestrictionType;
import org.applied_geodesy.adjustment.network.congruence.strain.parameter.StrainParameter;
import org.applied_geodesy.adjustment.network.point.Point;

public abstract class StrainAnalysisEquations {
    StrainParameter[] strainParameters = new StrainParameter[0];
    private List<RestrictionType> restrictions = new ArrayList<RestrictionType>(10);
    private Map<ParameterType, StrainParameter> strainParameterMap = new HashMap<ParameterType, StrainParameter>();

    StrainAnalysisEquations() {
        this.initDefaultRestictions();
        StrainParameter[] strainParameterArray = this.strainParameters = this.initStrainParameters();
        int n = this.strainParameters.length;
        int n2 = 0;
        while (n2 < n) {
            StrainParameter param = strainParameterArray[n2];
            this.strainParameterMap.put(param.getParameterType(), param);
            ++n2;
        }
    }

    StrainParameter getParameterByType(ParameterType type) {
        return this.strainParameterMap.get((Object)type);
    }

    public abstract int numberOfExpandedParameters();

    public int numberOfParameters() {
        return this.strainParameters.length;
    }

    public StrainParameter get(int i) {
        return this.strainParameters[i];
    }

    public static Equation[] getEquations(int dim) {
        switch (dim) {
            case 1: {
                return new Equation[]{Equation.Z};
            }
            case 2: {
                return new Equation[]{Equation.X, Equation.Y};
            }
            case 3: {
                return new Equation[]{Equation.X, Equation.Y, Equation.Z};
            }
        }
        return null;
    }

    public static CoordinateComponent[] getCoordinateComponents(int dim) {
        switch (dim) {
            case 1: {
                return new CoordinateComponent[]{CoordinateComponent.Z1, CoordinateComponent.Z2};
            }
            case 2: {
                return new CoordinateComponent[]{CoordinateComponent.X1, CoordinateComponent.Y1, CoordinateComponent.X2, CoordinateComponent.Y2};
            }
            case 3: {
                return new CoordinateComponent[]{CoordinateComponent.X1, CoordinateComponent.Y1, CoordinateComponent.Z1, CoordinateComponent.X2, CoordinateComponent.Y2, CoordinateComponent.Z2};
            }
        }
        return null;
    }

    public boolean hasUnconstraintParameters() {
        return this.numberOfParameters() - this.numberOfRestrictions() > 0;
    }

    public int numberOfRestrictions() {
        return this.restrictions.size();
    }

    public boolean isRestricted(RestrictionType restriction) {
        return this.restrictions.contains((Object)restriction);
    }

    public RestrictionType getRestriction(int index) {
        return this.restrictions.get(index);
    }

    public void addRestriction(RestrictionType restriction) {
        if (this.isSupportedRestriction(restriction) && !this.restrictions.contains((Object)restriction)) {
            if (restriction == RestrictionType.FIXED_SCALE_X) {
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_XY);
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_XZ);
            } else if (restriction == RestrictionType.FIXED_SCALE_Y) {
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_XY);
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_YZ);
            } else if (restriction == RestrictionType.FIXED_SCALE_Z) {
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_XZ);
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_YZ);
            } else if (restriction == RestrictionType.IDENT_SCALES_XY) {
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_X);
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_Y);
            } else if (restriction == RestrictionType.IDENT_SCALES_XZ) {
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_X);
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_Z);
            } else if (restriction == RestrictionType.IDENT_SCALES_YZ) {
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_Y);
                this.restrictions.remove((Object)RestrictionType.FIXED_SCALE_Z);
            }
            this.restrictions.add(restriction);
            if (this.restrictions.contains((Object)RestrictionType.IDENT_SCALES_XY) && this.restrictions.contains((Object)RestrictionType.IDENT_SCALES_XZ) && this.restrictions.contains((Object)RestrictionType.IDENT_SCALES_YZ)) {
                this.restrictions.remove((Object)RestrictionType.IDENT_SCALES_XY);
            }
        }
    }

    StrainParameter setStochasticParameters(StrainParameter param, double sigma2apost, double qxxPrio, boolean applyAposterioriVarianceOfUnitWeight) {
        qxxPrio = Math.abs(qxxPrio);
        double value = param.getValue();
        if ((param.getParameterType() == ParameterType.STRAIN_ROTATION_X || param.getParameterType() == ParameterType.STRAIN_ROTATION_Y || param.getParameterType() == ParameterType.STRAIN_ROTATION_Z || param.getParameterType() == ParameterType.STRAIN_SHEAR_X || param.getParameterType() == ParameterType.STRAIN_SHEAR_X || param.getParameterType() == ParameterType.STRAIN_SHEAR_Z) && Math.abs(Math.PI * 2 - (value = MathExtension.MOD(value, Math.PI * 2))) < Math.abs(value)) {
            value -= Math.PI * 2;
        }
        double qxxPost = sigma2apost * qxxPrio;
        double value0 = param.getExpectationValue();
        double nabla = value - value0;
        double tPrio = qxxPrio < Constant.EPS ? Double.POSITIVE_INFINITY : nabla * nabla / qxxPrio;
        double tPost = qxxPost < Constant.EPS ? Double.POSITIVE_INFINITY : nabla * nabla / qxxPost;
        double nabla0 = Math.signum(nabla) * Math.sqrt(qxxPrio);
        param.setTprio(tPrio);
        param.setTpost(applyAposterioriVarianceOfUnitWeight ? tPost : 0.0);
        param.setStd(Math.sqrt(qxxPost));
        param.setGrossError(nabla);
        param.setMinimalDetectableBias(nabla0);
        return param;
    }

    public abstract void expandParameters(double var1, Matrix var3, boolean var4);

    abstract void initDefaultRestictions();

    abstract StrainParameter[] initStrainParameters();

    public abstract boolean isSupportedRestriction(RestrictionType var1);

    public abstract double diff(StrainParameter var1, Point var2, Equation var3);

    public abstract double diff(Point var1, Point var2, CoordinateComponent var3, Equation var4);

    public abstract double diff(StrainParameter var1, RestrictionType var2);

    public abstract double getContradiction(Point var1, Point var2, Equation var3);

    public abstract double getContradiction(RestrictionType var1);
}

