/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.adjustment.network.approximation.AutomatedApproximationAdjustment;
import org.applied_geodesy.adjustment.network.approximation.bundle.PointBundle;
import org.applied_geodesy.adjustment.network.approximation.bundle.intersection.ForwardIntersectionEntry;
import org.applied_geodesy.adjustment.network.approximation.bundle.intersection.ForwardIntersectionSet;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.ClassicGeodeticComputation;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point1D;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.util.sql.DataBase;

public class SQLApproximationManager
implements PropertyChangeListener {
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    private final DataBase dataBase;
    private boolean estimateDatumPoints = false;
    private boolean freeNetwork = true;
    private boolean interrupt = false;
    private Set<String> underdeterminedPointNames1D = new HashSet<String>();
    private Set<String> underdeterminedPointNames2D = new HashSet<String>();
    private Set<String> completestationNames = new HashSet<String>();
    private Set<String> outlier1d = new HashSet<String>();
    private Set<String> outlier2d = new HashSet<String>();
    private Map<String, Set<String>> directionLinks = new LinkedHashMap<String, Set<String>>();
    private PointBundle targetSystem1d;
    private PointBundle targetSystem2d;
    private int subSystemsCounter1d = 0;
    private int subSystemsCounter2d = 0;
    private EstimationStateType estimationStatus1D = EstimationStateType.ERROR_FREE_ESTIMATION;
    private EstimationStateType estimationStatus2D = EstimationStateType.ERROR_FREE_ESTIMATION;
    private AutomatedApproximationAdjustment approximationAdjustment = null;

    public SQLApproximationManager(DataBase dataBase) {
        if (dataBase == null || !dataBase.isOpen()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, database must be open! " + String.valueOf(dataBase));
        }
        this.dataBase = dataBase;
    }

    public void clearAll() {
        this.subSystemsCounter2d = 0;
        this.subSystemsCounter1d = 0;
        this.underdeterminedPointNames1D.clear();
        this.underdeterminedPointNames2D.clear();
        this.completestationNames.clear();
        this.outlier1d.clear();
        this.outlier2d.clear();
        this.directionLinks.clear();
        this.targetSystem1d = null;
        this.targetSystem2d = null;
        this.approximationAdjustment = null;
    }

    public int getSubSystemsCounter1D() {
        return this.subSystemsCounter1d;
    }

    public int getSubSystemsCounter2D() {
        return this.subSystemsCounter2d;
    }

    public Set<String> getOutliers1D() {
        return this.outlier1d;
    }

    public Set<String> getOutliers2D() {
        return this.outlier2d;
    }

    public void adjustApproximationValues(double threshold) throws SQLException {
        List<Point> points1d;
        if (this.dataBase == null) {
            return;
        }
        this.clearAll();
        this.interrupt = false;
        this.freeNetwork = false;
        this.initTargetSystems(this.freeNetwork);
        boolean bl = this.freeNetwork = this.targetSystem1d == null && this.targetSystem2d == null;
        if (this.freeNetwork && !this.estimateDatumPoints) {
            this.initTargetSystems(true);
        }
        this.completestationNames = this.getCompletestationNames();
        this.initNonEstimatedPointNames();
        List<Point> points2d = this.getStationPointsWithSubSystems(2);
        if (points2d != null) {
            int targetCounter = -1;
            boolean converge = false;
            List<PointBundle> notTransFormedBundles = new ArrayList<PointBundle>(1);
            do {
                converge = false;
                this.approximationAdjustment = new AutomatedApproximationAdjustment(this.targetSystem2d, points2d);
                this.approximationAdjustment.addPropertyChangeListener(this);
                if (this.interrupt) {
                    this.estimationStatus2D = EstimationStateType.INTERRUPT;
                    this.approximationAdjustment.interrupt();
                    this.interrupt = false;
                    return;
                }
                if (notTransFormedBundles != null && notTransFormedBundles.size() > 0) {
                    this.approximationAdjustment.addSystems(notTransFormedBundles);
                }
                this.approximationAdjustment.setEstimateDatumPoints(this.estimateDatumPoints);
                this.approximationAdjustment.setFreeNetwork(this.freeNetwork);
                this.approximationAdjustment.setThreshold(threshold);
                this.estimationStatus2D = this.approximationAdjustment.estimateApproximatedValues();
                if (this.approximationAdjustment.getTargetSystem() != null) {
                    this.targetSystem2d = this.approximationAdjustment.getTargetSystem();
                }
                notTransFormedBundles = this.approximationAdjustment.getSystems().size() > 1 ? this.approximationAdjustment.getSystems() : new ArrayList(1);
                if (this.targetSystem2d != null) {
                    int i = 0;
                    while (i < this.targetSystem2d.size()) {
                        Point p = this.targetSystem2d.get(i);
                        if (this.underdeterminedPointNames2D.contains(p.getName())) {
                            this.underdeterminedPointNames2D.remove(p.getName());
                        }
                        ++i;
                    }
                    HashSet<String> estimatedPointIds = new HashSet<String>(this.underdeterminedPointNames2D.size());
                    for (String newPointId : this.underdeterminedPointNames2D) {
                        Point2D p = this.restockBundle(newPointId, this.targetSystem2d);
                        for (PointBundle localBundle : notTransFormedBundles) {
                            this.restockBundle(newPointId, localBundle);
                        }
                        if (p == null) continue;
                        estimatedPointIds.add(newPointId);
                    }
                    for (String estimatedPointId : estimatedPointIds) {
                        this.underdeterminedPointNames2D.remove(estimatedPointId);
                    }
                    this.savePoints(this.targetSystem2d);
                }
                if (this.targetSystem2d != null && this.approximationAdjustment.getSystems().size() > 1 && this.targetSystem2d.size() != targetCounter) {
                    targetCounter = this.targetSystem2d.size();
                    points2d = this.getStationPointsWithSubSystems(2);
                    converge = true;
                }
                this.approximationAdjustment.removePropertyChangeListener(this);
            } while (converge);
            if (this.approximationAdjustment != null) {
                this.subSystemsCounter2d = this.approximationAdjustment.getSubSystemsCounter();
                this.outlier2d = this.approximationAdjustment.getOutliers();
            }
            points2d = null;
        }
        if ((points1d = this.getStationPointsWithSubSystems(1)) != null) {
            this.approximationAdjustment = new AutomatedApproximationAdjustment(this.targetSystem1d, points1d);
            this.approximationAdjustment.addPropertyChangeListener(this);
            if (this.interrupt) {
                this.estimationStatus1D = EstimationStateType.INTERRUPT;
                this.approximationAdjustment.interrupt();
                this.interrupt = false;
                return;
            }
            this.approximationAdjustment.setEstimateDatumPoints(this.estimateDatumPoints);
            this.approximationAdjustment.setFreeNetwork(this.freeNetwork);
            this.approximationAdjustment.setThreshold(threshold);
            this.estimationStatus1D = this.approximationAdjustment.estimateApproximatedValues();
            this.targetSystem1d = this.approximationAdjustment.getTargetSystem();
            if (this.targetSystem1d != null) {
                int i = 0;
                while (i < this.targetSystem1d.size()) {
                    Point p = this.targetSystem1d.get(i);
                    if (this.underdeterminedPointNames1D.contains(p.getName())) {
                        this.underdeterminedPointNames1D.remove(p.getName());
                    }
                    ++i;
                }
                this.savePoints(this.targetSystem1d);
            }
            if (this.approximationAdjustment != null) {
                this.subSystemsCounter1d = this.approximationAdjustment.getSubSystemsCounter();
                this.outlier1d = this.approximationAdjustment.getOutliers();
            }
            this.approximationAdjustment.removePropertyChangeListener(this);
            points1d = null;
        }
    }

    public void interrupt() {
        this.interrupt = true;
        if (this.approximationAdjustment != null) {
            this.approximationAdjustment.interrupt();
        }
    }

    private Point2D restockBundle(String newPointId, PointBundle bundle) throws SQLException {
        if (bundle.contains(newPointId)) {
            return (Point2D)bundle.get(newPointId);
        }
        Point2D p = this.getForwardIntersectionPoint(newPointId, bundle);
        if (p == null) {
            p = this.getArcIntersectionPoint(newPointId, bundle);
        }
        if (p == null) {
            p = this.getBackwardIntersectionPoint(newPointId, bundle);
        }
        if (p != null) {
            bundle.addPoint(p);
        }
        return p;
    }

    private Set<String> getCompletestationNames() throws SQLException {
        HashSet<String> completestationNames = new HashSet<String>();
        List<String> stationNames = this.getPointNames(1, true);
        for (String pointName : stationNames) {
            completestationNames.add(pointName);
        }
        stationNames = this.getPointNames(2, true);
        for (String pointName : stationNames) {
            completestationNames.add(pointName);
        }
        stationNames = this.getPointNames(3, true);
        for (String pointName : stationNames) {
            completestationNames.add(pointName);
        }
        return completestationNames;
    }

    private void initNonEstimatedPointNames() throws SQLException {
        List<String> stationNames = this.getPointNames(1, false);
        for (String pointName : stationNames) {
            this.underdeterminedPointNames1D.add(pointName);
        }
        stationNames = this.getPointNames(2, false);
        for (String pointName : stationNames) {
            this.underdeterminedPointNames2D.add(pointName);
        }
        stationNames = this.getPointNames(3, false);
        for (String pointName : stationNames) {
            this.underdeterminedPointNames1D.add(pointName);
            this.underdeterminedPointNames2D.add(pointName);
        }
    }

    private List<Point> getStationPointsWithSubSystems(int dim) throws SQLException {
        ArrayList<Point> pointList = new ArrayList<Point>();
        LinkedHashMap<String, Point> pointMap = new LinkedHashMap<String, Point>();
        if (dim != 2) {
            List<String> stationNames = this.getPointNames(1, true);
            for (String string : stationNames) {
                Point1D point = new Point1D(string, 0.0);
                pointList.add(point);
                pointMap.put(string, point);
                this.addObservation(point);
            }
            stationNames = this.getPointNames(3, true);
            for (String string : stationNames) {
                Point1D point1d = new Point1D(string, 0.0);
                pointList.add(point1d);
                pointMap.put(string, point1d);
                this.addObservation(point1d);
            }
        } else if (dim != 1) {
            List<String> stationNames = this.getPointNames(2, true);
            for (String string : stationNames) {
                Point2D point = new Point2D(string, 0.0, 0.0);
                pointList.add(point);
                pointMap.put(string, point);
                this.addObservation(point);
            }
            stationNames = this.getPointNames(3, true);
            for (String string : stationNames) {
                Point2D point2d = new Point2D(string, 0.0, 0.0);
                pointList.add(point2d);
                pointMap.put(string, point2d);
                this.addObservation(point2d);
            }
            for (Map.Entry entry : this.directionLinks.entrySet()) {
                String fixPointIdA = (String)entry.getKey();
                Point fixPointA = (Point)pointMap.get(fixPointIdA);
                for (String fixPointIdB : (Set)entry.getValue()) {
                    if (!this.directionLinks.containsKey(fixPointIdB) || !this.directionLinks.get(fixPointIdB).contains(fixPointIdA)) continue;
                    Point fixPointB = (Point)pointMap.get(fixPointIdB);
                    this.addForwardIntersectionCombinations(fixPointA, fixPointB);
                }
                ((Set)entry.getValue()).clear();
                fixPointA.joinBundles();
            }
            this.directionLinks.clear();
        }
        pointMap.clear();
        return pointList;
    }

    private void addObservation(Point point) throws SQLException {
        int dim = -1;
        if (point instanceof Point1D) {
            dim = 1;
        } else if (point instanceof Point2D) {
            dim = 2;
        } else {
            return;
        }
        String pointName = point.getName();
        List<TerrestrialObservationRow> deltaH = null;
        List<TerrestrialObservationRow> distances2D = null;
        List<TerrestrialObservationRow> distances3D = null;
        List<TerrestrialObservationRow> zenithangle = null;
        if (dim != 2) {
            deltaH = this.getTerrestrialObservationsIgnoreGroups(pointName, ObservationType.LEVELING);
        } else if (dim != 1) {
            distances2D = this.getTerrestrialObservationsIgnoreGroups(pointName, ObservationType.HORIZONTAL_DISTANCE);
        }
        distances3D = this.getTerrestrialObservationsIgnoreGroups(pointName, ObservationType.SLOPE_DISTANCE);
        zenithangle = this.getTerrestrialObservationsIgnoreGroups(pointName, ObservationType.ZENITH_ANGLE);
        if (dim != 1 && this.targetSystem2d != null && this.targetSystem2d.get(pointName) != null) {
            startPoint = this.targetSystem2d.get(pointName);
            i = 0;
            while (i < this.targetSystem2d.size()) {
                endPoint = this.targetSystem2d.get(i);
                if (!endPoint.getName().equals(pointName) && endPoint.getDimension() == 1) {
                    boolean hasObservedDistance = false;
                    for (TerrestrialObservationRow terrestrialObservationRow : distances2D) {
                        if ((!terrestrialObservationRow.getStartPointName().equals(startPoint.getName()) || !terrestrialObservationRow.getEndPointName().equals(endPoint.getName())) && (!terrestrialObservationRow.getStartPointName().equals(endPoint.getName()) || !terrestrialObservationRow.getEndPointName().equals(startPoint.getName()))) continue;
                        hasObservedDistance = true;
                        break;
                    }
                    if (!hasObservedDistance) {
                        TerrestrialObservationRow terrestrialObservationRow = new TerrestrialObservationRow();
                        terrestrialObservationRow.setStartPointName(startPoint.getName());
                        terrestrialObservationRow.setEndPointName(endPoint.getName());
                        terrestrialObservationRow.setValueApriori(startPoint.getDistance2D(endPoint));
                        distances2D.add(terrestrialObservationRow);
                    }
                }
                ++i;
            }
        } else if (dim != 2 && this.targetSystem1d != null && this.targetSystem1d.get(pointName) != null) {
            startPoint = this.targetSystem1d.get(pointName);
            i = 0;
            while (i < this.targetSystem1d.size()) {
                endPoint = this.targetSystem1d.get(i);
                if (!endPoint.getName().equals(pointName) && endPoint.getDimension() == 1) {
                    boolean hasObservedDeltaH = false;
                    for (TerrestrialObservationRow terrestrialObservationRow : deltaH) {
                        if ((!terrestrialObservationRow.getStartPointName().equals(startPoint.getName()) || !terrestrialObservationRow.getEndPointName().equals(endPoint.getName())) && (!terrestrialObservationRow.getStartPointName().equals(endPoint.getName()) || !terrestrialObservationRow.getEndPointName().equals(startPoint.getName()))) continue;
                        hasObservedDeltaH = true;
                        break;
                    }
                    if (!hasObservedDeltaH) {
                        TerrestrialObservationRow terrestrialObservationRow = new TerrestrialObservationRow();
                        terrestrialObservationRow.setStartPointName(startPoint.getName());
                        terrestrialObservationRow.setEndPointName(endPoint.getName());
                        terrestrialObservationRow.setValueApriori(endPoint.getZ() - startPoint.getZ());
                        deltaH.add(terrestrialObservationRow);
                    }
                }
                ++i;
            }
        }
        Map<String, Double> medianDeltaH = null;
        Map<String, Double> medianDistances2D = null;
        if (dim != 2) {
            medianDeltaH = this.getMedianDeltaH(pointName, deltaH, distances3D, zenithangle);
        } else if (dim != 1) {
            medianDistances2D = this.getMedianDistance2D(pointName, distances2D, distances3D, zenithangle);
        }
        zenithangle = null;
        distances3D = null;
        distances2D = null;
        deltaH = null;
        if (dim != 2 && medianDeltaH != null) {
            Point1D point1d = (Point1D)point;
            point1d.addBundle();
            for (Map.Entry<String, Double> e : medianDeltaH.entrySet()) {
                String endPointName = e.getKey();
                double dh = e.getValue();
                point1d.addObservedPoint(endPointName, dh);
            }
            point1d.joinBundles();
        } else if (dim != 1) {
            Point2D point2d = (Point2D)point;
            Map<Integer, List<TerrestrialObservationRow>> directions = this.getObservations(pointName, null, ObservationType.DIRECTION, -1);
            if (this.targetSystem2d != null && this.targetSystem2d.get(point2d.getName()) != null) {
                Point point2 = this.targetSystem2d.get(point2d.getName());
                ArrayList<TerrestrialObservationRow> dirSet = new ArrayList<TerrestrialObservationRow>();
                int i = 0;
                while (i < this.targetSystem2d.size()) {
                    Point endPoint = this.targetSystem2d.get(i);
                    if (!endPoint.getName().equals(point2d.getName()) && endPoint.getDimension() != 1) {
                        double dy = endPoint.getY() - point2.getY();
                        double dx = endPoint.getX() - point2.getX();
                        TerrestrialObservationRow obs = new TerrestrialObservationRow();
                        obs.setStartPointName(point2.getName());
                        obs.setEndPointName(endPoint.getName());
                        obs.setValueApriori(MathExtension.MOD(Math.atan2(dy, dx), Math.PI * 2));
                        dirSet.add(obs);
                    }
                    ++i;
                }
                if (dirSet.size() > 1) {
                    directions.put(-1, dirSet);
                }
            }
            for (List list : directions.values()) {
                Map<String, Double> medianDirection = this.getMedianDirections(list);
                point2d.addBundle();
                for (Map.Entry<String, Double> elm : medianDirection.entrySet()) {
                    String endPointName = elm.getKey();
                    double dir = elm.getValue();
                    if (!this.directionLinks.containsKey(point2d.getName())) {
                        this.directionLinks.put(point2d.getName(), new HashSet());
                    }
                    if (this.completestationNames.contains(endPointName)) {
                        this.directionLinks.get(point2d.getName()).add(endPointName);
                    }
                    if (medianDistances2D == null || !medianDistances2D.containsKey(endPointName)) continue;
                    double dist2d = medianDistances2D.get(endPointName);
                    point2d.addObservedPoint(endPointName, dir, dist2d);
                }
            }
            point2d.joinBundles();
        }
    }

    private Map<String, Double> getMedianDeltaH(String startPointName, List<TerrestrialObservationRow> deltaH, List<TerrestrialObservationRow> distances3D, List<TerrestrialObservationRow> zenithangles) {
        LinkedHashMap deltaHList = new LinkedHashMap();
        if (deltaH != null) {
            for (TerrestrialObservationRow dh : deltaH) {
                String endPointName = dh.getEndPointName();
                double h = ClassicGeodeticComputation.ORTHO_HEIGHT(dh.getValueApriori(), dh.getInstrumentHeight(), dh.getReflectorHeight());
                if (!deltaHList.containsKey(endPointName)) {
                    deltaHList.put(endPointName, new ArrayList());
                }
                ((List)deltaHList.get(endPointName)).add(h);
            }
        }
        if (distances3D != null && zenithangles != null) {
            int j = 0;
            while (j < zenithangles.size()) {
                String endPointName = zenithangles.get(j).getEndPointName();
                double zenith = zenithangles.get(j).getValueApriori();
                double ihZenith = zenithangles.get(j).getInstrumentHeight();
                double thZenith = zenithangles.get(j).getReflectorHeight();
                int i = 0;
                while (i < distances3D.size()) {
                    if (endPointName.equals(distances3D.get(i).getEndPointName())) {
                        double dist3d = distances3D.get(i).getValueApriori();
                        double ihDist = distances3D.get(i).getInstrumentHeight();
                        double thDist = distances3D.get(i).getReflectorHeight();
                        double slopeDist = ClassicGeodeticComputation.SLOPEDISTANCE(dist3d, ihDist, thDist, zenith, ihZenith, thZenith);
                        double h = ClassicGeodeticComputation.TRIGO_HEIGHT_3D(slopeDist, zenith, ihZenith, thZenith);
                        if (!deltaHList.containsKey(endPointName)) {
                            deltaHList.put(endPointName, new ArrayList());
                        }
                        ((List)deltaHList.get(endPointName)).add(h);
                    }
                    ++i;
                }
                if (this.targetSystem2d != null && this.targetSystem2d.contains(startPointName) && this.targetSystem2d.contains(endPointName) && !this.outlier2d.contains(startPointName) && !this.outlier2d.contains(endPointName)) {
                    double dist2d = this.targetSystem2d.get(startPointName).getDistance2D(this.targetSystem2d.get(endPointName));
                    double h = ClassicGeodeticComputation.TRIGO_HEIGHT_2D(dist2d, zenith, ihZenith, thZenith);
                    if (!deltaHList.containsKey(endPointName)) {
                        deltaHList.put(endPointName, new ArrayList());
                    }
                    ((List)deltaHList.get(endPointName)).add(h);
                }
                ++j;
            }
        }
        LinkedHashMap<String, Double> deltaHmap = new LinkedHashMap<String, Double>();
        for (Map.Entry e : deltaHList.entrySet()) {
            List list = (List)e.getValue();
            if (list.size() <= 0) continue;
            Collections.sort(list);
            deltaHmap.put((String)e.getKey(), (Double)list.get((list.size() - 1) / 2));
        }
        return deltaHmap;
    }

    private Map<String, Double> getMedianDistance2D(String startPointName, List<TerrestrialObservationRow> distances2D, List<TerrestrialObservationRow> distances3D, List<TerrestrialObservationRow> zenithangles) {
        LinkedHashMap dist2dList = new LinkedHashMap();
        if (distances2D != null) {
            for (TerrestrialObservationRow dist : distances2D) {
                String endPointName = dist.getEndPointName();
                if (!dist2dList.containsKey(endPointName)) {
                    dist2dList.put(endPointName, new ArrayList());
                }
                ((List)dist2dList.get(endPointName)).add(dist.getValueApriori());
            }
        }
        if (distances3D != null && zenithangles != null) {
            int i = 0;
            while (i < distances3D.size()) {
                String endPointName = distances3D.get(i).getEndPointName();
                double dist3d = distances3D.get(i).getValueApriori();
                double ihDist = distances3D.get(i).getInstrumentHeight();
                double thDist = distances3D.get(i).getReflectorHeight();
                int j = 0;
                while (j < zenithangles.size()) {
                    if (endPointName.equals(zenithangles.get(j).getEndPointName())) {
                        double zenith = zenithangles.get(j).getValueApriori();
                        double ihZenith = zenithangles.get(j).getInstrumentHeight();
                        double thZenith = zenithangles.get(j).getReflectorHeight();
                        double slopeDist = ClassicGeodeticComputation.SLOPEDISTANCE(dist3d, ihDist, thDist, zenith, ihZenith, thZenith);
                        double dist2d = ClassicGeodeticComputation.DISTANCE2D(slopeDist, zenith);
                        if (!dist2dList.containsKey(endPointName)) {
                            dist2dList.put(endPointName, new ArrayList());
                        }
                        ((List)dist2dList.get(endPointName)).add(dist2d);
                    }
                    ++j;
                }
                ++i;
            }
        }
        LinkedHashMap<String, Double> dist2D = new LinkedHashMap<String, Double>();
        for (Map.Entry e : dist2dList.entrySet()) {
            List list = (List)e.getValue();
            if (list.size() <= 0) continue;
            Collections.sort(list);
            dist2D.put((String)e.getKey(), (Double)list.get((list.size() - 1) / 2));
        }
        return dist2D;
    }

    private Map<String, Double> getMedianDirections(List<TerrestrialObservationRow> observations) {
        LinkedHashMap obsToPoint = new LinkedHashMap();
        for (TerrestrialObservationRow observation : observations) {
            String pointName = observation.getEndPointName();
            if (obsToPoint.containsKey(pointName)) {
                double refValue = (Double)((List)obsToPoint.get(pointName)).get(0);
                ((List)obsToPoint.get(pointName)).add(this.formingDirectionToFaceI(refValue, observation.getValueApriori()));
                continue;
            }
            ArrayList<Double> l = new ArrayList<Double>();
            l.add(observation.getValueApriori());
            obsToPoint.put(pointName, l);
        }
        LinkedHashMap<String, Double> dir = new LinkedHashMap<String, Double>();
        for (Map.Entry elm : obsToPoint.entrySet()) {
            List list = (List)elm.getValue();
            if (list.size() <= 0) continue;
            Collections.sort(list);
            double median = (Double)list.get((list.size() - 1) / 2);
            dir.put((String)elm.getKey(), median);
        }
        return dir;
    }

    private double formingDirectionToFaceI(double refValue, double dir) {
        double face2;
        double azimuthMeasuredFace1 = dir;
        double azimuthMeasuredFace2 = MathExtension.MOD(dir + Math.PI, Math.PI * 2);
        double face1 = Math.min(Math.abs(refValue - azimuthMeasuredFace1), Math.abs(Math.abs(refValue - azimuthMeasuredFace1) - Math.PI * 2));
        if (face1 > (face2 = Math.min(Math.abs(refValue - azimuthMeasuredFace2), Math.abs(Math.abs(refValue - azimuthMeasuredFace2) - Math.PI * 2)))) {
            return azimuthMeasuredFace2;
        }
        return azimuthMeasuredFace1;
    }

    private Point2D getArcIntersectionPoint(String pointName, PointBundle bundle) throws SQLException {
        if (bundle.isIntersection()) {
            return null;
        }
        ArrayList<Point2D> startPoints = new ArrayList<Point2D>();
        List<TerrestrialObservationRow> distances2d = this.getTerrestrialObservationsIgnoreGroups(pointName, ObservationType.HORIZONTAL_DISTANCE);
        Map<String, Double> medianDistance2d = this.getMedianDistance2D(pointName, distances2d, null, null);
        ArrayList<Point2D> endPoints = new ArrayList<Point2D>(medianDistance2d.size());
        ArrayList<Double> observations = new ArrayList<Double>(medianDistance2d.size());
        for (Map.Entry<String, Double> dist2d : medianDistance2d.entrySet()) {
            if (!bundle.contains(dist2d.getKey())) continue;
            endPoints.add((Point2D)bundle.get(dist2d.getKey()));
            observations.add(dist2d.getValue());
        }
        if (endPoints.size() < 3) {
            return null;
        }
        int k = 0;
        while (k < endPoints.size()) {
            Point2D A = (Point2D)endPoints.get(k);
            double s1 = (Double)observations.get(k);
            int l = k + 1;
            while (l < endPoints.size()) {
                int m = l + 1 < endPoints.size() ? l + 1 : 0;
                Point2D B = (Point2D)endPoints.get(l);
                Point2D C = (Point2D)endPoints.get(m);
                double s2 = (Double)observations.get(l);
                double s3 = (Double)observations.get(m);
                double s = A.getDistance2D(B);
                if (2.0 * s * s1 != 0.0) {
                    double tAB = ClassicGeodeticComputation.DIRECTION(A, B);
                    double alpha = Math.acos((s * s + s1 * s1 - s2 * s2) / (2.0 * s * s1));
                    Point2D tmp1 = ClassicGeodeticComputation.POLAR(A, pointName, tAB + alpha, s1);
                    Point2D tmp2 = ClassicGeodeticComputation.POLAR(A, pointName, tAB - alpha, s1);
                    if (Math.abs(C.getDistance2D(tmp1) - s3) < Math.abs(C.getDistance2D(tmp2) - s3)) {
                        startPoints.add(tmp1);
                    } else {
                        startPoints.add(tmp2);
                    }
                }
                ++l;
            }
            ++k;
        }
        return (Point2D)this.getMedianPoint(startPoints);
    }

    private Point2D getBackwardIntersectionPoint(String startPointName, PointBundle bundle) throws SQLException {
        ArrayList<Point2D> startPoints = new ArrayList<Point2D>();
        Map<Integer, List<TerrestrialObservationRow>> directions = this.getObservations(startPointName, null, ObservationType.DIRECTION, -1);
        for (List<TerrestrialObservationRow> directionSets : directions.values()) {
            Map<String, Double> medianDirection = this.getMedianDirections(directionSets);
            ArrayList<Point2D> endPoints = new ArrayList<Point2D>(medianDirection.size());
            ArrayList<Double> observations = new ArrayList<Double>(medianDirection.size());
            for (Map.Entry<String, Double> dir : medianDirection.entrySet()) {
                if (!bundle.contains(dir.getKey())) continue;
                endPoints.add((Point2D)bundle.get(dir.getKey()));
                observations.add(dir.getValue());
            }
            if (endPoints.size() < 3) {
                return null;
            }
            int k = 0;
            while (k < endPoints.size()) {
                Point2D A = (Point2D)endPoints.get(k);
                double rA = (Double)observations.get(k);
                int l = k + 1;
                while (l < endPoints.size()) {
                    Point2D B = (Point2D)endPoints.get(l);
                    double rB = (Double)observations.get(l);
                    double distAB = A.getDistance2D(B);
                    double tAB = ClassicGeodeticComputation.DIRECTION(A, B);
                    int m = l + 1;
                    while (m < endPoints.size()) {
                        double sinAlphaBeta;
                        double beta;
                        Point2D C = (Point2D)endPoints.get(m);
                        double rC = (Double)observations.get(m);
                        double distAC = A.getDistance2D(C);
                        double tAC = ClassicGeodeticComputation.DIRECTION(A, C);
                        double alpha = MathExtension.MOD(rB - rA, Math.PI * 2);
                        if (alpha + (beta = MathExtension.MOD(rC - rB, Math.PI * 2)) > Math.PI) {
                            alpha -= Math.PI;
                            beta -= Math.PI;
                        }
                        if ((sinAlphaBeta = Math.sin(alpha + beta)) != 0.0) {
                            double distAF;
                            double gamma = tAB - tAC;
                            double distGH = -distAC * Math.sin(alpha) / sinAlphaBeta * Math.sin(beta);
                            double distAG = distAC * Math.sin(alpha) / sinAlphaBeta * Math.cos(beta);
                            double distFB = distAB * Math.sin(gamma);
                            double delta = Math.atan2(distGH - distFB, distAG - (distAF = distAB * Math.cos(gamma)));
                            if (delta > Math.PI) {
                                delta -= Math.PI;
                            }
                            double tAN = tAC + delta - alpha;
                            double distAN = distAC * Math.sin(delta + beta) / sinAlphaBeta;
                            Point2D N = ClassicGeodeticComputation.POLAR(A, startPointName, tAN, distAN);
                            startPoints.add(N);
                        }
                        ++m;
                    }
                    ++l;
                }
                ++k;
            }
        }
        return (Point2D)this.getMedianPoint(startPoints);
    }

    private Point2D getForwardIntersectionPoint(String newPointId, PointBundle bundle) throws SQLException {
        String sql = "SELECT DISTINCT \"start_point_name\", \"group_id\" FROM \"ObservationApriori\" AS \"o1\" JOIN \"ObservationGroup\" AS \"g1\" ON \"g1\".\"id\" = \"o1\".\"group_id\" AND \"g1\".\"enable\" = TRUE JOIN \"PointApriori\" ON \"PointApriori\".\"name\" = \"o1\".\"start_point_name\" AND \"PointApriori\".\"enable\" = TRUE JOIN \"PointGroup\" ON \"PointApriori\".\"group_id\" = \"PointGroup\".\"id\" AND \"PointGroup\".\"enable\" = TRUE WHERE \"o1\".\"enable\" = TRUE AND \"g1\".\"type\" = ? AND \"o1\".\"end_point_name\" = ?";
        ArrayList<Integer> groups = new ArrayList<Integer>();
        LinkedHashMap<Integer, TerrestrialObservationRow> directionSets = new LinkedHashMap<Integer, TerrestrialObservationRow>();
        PreparedStatement statement = this.dataBase.getPreparedStatement(sql);
        statement.setInt(1, ObservationType.DIRECTION.getId());
        statement.setString(2, newPointId);
        ResultSet result = statement.executeQuery();
        while (result.next()) {
            Map<Integer, List<TerrestrialObservationRow>> directions;
            TerrestrialObservationRow orientatedDirectionAngle;
            int groupId = result.getInt("group_id");
            String startPointName = result.getString("start_point_name");
            if (!bundle.contains(startPointName) || (orientatedDirectionAngle = this.getOrientatedDirectionAngle(newPointId, (directions = this.getObservations(startPointName, null, ObservationType.DIRECTION, groupId)).get(groupId), bundle)) == null) continue;
            directionSets.put(groupId, orientatedDirectionAngle);
            groups.add(groupId);
        }
        ForwardIntersectionSet forwardIntersections = new ForwardIntersectionSet();
        int i = 0;
        while (i < groups.size()) {
            TerrestrialObservationRow directionAngleA = (TerrestrialObservationRow)directionSets.get(groups.get(i));
            String fixPointIdA = directionAngleA.getStartPointName();
            Point2D fixPointA = (Point2D)bundle.get(fixPointIdA);
            if (fixPointIdA != null) {
                int j = i + 1;
                while (j < groups.size()) {
                    TerrestrialObservationRow directionAngleB = (TerrestrialObservationRow)directionSets.get(groups.get(j));
                    String fixPointIdB = directionAngleB.getStartPointName();
                    Point2D fixPointB = (Point2D)bundle.get(fixPointIdB);
                    if (fixPointB != null && !fixPointIdA.equals(fixPointIdB)) {
                        double rAB = ClassicGeodeticComputation.DIRECTION(fixPointA, fixPointB);
                        double rAN = directionAngleA.getValueApriori();
                        double rBA = MathExtension.MOD(rAB + Math.PI, Math.PI * 2);
                        double rBN = directionAngleB.getValueApriori();
                        forwardIntersections.add(fixPointA, fixPointB, newPointId, rAB, rAN, rBA, rBN);
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<Point2D> points = forwardIntersections.adjustForwardIntersections();
        return (Point2D)this.getMedianPoint(points);
    }

    private void addForwardIntersectionCombinations(Point referencePointA, Point referencePointB) throws SQLException {
        int offsetX = 10;
        int offsetY = 20;
        ForwardIntersectionSet forwardIntersections = new ForwardIntersectionSet();
        String referencePointNameA = referencePointA.getName();
        String referencePointNameB = referencePointB.getName();
        Point2D tmpReferencePointA = new Point2D(referencePointNameA, 0.0, 0.0);
        Point2D tmpReferencePointB = new Point2D(referencePointNameB, offsetX, offsetY);
        String sqlPoint = "SELECT DISTINCT \"end_point_name\" FROM \"ObservationApriori\" AS \"o1\" JOIN \"PointApriori\" AS \"pa1\" ON \"o1\".\"end_point_name\" = \"pa1\".\"name\" AND \"pa1\".\"enable\" = TRUE JOIN \"PointGroup\" AS \"pg1\" ON \"pa1\".\"group_id\" = \"pg1\".\"id\" AND \"pg1\".\"enable\" = TRUE JOIN \"ObservationApriori\" AS \"o2\" ON \"o1\".\"end_point_name\" = \"o2\".\"end_point_name\" AND \"o1\".\"start_point_name\" != \"o2\".\"start_point_name\" JOIN \"ObservationGroup\" AS \"g1\" ON \"g1\".\"id\" = \"o1\".\"group_id\" AND \"g1\".\"enable\" = TRUE JOIN \"ObservationGroup\" AS \"g2\" ON \"g2\".\"id\" = \"o2\".\"group_id\" AND \"g1\".\"type\" = \"g2\".\"type\" AND \"g2\".\"enable\" = TRUE WHERE \"g1\".\"type\" = ? AND \"o1\".\"start_point_name\" = ? AND  \"o2\".\"start_point_name\" = ?  AND \"o1\".\"enable\" = TRUE AND \"o2\".\"enable\" = TRUE";
        String sqlObservation = "SELECT \"group_id\", \"end_point_name\", \"value_0\" FROM \"ObservationApriori\" JOIN \"ObservationGroup\" ON \"ObservationGroup\".\"id\" = \"ObservationApriori\".\"group_id\" AND \"ObservationGroup\".\"enable\" = TRUE AND \"ObservationGroup\".\"type\" = ? WHERE \"enable\" = TRUE AND \"start_point_name\" = ? AND \"end_point_name\" IN (?, ?) ORDER BY \"group_id\", \"end_point_name\", \"id\"";
        LinkedHashSet<String> identEndPoints = new LinkedHashSet<String>();
        PreparedStatement statement = this.dataBase.getPreparedStatement(sqlPoint);
        statement.setInt(1, ObservationType.DIRECTION.getId());
        statement.setString(2, referencePointNameA);
        statement.setString(3, referencePointNameB);
        ResultSet result = statement.executeQuery();
        while (result.next()) {
            String pointName = result.getString("end_point_name");
            if (referencePointA.containsPointInBundle(pointName) && referencePointB.containsPointInBundle(pointName)) continue;
            identEndPoints.add(pointName);
        }
        statement = this.dataBase.getPreparedStatement(sqlObservation);
        statement.setInt(1, ObservationType.DIRECTION.getId());
        for (String pointName : identEndPoints) {
            Map<String, Double> median;
            TerrestrialObservationRow obs;
            double value;
            String endPointName;
            int groupId;
            statement.setString(4, pointName);
            LinkedHashMap observationsA = new LinkedHashMap();
            LinkedHashMap observationsB = new LinkedHashMap();
            statement.setString(2, referencePointNameA);
            statement.setString(3, referencePointNameB);
            result = statement.executeQuery();
            while (result.next()) {
                groupId = result.getInt("group_id");
                endPointName = result.getString("end_point_name");
                value = result.getDouble("value_0");
                if (!observationsA.containsKey(groupId)) {
                    observationsA.put(groupId, new ArrayList());
                }
                obs = new TerrestrialObservationRow();
                obs.setStartPointName(referencePointNameA);
                obs.setEndPointName(endPointName);
                obs.setValueApriori(value);
                ((ArrayList)observationsA.get(groupId)).add(obs);
            }
            statement.setString(2, referencePointNameB);
            statement.setString(3, referencePointNameA);
            result = statement.executeQuery();
            while (result.next()) {
                groupId = result.getInt("group_id");
                endPointName = result.getString("end_point_name");
                value = result.getDouble("value_0");
                if (!observationsB.containsKey(groupId)) {
                    observationsB.put(groupId, new ArrayList());
                }
                obs = new TerrestrialObservationRow();
                obs.setStartPointName(referencePointNameB);
                obs.setEndPointName(endPointName);
                obs.setValueApriori(value);
                ((ArrayList)observationsB.get(groupId)).add(obs);
            }
            LinkedHashMap<Integer, Map<String, Double>> medianObsA = new LinkedHashMap<Integer, Map<String, Double>>();
            LinkedHashMap<Integer, Map<String, Double>> medianObsB = new LinkedHashMap<Integer, Map<String, Double>>();
            for (Map.Entry groupObsA : observationsA.entrySet()) {
                int groupId2 = (Integer)groupObsA.getKey();
                List obsA = (List)groupObsA.getValue();
                median = this.getMedianDirections(obsA);
                if (!median.containsKey(referencePointNameB) || !median.containsKey(pointName)) continue;
                medianObsA.put(groupId2, median);
            }
            for (Map.Entry groupObsB : observationsB.entrySet()) {
                int groupId3 = (Integer)groupObsB.getKey();
                List obsB = (List)groupObsB.getValue();
                median = this.getMedianDirections(obsB);
                if (!median.containsKey(referencePointNameA) || !median.containsKey(pointName)) continue;
                medianObsB.put(groupId3, median);
            }
            for (Map medianA : medianObsA.values()) {
                double rAB = (Double)medianA.get(referencePointNameB);
                double rAN = (Double)medianA.get(pointName);
                for (Map medianB : medianObsB.values()) {
                    double rBA = (Double)medianB.get(referencePointNameA);
                    double rBN = (Double)medianB.get(pointName);
                    forwardIntersections.add(tmpReferencePointA, tmpReferencePointB, pointName, rAB, rAN, rBA, rBN);
                }
            }
        }
        Map<String, ForwardIntersectionEntry> forwardIntersectionMap = forwardIntersections.getForwardIntersectionsByFixPoints(tmpReferencePointA, tmpReferencePointB);
        if (forwardIntersectionMap != null) {
            for (ForwardIntersectionEntry forwardIntersection : forwardIntersectionMap.values()) {
                Point2D intersectionPoint = forwardIntersection.adjust();
                referencePointA.addBundle(true);
                PointBundle bundle = referencePointA.getCurrentBundle();
                bundle.addPoint(intersectionPoint);
                bundle.addPoint(tmpReferencePointB);
                referencePointB.addBundle(true);
                bundle = referencePointB.getCurrentBundle();
                bundle.addPoint(new Point2D(intersectionPoint.getName(), intersectionPoint.getX() - (double)offsetX, intersectionPoint.getY() - (double)offsetY));
                bundle.addPoint(new Point2D(tmpReferencePointA.getName(), tmpReferencePointA.getX() - (double)offsetX, tmpReferencePointA.getY() - (double)offsetY));
            }
        }
    }

    private Map<Integer, List<TerrestrialObservationRow>> getObservations(String startPointName, String endPointName, ObservationType type, int groupId) throws SQLException {
        LinkedHashMap<Integer, List<TerrestrialObservationRow>> observations = new LinkedHashMap<Integer, List<TerrestrialObservationRow>>();
        boolean isAngle = type == ObservationType.DIRECTION || type == ObservationType.ZENITH_ANGLE;
        String[] sqlFormatObs = new String[isAngle ? 1 : 2];
        sqlFormatObs[0] = "SELECT \"ObservationApriori\".\"end_point_name\" AS \"end_point_name\", \"ObservationApriori\".\"group_id\" AS \"group_id\", \"ObservationApriori\".\"id\" AS \"id\", \"ObservationApriori\".\"instrument_height\" AS \"instrument_height\", \"ObservationApriori\".\"reflector_height\" AS \"reflector_height\", \"ObservationApriori\".\"value_0\" AS \"value_0\" FROM \"ObservationApriori\" INNER JOIN \"ObservationGroup\" ON \"ObservationGroup\".\"id\" = \"ObservationApriori\".\"group_id\" AND \"ObservationGroup\".\"type\" = ? AND \"ObservationApriori\".\"start_point_name\" = ? AND " + (endPointName != null ? "\"ObservationApriori\".\"end_point_name\" = ? AND " : "") + (groupId >= 0 ? "\"ObservationApriori\".\"group_id\" = ? AND " : "") + "\"ObservationApriori\".\"enable\" = TRUE AND \"ObservationGroup\".\"enable\" = TRUE INNER JOIN \"PointApriori\" AS \"ps\" ON \"ObservationApriori\".\"start_point_name\" = \"ps\".\"name\" AND \"ps\".\"enable\" = TRUE INNER JOIN \"PointApriori\" AS \"pe\" ON \"ObservationApriori\".\"end_point_name\" = \"pe\".\"name\" AND \"pe\".\"enable\" = TRUE INNER JOIN \"PointGroup\" AS \"gs\" ON \"ps\".\"group_id\" = \"gs\".\"id\" AND \"gs\".\"enable\" = TRUE INNER JOIN \"PointGroup\" AS \"ge\" ON \"pe\".\"group_id\" = \"ge\".\"id\" AND \"ge\".\"enable\" = TRUE ORDER BY \"ObservationApriori\".\"id\" ASC";
        if (!isAngle) {
            sqlFormatObs[1] = "SELECT \"ObservationApriori\".\"start_point_name\" AS \"end_point_name\", \"ObservationApriori\".\"group_id\" AS \"group_id\", \"ObservationApriori\".\"id\" AS \"id\", \"ObservationApriori\".\"instrument_height\" AS \"reflector_height\", \"ObservationApriori\".\"reflector_height\" AS \"instrument_height\", " + (type == ObservationType.LEVELING ? "-" : "") + "\"ObservationApriori\".\"value_0\" AS \"value_0\" FROM \"ObservationApriori\" INNER JOIN \"ObservationGroup\" ON \"ObservationGroup\".\"id\" = \"ObservationApriori\".\"group_id\" AND \"ObservationGroup\".\"type\" = ? AND \"ObservationApriori\".\"end_point_name\" = ? AND " + (endPointName != null ? "\"ObservationApriori\".\"start_point_name\" = ? AND " : "") + (groupId >= 0 ? "\"ObservationApriori\".\"group_id\" = ? AND " : "") + "\"ObservationApriori\".\"enable\" = TRUE AND \"ObservationGroup\".\"enable\" = TRUE INNER JOIN \"PointApriori\" AS \"ps\" ON \"ObservationApriori\".\"start_point_name\" = \"ps\".\"name\" AND \"ps\".\"enable\" = TRUE INNER JOIN \"PointApriori\" AS \"pe\" ON \"ObservationApriori\".\"end_point_name\" = \"pe\".\"name\" AND \"pe\".\"enable\" = TRUE INNER JOIN \"PointGroup\" AS \"gs\" ON \"ps\".\"group_id\" = \"gs\".\"id\" AND \"gs\".\"enable\" = TRUE INNER JOIN \"PointGroup\" AS \"ge\" ON \"pe\".\"group_id\" = \"ge\".\"id\" AND \"ge\".\"enable\" = TRUE ORDER BY \"ObservationApriori\".\"id\" ASC";
        }
        PreparedStatement statementPointObservations = null;
        String[] stringArray = sqlFormatObs;
        int n = sqlFormatObs.length;
        int n2 = 0;
        while (n2 < n) {
            String sqlFormatOb = stringArray[n2];
            int col = 1;
            statementPointObservations = this.dataBase.getPreparedStatement(sqlFormatOb);
            statementPointObservations.setInt(col++, type.getId());
            statementPointObservations.setString(col++, startPointName);
            if (endPointName != null) {
                statementPointObservations.setString(col++, endPointName);
            }
            if (groupId >= 0) {
                statementPointObservations.setInt(col++, groupId);
            }
            ResultSet obsSet = statementPointObservations.executeQuery();
            while (obsSet.next()) {
                endPointName = obsSet.getString("end_point_name");
                int group_id = obsSet.getInt("group_id");
                double value = obsSet.getDouble("value_0");
                double ih = obsSet.getDouble("instrument_height");
                double th = obsSet.getDouble("reflector_height");
                TerrestrialObservationRow obs = new TerrestrialObservationRow();
                obs.setStartPointName(startPointName);
                obs.setEndPointName(endPointName);
                obs.setInstrumentHeight(ih);
                obs.setReflectorHeight(th);
                obs.setValueApriori(value);
                if (observations.containsKey(group_id)) {
                    ((List)observations.get(group_id)).add(obs);
                    continue;
                }
                ArrayList<TerrestrialObservationRow> obsList = new ArrayList<TerrestrialObservationRow>();
                obsList.add(obs);
                observations.put(group_id, obsList);
            }
            ++n2;
        }
        return observations;
    }

    private List<TerrestrialObservationRow> getTerrestrialObservationsIgnoreGroups(String startPointName, ObservationType type) throws SQLException {
        ArrayList<TerrestrialObservationRow> observations = new ArrayList<TerrestrialObservationRow>();
        Object sqlFormatObs = "SELECT \"ObservationApriori\".\"end_point_name\" AS \"end_point_name\", \"ObservationApriori\".\"group_id\" AS \"group_id\", \"ObservationApriori\".\"instrument_height\" AS \"instrument_height\", \"ObservationApriori\".\"reflector_height\" AS \"reflector_height\", \"ObservationApriori\".\"value_0\" AS \"value_0\" FROM \"ObservationApriori\" JOIN \"ObservationGroup\" ON \"ObservationGroup\".\"id\" = \"ObservationApriori\".\"group_id\" AND \"ObservationGroup\".\"type\" = ? AND \"ObservationApriori\".\"start_point_name\" = ? AND \"ObservationApriori\".\"enable\" = TRUE AND \"ObservationGroup\".\"enable\" = TRUE JOIN \"PointApriori\" AS \"ps\" ON \"ObservationApriori\".\"start_point_name\" = \"ps\".\"name\" AND \"ps\".\"enable\" = TRUE JOIN \"PointApriori\" AS \"pe\" ON \"ObservationApriori\".\"end_point_name\" = \"pe\".\"name\" AND \"pe\".\"enable\" = TRUE JOIN \"PointGroup\" AS \"gs\" ON \"ps\".\"group_id\" = \"gs\".\"id\" AND \"gs\".\"enable\" = TRUE JOIN \"PointGroup\" AS \"ge\" ON \"pe\".\"group_id\" = \"ge\".\"id\" AND \"ge\".\"enable\" = TRUE";
        if (type != ObservationType.DIRECTION) {
            sqlFormatObs = (String)sqlFormatObs + " UNION ALL SELECT \"ObservationApriori\".\"start_point_name\" AS \"end_point_name\", \"ObservationApriori\".\"group_id\" AS \"group_id\", \"ObservationApriori\".\"instrument_height\" AS \"reflector_height\", \"ObservationApriori\".\"reflector_height\" AS \"instrument_height\", " + (type == ObservationType.LEVELING ? "-" : (type == ObservationType.ZENITH_ANGLE ? "PI()-" : "")) + "\"ObservationApriori\".\"value_0\" AS \"value_0\" FROM \"ObservationApriori\" JOIN \"ObservationGroup\" ON \"ObservationGroup\".\"id\" = \"ObservationApriori\".\"group_id\" AND \"ObservationGroup\".\"type\" = ? AND \"ObservationApriori\".\"end_point_name\" = ? AND \"ObservationApriori\".\"enable\" = TRUE AND \"ObservationGroup\".\"enable\" = TRUE JOIN \"PointApriori\" AS \"ps\" ON \"ObservationApriori\".\"start_point_name\" = \"ps\".\"name\" AND \"ps\".\"enable\" = TRUE JOIN \"PointApriori\" AS \"pe\" ON \"ObservationApriori\".\"end_point_name\" = \"pe\".\"name\" AND \"pe\".\"enable\" = TRUE JOIN \"PointGroup\" AS \"gs\" ON \"ps\".\"group_id\" = \"gs\".\"id\" AND \"gs\".\"enable\" = TRUE JOIN \"PointGroup\" AS \"ge\" ON \"pe\".\"group_id\" = \"ge\".\"id\" AND \"ge\".\"enable\" = TRUE";
        }
        PreparedStatement statementPointObservations = null;
        statementPointObservations = this.dataBase.getPreparedStatement((String)sqlFormatObs);
        statementPointObservations.setInt(1, type.getId());
        statementPointObservations.setString(2, startPointName);
        if (type != ObservationType.DIRECTION) {
            statementPointObservations.setInt(3, type.getId());
            statementPointObservations.setString(4, startPointName);
        }
        ResultSet obsSet = statementPointObservations.executeQuery();
        while (obsSet.next()) {
            String endPointName = obsSet.getString("end_point_name");
            double value = obsSet.getDouble("value_0");
            double ih = obsSet.getDouble("instrument_height");
            double th = obsSet.getDouble("reflector_height");
            TerrestrialObservationRow obs = new TerrestrialObservationRow();
            obs.setStartPointName(startPointName);
            obs.setEndPointName(endPointName);
            obs.setInstrumentHeight(ih);
            obs.setReflectorHeight(th);
            obs.setValueApriori(value);
            observations.add(obs);
        }
        return observations;
    }

    private List<String> getPointNames(int dim, boolean stationsOnly) throws SQLException {
        ArrayList<String> pointNames = new ArrayList<String>();
        String sqlFormatPoints = stationsOnly ? "SELECT DISTINCT \"start_point_name\" AS \"name\" FROM \"ObservationApriori\" JOIN \"PointApriori\" ON \"PointApriori\".\"name\" = \"ObservationApriori\".\"start_point_name\" JOIN \"PointGroup\" ON \"PointApriori\".\"group_id\" = \"PointGroup\".\"id\" WHERE \"ObservationApriori\".\"enable\" = TRUE AND \"PointApriori\".\"enable\" = TRUE AND \"PointGroup\".\"enable\" = TRUE AND \"PointGroup\".\"dimension\" = ?" : "SELECT \"name\" FROM \"PointApriori\" JOIN \"PointGroup\" ON \"PointApriori\".\"group_id\" = \"PointGroup\".\"id\" WHERE \"PointGroup\".\"enable\" = TRUE AND \"PointApriori\".\"enable\" = TRUE AND \"PointGroup\".\"dimension\" = ?";
        PreparedStatement statementPoints = this.dataBase.getPreparedStatement(sqlFormatPoints);
        statementPoints.setInt(1, dim);
        ResultSet pointNameSet = statementPoints.executeQuery();
        while (pointNameSet.next()) {
            String pointName = pointNameSet.getString("name");
            pointNames.add(pointName);
        }
        return pointNames;
    }

    private void initTargetSystems(boolean isFreeNet) throws SQLException {
        String sqlGroup = "SELECT \"id\" FROM \"PointGroup\" WHERE (\"type\" = ? OR \"type\" = ?) AND \"dimension\" = ? AND \"enable\" = TRUE ORDER BY \"id\" ASC";
        String sqlPoint = "SELECT \"name\", \"x0\", \"y0\", \"z0\" FROM \"PointApriori\" WHERE \"group_id\" = ? AND \"enable\" = TRUE ORDER BY \"id\" ASC";
        PointBundle targetSystem1d = new PointBundle(1);
        PointBundle targetSystem2d = new PointBundle(2);
        PreparedStatement statementGroup = this.dataBase.getPreparedStatement(sqlGroup);
        PreparedStatement statementPoint = this.dataBase.getPreparedStatement(sqlPoint);
        int pointDim = 1;
        while (pointDim < 4) {
            if (!isFreeNet) {
                statementGroup.setInt(1, PointType.REFERENCE_POINT.getId());
                statementGroup.setInt(2, PointType.STOCHASTIC_POINT.getId());
            } else {
                statementGroup.setInt(1, PointType.DATUM_POINT.getId());
                statementGroup.setInt(2, PointType.DATUM_POINT.getId());
            }
            statementGroup.setInt(3, pointDim);
            ResultSet groupSet = statementGroup.executeQuery();
            while (groupSet.next()) {
                statementPoint.setInt(1, groupSet.getInt("id"));
                ResultSet pointsSet = statementPoint.executeQuery();
                while (pointsSet.next()) {
                    Point point;
                    if (pointDim == 1) {
                        point = new Point1D(pointsSet.getString("name"), pointsSet.getDouble("z0"));
                        if (targetSystem1d.get(point.getName()) != null) continue;
                        targetSystem1d.addPoint(point);
                        continue;
                    }
                    if (pointDim == 2) {
                        point = new Point2D(pointsSet.getString("name"), pointsSet.getDouble("x0"), pointsSet.getDouble("y0"));
                        if (targetSystem2d.get(point.getName()) != null) continue;
                        targetSystem2d.addPoint(point);
                        continue;
                    }
                    if (pointDim != 3) continue;
                    Point1D point1d = new Point1D(pointsSet.getString("name"), pointsSet.getDouble("z0"));
                    Point2D point2d = new Point2D(pointsSet.getString("name"), pointsSet.getDouble("x0"), pointsSet.getDouble("y0"));
                    if (targetSystem1d.get(point1d.getName()) == null) {
                        targetSystem1d.addPoint(point1d);
                    }
                    if (targetSystem2d.get(point2d.getName()) != null) continue;
                    targetSystem2d.addPoint(point2d);
                }
            }
            ++pointDim;
        }
        if (targetSystem1d != null && targetSystem1d.size() > 0) {
            this.targetSystem1d = targetSystem1d;
        }
        if (targetSystem2d != null && targetSystem2d.size() > 0) {
            this.targetSystem2d = targetSystem2d;
        }
    }

    private void savePoints(PointBundle bundle) throws SQLException {
        int i = 0;
        while (bundle != null && i < bundle.size()) {
            this.savePoint(bundle.get(i));
            ++i;
        }
    }

    private void savePoint(Point p) throws SQLException {
        if (p == null) {
            return;
        }
        String sqlPoint = null;
        if (p.getDimension() == 1) {
            sqlPoint = "UPDATE \"PointApriori\" SET \"z0\" = ? WHERE \"name\" = ?";
        } else if (p.getDimension() == 2) {
            sqlPoint = "UPDATE \"PointApriori\" SET \"x0\" = ?, \"y0\" = ? WHERE \"name\" = ?";
        } else {
            return;
        }
        PreparedStatement statementPoint = this.dataBase.getPreparedStatement(sqlPoint);
        if (p.getDimension() == 1) {
            statementPoint.setDouble(1, p.getZ());
            statementPoint.setString(2, p.getName());
        } else if (p.getDimension() == 2) {
            statementPoint.setDouble(1, p.getX());
            statementPoint.setDouble(2, p.getY());
            statementPoint.setString(3, p.getName());
        }
        statementPoint.execute();
    }

    public void transferAposteriori2AprioriValues() throws SQLException {
        String sql = "UPDATE \"AdditionalParameterApriori\" SET \"value_0\" = CASE WHEN (SELECT \"value\" FROM \"AdditionalParameterAposteriori\" WHERE \"AdditionalParameterApriori\".\"id\" = \"AdditionalParameterAposteriori\".\"id\")  ELSE \"value_0\" END WHERE \"enable\" = TRUE";
        PreparedStatement stmt = this.dataBase.getPreparedStatement(sql);
        stmt.execute();
    }

    public void transferAposteriori2AprioriValues(boolean transferDatumPoints) throws SQLException {
        String sql = "UPDATE \"AdditionalParameterApriori\" SET \"value_0\" = IFNULL((SELECT \"value\" FROM \"AdditionalParameterAposteriori\" WHERE \"AdditionalParameterApriori\".\"id\" = \"AdditionalParameterAposteriori\".\"id\"),  \"value_0\") WHERE \"enable\" = TRUE";
        PreparedStatement stmt = this.dataBase.getPreparedStatement(sql);
        stmt.execute();
        int pointDimension = 3;
        sql = "UPDATE \"PointApriori\" SET \"x0\" = IFNULL((SELECT \"x\" FROM \"PointAposteriori\" JOIN \"PointGroup\" ON \"group_id\" = \"PointGroup\".\"id\" AND \"PointGroup\".\"enable\" = TRUE AND \"PointGroup\".\"type\" IN (?, ?) WHERE \"PointApriori\".\"id\" = \"PointAposteriori\".\"id\" AND \"enable\" = TRUE), \"x0\"), \"y0\" = IFNULL((SELECT \"y\" FROM \"PointAposteriori\" JOIN \"PointGroup\" ON \"group_id\" = \"PointGroup\".\"id\" AND \"PointGroup\".\"enable\" = TRUE AND \"PointGroup\".\"type\" IN (?, ?) WHERE \"PointApriori\".\"id\" = \"PointAposteriori\".\"id\" AND \"enable\" = TRUE), \"y0\"), \"z0\" = IFNULL((SELECT \"z\" FROM \"PointAposteriori\" JOIN \"PointGroup\" ON \"group_id\" = \"PointGroup\".\"id\" AND \"PointGroup\".\"enable\" = TRUE AND \"PointGroup\".\"type\" IN (?, ?) WHERE \"PointApriori\".\"id\" = \"PointAposteriori\".\"id\" AND \"enable\" = TRUE), \"z0\") WHERE \"enable\" = TRUE";
        stmt = this.dataBase.getPreparedStatement(sql);
        int i = 0;
        int j = 1;
        while (i < pointDimension) {
            stmt.setInt(j++, PointType.NEW_POINT.getId());
            stmt.setInt(j++, transferDatumPoints ? PointType.DATUM_POINT.getId() : PointType.NEW_POINT.getId());
            ++i;
        }
        stmt.execute();
        int deflectionDimension = 2;
        sql = "UPDATE \"VerticalDeflectionApriori\" SET \"x0\" = IFNULL((SELECT \"x\" FROM \"VerticalDeflectionAposteriori\" JOIN \"VerticalDeflectionGroup\" ON \"group_id\" = \"VerticalDeflectionGroup\".\"id\" AND \"VerticalDeflectionGroup\".\"enable\" = TRUE AND \"VerticalDeflectionGroup\".\"type\" IN (?, ?) WHERE \"VerticalDeflectionApriori\".\"id\" = \"VerticalDeflectionAposteriori\".\"id\" AND \"enable\" = TRUE), \"x0\"), \"y0\" = IFNULL((SELECT \"y\" FROM \"VerticalDeflectionAposteriori\" JOIN \"VerticalDeflectionGroup\" ON \"group_id\" = \"VerticalDeflectionGroup\".\"id\" AND \"VerticalDeflectionGroup\".\"enable\" = TRUE AND \"VerticalDeflectionGroup\".\"type\" IN (?, ?) WHERE \"VerticalDeflectionApriori\".\"id\" = \"VerticalDeflectionAposteriori\".\"id\" AND \"enable\" = TRUE), \"y0\") WHERE \"enable\" = TRUE";
        stmt = this.dataBase.getPreparedStatement(sql);
        int i2 = 0;
        int j2 = 1;
        while (i2 < deflectionDimension) {
            stmt.setInt(j2++, VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION.getId());
            stmt.setInt(j2++, VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION.getId());
            ++i2;
        }
        stmt.execute();
        this.estimationStatus1D = EstimationStateType.ERROR_FREE_ESTIMATION;
        this.estimationStatus2D = EstimationStateType.ERROR_FREE_ESTIMATION;
    }

    private TerrestrialObservationRow getOrientatedDirectionAngle(String newPointId, List<TerrestrialObservationRow> directionSet, PointBundle bundle) {
        Map<String, Double> medianDirectionSet = this.getMedianDirections(directionSet);
        int count = medianDirectionSet.size();
        String startPointName = directionSet.get(0).getStartPointName();
        Point2D startPoint = (Point2D)bundle.get(startPointName);
        if (startPoint == null) {
            return null;
        }
        ArrayList<Double> o = new ArrayList<Double>(count);
        int i = 0;
        for (Map.Entry<String, Double> direction : medianDirectionSet.entrySet()) {
            String endPointName = direction.getKey();
            Point2D endPoint = (Point2D)bundle.get(endPointName);
            if (endPoint == null) continue;
            double obsDir = direction.getValue();
            double calDir = ClassicGeodeticComputation.DIRECTION(startPoint, endPoint);
            double tmp_o = obsDir - calDir;
            tmp_o = MathExtension.MOD(tmp_o, Math.PI * 2);
            if (i > 0 && Math.PI * 2 - Math.abs((Double)o.get(i - 1) - tmp_o) < 0.5) {
                tmp_o = tmp_o < (Double)o.get(i - 1) ? (tmp_o += Math.PI * 2) : (tmp_o -= Math.PI * 2);
            }
            o.add(tmp_o);
            ++i;
        }
        if (o.size() == 0) {
            return null;
        }
        Collections.sort(o);
        double ori = (Double)o.get(o.size() / 2);
        if (medianDirectionSet.containsKey(newPointId)) {
            TerrestrialObservationRow row = new TerrestrialObservationRow();
            row.setStartPointName(startPointName);
            row.setEndPointName(newPointId);
            row.setValueApriori(MathExtension.MOD(medianDirectionSet.get(newPointId) - ori, Math.PI * 2));
            return row;
        }
        return null;
    }

    private Point getMedianPoint(List<? extends Point> points) {
        if (points.size() == 1) {
            return points.get(0);
        }
        if (points.size() > 1) {
            int index = 0;
            ArrayList<Double> medianX = new ArrayList<Double>();
            ArrayList<Double> medianY = new ArrayList<Double>();
            ArrayList<Double> medianZ = new ArrayList<Double>();
            int i = 0;
            while (i < points.size()) {
                medianX.add(points.get(i).getX());
                medianY.add(points.get(i).getY());
                medianZ.add(points.get(i).getZ());
                ++i;
            }
            Collections.sort(medianX);
            Collections.sort(medianY);
            Collections.sort(medianZ);
            double x0 = (Double)medianX.get(medianX.size() / 2);
            double y0 = (Double)medianY.get(medianX.size() / 2);
            double z0 = (Double)medianZ.get(medianX.size() / 2);
            double norm2 = Double.MAX_VALUE;
            int i2 = 0;
            while (i2 < points.size()) {
                double z;
                double y;
                double x = points.get(i2).getX() - x0;
                double norm = Math.sqrt(x * x + (y = points.get(i2).getY() - y0) * y + (z = points.get(i2).getZ() - z0) * z);
                if (norm < norm2) {
                    norm2 = norm;
                    index = i2;
                }
                ++i2;
            }
            return points.get(index);
        }
        return null;
    }

    public EstimationStateType getEstimationStatus1D() {
        return this.estimationStatus1D;
    }

    public EstimationStateType getEstimationStatus2D() {
        return this.estimationStatus2D;
    }

    public Set<String> getUnderdeterminedPointNames1D() {
        return this.underdeterminedPointNames1D;
    }

    public Set<String> getUnderdeterminedPointNames2D() {
        return this.underdeterminedPointNames2D;
    }

    public void setEstimateDatumsPoints(boolean estimate) {
        this.estimateDatumPoints = estimate;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.change.firePropertyChange(event);
    }
}

