/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.transformation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.approximation.bundle.PointBundle;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.Transformation;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterSet;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterType;

public class Transformation2D
implements Transformation {
    private PointBundle source = new PointBundle(this.getDimension());
    private PointBundle target = new PointBundle(this.getDimension());
    private PointBundle originalTarget = new PointBundle(this.getDimension());
    private PointBundle pointsToTransform = new PointBundle(this.getDimension());
    private TransformationParameterSet transParameter = null;
    private double omega = 0.0;
    private Map<TransformationParameterType, Boolean> fixedParameters = new HashMap<TransformationParameterType, Boolean>(Map.of(TransformationParameterType.TRANSLATION_X, Boolean.FALSE, TransformationParameterType.TRANSLATION_Y, Boolean.FALSE, TransformationParameterType.TRANSLATION_Z, Boolean.TRUE, TransformationParameterType.ROTATION_X, Boolean.TRUE, TransformationParameterType.ROTATION_Y, Boolean.TRUE, TransformationParameterType.ROTATION_Z, Boolean.FALSE, TransformationParameterType.SCALE, Boolean.FALSE));

    public Transformation2D(TransformationParameterSet transParameter) {
        this.transParameter = transParameter;
    }

    public Transformation2D(PointBundle source, PointBundle target) {
        if (source.getDimension() != target.getDimension() || source.getDimension() != this.numberOfRequiredPoints()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " Dimensionsfehler, benoetige d = " + this.getDimension());
        }
        this.init(source, target);
    }

    @Override
    public boolean transformLMS() {
        TransformationParameterSet transParameter = null;
        double omega = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numberOfIdenticalPoints()) {
            Point pS1 = this.source.get(i);
            Point pT1 = this.target.get(pS1.getName());
            int j = i + 1;
            while (j < this.numberOfIdenticalPoints()) {
                Point pS2 = this.source.get(j);
                Point pT2 = this.target.get(pS2.getName());
                PointBundle subSource = new PointBundle(this.getDimension());
                PointBundle subTarget = new PointBundle(this.getDimension());
                subSource.addPoint(pS1);
                subSource.addPoint(pS2);
                subTarget.addPoint(pT1);
                subTarget.addPoint(pT2);
                TransformationParameterSet subParameter = this.adjustTransformationsParameter(subSource, subTarget);
                double o = this.getOmega(subParameter, this.source, this.target, true);
                if (o < omega) {
                    transParameter = subParameter;
                    omega = o;
                }
                ++j;
            }
            ++i;
        }
        this.omega = omega;
        this.transParameter = transParameter;
        return this.transParameter != null;
    }

    @Override
    public boolean transformL2Norm() {
        if (this.numberOfIdenticalPoints() < this.numberOfRequiredPoints()) {
            return false;
        }
        this.transParameter = null;
        this.transParameter = this.adjustTransformationsParameter(this.source, this.target);
        this.omega = this.getOmega(this.transParameter, this.source, this.target, false);
        return this.transParameter != null;
    }

    private double getOmega(TransformationParameterSet transParameter, PointBundle source, PointBundle target, boolean isLMS) {
        if (transParameter == null) {
            return Double.MAX_VALUE;
        }
        double m = transParameter.getParameterValue(TransformationParameterType.SCALE);
        double rZ = transParameter.getParameterValue(TransformationParameterType.ROTATION_Z);
        double tX = transParameter.getParameterValue(TransformationParameterType.TRANSLATION_X);
        double tY = transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Y);
        double[] omegaLMS = new double[this.getDimension() * source.size()];
        double omegaLS = 0.0;
        int i = 0;
        int j = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point pT = target.get(pS.getName());
            double x = m * (Math.cos(rZ) * pS.getX() - Math.sin(rZ) * pS.getY()) + tX;
            double y = m * (Math.sin(rZ) * pS.getX() + Math.cos(rZ) * pS.getY()) + tY;
            double vx = pT.getX() - x;
            double vy = pT.getY() - y;
            omegaLMS[j++] = vx * vx;
            omegaLMS[j++] = vy * vy;
            omegaLS += vx * vx + vy * vy;
            ++i;
        }
        if (isLMS) {
            Arrays.sort(omegaLMS);
            if (omegaLMS.length == this.getDimension() * this.numberOfRequiredPoints()) {
                return omegaLMS[omegaLMS.length - 1];
            }
            if (omegaLMS.length < 2 * this.getDimension() * this.numberOfRequiredPoints()) {
                return omegaLMS[this.getDimension() * this.numberOfRequiredPoints()];
            }
            if (omegaLMS.length % 2 == 1) {
                return omegaLMS[omegaLMS.length / 2];
            }
            return 0.5 * (omegaLMS[omegaLMS.length / 2 - 1] + omegaLMS[omegaLMS.length / 2]);
        }
        return omegaLS;
    }

    private TransformationParameterSet adjustTransformationsParameter(PointBundle source, PointBundle target) {
        Point centerPointS = source.getCenterPoint();
        Point centerPointT = target.getCenterPoint();
        double o = 0.0;
        double a = 0.0;
        double oa = 0.0;
        int i = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point pT = target.get(i);
            o += (pS.getX() - centerPointS.getX()) * (pT.getY() - centerPointT.getY()) - (pS.getY() - centerPointS.getY()) * (pT.getX() - centerPointT.getX());
            a += (pS.getX() - centerPointS.getX()) * (pT.getX() - centerPointT.getX()) + (pS.getY() - centerPointS.getY()) * (pT.getY() - centerPointT.getY());
            oa += Math.pow(pS.getX() - centerPointS.getX(), 2.0) + Math.pow(pS.getY() - centerPointS.getY(), 2.0);
            ++i;
        }
        if (oa == 0.0) {
            return null;
        }
        o /= oa;
        a /= oa;
        double tX = 0.0;
        double tY = 0.0;
        double rZ = 0.0;
        double m = 1.0;
        TransformationParameterSet transParameter = new TransformationParameterSet();
        if (!this.fixedParameters.get((Object)TransformationParameterType.ROTATION_Z).booleanValue()) {
            rZ = MathExtension.MOD(Math.atan2(o, a), Math.PI * 2);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.SCALE).booleanValue()) {
            m = Math.hypot(a, o);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_X).booleanValue()) {
            tX = centerPointT.getX() - m * (Math.cos(rZ) * centerPointS.getX() - Math.sin(rZ) * centerPointS.getY());
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_Y).booleanValue()) {
            tY = centerPointT.getY() - m * (Math.sin(rZ) * centerPointS.getX() + Math.cos(rZ) * centerPointS.getY());
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_X).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.TRANSLATION_X, tX);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_Y).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.TRANSLATION_Y, tY);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.ROTATION_Z).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.ROTATION_Z, rZ);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.SCALE).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.SCALE, m);
        }
        return transParameter;
    }

    private void init(PointBundle source, PointBundle target) {
        this.originalTarget = target;
        int i = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point2D tempPS = new Point2D(pS.getName(), pS.getX(), pS.getY());
            this.pointsToTransform.addPoint(tempPS);
            int j = 0;
            while (j < target.size()) {
                Point pT = target.get(j);
                if (pS.getName().equals(pT.getName())) {
                    Point2D tempPT = new Point2D(pT.getName(), pT.getX(), pT.getY());
                    this.source.addPoint(tempPS);
                    this.target.addPoint(tempPT);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Point2D transformPoint2SourceSystem(Point point) {
        if (this.transParameter == null) {
            return null;
        }
        double m = this.transParameter.getParameterValue(TransformationParameterType.SCALE);
        double rZ = this.transParameter.getParameterValue(TransformationParameterType.ROTATION_Z);
        double tX = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_X);
        double tY = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Y);
        double x = (Math.cos(rZ) * (point.getX() - tX) + Math.sin(rZ) * (point.getY() - tY)) / m;
        double y = (-Math.sin(rZ) * (point.getX() - tX) + Math.cos(rZ) * (point.getY() - tY)) / m;
        return new Point2D(point.getName(), x, y);
    }

    @Override
    public Point2D transformPoint2TargetSystem(Point point) {
        if (this.transParameter == null || point == null) {
            return null;
        }
        double m = this.transParameter.getParameterValue(TransformationParameterType.SCALE);
        double rZ = this.transParameter.getParameterValue(TransformationParameterType.ROTATION_Z);
        double tX = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_X);
        double tY = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Y);
        double x = m * (Math.cos(rZ) * point.getX() - Math.sin(rZ) * point.getY()) + tX;
        double y = m * (Math.sin(rZ) * point.getX() + Math.cos(rZ) * point.getY()) + tY;
        return new Point2D(point.getName(), x, y);
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public int numberOfIdenticalPoints() {
        return this.source.size();
    }

    @Override
    public int numberOfRequiredPoints() {
        return 2;
    }

    @Override
    public PointBundle getTransformdPoints() {
        if (this.transParameter == null) {
            return null;
        }
        PointBundle transformedPoints = new PointBundle(this.getDimension());
        int i = 0;
        while (i < this.originalTarget.size()) {
            Point pT = this.originalTarget.get(i);
            transformedPoints.addPoint(pT);
            ++i;
        }
        i = 0;
        while (i < this.pointsToTransform.size()) {
            Point pS = this.pointsToTransform.get(i);
            Point pT = transformedPoints.get(pS.getName());
            if (pT == null) {
                pT = this.transformPoint2TargetSystem(pS);
                transformedPoints.addPoint(pT);
            }
            ++i;
        }
        transformedPoints.setTransformationParameterSet(this.transParameter);
        return transformedPoints;
    }

    @Override
    public TransformationParameterSet getTransformationParameterSet() {
        return this.transParameter;
    }

    @Override
    public void setFixedParameter(TransformationParameterType type, boolean fixed) {
        this.fixedParameters.put(type, fixed);
    }

    @Override
    public double getOmega() {
        return this.omega;
    }
}

