/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.transformation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.applied_geodesy.adjustment.network.approximation.bundle.PointBundle;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point1D;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.Transformation;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterSet;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterType;

public class Transformation1D
implements Transformation {
    public PointBundle source = new PointBundle(this.getDimension());
    public PointBundle target = new PointBundle(this.getDimension());
    public PointBundle originalTarget = new PointBundle(this.getDimension());
    public PointBundle pointsToTransform = new PointBundle(this.getDimension());
    public TransformationParameterSet transParameter = null;
    private double omega = 0.0;
    private Map<TransformationParameterType, Boolean> fixedParameters = new HashMap<TransformationParameterType, Boolean>(Map.of(TransformationParameterType.TRANSLATION_X, Boolean.TRUE, TransformationParameterType.TRANSLATION_Y, Boolean.TRUE, TransformationParameterType.TRANSLATION_Z, Boolean.FALSE, TransformationParameterType.ROTATION_X, Boolean.TRUE, TransformationParameterType.ROTATION_Y, Boolean.TRUE, TransformationParameterType.ROTATION_Z, Boolean.TRUE, TransformationParameterType.SCALE, Boolean.TRUE));

    public Transformation1D(TransformationParameterSet transParameter) {
        this.transParameter = transParameter;
    }

    public Transformation1D(PointBundle source, PointBundle target) {
        if (source.getDimension() != target.getDimension() || source.getDimension() != this.numberOfRequiredPoints()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " Dimensionsfehler, benoetige d = " + this.getDimension());
        }
        this.init(source, target);
    }

    @Override
    public boolean transformLMS() {
        TransformationParameterSet transParameter = null;
        double omega = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numberOfIdenticalPoints()) {
            Point pS1 = this.source.get(i);
            Point pT1 = this.target.get(pS1.getName());
            if (this.fixedParameters.get((Object)TransformationParameterType.SCALE).booleanValue()) {
                PointBundle subSource = new PointBundle(this.getDimension());
                PointBundle subTarget = new PointBundle(this.getDimension());
                subSource.addPoint(pS1);
                subTarget.addPoint(pT1);
                TransformationParameterSet subParameter = this.adjustTransformationsParameter(subSource, subTarget);
                double o = this.getOmega(subParameter, this.source, this.target, true);
                if (o < omega) {
                    transParameter = subParameter;
                    omega = o;
                }
            } else {
                int j = i + 1;
                while (j < this.numberOfIdenticalPoints()) {
                    Point pS2 = this.source.get(j);
                    Point pT2 = this.target.get(pS2.getName());
                    PointBundle subSource = new PointBundle(this.getDimension());
                    PointBundle subTarget = new PointBundle(this.getDimension());
                    subSource.addPoint(pS1);
                    subSource.addPoint(pS2);
                    subTarget.addPoint(pT1);
                    subTarget.addPoint(pT2);
                    TransformationParameterSet subParameter = this.adjustTransformationsParameter(subSource, subTarget);
                    double o = this.getOmega(subParameter, this.source, this.target, true);
                    if (o < omega) {
                        transParameter = subParameter;
                        omega = o;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.omega = omega;
        this.transParameter = transParameter;
        return this.transParameter != null;
    }

    private double getOmega(TransformationParameterSet transParameter, PointBundle source, PointBundle target, boolean isLMS) {
        if (transParameter == null) {
            return Double.MAX_VALUE;
        }
        double m = transParameter.getParameterValue(TransformationParameterType.SCALE);
        double tZ = transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Z);
        double[] omegaLMS = new double[source.size()];
        double omegaLS = 0.0;
        int i = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point pT = target.get(pS.getName());
            double z = m * pS.getZ() + tZ;
            double vz = pT.getZ() - z;
            omegaLMS[i] = vz * vz;
            omegaLS += vz * vz;
            ++i;
        }
        Arrays.sort(omegaLMS);
        if (isLMS) {
            Arrays.sort(omegaLMS);
            if (omegaLMS.length == this.numberOfRequiredPoints()) {
                return omegaLMS[omegaLMS.length - 1];
            }
            if (omegaLMS.length < 2 * this.numberOfRequiredPoints()) {
                return omegaLMS[this.numberOfRequiredPoints()];
            }
            if (omegaLMS.length % 2 == 1) {
                return omegaLMS[omegaLMS.length / 2];
            }
            return 0.5 * (omegaLMS[omegaLMS.length / 2 - 1] + omegaLMS[omegaLMS.length / 2]);
        }
        return omegaLS;
    }

    @Override
    public boolean transformL2Norm() {
        if (this.numberOfIdenticalPoints() < this.numberOfRequiredPoints()) {
            return false;
        }
        this.transParameter = null;
        this.transParameter = this.adjustTransformationsParameter(this.source, this.target);
        this.omega = this.getOmega(this.transParameter, this.source, this.target, false);
        return this.transParameter != null;
    }

    public TransformationParameterSet adjustTransformationsParameter(PointBundle source, PointBundle target) {
        Point centerPointS = source.getCenterPoint();
        Point centerPointT = target.getCenterPoint();
        double m = 0.0;
        int k = 0;
        int i = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point pT = target.get(i);
            if (pS.getZ() - centerPointS.getZ() != 0.0) {
                m += Math.abs((pT.getZ() - centerPointT.getZ()) / (pS.getZ() - centerPointS.getZ()));
                ++k;
            }
            ++i;
        }
        m = !this.fixedParameters.get((Object)TransformationParameterType.SCALE).booleanValue() && m > 0.0 && k > 0 ? (m /= (double)k) : 1.0;
        double tZ = 0.0;
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_Z).booleanValue()) {
            tZ = centerPointT.getZ() - m * centerPointS.getZ();
        }
        TransformationParameterSet transParameter = new TransformationParameterSet();
        if (!this.fixedParameters.get((Object)TransformationParameterType.TRANSLATION_Z).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.TRANSLATION_Z, tZ);
        }
        if (!this.fixedParameters.get((Object)TransformationParameterType.SCALE).booleanValue()) {
            transParameter.setParameterValue(TransformationParameterType.SCALE, m);
        }
        return transParameter;
    }

    private void init(PointBundle source, PointBundle target) {
        this.originalTarget = target;
        int i = 0;
        while (i < source.size()) {
            Point pS = source.get(i);
            Point1D tempPS = new Point1D(pS.getName(), pS.getZ());
            this.pointsToTransform.addPoint(tempPS);
            int j = 0;
            while (j < target.size()) {
                Point pT = target.get(j);
                if (pS.getName().equals(pT.getName())) {
                    Point1D tempPT = new Point1D(pT.getName(), pT.getZ());
                    this.source.addPoint(tempPS);
                    this.target.addPoint(tempPT);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Point1D transformPoint2SourceSystem(Point point) {
        if (this.transParameter == null) {
            return null;
        }
        double m = this.transParameter.getParameterValue(TransformationParameterType.SCALE);
        double tZ = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Z);
        double z = (point.getZ() - tZ) / m;
        return new Point1D(point.getName(), z);
    }

    @Override
    public Point1D transformPoint2TargetSystem(Point point) {
        if (this.transParameter == null || point == null) {
            return null;
        }
        double m = this.transParameter.getParameterValue(TransformationParameterType.SCALE);
        double tZ = this.transParameter.getParameterValue(TransformationParameterType.TRANSLATION_Z);
        double z = m * point.getZ() + tZ;
        return new Point1D(point.getName(), z);
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public int numberOfIdenticalPoints() {
        return this.source.size();
    }

    @Override
    public int numberOfRequiredPoints() {
        return 1;
    }

    @Override
    public PointBundle getTransformdPoints() {
        if (this.transParameter == null) {
            return null;
        }
        PointBundle transformedPoints = new PointBundle(this.getDimension());
        int i = 0;
        while (i < this.originalTarget.size()) {
            Point pT = this.originalTarget.get(i);
            transformedPoints.addPoint(pT);
            ++i;
        }
        i = 0;
        while (i < this.pointsToTransform.size()) {
            Point pS = this.pointsToTransform.get(i);
            Point pT = transformedPoints.get(pS.getName());
            if (pT == null) {
                pT = this.transformPoint2TargetSystem(pS);
                transformedPoints.addPoint(pT);
            }
            ++i;
        }
        transformedPoints.setTransformationParameterSet(this.transParameter);
        return transformedPoints;
    }

    @Override
    public TransformationParameterSet getTransformationParameterSet() {
        return this.transParameter;
    }

    @Override
    public void setFixedParameter(TransformationParameterType type, boolean fixed) {
        this.fixedParameters.put(type, fixed);
    }

    @Override
    public double getOmega() {
        return this.omega;
    }
}

