/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.transformation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.NormalEquationSystem;
import org.applied_geodesy.adjustment.network.approximation.bundle.PointBundle;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point1D;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point3D;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.Transformation;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameter;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterSet;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterType;

public abstract class BundleTransformation {
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    public static final double SQRT_EPS = 1.0E-5;
    private Map<String, Integer> pointInSystemsCounter = new LinkedHashMap<String, Integer>();
    private Set<String> outliers = new HashSet<String>();
    private EstimationStateType currentEstimationStatus = EstimationStateType.BUSY;
    private int maxIteration = 50;
    private int numberOfUnknowns = 0;
    private int numberOfObservations = 0;
    private double maxDx = Double.MIN_VALUE;
    private double omega = 0.0;
    private double threshold = 15.0;
    boolean interrupt = false;
    private PointBundle targetSystem = null;
    private Set<String> targetSystemPointIds = new HashSet<String>();
    private List<PointBundle> sourceSystems = new ArrayList<PointBundle>();
    private List<PointBundle> excludedSystems = new ArrayList<PointBundle>();

    public BundleTransformation(double threshold, List<PointBundle> sourceSystems) {
        if (sourceSystems.size() < 1) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " Fehler, mind. ein System wird benoetigt! " + sourceSystems.size());
        }
        this.setThreshold(threshold);
        this.initSystems(sourceSystems);
        this.init();
    }

    public BundleTransformation(double threshold, PointBundle sourceSystem, PointBundle targetSystem) {
        this.setThreshold(threshold);
        this.targetSystem = targetSystem;
        this.sourceSystems.add(sourceSystem);
        this.init();
    }

    public BundleTransformation(double threshold, List<PointBundle> sourceSystems, PointBundle targetSystem) {
        this.setThreshold(threshold);
        this.targetSystem = targetSystem;
        this.sourceSystems = sourceSystems;
        this.init();
    }

    public abstract Transformation getSimpleTransformationModel(PointBundle var1, PointBundle var2);

    public abstract Transformation getSimpleTransformationModel(TransformationParameterSet var1);

    private void initSystems(List<PointBundle> sourceSystems) {
        PointBundle bundle1 = null;
        PointBundle bundle2 = null;
        int numIdentPoints = 0;
        int i = 0;
        while (i < sourceSystems.size()) {
            PointBundle b1 = sourceSystems.get(i);
            int j = i + 1;
            while (j < sourceSystems.size()) {
                PointBundle b2 = sourceSystems.get(j);
                Transformation t = this.getSimpleTransformationModel(b1, b2);
                if (t != null && t.numberOfIdenticalPoints() >= t.numberOfRequiredPoints() && t.numberOfIdenticalPoints() >= numIdentPoints) {
                    numIdentPoints = t.numberOfIdenticalPoints();
                    bundle1 = b1;
                    bundle2 = b2;
                }
                ++j;
            }
            ++i;
        }
        if (bundle1 != null && bundle2 != null) {
            if (bundle1.size() > bundle2.size()) {
                this.targetSystem = bundle1;
                sourceSystems.remove(bundle1);
            } else {
                this.targetSystem = bundle2;
                sourceSystems.remove(bundle2);
            }
        } else {
            this.targetSystem = sourceSystems.get(0);
            sourceSystems.remove(sourceSystems.get(0));
        }
        this.sourceSystems = sourceSystems;
    }

    public final int getDimension() {
        return this.targetSystem.getDimension();
    }

    private void calculateTargetSystemApproximatedCoordinates() {
        ArrayList<PointBundle> pointSystems = new ArrayList<PointBundle>();
        int dim = this.getDimension();
        for (PointBundle sourceSystem : this.sourceSystems) {
            PointBundle pointBundleDeepCopy = new PointBundle(dim, sourceSystem.isIntersection());
            int i = 0;
            while (i < sourceSystem.size()) {
                Point p = sourceSystem.get(i);
                Point cp = null;
                if (dim == 1) {
                    cp = new Point1D(p.getName(), p.getZ());
                } else if (dim == 2) {
                    cp = new Point2D(p.getName(), p.getX(), p.getY());
                } else if (dim == 3) {
                    cp = new Point3D(p.getName(), p.getX(), p.getY(), p.getZ());
                }
                if (cp != null) {
                    pointBundleDeepCopy.addPoint(cp);
                }
                ++i;
            }
            if (pointBundleDeepCopy.size() <= 0) continue;
            pointSystems.add(pointBundleDeepCopy);
        }
        PointBundle pointBundleDeepCopy = new PointBundle(dim, this.targetSystem.isIntersection());
        int i = 0;
        while (i < this.targetSystem.size()) {
            Point p = this.targetSystem.get(i);
            String id = p.getName();
            this.targetSystemPointIds.add(id);
            if (this.pointInSystemsCounter.containsKey(id)) {
                this.pointInSystemsCounter.put(id, this.pointInSystemsCounter.get(id) + 1);
            } else {
                this.pointInSystemsCounter.put(id, 1);
            }
            Point cp = null;
            if (dim == 1) {
                cp = new Point1D(id, p.getZ());
            } else if (dim == 2) {
                cp = new Point2D(id, p.getX(), p.getY());
            } else if (dim == 3) {
                cp = new Point3D(id, p.getX(), p.getY(), p.getZ());
            }
            if (cp != null) {
                pointBundleDeepCopy.addPoint(cp);
            }
            ++i;
        }
        if (pointBundleDeepCopy.size() > 0) {
            pointSystems.add(pointBundleDeepCopy);
        }
        int numberOfIdenticalPoints = 0;
        boolean transformedSystems = true;
        while (transformedSystems && pointSystems.size() > 0) {
            PointBundle maxSRC = null;
            PointBundle maxTRG = null;
            numberOfIdenticalPoints = 0;
            int i2 = 0;
            while (i2 < pointSystems.size()) {
                PointBundle bundleOne = (PointBundle)pointSystems.get(i2);
                int j = i2 + 1;
                while (j < pointSystems.size()) {
                    int numIdents = 0;
                    PointBundle bundleTwo = (PointBundle)pointSystems.get(j);
                    int o = 0;
                    while (o < bundleOne.size()) {
                        Point pOne = bundleOne.get(o);
                        Point pTwo = bundleTwo.get(pOne.getName());
                        if (pTwo != null) {
                            ++numIdents;
                        }
                        ++o;
                    }
                    if (numIdents > numberOfIdenticalPoints) {
                        maxSRC = bundleOne;
                        maxTRG = bundleTwo;
                        numberOfIdenticalPoints = numIdents;
                    }
                    ++j;
                }
                ++i2;
            }
            if (maxSRC != null && maxTRG != null) {
                Transformation trans;
                boolean src2trg = false;
                src2trg = !maxSRC.isIntersection() && maxTRG.isIntersection() ? true : (maxSRC.isIntersection() && !maxTRG.isIntersection() ? false : maxSRC.size() >= maxTRG.size());
                if (src2trg) {
                    PointBundle tmpBundle = maxTRG;
                    maxTRG = maxSRC;
                    maxSRC = tmpBundle;
                }
                if ((trans = this.getSimpleTransformationModel(maxSRC, maxTRG)) != null && trans.numberOfIdenticalPoints() >= trans.numberOfRequiredPoints()) {
                    trans.setFixedParameter(TransformationParameterType.SCALE, !maxSRC.isIntersection() && !maxTRG.isIntersection());
                    if (trans.transformL2Norm() && trans.getOmega() <= this.threshold * Math.sqrt(1.0E-5) || trans.transformLMS()) {
                        int o = 0;
                        while (o < maxSRC.size()) {
                            Point src = maxSRC.get(o);
                            Point trg = maxTRG.get(src.getName());
                            if (trg == null) {
                                trg = trans.transformPoint2TargetSystem(src);
                                maxTRG.addPoint(trg);
                            }
                            ++o;
                        }
                    }
                } else {
                    transformedSystems = false;
                }
                pointSystems.remove(maxSRC);
                continue;
            }
            transformedSystems = false;
        }
        PointBundle maxScrSystem = (PointBundle)pointSystems.get(0);
        int i3 = 1;
        while (i3 < pointSystems.size()) {
            if (((PointBundle)pointSystems.get(i3)).size() > maxScrSystem.size()) {
                maxScrSystem = (PointBundle)pointSystems.get(i3);
            }
            ++i3;
        }
        Transformation trans = this.getSimpleTransformationModel(maxScrSystem, this.targetSystem);
        if (trans != null && trans.numberOfIdenticalPoints() >= trans.numberOfRequiredPoints()) {
            trans.setFixedParameter(TransformationParameterType.SCALE, !maxScrSystem.isIntersection() && !this.targetSystem.isIntersection());
            if (trans.transformL2Norm() && trans.getOmega() <= this.threshold * Math.sqrt(1.0E-5) || trans.transformLMS()) {
                int o = 0;
                while (o < maxScrSystem.size()) {
                    Point src = maxScrSystem.get(o);
                    Point trg = this.targetSystem.get(src.getName());
                    if (trg == null) {
                        trg = trans.transformPoint2TargetSystem(src);
                        this.targetSystem.addPoint(trg);
                    }
                    ++o;
                }
            }
        }
    }

    private void calculateTransformationParameterApproximatedValues() {
        ArrayList<PointBundle> srcPointSystems = new ArrayList<PointBundle>();
        for (PointBundle sourceSystem : this.sourceSystems) {
            srcPointSystems.add(sourceSystem);
            int i = 0;
            while (i < sourceSystem.size()) {
                Point p = sourceSystem.get(i);
                p.setColInJacobiMatrix(-1);
                p.setRowInJacobiMatrix(-1);
                String id = p.getName();
                if (this.pointInSystemsCounter.containsKey(id)) {
                    this.pointInSystemsCounter.put(id, this.pointInSystemsCounter.get(id) + 1);
                } else {
                    this.pointInSystemsCounter.put(id, 1);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.targetSystem.size()) {
            Point p = this.targetSystem.get(i);
            p.setColInJacobiMatrix(-1);
            p.setRowInJacobiMatrix(-1);
            ++i;
        }
        for (PointBundle sourceSystem : srcPointSystems) {
            if (sourceSystem != null && this.setApproximatedValues(sourceSystem)) continue;
            System.err.println(this.getClass().getSimpleName() + " Fehler, nicht genuegend identische\nPunkte vorhanden oder System nicht transformierbar!");
            if (sourceSystem == null) continue;
            this.sourceSystems.remove(sourceSystem);
            this.excludedSystems.add(sourceSystem);
        }
        ((ArrayList)this.sourceSystems).trimToSize();
    }

    private boolean setApproximatedValues(PointBundle sourceSystem) {
        int dim = this.getDimension();
        Transformation trans = this.getSimpleTransformationModel(this.targetSystem, sourceSystem);
        if (trans == null || trans.numberOfIdenticalPoints() < trans.numberOfRequiredPoints()) {
            return false;
        }
        trans.setFixedParameter(TransformationParameterType.SCALE, !sourceSystem.isIntersection() && !this.targetSystem.isIntersection());
        if (trans.transformL2Norm() && trans.getOmega() <= this.threshold * Math.sqrt(1.0E-5) || trans.transformLMS()) {
            this.omega = Math.max(this.omega, trans.getOmega());
            sourceSystem.setTransformationParameterSet(trans.getTransformationParameterSet());
            int i = 0;
            while (i < sourceSystem.size()) {
                Point pointSource = sourceSystem.get(i);
                if (this.pointInSystemsCounter.get(pointSource.getName()) > 1) {
                    Point pointTarget = this.targetSystem.get(pointSource.getName());
                    if (pointTarget == null) {
                        pointTarget = trans.transformPoint2SourceSystem(pointSource);
                        pointTarget.setColInJacobiMatrix(this.numberOfUnknowns);
                        pointSource.setColInJacobiMatrix(this.numberOfUnknowns);
                        this.targetSystem.addPoint(pointTarget);
                        this.numberOfUnknowns += dim;
                    } else if (!this.targetSystemPointIds.contains(pointSource.getName()) && pointTarget.getColInJacobiMatrix() < 0) {
                        pointTarget.setColInJacobiMatrix(this.numberOfUnknowns);
                        pointSource.setColInJacobiMatrix(this.numberOfUnknowns);
                        this.numberOfUnknowns += dim;
                    } else {
                        pointSource.setColInJacobiMatrix(pointTarget.getColInJacobiMatrix());
                    }
                    pointSource.setRowInJacobiMatrix(this.numberOfObservations);
                    this.numberOfObservations += dim;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void init() {
        this.numberOfUnknowns = 0;
        this.numberOfObservations = 0;
        int dim = this.getDimension();
        this.calculateTargetSystemApproximatedCoordinates();
        this.calculateTransformationParameterApproximatedValues();
        for (PointBundle sourceSystem : this.sourceSystems) {
            TransformationParameterSet transParameter = sourceSystem.getTransformationParameterSet();
            if (sourceSystem.isIntersection()) {
                TransformationParameter m = transParameter.get(TransformationParameterType.SCALE);
                m.setColInJacobiMatrix(this.numberOfUnknowns++);
            }
            if (dim != 1) {
                TransformationParameter rz = transParameter.get(TransformationParameterType.ROTATION_Z);
                rz.setColInJacobiMatrix(this.numberOfUnknowns++);
                TransformationParameter tx = transParameter.get(TransformationParameterType.TRANSLATION_X);
                tx.setColInJacobiMatrix(this.numberOfUnknowns++);
                TransformationParameter ty = transParameter.get(TransformationParameterType.TRANSLATION_Y);
                ty.setColInJacobiMatrix(this.numberOfUnknowns++);
            }
            if (dim == 3) {
                TransformationParameter rx = transParameter.get(TransformationParameterType.ROTATION_X);
                rx.setColInJacobiMatrix(this.numberOfUnknowns++);
                TransformationParameter ry = transParameter.get(TransformationParameterType.ROTATION_Y);
                ry.setColInJacobiMatrix(this.numberOfUnknowns++);
            }
            if (dim == 2) continue;
            TransformationParameter tz = transParameter.get(TransformationParameterType.TRANSLATION_Z);
            tz.setColInJacobiMatrix(this.numberOfUnknowns++);
        }
    }

    public EstimationStateType estimateModel() {
        boolean isEstimated = false;
        boolean isConverge = true;
        this.currentEstimationStatus = EstimationStateType.BUSY;
        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
        int runs = this.maxIteration - 1;
        try {
            do {
                this.currentEstimationStatus = EstimationStateType.ITERATE;
                this.change.firePropertyChange(this.currentEstimationStatus.name(), this.maxIteration, this.maxIteration - runs);
                if (this.interrupt) {
                    this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                    this.interrupt = false;
                    this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                    return this.currentEstimationStatus;
                }
                DenseVector dx = new DenseVector(this.numberOfUnknowns);
                try {
                    NormalEquationSystem NES = this.createNormalEquationSystem();
                    if (this.interrupt || NES == null) {
                        this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                        this.interrupt = false;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        return this.currentEstimationStatus;
                    }
                    UpperSymmPackMatrix N = NES.getMatrix();
                    DenseVector n = NES.getVector();
                    if (N == null || n == null || this.numberOfObservations() < this.getDimension() || this.numberOfUnknowns() == 0) {
                        this.currentEstimationStatus = EstimationStateType.NOT_INITIALISED;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        return this.currentEstimationStatus;
                    }
                    this.maxDx = Double.MIN_VALUE;
                    MathExtension.solve(N, n, false);
                    dx = n;
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | MatrixNotSPDException | MatrixSingularException e) {
                    e.printStackTrace();
                    this.currentEstimationStatus = EstimationStateType.SINGULAR_MATRIX;
                    this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                    return this.currentEstimationStatus;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                    this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                    return this.currentEstimationStatus;
                }
                this.updateUnknownParameters((Vector)dx);
                this.currentEstimationStatus = EstimationStateType.CONVERGENCE;
                this.change.firePropertyChange(this.currentEstimationStatus.name(), 1.0E-5, this.maxDx);
                if (this.maxDx <= 1.0E-5) {
                    isEstimated = true;
                    --runs;
                    continue;
                }
                if (runs-- > 1) continue;
                isConverge = false;
                isEstimated = true;
            } while (!isEstimated);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            this.currentEstimationStatus = EstimationStateType.OUT_OF_MEMORY;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
            return this.currentEstimationStatus;
        }
        if (!isConverge) {
            this.currentEstimationStatus = EstimationStateType.NO_CONVERGENCE;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), 1.0E-5, this.maxDx);
        }
        for (PointBundle sourceSystem : this.sourceSystems) {
            Transformation trans = this.getSimpleTransformationModel(sourceSystem.getTransformationParameterSet());
            int i = 0;
            while (i < sourceSystem.size()) {
                Point pointSource = sourceSystem.get(i);
                Point pointTarget = this.targetSystem.get(pointSource.getName());
                if (pointTarget == null && trans != null) {
                    pointTarget = trans.transformPoint2SourceSystem(pointSource);
                    this.targetSystem.addPoint(pointTarget);
                }
                ++i;
            }
        }
        if (this.currentEstimationStatus.getId() == EstimationStateType.BUSY.getId()) {
            this.currentEstimationStatus = EstimationStateType.ERROR_FREE_ESTIMATION;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), 1.0E-5, this.maxDx);
        }
        return this.currentEstimationStatus;
    }

    private void updateUnknownParameters(Vector dx) {
        for (PointBundle sourceSystem : this.sourceSystems) {
            double oldValue;
            int col;
            if (this.interrupt) {
                return;
            }
            TransformationParameterSet parameters = sourceSystem.getTransformationParameterSet();
            TransformationParameter m = parameters.get(TransformationParameterType.SCALE);
            TransformationParameter rx = parameters.get(TransformationParameterType.ROTATION_X);
            TransformationParameter ry = parameters.get(TransformationParameterType.ROTATION_Y);
            TransformationParameter rz = parameters.get(TransformationParameterType.ROTATION_Z);
            TransformationParameter tx = parameters.get(TransformationParameterType.TRANSLATION_X);
            TransformationParameter ty = parameters.get(TransformationParameterType.TRANSLATION_Y);
            TransformationParameter tz = parameters.get(TransformationParameterType.TRANSLATION_Z);
            if (!m.isFixed()) {
                col = m.getColInJacobiMatrix();
                oldValue = m.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                m.setValue(oldValue + dx.get(col));
            }
            if (!tx.isFixed()) {
                col = tx.getColInJacobiMatrix();
                oldValue = tx.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                tx.setValue(oldValue + dx.get(col));
            }
            if (!ty.isFixed()) {
                col = ty.getColInJacobiMatrix();
                oldValue = ty.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                ty.setValue(oldValue + dx.get(col));
            }
            if (!tz.isFixed()) {
                col = tz.getColInJacobiMatrix();
                oldValue = tz.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                tz.setValue(oldValue + dx.get(col));
            }
            if (!rx.isFixed()) {
                col = rx.getColInJacobiMatrix();
                oldValue = rx.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                rx.setValue(MathExtension.MOD(oldValue + dx.get(col), Math.PI * 2));
            }
            if (!ry.isFixed()) {
                col = ry.getColInJacobiMatrix();
                oldValue = ry.getValue();
                this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                ry.setValue(MathExtension.MOD(oldValue + dx.get(col), Math.PI * 2));
            }
            if (rz.isFixed()) continue;
            col = rz.getColInJacobiMatrix();
            oldValue = rz.getValue();
            this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
            rz.setValue(MathExtension.MOD(oldValue + dx.get(col), Math.PI * 2));
        }
        int dim = this.getDimension();
        int i = 0;
        while (i < this.targetSystem.size()) {
            if (this.interrupt) {
                return;
            }
            Point point = this.targetSystem.get(i);
            int col = point.getColInJacobiMatrix();
            if (col >= 0) {
                if (dim != 1) {
                    this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                    point.setX(point.getX() + dx.get(col++));
                    this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                    point.setY(point.getY() + dx.get(col++));
                }
                if (dim != 2) {
                    this.maxDx = Math.max(Math.abs(dx.get(col)), this.maxDx);
                    point.setZ(point.getZ() + dx.get(col));
                }
            }
            ++i;
        }
    }

    public List<PointBundle> getExcludedSystems() {
        return this.excludedSystems;
    }

    public final int numberOfObservations() {
        return this.numberOfObservations;
    }

    public final int numberOfUnknowns() {
        return this.numberOfUnknowns;
    }

    protected abstract NormalEquationSystem createNormalEquationSystem();

    public PointBundle getTargetSystem() {
        return this.targetSystem;
    }

    public List<PointBundle> getSourceSystems() {
        return this.sourceSystems;
    }

    private void setThreshold(double t) {
        this.threshold = t > 1.0 ? t : 1.0;
    }

    protected double getScaleEstimate() {
        double SQRT_EPS = Math.sqrt(Constant.EPS);
        double omega = this.omega > SQRT_EPS ? this.omega : 1.0;
        int dof = this.numberOfObservations() - this.numberOfUnknowns();
        if (dof > 0) {
            return this.threshold * 1.4826022185056 * (1.0 + 5.0 / (double)dof) * Math.sqrt(omega);
        }
        return 1.0;
    }

    public Set<String> getOutliers() {
        return this.outliers;
    }

    protected void removeOutlierPoint(Point point) {
        String pointId = point.getName();
        if (this.outliers.contains(pointId)) {
            this.outliers.remove(pointId);
        }
    }

    protected void addOutlierPoint(Point point) {
        String pointId = point.getName();
        if (!this.outliers.contains(pointId)) {
            this.outliers.add(pointId);
        }
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }
}

