/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.point;

import java.util.ArrayList;
import java.util.List;
import org.applied_geodesy.adjustment.network.approximation.bundle.PointBundle;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.Transformation;
import org.applied_geodesy.adjustment.network.approximation.bundle.transformation.TransformationParameterType;

public abstract class Point {
    private String name;
    private int colInJacobiMatrix = -1;
    private int rowInJacobiMatrix = -1;
    private boolean isOutlier = false;
    private List<PointBundle> bundles = new ArrayList<PointBundle>();
    private double[] coordinates = new double[this.getDimension()];
    private double[] weigths = new double[this.getDimension()];

    public Point(String name) throws IllegalArgumentException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " Punktnummer ungueltig!");
        }
        this.name = name.trim();
        int i = 0;
        while (i < this.getDimension()) {
            this.weigths[i] = 1.0;
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public abstract int getDimension();

    public void setWeightedX(double px) {
        this.weigths[0] = px;
    }

    public void setWeightedY(double py) {
        this.weigths[1] = py;
    }

    public void setWeightedZ(double pz) {
        this.weigths[this.getDimension() - 1] = pz;
    }

    public double getWeightedX() {
        return this.weigths[0];
    }

    public double getWeightedY() {
        return this.weigths[1];
    }

    public double getWeightedZ() {
        return this.weigths[this.getDimension() - 1];
    }

    public void setX(double x) {
        this.coordinates[0] = x;
    }

    public void setY(double y) {
        this.coordinates[1] = y;
    }

    public void setZ(double z) {
        this.coordinates[this.getDimension() - 1] = z;
    }

    public double getX() {
        return this.coordinates[0];
    }

    public double getY() {
        return this.coordinates[1];
    }

    public double getZ() {
        return this.coordinates[this.getDimension() - 1];
    }

    public void join(Point p) {
        if (this.name.equals(p.getName()) && this.getDimension() == p.getDimension()) {
            if (this.getDimension() == 1) {
                this.setZ(0.5 * (this.getZ() + p.getZ()));
            } else if (this.getDimension() == 2) {
                this.setX(0.5 * (this.getX() + p.getX()));
                this.setY(0.5 * (this.getY() + p.getY()));
            } else if (this.getDimension() == 3) {
                this.setX(0.5 * (this.getX() + p.getX()));
                this.setY(0.5 * (this.getY() + p.getY()));
                this.setZ(0.5 * (this.getZ() + p.getZ()));
            }
        }
    }

    public double getDistance3D(Point p) {
        if (this.getDimension() + p.getDimension() < 6) {
            throw new IllegalArgumentException("Raumstrecke nur zwischen 3D Punkten bestimmbar " + this.name + " " + this.getDimension() + "D und " + p.getName() + " " + p.getDimension() + "D");
        }
        return Math.sqrt(Math.pow(this.getX() - p.getX(), 2.0) + Math.pow(this.getY() - p.getY(), 2.0) + Math.pow(this.getZ() - p.getZ(), 2.0));
    }

    public double getDistance2D(Point p) {
        if (this.getDimension() == 1 || p.getDimension() == 1) {
            throw new IllegalArgumentException("Horizontalstrecke nicht mit 1D Punkte(n) bestimmbar " + this.name + " " + this.getDimension() + "D und " + p.getName() + " " + p.getDimension() + "D");
        }
        return Math.sqrt(Math.pow(this.getX() - p.getX(), 2.0) + Math.pow(this.getY() - p.getY(), 2.0));
    }

    public int getRowInJacobiMatrix() {
        return this.rowInJacobiMatrix;
    }

    public void setRowInJacobiMatrix(int row) {
        this.rowInJacobiMatrix = row;
    }

    public int getColInJacobiMatrix() {
        return this.colInJacobiMatrix;
    }

    public void setColInJacobiMatrix(int col) {
        this.colInJacobiMatrix = col;
    }

    public abstract Transformation getTransformation(PointBundle var1, PointBundle var2);

    public PointBundle getCurrentBundle() {
        if (this.bundles.size() > 0) {
            return this.bundles.get(this.bundles.size() - 1);
        }
        this.addBundle();
        return this.getCurrentBundle();
    }

    public List<PointBundle> getPointBundles() {
        return this.bundles;
    }

    public void addBundle() {
        this.addBundle(false);
    }

    public void addBundle(boolean isInsersectionBundle) {
        this.bundles.add(new PointBundle(this, isInsersectionBundle));
    }

    public void removeEmptyBundles() {
        ArrayList<PointBundle> newBundles = new ArrayList<PointBundle>();
        int i = 0;
        while (i < this.bundles.size()) {
            PointBundle bundle = this.bundles.get(i);
            if (bundle.size() > 0 && (bundle.size() != 1 || bundle.get(0) != this)) {
                newBundles.add(bundle);
            }
            ++i;
        }
        this.bundles = newBundles;
    }

    public boolean containsPointInBundle(String pointId) {
        for (PointBundle bundle : this.bundles) {
            if (!bundle.contains(pointId)) continue;
            return true;
        }
        return false;
    }

    public void joinBundles() {
        this.removeEmptyBundles();
        if (this.bundles.size() > 1) {
            Transformation trans = null;
            do {
                trans = null;
                PointBundle bundle1 = null;
                PointBundle bundle2 = null;
                int numIdentPoints = -1;
                int i = 0;
                while (i < this.bundles.size()) {
                    PointBundle b1 = this.bundles.get(i);
                    int j = i + 1;
                    while (j < this.bundles.size()) {
                        PointBundle b2 = this.bundles.get(j);
                        Transformation t = this.getTransformation(b1, b2);
                        if (t != null && t.numberOfIdenticalPoints() >= t.numberOfRequiredPoints() && t.numberOfIdenticalPoints() > numIdentPoints) {
                            numIdentPoints = t.numberOfIdenticalPoints();
                            bundle1 = b1;
                            bundle2 = b2;
                        }
                        ++j;
                    }
                    ++i;
                }
                trans = bundle1 != null && bundle2 != null ? (bundle1.isIntersection() && !bundle2.isIntersection() ? this.getTransformation(bundle1, bundle2) : (!bundle1.isIntersection() && bundle2.isIntersection() ? this.getTransformation(bundle2, bundle1) : (bundle1.size() < bundle2.size() ? this.getTransformation(bundle1, bundle2) : this.getTransformation(bundle2, bundle1)))) : null;
                if (trans != null && trans.numberOfIdenticalPoints() >= trans.numberOfRequiredPoints()) {
                    trans.setFixedParameter(TransformationParameterType.SCALE, !bundle1.isIntersection() && !bundle2.isIntersection());
                    if (trans.transformLMS()) {
                        PointBundle joinedBundle = trans.getTransformdPoints();
                        if (joinedBundle != null) {
                            joinedBundle.setIntersection(bundle1.isIntersection() && bundle2.isIntersection());
                            this.bundles.remove(bundle1);
                            this.bundles.remove(bundle2);
                            this.bundles.add(joinedBundle);
                            continue;
                        }
                        trans = null;
                        continue;
                    }
                    trans = null;
                    continue;
                }
                trans = null;
            } while (trans != null);
        }
    }

    public void isOutlier(boolean isOutlier) {
        this.isOutlier = isOutlier;
    }

    public boolean isOutlier() {
        return this.isOutlier;
    }
}

