/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.point;

import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point1D;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;

public abstract class ClassicGeodeticComputation {
    public static double DIRECTION(Point2D startPoint, Point2D endPoint) {
        return MathExtension.MOD(Math.atan2(endPoint.getY() - startPoint.getY(), endPoint.getX() - startPoint.getX()), Math.PI * 2);
    }

    public static Point2D POLAR(Point2D station, String id, double epsilon, double dist2d) {
        double y = station.getY() + dist2d * Math.sin(epsilon);
        double x = station.getX() + dist2d * Math.cos(epsilon);
        return new Point2D(id, x, y);
    }

    public static Point2D POLAR(Point2D station, String id, double epsilon, double dist3d, double zenith) {
        double dist2d = ClassicGeodeticComputation.DISTANCE2D(dist3d, zenith);
        return ClassicGeodeticComputation.POLAR(station, id, epsilon, dist2d);
    }

    public static double SLOPEDISTANCE(double dist3d, double ihDist, double thDist, double zenith, double ihZenith, double thZenith) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        double dh = thZenith - (ihZenith - ihDist) - thDist;
        double alpha = Math.asin(dh * Math.sin(zenith) / Math.abs(dist3d));
        double beta = Math.PI - alpha - zenith;
        return Math.sqrt(dist3d * dist3d + dh * dh - 2.0 * dist3d * dh * Math.cos(beta));
    }

    public static Point1D TRIGO_HEIGHT_3D(Point1D station, String id, double dist3d, double zenith, double ih, double th) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        return new Point1D(id, station.getZ() + Math.abs(dist3d) * Math.cos(zenith) + ih - th);
    }

    public static Point1D TRIGO_HEIGHT_2D(Point1D station, String id, double dist2d, double zenith, double ih, double th) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        double dh = zenith == 0.0 || zenith == Math.PI ? 0.0 : Math.abs(dist2d) * Math.cos(zenith) / Math.sin(zenith);
        return new Point1D(id, station.getZ() + dh + ih - th);
    }

    public static Point1D ORTHO_HEIGHT(Point1D station, String id, double deltaH, double ih, double th) {
        return new Point1D(id, station.getZ() + deltaH + ih - th);
    }

    public static double TRIGO_HEIGHT_3D(double dist3d, double zenith, double ih, double th) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        return Math.abs(dist3d) * Math.cos(zenith) + ih - th;
    }

    public static double TRIGO_HEIGHT_2D(double dist2d, double zenith, double ih, double th) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        return zenith == 0.0 || zenith == Math.PI ? 0.0 : Math.abs(dist2d) * Math.cos(zenith) / Math.sin(zenith) + ih - th;
    }

    public static double ORTHO_HEIGHT(double deltaH, double ih, double th) {
        return deltaH + ih - th;
    }

    public static double DISTANCE2D(double dist3d, double zenith) {
        if (zenith > Math.PI) {
            zenith = Math.PI * 2 - zenith;
        }
        return Math.abs(dist3d) * Math.sin(zenith);
    }
}

