/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.intersection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.applied_geodesy.adjustment.network.approximation.bundle.intersection.ForwardIntersectionEntry;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;

public class ForwardIntersectionSet {
    Map<PointCouple, Map<String, ForwardIntersectionEntry>> forwardIntersectionMap = new LinkedHashMap<PointCouple, Map<String, ForwardIntersectionEntry>>();

    public void add(Point2D fixPointA, Point2D fixPointB, String newPointId, double rAB, double rAN, double rBA, double rBN) {
        if (fixPointA.getName().compareTo(fixPointB.getName()) > 0) {
            double tmpR = rAB;
            rAB = rBA;
            rBA = tmpR;
            tmpR = rAN;
            rAN = rBN;
            rBN = tmpR;
            Point2D tmpPoint = fixPointA;
            fixPointA = fixPointB;
            fixPointB = tmpPoint;
        }
        PointCouple pointCouple = new PointCouple(fixPointA, fixPointB);
        double alpha = rAB - rAN;
        double beta = rBN - rBA;
        if (this.forwardIntersectionMap.containsKey(pointCouple)) {
            Map<String, ForwardIntersectionEntry> map = this.forwardIntersectionMap.get(pointCouple);
            if (map.containsKey(newPointId)) {
                ForwardIntersectionEntry forwardIntersectionEntry = map.get(newPointId);
                forwardIntersectionEntry.addAngles(alpha, beta);
            } else {
                map.put(newPointId, new ForwardIntersectionEntry(fixPointA, fixPointB, newPointId, alpha, beta));
            }
        } else {
            LinkedHashMap<String, ForwardIntersectionEntry> map = new LinkedHashMap<String, ForwardIntersectionEntry>();
            map.put(newPointId, new ForwardIntersectionEntry(fixPointA, fixPointB, newPointId, alpha, beta));
            this.forwardIntersectionMap.put(pointCouple, map);
        }
    }

    public Map<String, ForwardIntersectionEntry> getForwardIntersectionsByFixPoints(Point2D fixPointA, Point2D fixPointB) {
        PointCouple pointCouple = new PointCouple(fixPointA, fixPointB);
        return this.forwardIntersectionMap.get(pointCouple);
    }

    public List<Point2D> adjustForwardIntersections() {
        ArrayList<Point2D> intersectionPoints = new ArrayList<Point2D>();
        for (Map<String, ForwardIntersectionEntry> forwardIntersections : this.forwardIntersectionMap.values()) {
            for (ForwardIntersectionEntry forwardIntersection : forwardIntersections.values()) {
                Point2D p2d = forwardIntersection.adjust();
                if (p2d == null) continue;
                intersectionPoints.add(p2d);
            }
        }
        return intersectionPoints;
    }

    private class PointCouple {
        private final Point2D pointA;
        private final Point2D pointB;

        public PointCouple(Point2D pointA, Point2D pointB) {
            this.pointA = pointA;
            this.pointB = pointB;
        }

        public Point2D getPointA() {
            return this.pointA;
        }

        public Point2D getPointB() {
            return this.pointB;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            if (this.pointA.getName().compareTo(this.pointB.getName()) < 0) {
                result = 31 * result + this.pointA.getName().hashCode();
                result = 31 * result + this.pointB.getName().hashCode();
            } else {
                result = 31 * result + this.pointB.getName().hashCode();
                result = 31 * result + this.pointA.getName().hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PointCouple other = (PointCouple)obj;
            return this.pointA.getName().equals(other.getPointA().getName()) && this.pointB.getName().equals(other.getPointB().getName()) || this.pointA.getName().equals(other.getPointB().getName()) && this.pointB.getName().equals(other.getPointA().getName());
        }

        private ForwardIntersectionSet getOuterType() {
            return ForwardIntersectionSet.this;
        }
    }
}

