/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.approximation.bundle.intersection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point;
import org.applied_geodesy.adjustment.network.approximation.bundle.point.Point2D;

public class ForwardIntersectionEntry {
    private final Point2D fixPointA;
    private final Point2D fixPointB;
    private final String newPointId;
    private List<Double> alpha = new ArrayList<Double>();
    private List<Double> beta = new ArrayList<Double>();

    public ForwardIntersectionEntry(Point2D fixPointA, Point2D fixPointB, String newPointId, double alpha, double beta) {
        this.fixPointA = fixPointA;
        this.fixPointB = fixPointB;
        this.newPointId = newPointId;
        this.addAngles(alpha, beta);
    }

    public void addAngles(double alpha, double beta) {
        this.alpha.add(MathExtension.MOD(alpha, Math.PI * 2));
        this.beta.add(MathExtension.MOD(beta, Math.PI * 2));
    }

    public void setFixPoint(Point2D p) {
        if (p.getName().equals(this.fixPointA.getName())) {
            this.fixPointA.setX(p.getX());
            this.fixPointA.setY(p.getY());
        } else if (p.getName().equals(this.fixPointB.getName())) {
            this.fixPointB.setX(p.getX());
            this.fixPointB.setY(p.getY());
        }
    }

    public Point2D adjust() {
        if (this.fixPointA == null || this.fixPointB == null) {
            return null;
        }
        int n = this.alpha.size();
        ArrayList<Double> medianX = new ArrayList<Double>(n);
        ArrayList<Double> medianY = new ArrayList<Double>(n);
        ArrayList<Point2D> intersectPoint = new ArrayList<Point2D>(n);
        double xA = this.fixPointA.getX();
        double yA = this.fixPointA.getY();
        double xB = this.fixPointB.getX();
        double yB = this.fixPointB.getY();
        double sAB = this.fixPointA.getDistance2D(this.fixPointB);
        double tAB = Math.atan2(yB - yA, xB - xA);
        int i = 0;
        while (i < n) {
            double beta;
            double alpha = this.alpha.get(i);
            if (alpha + (beta = this.beta.get(i).doubleValue()) != 0.0) {
                double sAN = sAB * Math.sin(beta) / Math.sin(alpha + beta);
                double sBN = sAB * Math.sin(alpha) / Math.sin(alpha + beta);
                double tAN = tAB - alpha;
                double tBN = Math.PI + tAB + beta;
                double yNA = yA + sAN * Math.sin(tAN);
                double xNA = xA + sAN * Math.cos(tAN);
                double yNB = yB + sBN * Math.sin(tBN);
                double xNB = xB + sBN * Math.cos(tBN);
                if (Math.abs(yNA - yNB) < 0.1 && Math.abs(xNA - xNB) < 0.1) {
                    double yN = 0.5 * (yNA + yNB);
                    double xN = 0.5 * (xNA + xNB);
                    medianX.add(xN);
                    medianY.add(yN);
                    intersectPoint.add(new Point2D(this.newPointId, xN, yN));
                }
            }
            ++i;
        }
        Collections.sort(medianX);
        Collections.sort(medianY);
        double x0 = (Double)medianX.get(medianX.size() / 2);
        double y0 = (Double)medianY.get(medianX.size() / 2);
        double norm2 = Double.MAX_VALUE;
        int index = 0;
        int i2 = 0;
        while (i2 < intersectPoint.size()) {
            double y;
            double x = ((Point2D)intersectPoint.get(i2)).getX() - x0;
            double norm = Math.hypot(x, y = ((Point2D)intersectPoint.get(i2)).getY() - y0);
            if (norm < norm2) {
                norm2 = norm;
                index = i2;
            }
            ++i2;
        }
        return (Point2D)intersectPoint.get(index);
    }

    public Point getReferencePointA() {
        return this.fixPointA;
    }

    public Point getReferencePointB() {
        return this.fixPointB;
    }

    public String getNewPointId() {
        return this.newPointId;
    }
}

