/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import org.applied_geodesy.adjustment.network.ObservationType;

public enum VarianceComponentType {
    GLOBAL(0),
    STOCHASTIC_POINT_1D_COMPONENT(101),
    STOCHASTIC_POINT_2D_COMPONENT(102),
    STOCHASTIC_POINT_3D_COMPONENT(103),
    STOCHASTIC_DEFLECTION_COMPONENT(201),
    LEVELING_COMPONENT(10),
    LEVELING_ZERO_POINT_OFFSET_COMPONENT(11),
    LEVELING_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(12),
    LEVELING_DISTANCE_DEPENDENT_COMPONENT(13),
    DIRECTION_COMPONENT(20),
    DIRECTION_ZERO_POINT_OFFSET_COMPONENT(21),
    DIRECTION_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(22),
    DIRECTION_DISTANCE_DEPENDENT_COMPONENT(23),
    HORIZONTAL_DISTANCE_COMPONENT(30),
    HORIZONTAL_DISTANCE_ZERO_POINT_OFFSET_COMPONENT(31),
    HORIZONTAL_DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(32),
    HORIZONTAL_DISTANCE_DISTANCE_DEPENDENT_COMPONENT(33),
    SLOPE_DISTANCE_COMPONENT(40),
    SLOPE_DISTANCE_ZERO_POINT_OFFSET_COMPONENT(41),
    SLOPE_DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(42),
    SLOPE_DISTANCE_DISTANCE_DEPENDENT_COMPONENT(43),
    ZENITH_ANGLE_COMPONENT(50),
    ZENITH_ANGLE_ZERO_POINT_OFFSET_COMPONENT(51),
    ZENITH_ANGLE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(52),
    ZENITH_ANGLE_DISTANCE_DEPENDENT_COMPONENT(53),
    GNSS1D_COMPONENT(60),
    GNSS1D_ZERO_POINT_OFFSET_COMPONENT(61),
    GNSS1D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(62),
    GNSS1D_DISTANCE_DEPENDENT_COMPONENT(63),
    GNSS2D_COMPONENT(70),
    GNSS2D_ZERO_POINT_OFFSET_COMPONENT(71),
    GNSS2D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(72),
    GNSS2D_DISTANCE_DEPENDENT_COMPONENT(73),
    GNSS3D_COMPONENT(80),
    GNSS3D_ZERO_POINT_OFFSET_COMPONENT(81),
    GNSS3D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT(82),
    GNSS3D_DISTANCE_DEPENDENT_COMPONENT(83);

    private int id;

    private VarianceComponentType(int id) {
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    public static VarianceComponentType getEnumByValue(int value) {
        VarianceComponentType[] varianceComponentTypeArray = VarianceComponentType.values();
        int n = varianceComponentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarianceComponentType element = varianceComponentTypeArray[n2];
            if (element.id == value) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static VarianceComponentType getVarianceComponentTypeByObservationType(ObservationType type) {
        if (type != null) {
            switch (type) {
                case LEVELING: {
                    return LEVELING_COMPONENT;
                }
                case DIRECTION: {
                    return DIRECTION_COMPONENT;
                }
                case HORIZONTAL_DISTANCE: {
                    return HORIZONTAL_DISTANCE_COMPONENT;
                }
                case SLOPE_DISTANCE: {
                    return SLOPE_DISTANCE_COMPONENT;
                }
                case ZENITH_ANGLE: {
                    return ZENITH_ANGLE_COMPONENT;
                }
                case GNSS1D: {
                    return GNSS1D_COMPONENT;
                }
                case GNSS2D: {
                    return GNSS2D_COMPONENT;
                }
                case GNSS3D: {
                    return GNSS3D_COMPONENT;
                }
            }
        }
        return null;
    }

    public static VarianceComponentType getZeroPointOffsetVarianceComponentTypeByObservationType(ObservationType type) {
        if (type != null) {
            switch (type) {
                case LEVELING: {
                    return LEVELING_ZERO_POINT_OFFSET_COMPONENT;
                }
                case DIRECTION: {
                    return DIRECTION_ZERO_POINT_OFFSET_COMPONENT;
                }
                case HORIZONTAL_DISTANCE: {
                    return HORIZONTAL_DISTANCE_ZERO_POINT_OFFSET_COMPONENT;
                }
                case SLOPE_DISTANCE: {
                    return SLOPE_DISTANCE_ZERO_POINT_OFFSET_COMPONENT;
                }
                case ZENITH_ANGLE: {
                    return ZENITH_ANGLE_ZERO_POINT_OFFSET_COMPONENT;
                }
                case GNSS1D: {
                    return GNSS1D_ZERO_POINT_OFFSET_COMPONENT;
                }
                case GNSS2D: {
                    return GNSS2D_ZERO_POINT_OFFSET_COMPONENT;
                }
                case GNSS3D: {
                    return GNSS3D_ZERO_POINT_OFFSET_COMPONENT;
                }
            }
        }
        return null;
    }

    public static VarianceComponentType getSquareRootDistanceDependentVarianceComponentTypeByObservationType(ObservationType type) {
        if (type != null) {
            switch (type) {
                case LEVELING: {
                    return LEVELING_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case DIRECTION: {
                    return DIRECTION_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case HORIZONTAL_DISTANCE: {
                    return HORIZONTAL_DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case SLOPE_DISTANCE: {
                    return SLOPE_DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case ZENITH_ANGLE: {
                    return ZENITH_ANGLE_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS1D: {
                    return GNSS1D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS2D: {
                    return GNSS2D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS3D: {
                    return GNSS3D_SQUARE_ROOT_DISTANCE_DEPENDENT_COMPONENT;
                }
            }
        }
        return null;
    }

    public static VarianceComponentType getDistanceDependentVarianceComponentTypeByObservationType(ObservationType type) {
        if (type != null) {
            switch (type) {
                case LEVELING: {
                    return LEVELING_DISTANCE_DEPENDENT_COMPONENT;
                }
                case DIRECTION: {
                    return DIRECTION_DISTANCE_DEPENDENT_COMPONENT;
                }
                case HORIZONTAL_DISTANCE: {
                    return HORIZONTAL_DISTANCE_DISTANCE_DEPENDENT_COMPONENT;
                }
                case SLOPE_DISTANCE: {
                    return SLOPE_DISTANCE_DISTANCE_DEPENDENT_COMPONENT;
                }
                case ZENITH_ANGLE: {
                    return ZENITH_ANGLE_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS1D: {
                    return GNSS1D_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS2D: {
                    return GNSS2D_DISTANCE_DEPENDENT_COMPONENT;
                }
                case GNSS3D: {
                    return GNSS3D_DISTANCE_DEPENDENT_COMPONENT;
                }
            }
        }
        return null;
    }

    public static VarianceComponentType getComponentTypeByPointDimension(int dimension) {
        switch (dimension) {
            case 1: {
                return STOCHASTIC_POINT_1D_COMPONENT;
            }
            case 2: {
                return STOCHASTIC_POINT_2D_COMPONENT;
            }
            case 3: {
                return STOCHASTIC_POINT_3D_COMPONENT;
            }
        }
        return null;
    }
}

