/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import org.applied_geodesy.adjustment.network.VarianceComponentType;

public class VarianceComponent {
    private final VarianceComponentType type;
    private int numberOfObservations = 0;
    private int numberOfEffectiveObservations = 0;
    private int numberOfNegativeResiduals = 0;
    private double redundancy = 0.0;
    private double omega = 0.0;

    VarianceComponent(VarianceComponentType type) {
        this.type = type;
    }

    public double getRedundancy() {
        return this.redundancy;
    }

    public void setRedundancy(double redundancy) {
        this.redundancy = redundancy;
    }

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    public void setNumberOfObservations(int noo) {
        this.numberOfObservations = noo;
    }

    public int getNumberOfEffectiveObservations() {
        return this.numberOfEffectiveObservations;
    }

    public void setNumberOfEffectiveObservations(int noeo) {
        this.numberOfEffectiveObservations = noeo;
    }

    public int getNumberOfNegativeResiduals() {
        return this.numberOfNegativeResiduals;
    }

    public void setNumberOfNegativeResiduals(int nopr) {
        this.numberOfNegativeResiduals = nopr;
    }

    public VarianceComponentType getVarianceComponentType() {
        return this.type;
    }

    public double getVarianceFactorAposteriori() {
        return this.redundancy > 0.0 ? this.omega / this.redundancy : 0.0;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + "\r\nr=" + this.getRedundancy() + "\r\nomega=" + this.getOmega() + "\r\nsigma=" + this.getVarianceFactorAposteriori() + "\r\nnumObs=" + this.getNumberOfObservations();
    }
}

