/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import org.applied_geodesy.adjustment.network.DefectType;

public class RankDefect {
    private boolean userDefinedRankDefect = false;
    private DefectType rx = DefectType.NOT_SET;
    private DefectType ry = DefectType.NOT_SET;
    private DefectType rz = DefectType.NOT_SET;
    private DefectType tx = DefectType.NOT_SET;
    private DefectType ty = DefectType.NOT_SET;
    private DefectType tz = DefectType.NOT_SET;
    private DefectType sx = DefectType.NOT_SET;
    private DefectType sy = DefectType.NOT_SET;
    private DefectType sz = DefectType.NOT_SET;
    private DefectType mx = DefectType.NOT_SET;
    private DefectType my = DefectType.NOT_SET;
    private DefectType mz = DefectType.NOT_SET;
    private DefectType mxy = DefectType.NOT_SET;
    private DefectType mxyz = DefectType.NOT_SET;

    void setScaleXYZ(DefectType defectType) {
        this.mz = this.mxy = DefectType.NOT_SET;
        this.my = this.mxy;
        this.mx = this.mxy;
        this.mxyz = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setScaleXY(DefectType defectType) {
        if (this.mxyz != DefectType.NOT_SET) {
            this.mz = this.mxy = DefectType.NOT_SET;
            this.my = this.mxy;
            this.mx = this.mxy;
        } else {
            this.mxy = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
        }
    }

    void setScaleX(DefectType defectType) {
        if (this.mxyz != DefectType.NOT_SET) {
            this.mz = this.mxy = DefectType.NOT_SET;
            this.my = this.mxy;
            this.mx = this.mxy;
        } else {
            this.mx = this.mxy != DefectType.NOT_SET ? (this.my = DefectType.NOT_SET) : (defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE);
        }
    }

    void setScaleY(DefectType defectType) {
        if (this.mxyz != DefectType.NOT_SET) {
            this.mz = this.mxy = DefectType.NOT_SET;
            this.my = this.mxy;
            this.mx = this.mxy;
        } else if (this.mxy != DefectType.NOT_SET) {
            this.mx = this.my = DefectType.NOT_SET;
        } else {
            this.my = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
        }
    }

    void setScaleZ(DefectType defectType) {
        if (this.mxyz != DefectType.NOT_SET) {
            this.mz = this.mxy = DefectType.NOT_SET;
            this.my = this.mxy;
            this.mx = this.mxy;
        } else {
            this.mz = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
        }
    }

    void setShearX(DefectType defectType) {
        this.sx = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setShearY(DefectType defectType) {
        this.sy = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setShearZ(DefectType defectType) {
        this.sz = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setRotationX(DefectType defectType) {
        this.rx = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setRotationY(DefectType defectType) {
        this.ry = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setRotationZ(DefectType defectType) {
        this.rz = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setTranslationX(DefectType defectType) {
        this.tx = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setTranslationY(DefectType defectType) {
        this.ty = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    void setTranslationZ(DefectType defectType) {
        this.tz = defectType == DefectType.FIXED ? DefectType.FIXED : DefectType.FREE;
    }

    public void setScaleXYZDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setScaleXYZ(defectType);
    }

    public void setScaleXYDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setScaleXY(defectType);
    }

    public void setScaleXDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setScaleX(defectType);
    }

    public void setScaleYDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setScaleY(defectType);
    }

    public void setScaleZDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setScaleZ(defectType);
    }

    public void setShearXDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setShearX(defectType);
    }

    public void setShearYDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setShearY(defectType);
    }

    public void setShearZDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setShearZ(defectType);
    }

    public void setRotationXDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setRotationX(defectType);
    }

    public void setRotationYDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setRotationY(defectType);
    }

    public void setRotationZDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setRotationZ(defectType);
    }

    public void setTranslationXDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setTranslationX(defectType);
    }

    public void setTranslationYDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setTranslationY(defectType);
    }

    public void setTranslationZDefectType(DefectType defectType) {
        this.userDefinedRankDefect = true;
        this.setTranslationZ(defectType);
    }

    public boolean estimateScaleX() {
        return this.mx == DefectType.FREE;
    }

    public boolean estimateScaleY() {
        return this.my == DefectType.FREE;
    }

    public boolean estimateScaleZ() {
        return this.mz == DefectType.FREE;
    }

    public boolean estimateScaleXY() {
        return this.mxy == DefectType.FREE;
    }

    public boolean estimateScaleXYZ() {
        return this.mxyz == DefectType.FREE;
    }

    public boolean estimateShearX() {
        return this.sx == DefectType.FREE;
    }

    public boolean estimateShearY() {
        return this.sy == DefectType.FREE;
    }

    public boolean estimateShearZ() {
        return this.sz == DefectType.FREE;
    }

    public boolean estimateRotationX() {
        return this.rx == DefectType.FREE;
    }

    public boolean estimateRotationY() {
        return this.ry == DefectType.FREE;
    }

    public boolean estimateRotationZ() {
        return this.rz == DefectType.FREE;
    }

    public boolean estimateTranslationX() {
        return this.tx == DefectType.FREE;
    }

    public boolean estimateTranslationY() {
        return this.ty == DefectType.FREE;
    }

    public boolean estimateTranslationZ() {
        return this.tz == DefectType.FREE;
    }

    public DefectType getScaleXYZ() {
        return this.mxyz;
    }

    public DefectType getScaleXY() {
        return this.mxy;
    }

    public DefectType getScaleX() {
        return this.mx;
    }

    public DefectType getScaleY() {
        return this.my;
    }

    public DefectType getScaleZ() {
        return this.mz;
    }

    public DefectType getShearX() {
        return this.sx;
    }

    public DefectType getShearY() {
        return this.sy;
    }

    public DefectType getShearZ() {
        return this.sz;
    }

    public DefectType getRotationX() {
        return this.rx;
    }

    public DefectType getRotationY() {
        return this.ry;
    }

    public DefectType getRotationZ() {
        return this.rz;
    }

    public DefectType getTranslationX() {
        return this.tx;
    }

    public DefectType getTranslationY() {
        return this.ty;
    }

    public DefectType getTranslationZ() {
        return this.tz;
    }

    public int getDefect() {
        int d = 0;
        d += this.estimateScaleX() ? 1 : 0;
        d += this.estimateScaleY() ? 1 : 0;
        d += this.estimateScaleZ() ? 1 : 0;
        d += this.estimateScaleXY() ? 1 : 0;
        d += this.estimateScaleXYZ() ? 1 : 0;
        d += this.estimateRotationX() ? 1 : 0;
        d += this.estimateRotationY() ? 1 : 0;
        d += this.estimateRotationZ() ? 1 : 0;
        d += this.estimateShearX() ? 1 : 0;
        d += this.estimateShearY() ? 1 : 0;
        d += this.estimateShearZ() ? 1 : 0;
        d += this.estimateTranslationX() ? 1 : 0;
        d += this.estimateTranslationY() ? 1 : 0;
        return d += this.estimateTranslationZ() ? 1 : 0;
    }

    public boolean isUserDefinedRankDefect() {
        return this.userDefinedRankDefect;
    }

    public void reset() {
        this.userDefinedRankDefect = false;
        this.ty = this.tz = DefectType.NOT_SET;
        this.tx = this.tz;
        this.ry = this.rz = DefectType.NOT_SET;
        this.rx = this.rz;
        this.sy = this.sz = DefectType.NOT_SET;
        this.sx = this.sz;
        this.my = this.mz = DefectType.NOT_SET;
        this.mx = this.mz;
        this.mxy = this.mxyz = DefectType.NOT_SET;
    }

    public String toString() {
        return "RankDefect [rx=" + String.valueOf((Object)this.rx) + ", ry=" + String.valueOf((Object)this.ry) + ", rz=" + String.valueOf((Object)this.rz) + ", tx=" + String.valueOf((Object)this.tx) + ", ty=" + String.valueOf((Object)this.ty) + ", tz=" + String.valueOf((Object)this.tz) + ", sx=" + String.valueOf((Object)this.sx) + ", sy=" + String.valueOf((Object)this.sy) + ", sz=" + String.valueOf((Object)this.sz) + ", mx=" + String.valueOf((Object)this.mx) + ", my=" + String.valueOf((Object)this.my) + ", mz=" + String.valueOf((Object)this.mz) + ", mxy=" + String.valueOf((Object)this.mxy) + ", mxyz=" + String.valueOf((Object)this.mxyz) + ", defect=" + this.getDefect() + ", userDefinedRankDefect=" + this.userDefinedRankDefect + "]";
    }
}

