/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.applied_geodesy.adjustment.ConfidenceRegion;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.NormalEquationSystem;
import org.applied_geodesy.adjustment.UnscentedTransformationParameter;
import org.applied_geodesy.adjustment.network.DefectType;
import org.applied_geodesy.adjustment.network.Epoch;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.PrincipalComponent;
import org.applied_geodesy.adjustment.network.RankDefect;
import org.applied_geodesy.adjustment.network.VarianceComponent;
import org.applied_geodesy.adjustment.network.VarianceComponentType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.adjustment.network.congruence.CongruenceAnalysisGroup;
import org.applied_geodesy.adjustment.network.congruence.CongruenceAnalysisPointPair;
import org.applied_geodesy.adjustment.network.congruence.strain.CoordinateComponent;
import org.applied_geodesy.adjustment.network.congruence.strain.Equation;
import org.applied_geodesy.adjustment.network.congruence.strain.RestrictionType;
import org.applied_geodesy.adjustment.network.congruence.strain.StrainAnalysisEquations;
import org.applied_geodesy.adjustment.network.congruence.strain.parameter.StrainParameter;
import org.applied_geodesy.adjustment.network.observation.ComponentType;
import org.applied_geodesy.adjustment.network.observation.DeltaZ;
import org.applied_geodesy.adjustment.network.observation.Direction;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline1D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline2D;
import org.applied_geodesy.adjustment.network.observation.GNSSBaseline3D;
import org.applied_geodesy.adjustment.network.observation.HorizontalDistance;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.observation.SlopeDistance;
import org.applied_geodesy.adjustment.network.observation.ZenithAngle;
import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameters;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflection;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflectionX;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflectionY;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.adjustment.network.point.Point3D;
import org.applied_geodesy.adjustment.statistic.BaardaMethodTestStatistic;
import org.applied_geodesy.adjustment.statistic.BinomialTestStatisticParameters;
import org.applied_geodesy.adjustment.statistic.SidakTestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameters;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.adjustment.statistic.UnadjustedTestStatitic;
import org.applied_geodesy.jag3d.ui.io.writer.AdjustmentResultWritable;
import org.applied_geodesy.jag3d.ui.io.writer.NetworkAdjustmentResultWriter;
import org.applied_geodesy.transformation.datum.SphericalDeflectionModel;

public class NetworkAdjustment
implements Runnable {
    private Map<Observation, Double> adaptedObservationUncertainties = new LinkedHashMap<Observation, Double>();
    private Map<Point, Double[]> adaptedPointUncertainties = new LinkedHashMap<Point, Double[]>();
    private Map<VerticalDeflection, Double> adaptedVerticalDeflectionUncertainties = new LinkedHashMap<VerticalDeflection, Double>();
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    private boolean calculateStochasticParameters = false;
    private static double SQRT_EPS = Math.sqrt(Constant.EPS);
    private EstimationType estimationType = EstimationType.L2NORM;
    private UpperSymmPackMatrix Qxx = null;
    private SphericalDeflectionModel sphericalDeflectionModel = null;
    private int maximalNumberOfIterations = DefaultValue.getMaximumNumberOfIterations();
    private int iterationStep = 0;
    private int numberOfStochasticPointRows = 0;
    private int numberOfStochasticDeflectionRows = 0;
    private int numberOfFixPointRows = 0;
    private int numberOfUnknownParameters = 0;
    private int numberOfObservations = 0;
    private int numberOfHypotesis = 0;
    private int numberOfPrincipalComponents = 0;
    private boolean interrupt = false;
    private boolean freeNetwork = false;
    private boolean congruenceAnalysis = false;
    private boolean proofOfDatumDefectDetection = false;
    private boolean applyAposterioriVarianceOfUnitWeight = true;
    private double maxDx = Double.MIN_VALUE;
    private double degreeOfFreedom = 0.0;
    private double omega = 0.0;
    private double traceCxxPoints = 0.0;
    private double finalLinearisationError = 0.0;
    private double robustEstimationLimit = DefaultValue.getRobustEstimationLimit();
    private double alphaUT = UnscentedTransformationParameter.getAlpha();
    private double betaUT = UnscentedTransformationParameter.getBeta();
    private double weightZero = UnscentedTransformationParameter.getWeightZero();
    private EstimationStateType currentEstimationStatus = EstimationStateType.BUSY;
    private double currentMaxAbsDx = this.maxDx;
    private TestStatisticDefinition testStatisticDefinition = new TestStatisticDefinition();
    private TestStatisticDefinition confidenceRegionDefinition = new TestStatisticDefinition(TestStatisticType.NONE, 1.0 - DefaultValue.getConfidenceLevel());
    private TestStatisticParameters significanceTestStatisticParameters = null;
    private BinomialTestStatisticParameters binomialTestStatisticParameters = null;
    private TestStatisticParameters confidenceRegionParameters = null;
    private Map<String, Point> allPoints = new LinkedHashMap<String, Point>();
    private List<Point> datumPoints = new ArrayList<Point>();
    private List<Point> stochasticPoints = new ArrayList<Point>();
    private List<Point> pointsWithUnknownDeflection = new ArrayList<Point>();
    private List<Point> pointsWithStochasticDeflection = new ArrayList<Point>();
    private List<Point> pointsWithReferenceDeflection = new ArrayList<Point>();
    private List<Point> referencePoints = new ArrayList<Point>();
    private PrincipalComponent[] principalComponents = new PrincipalComponent[0];
    private List<CongruenceAnalysisGroup> congruenceAnalysisGroup = new ArrayList<CongruenceAnalysisGroup>();
    private Map<VarianceComponentType, VarianceComponent> varianceComponents = new LinkedHashMap<VarianceComponentType, VarianceComponent>();
    private Map<Integer, Matrix> ATQxxBP_GNSS_EP = new LinkedHashMap<Integer, Matrix>();
    private Map<Integer, Matrix> PAzTQzzAzP_GNSS_EF = new LinkedHashMap<Integer, Matrix>();
    private UnknownParameters unknownParameters = new UnknownParameters();
    private ObservationGroup projectObservations = new ObservationGroup(-1, Double.NaN, Double.NaN, Double.NaN, Epoch.REFERENCE);
    private RankDefect rankDefect = new RankDefect();
    private AdjustmentResultWritable adjustmentResultWriter = null;

    private void estimateFactorsForOutherAccracy(UpperSymmPackMatrix N, DenseVector n) {
        int colM;
        int j;
        LinkedHashMap<Integer, Integer> idxAddParamGlobal2LocalInQxx = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> idxPointGlobal2LocalInQxx = new LinkedHashMap<Integer, Integer>();
        ArrayList<Integer> idxAddParamLocal2GlobalInQxx = new ArrayList<Integer>();
        ArrayList<Integer> idxPointLocal2GlobalInQxx = new ArrayList<Integer>();
        int i = 0;
        while (i < this.unknownParameters.size()) {
            UnknownParameter param = this.unknownParameters.get(i);
            if (param.getColInJacobiMatrix() >= 0) {
                if (param.getParameterType() == ParameterType.POINT1D) {
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix(), idxPointLocal2GlobalInQxx.size());
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix());
                } else if (param.getParameterType() == ParameterType.POINT2D) {
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix(), idxPointLocal2GlobalInQxx.size());
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix() + 1, idxPointLocal2GlobalInQxx.size() + 1);
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix());
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix() + 1);
                } else if (param.getParameterType() == ParameterType.POINT3D) {
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix(), idxPointLocal2GlobalInQxx.size());
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix() + 1, idxPointLocal2GlobalInQxx.size() + 1);
                    idxPointGlobal2LocalInQxx.put(param.getColInJacobiMatrix() + 2, idxPointLocal2GlobalInQxx.size() + 2);
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix());
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix() + 1);
                    idxPointLocal2GlobalInQxx.add(param.getColInJacobiMatrix() + 2);
                } else if (param instanceof AdditionalUnknownParameter) {
                    idxAddParamGlobal2LocalInQxx.put(param.getColInJacobiMatrix(), idxAddParamLocal2GlobalInQxx.size());
                    idxAddParamLocal2GlobalInQxx.add(param.getColInJacobiMatrix());
                }
            }
            ++i;
        }
        UpperSymmPackMatrix Qzz = new UpperSymmPackMatrix(idxAddParamLocal2GlobalInQxx.size());
        int k = 0;
        while (k < idxAddParamLocal2GlobalInQxx.size()) {
            int rowM = (Integer)idxAddParamLocal2GlobalInQxx.get(k);
            j = k;
            while (j < idxAddParamLocal2GlobalInQxx.size()) {
                colM = (Integer)idxAddParamLocal2GlobalInQxx.get(j);
                Qzz.set(k, j, N.get(rowM, colM));
                ++j;
            }
            ++k;
        }
        DenseMatrix QzzNzx = new DenseMatrix(idxAddParamLocal2GlobalInQxx.size(), idxPointLocal2GlobalInQxx.size());
        try {
            MathExtension.inv(Qzz);
            int k2 = 0;
            while (k2 < idxAddParamLocal2GlobalInQxx.size()) {
                j = 0;
                while (j < idxPointLocal2GlobalInQxx.size()) {
                    colM = (Integer)idxPointLocal2GlobalInQxx.get(j);
                    int i2 = 0;
                    while (i2 < idxAddParamLocal2GlobalInQxx.size()) {
                        int idx = (Integer)idxAddParamLocal2GlobalInQxx.get(i2);
                        double qzznzx = Qzz.get(k2, i2) * N.get(idx, colM);
                        QzzNzx.add(k2, j, qzznzx);
                        ++i2;
                    }
                    ++j;
                }
                ++k2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MathExtension.solve(N, n, true);
        this.Qxx = N;
        LinkedHashSet<Integer> gnssObsIds = new LinkedHashSet<Integer>();
        int i3 = 0;
        while (i3 < this.projectObservations.size()) {
            boolean isGNSS;
            Observation obs = this.projectObservations.get(i3);
            boolean bl = isGNSS = obs.getObservationType() == ObservationType.GNSS1D || obs.getObservationType() == ObservationType.GNSS2D || obs.getObservationType() == ObservationType.GNSS3D;
            if (!isGNSS || !gnssObsIds.contains(obs.getId())) {
                int col;
                Observation observation;
                if (isGNSS) {
                    gnssObsIds.add(obs.getId());
                }
                List<Observation> observations = null;
                if (isGNSS) {
                    observations = ((GNSSBaseline)obs).getBaselineComponents();
                } else {
                    observations = new ArrayList<Observation>(1);
                    observations.add(obs);
                }
                int numOfObs = observations.size();
                DenseMatrix aRedu = new DenseMatrix(numOfObs, idxPointLocal2GlobalInQxx.size());
                DenseMatrix aQxx = new DenseMatrix(numOfObs, idxPointLocal2GlobalInQxx.size());
                DenseMatrix aAdd = new DenseMatrix(numOfObs, idxAddParamLocal2GlobalInQxx.size());
                double[] weights = new double[numOfObs];
                int d = 0;
                while (d < numOfObs) {
                    observation = observations.get(d);
                    weights[d] = 1.0 / observation.getStdApriori() / observation.getStdApriori();
                    int column = 0;
                    while (column < QzzNzx.numColumns()) {
                        aQxx.set(d, column, this.getAQxxElement(observation, (Integer)idxPointLocal2GlobalInQxx.get(column), true));
                        ++column;
                    }
                    col = observation.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix();
                    if (col >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffVerticalDeflectionXs());
                    }
                    if ((col = observation.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffVerticalDeflectionYs());
                    }
                    if ((col = observation.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffVerticalDeflectionXe());
                    }
                    if ((col = observation.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffVerticalDeflectionYe());
                    }
                    if ((col = observation.getColInJacobiMatrixFromOrientation()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffOri());
                    }
                    if ((col = observation.getColInJacobiMatrixFromScale()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffScale());
                    }
                    if ((col = observation.getColInJacobiMatrixFromAdd()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffAdd());
                    }
                    if ((col = observation.getColInJacobiMatrixFromRefCoeff()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffRefCoeff());
                    }
                    if ((col = observation.getColInJacobiMatrixFromRotationX()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffRotX());
                    }
                    if ((col = observation.getColInJacobiMatrixFromRotationY()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffRotY());
                    }
                    if ((col = observation.getColInJacobiMatrixFromRotationZ()) >= 0 && idxAddParamGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxAddParamGlobal2LocalInQxx.get(col);
                        aAdd.set(d, col, observation.diffRotZ());
                    }
                    ++d;
                }
                aAdd.mult((Matrix)QzzNzx, (Matrix)aRedu);
                aRedu = aRedu.scale(-1.0);
                d = 0;
                while (d < numOfObs) {
                    observation = observations.get(d);
                    col = observation.getStartPoint().getColInJacobiMatrix();
                    int dim = observation.getStartPoint().getDimension();
                    if (col >= 0 && idxPointGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxPointGlobal2LocalInQxx.get(col);
                        if (dim != 1) {
                            aRedu.add(d, col++, observation.diffXs());
                            aRedu.add(d, col++, observation.diffYs());
                        }
                        if (dim != 2) {
                            aRedu.add(d, col++, observation.diffZs());
                        }
                    }
                    col = observation.getEndPoint().getColInJacobiMatrix();
                    dim = observation.getEndPoint().getDimension();
                    if (col >= 0 && idxPointGlobal2LocalInQxx.containsKey(col)) {
                        col = (Integer)idxPointGlobal2LocalInQxx.get(col);
                        if (dim != 1) {
                            aRedu.add(d, col++, observation.diffXe());
                            aRedu.add(d, col++, observation.diffYe());
                        }
                        if (dim != 2) {
                            aRedu.add(d, col++, observation.diffZe());
                        }
                    }
                    ++d;
                }
                DenseMatrix AzTQzz = new DenseMatrix(aAdd.numRows(), Qzz.numColumns());
                aAdd.mult((Matrix)Qzz, (Matrix)AzTQzz);
                UpperSymmPackMatrix PAzTQzzAzP = new UpperSymmPackMatrix(aAdd.numRows());
                AzTQzz.transBmult((Matrix)aAdd, (Matrix)PAzTQzzAzP);
                AzTQzz = null;
                DenseMatrix ATQxxBP = new DenseMatrix(numOfObs, numOfObs);
                aQxx.transBmult((Matrix)aRedu, (Matrix)ATQxxBP);
                int r = 0;
                while (r < numOfObs) {
                    int c = 0;
                    while (c < numOfObs) {
                        ATQxxBP.set(r, c, weights[r] * ATQxxBP.get(r, c));
                        PAzTQzzAzP.set(r, c, weights[c] * weights[r] * PAzTQzzAzP.get(r, c));
                        ++c;
                    }
                    ++r;
                }
                if (isGNSS) {
                    this.ATQxxBP_GNSS_EP.put(obs.getId(), (Matrix)ATQxxBP);
                    this.PAzTQzzAzP_GNSS_EF.put(obs.getId(), (Matrix)PAzTQzzAzP);
                } else {
                    obs.setInfluenceOnPointPosition(ATQxxBP.get(0, 0));
                    obs.setInfluenceOnNetworkDistortion(PAzTQzzAzP.get(0, 0));
                }
            }
            ++i3;
        }
    }

    private double getAQxxElement(Observation observation, int column) {
        return this.getAQxxElement(observation, column, false);
    }

    private double getAQxxElement(Observation observation, int column, boolean withoutAdditionalParameters) {
        if (column < 0) {
            return 0.0;
        }
        double aqxx = 0.0;
        int row = observation.getStartPoint().getColInJacobiMatrix();
        int dim = observation.getStartPoint().getDimension();
        if (row >= 0) {
            if (dim != 1) {
                aqxx += observation.diffXs() * this.Qxx.get(row++, column);
                aqxx += observation.diffYs() * this.Qxx.get(row++, column);
            }
            if (dim != 2) {
                aqxx += observation.diffZs() * this.Qxx.get(row, column);
            }
        }
        row = observation.getEndPoint().getColInJacobiMatrix();
        dim = observation.getEndPoint().getDimension();
        if (row >= 0) {
            if (dim != 1) {
                aqxx += observation.diffXe() * this.Qxx.get(row++, column);
                aqxx += observation.diffYe() * this.Qxx.get(row++, column);
            }
            if (dim != 2) {
                aqxx += observation.diffZe() * this.Qxx.get(row, column);
            }
        }
        if (!withoutAdditionalParameters) {
            row = observation.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix();
            if (row >= 0) {
                aqxx += observation.diffVerticalDeflectionXs() * this.Qxx.get(row, column);
            }
            if ((row = observation.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0) {
                aqxx += observation.diffVerticalDeflectionYs() * this.Qxx.get(row, column);
            }
            if ((row = observation.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix()) >= 0) {
                aqxx += observation.diffVerticalDeflectionXe() * this.Qxx.get(row, column);
            }
            if ((row = observation.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0) {
                aqxx += observation.diffVerticalDeflectionYe() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromOrientation()) >= 0) {
                aqxx += observation.diffOri() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromScale()) >= 0) {
                aqxx += observation.diffScale() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromAdd()) >= 0) {
                aqxx += observation.diffAdd() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromRefCoeff()) >= 0) {
                aqxx += observation.diffRefCoeff() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromRotationX()) >= 0) {
                aqxx += observation.diffRotX() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromRotationY()) >= 0) {
                aqxx += observation.diffRotY() * this.Qxx.get(row, column);
            }
            if ((row = observation.getColInJacobiMatrixFromRotationZ()) >= 0) {
                aqxx += observation.diffRotZ() * this.Qxx.get(row, column);
            }
        }
        return aqxx;
    }

    private double getQllElement(Observation observationOne, Observation observationTwo) {
        double qll = 0.0;
        int col = observationTwo.getStartPoint().getColInJacobiMatrix();
        int dim = observationTwo.getStartPoint().getDimension();
        if (col >= 0) {
            if (dim != 1) {
                qll += observationTwo.diffXs() * this.getAQxxElement(observationOne, col++);
                qll += observationTwo.diffYs() * this.getAQxxElement(observationOne, col++);
            }
            if (dim != 2) {
                qll += observationTwo.diffZs() * this.getAQxxElement(observationOne, col);
            }
        }
        col = observationTwo.getEndPoint().getColInJacobiMatrix();
        dim = observationTwo.getEndPoint().getDimension();
        if (col >= 0) {
            if (dim != 1) {
                qll += observationTwo.diffXe() * this.getAQxxElement(observationOne, col++);
                qll += observationTwo.diffYe() * this.getAQxxElement(observationOne, col++);
            }
            if (dim != 2) {
                qll += observationTwo.diffZe() * this.getAQxxElement(observationOne, col);
            }
        }
        if ((col = observationTwo.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix()) >= 0) {
            qll += observationTwo.diffVerticalDeflectionXs() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0) {
            qll += observationTwo.diffVerticalDeflectionYs() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix()) >= 0) {
            qll += observationTwo.diffVerticalDeflectionXe() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix()) >= 0) {
            qll += observationTwo.diffVerticalDeflectionYe() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromOrientation()) >= 0) {
            qll += observationTwo.diffOri() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromScale()) >= 0) {
            qll += observationTwo.diffScale() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromAdd()) >= 0) {
            qll += observationTwo.diffAdd() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromRefCoeff()) >= 0) {
            qll += observationTwo.diffRefCoeff() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromRotationX()) >= 0) {
            qll += observationTwo.diffRotX() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromRotationY()) >= 0) {
            qll += observationTwo.diffRotY() * this.getAQxxElement(observationOne, col);
        }
        if ((col = observationTwo.getColInJacobiMatrixFromRotationZ()) >= 0) {
            qll += observationTwo.diffRotZ() * this.getAQxxElement(observationOne, col);
        }
        return qll;
    }

    public void addSubRedundanceAndCofactor2Deflection(Point deflectionPoint, boolean restoreUncertainties) {
        VerticalDeflectionX deflectionX = deflectionPoint.getVerticalDeflectionX();
        VerticalDeflectionY deflectionY = deflectionPoint.getVerticalDeflectionY();
        int colX = deflectionX.getColInJacobiMatrix();
        int colY = deflectionY.getColInJacobiMatrix();
        int[] cols = new int[]{colX, colY};
        int dim = cols.length;
        double[] rDiag = new double[dim];
        double sumDiagR = 0.0;
        DenseMatrix Qll_P = new DenseMatrix(dim, dim);
        UpperSymmPackMatrix PR = new UpperSymmPackMatrix(dim);
        DenseMatrix Qnn = new DenseMatrix(dim, dim);
        DenseVector Pv = new DenseVector(dim);
        DenseVector Pv0 = new DenseVector(dim);
        DenseVector nabla = new DenseVector(dim);
        UpperSymmPackMatrix subPsubPQvvP = new UpperSymmPackMatrix(dim);
        double[] qll = new double[dim];
        double[] qll0 = new double[dim];
        Double[] u = new Double[dim];
        if (this.estimationType == EstimationType.L1NORM && restoreUncertainties) {
            if (this.adaptedVerticalDeflectionUncertainties.containsKey(deflectionX)) {
                u[0] = this.adaptedVerticalDeflectionUncertainties.get(deflectionX);
            }
            if (this.adaptedVerticalDeflectionUncertainties.containsKey(deflectionY)) {
                u[1] = this.adaptedVerticalDeflectionUncertainties.get(deflectionY);
            }
        }
        int diag = 0;
        double vx = deflectionX.getValue() - deflectionX.getValue0();
        double vy = deflectionY.getValue() - deflectionY.getValue0();
        qll[diag] = deflectionX.getStdApriori() * deflectionX.getStdApriori();
        qll0[diag] = u[diag] == null ? qll[diag] : u[diag];
        deflectionX.setOmega(vx * vx / qll0[diag]);
        Pv0.set(diag, vx / qll0[diag]);
        Pv.set(diag, vx / qll[diag++]);
        qll[diag] = deflectionY.getStdApriori() * deflectionY.getStdApriori();
        qll0[diag] = u[diag] == null ? qll[diag] : u[diag];
        deflectionY.setOmega(vy * vy / qll0[diag]);
        Pv0.set(diag, vy / qll0[diag]);
        Pv.set(diag, vy / qll[diag++]);
        int i = 0;
        while (i < dim) {
            int j = i;
            while (j < dim) {
                double qxx = this.Qxx.get(cols[i], cols[j]);
                if (i == j) {
                    double rr;
                    qvv = qll[i] - qxx;
                    qvv = Math.abs(qvv) < Constant.EPS || qvv < 0.0 ? 0.0 : qvv;
                    rDiag[i] = rr = 1.0 / qll[i] * qvv;
                    sumDiagR += rr;
                    Qll_P.set(i, i, qxx / qll[i]);
                    PR.set(i, i, 1.0 / qll[i] * rr);
                } else {
                    qvv = -qxx;
                    qvv = Math.abs(qvv) < Constant.EPS ? 0.0 : qvv;
                    double rrIJ = 1.0 / qll[i] * qvv;
                    Qll_P.set(j, i, qxx / qll[i]);
                    PR.set(i, j, 1.0 / qll[j] * rrIJ);
                    Qll_P.set(i, j, qxx / qll[j]);
                }
                ++j;
            }
            ++i;
        }
        subPsubPQvvP = new UpperSymmPackMatrix((Matrix)PR);
        subPsubPQvvP.scale(-1.0);
        int d = 0;
        while (d < dim) {
            subPsubPQvvP.add(d, d, 1.0 / qll[d]);
            ++d;
        }
        deflectionX.setRedundancy(rDiag[0]);
        deflectionY.setRedundancy(rDiag[1]);
        this.degreeOfFreedom += sumDiagR;
        this.omega += deflectionX.getOmega() + deflectionY.getOmega();
        VarianceComponentType vcType = VarianceComponentType.STOCHASTIC_DEFLECTION_COMPONENT;
        if (vcType != null && this.varianceComponents.containsKey((Object)vcType)) {
            VarianceComponent vc = this.varianceComponents.get((Object)vcType);
            vc.setOmega(vc.getOmega() + deflectionX.getOmega() + deflectionY.getOmega());
            vc.setRedundancy(vc.getRedundancy() + sumDiagR);
            vc.setNumberOfObservations(vc.getNumberOfObservations() + 2);
            if (sumDiagR > 0.0) {
                vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + (vx < 0.0 ? 1 : 0) + (vy < 0.0 ? 1 : 0));
                vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + 2);
            }
        }
        if (sumDiagR > SQRT_EPS) {
            boolean isCalculated = false;
            ConfidenceRegion confidenceRegion = null;
            try {
                Qnn = MathExtension.pinv((Matrix)PR, -1);
                confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                isCalculated = true;
            }
            catch (NotConvergedException nce) {
                isCalculated = false;
                nce.printStackTrace();
            }
            if (isCalculated) {
                if (this.estimationType == EstimationType.SIMULATION) {
                    DenseVector nabla0 = new DenseVector(dim);
                    int j = 0;
                    while (j < dim) {
                        nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                        ++j;
                    }
                    DenseVector subPsubPQvvPNabla0 = new DenseVector(dim);
                    subPsubPQvvP.mult((Vector)nabla0, (Vector)subPsubPQvvPNabla0);
                    deflectionX.setMaximumTolerableBias(nabla0.get(0));
                    deflectionY.setMaximumTolerableBias(nabla0.get(1));
                } else {
                    Qnn.mult((Vector)Pv, (Vector)nabla);
                    double normNabla = nabla.norm(Vector.Norm.Two);
                    double nablaCoVarNable = Math.abs(nabla.dot((Vector)Pv0));
                    deflectionX.setNablaCoVarNabla(nablaCoVarNable);
                    nabla = nabla.scale(-1.0);
                    deflectionX.setGrossError(nabla.get(0));
                    deflectionY.setGrossError(nabla.get(1));
                    DenseVector subPsubPQvvPNabla = new DenseVector(dim);
                    subPsubPQvvP.mult((Vector)nabla, (Vector)subPsubPQvvPNabla);
                    DenseVector nabla0 = new DenseVector((Vector)nabla, true);
                    DenseVector PQvvPnabla0 = new DenseVector((Vector)nabla0);
                    PR.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                    double nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                    if (normNabla < SQRT_EPS || nQn0 <= 0.0) {
                        int j = 0;
                        while (j < dim) {
                            nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < dim) {
                            nabla0.set(j, nabla0.get(j) / Math.sqrt(nQn0));
                            ++j;
                        }
                    }
                    deflectionX.setMaximumTolerableBias(nabla0.get(0));
                    deflectionY.setMaximumTolerableBias(nabla0.get(1));
                }
            }
        }
        if (restoreUncertainties && sumDiagR > SQRT_EPS) {
            ++this.numberOfHypotesis;
        }
    }

    public void addSubRedundanceAndCofactor2Point(Point point, boolean restoreUncertainties) {
        int dim = point.getDimension();
        int col = point.getColInJacobiMatrix();
        int negativeSignPoint = 0;
        double[] rDiag = new double[dim];
        double sumDiagR = 0.0;
        double omegaPoint = 0.0;
        DenseMatrix Qll_P = new DenseMatrix(dim, dim);
        UpperSymmPackMatrix PR = new UpperSymmPackMatrix(dim);
        DenseMatrix Qnn = new DenseMatrix(dim, dim);
        DenseVector Pv = new DenseVector(dim);
        DenseVector Pv0 = new DenseVector(dim);
        DenseVector nabla = new DenseVector(dim);
        DenseVector ep = new DenseVector(dim);
        UpperSymmPackMatrix subPsubPQvvP = new UpperSymmPackMatrix(dim);
        double[] qll = new double[dim];
        double[] qll0 = new double[dim];
        Double[] u = this.estimationType == EstimationType.L1NORM && restoreUncertainties && this.adaptedPointUncertainties.containsKey(point) ? this.adaptedPointUncertainties.get(point) : new Double[dim];
        int diag = 0;
        if (dim != 1) {
            double vx = point.getX() - point.getX0();
            double vy = point.getY() - point.getY0();
            qll[diag] = point.getStdXApriori() * point.getStdXApriori();
            qll0[diag] = u[diag] == null ? qll[diag] : u[diag];
            omegaPoint += vx * vx / qll0[diag];
            Pv0.set(diag, vx / qll0[diag]);
            Pv.set(diag, vx / qll[diag++]);
            qll[diag] = point.getStdYApriori() * point.getStdYApriori();
            qll0[diag] = u[diag] == null ? qll[diag] : u[diag];
            omegaPoint += vy * vy / qll0[diag];
            Pv0.set(diag, vy / qll0[diag]);
            Pv.set(diag, vy / qll[diag++]);
            negativeSignPoint += vx < 0.0 ? 1 : 0;
            negativeSignPoint += vy < 0.0 ? 1 : 0;
        }
        if (dim != 2) {
            double vz = point.getZ() - point.getZ0();
            qll[diag] = point.getStdZApriori() * point.getStdZApriori();
            qll0[diag] = u[diag] == null ? qll[diag] : u[diag];
            omegaPoint += vz * vz / qll0[diag];
            Pv0.set(diag, vz / qll0[diag]);
            Pv.set(diag, vz / qll[diag++]);
            negativeSignPoint += vz < 0.0 ? 1 : 0;
        }
        int i = 0;
        while (i < dim) {
            int j = i;
            while (j < dim) {
                double qxx = this.Qxx.get(col + i, col + j);
                if (i == j) {
                    double rr;
                    qvv = qll[i] - qxx;
                    qvv = Math.abs(qvv) < Constant.EPS || qvv < 0.0 ? 0.0 : qvv;
                    rDiag[i] = rr = 1.0 / qll[i] * qvv;
                    sumDiagR += rr;
                    Qll_P.set(i, i, qxx / qll[i]);
                    PR.set(i, i, 1.0 / qll[i] * rr);
                } else {
                    qvv = -qxx;
                    qvv = Math.abs(qvv) < Constant.EPS ? 0.0 : qvv;
                    double rrIJ = 1.0 / qll[i] * qvv;
                    Qll_P.set(j, i, qxx / qll[i]);
                    PR.set(i, j, 1.0 / qll[j] * rrIJ);
                    Qll_P.set(i, j, qxx / qll[j]);
                }
                ++j;
            }
            ++i;
        }
        subPsubPQvvP = new UpperSymmPackMatrix((Matrix)PR);
        subPsubPQvvP.scale(-1.0);
        int d = 0;
        while (d < dim) {
            subPsubPQvvP.add(d, d, 1.0 / qll[d]);
            ++d;
        }
        point.setRedundancy(rDiag);
        this.degreeOfFreedom += sumDiagR;
        point.setOmega(omegaPoint);
        this.omega += omegaPoint;
        VarianceComponentType vcType = VarianceComponentType.getComponentTypeByPointDimension(dim);
        if (vcType != null && this.varianceComponents.containsKey((Object)vcType)) {
            VarianceComponent vc = this.varianceComponents.get((Object)vcType);
            vc.setOmega(vc.getOmega() + omegaPoint);
            vc.setRedundancy(vc.getRedundancy() + sumDiagR);
            vc.setNumberOfObservations(vc.getNumberOfObservations() + point.getDimension());
            if (sumDiagR > 0.0) {
                vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + negativeSignPoint);
                vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + point.getDimension());
            }
        }
        if (sumDiagR > SQRT_EPS) {
            boolean isCalculated = false;
            ConfidenceRegion confidenceRegion = null;
            try {
                Qnn = MathExtension.pinv((Matrix)PR, -1);
                confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                isCalculated = true;
            }
            catch (NotConvergedException nce) {
                isCalculated = false;
                nce.printStackTrace();
            }
            if (isCalculated) {
                if (this.estimationType == EstimationType.SIMULATION) {
                    DenseVector nabla0 = new DenseVector(dim);
                    int j = 0;
                    while (j < dim) {
                        nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                        ++j;
                    }
                    DenseVector subPsubPQvvPNabla0 = new DenseVector(dim);
                    subPsubPQvvP.mult((Vector)nabla0, (Vector)subPsubPQvvPNabla0);
                    double efsp = Math.sqrt(Math.abs(subPsubPQvvPNabla0.dot((Vector)nabla0)));
                    Qll_P.mult((Vector)nabla0, (Vector)ep);
                    point.setMaximumTolerableBiases(Matrices.getArray((Vector)nabla0));
                    point.setInfluencesOnPointPosition(Matrices.getArray((Vector)ep));
                    point.setInfluenceOnNetworkDistortion(efsp);
                } else {
                    Qnn.mult((Vector)Pv, (Vector)nabla);
                    point.setNablaCoVarNabla(Math.abs(nabla.dot((Vector)Pv0)));
                    nabla = nabla.scale(-1.0);
                    point.setGrossErrors(Matrices.getArray((Vector)nabla));
                    Qll_P.mult((Vector)nabla, (Vector)ep);
                    point.setInfluencesOnPointPosition(Matrices.getArray((Vector)ep));
                    DenseVector subPsubPQvvPNabla = new DenseVector(dim);
                    subPsubPQvvP.mult((Vector)nabla, (Vector)subPsubPQvvPNabla);
                    double efsp = Math.sqrt(Math.abs(subPsubPQvvPNabla.dot((Vector)nabla)));
                    DenseVector nabla0 = new DenseVector((Vector)nabla, true);
                    DenseVector PQvvPnabla0 = new DenseVector((Vector)nabla0);
                    PR.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                    double nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                    double normNabla = nabla.norm(Vector.Norm.Two);
                    if (normNabla < SQRT_EPS || nQn0 <= 0.0) {
                        int j = 0;
                        while (j < dim) {
                            nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < dim) {
                            nabla0.set(j, nabla0.get(j) / Math.sqrt(nQn0));
                            ++j;
                        }
                    }
                    point.setMaximumTolerableBiases(Matrices.getArray((Vector)nabla0));
                    point.setInfluenceOnNetworkDistortion(efsp);
                }
            }
        }
        if (restoreUncertainties && sumDiagR > SQRT_EPS) {
            ++this.numberOfHypotesis;
        }
    }

    public void addSubRedundanceAndCofactor(Observation observation) {
        boolean isGNSS = observation.getObservationType() == ObservationType.GNSS1D || observation.getObservationType() == ObservationType.GNSS2D || observation.getObservationType() == ObservationType.GNSS3D;
        List<Observation> observations = null;
        if (isGNSS) {
            observations = ((GNSSBaseline)observation).getBaselineComponents();
        } else {
            observations = new ArrayList<Observation>(1);
            observations.add(observation);
        }
        int dim = observations.size();
        DenseMatrix aRows = new DenseMatrix(dim, this.numberOfUnknownParameters);
        Point startPoint = observation.getStartPoint();
        Point endPoint = observation.getEndPoint();
        LinkedHashSet<Integer> colums = new LinkedHashSet<Integer>(15);
        int row = 0;
        while (row < dim) {
            Observation obs = observations.get(row);
            int colASp = startPoint.getColInJacobiMatrix();
            int colAEp = endPoint.getColInJacobiMatrix();
            if (colASp >= 0) {
                if (startPoint.getDimension() != 1) {
                    colums.add(colASp);
                    aRows.set(row, colASp++, obs.diffXs());
                    colums.add(colASp);
                    aRows.set(row, colASp++, obs.diffYs());
                }
                if (startPoint.getDimension() != 2) {
                    colums.add(colASp);
                    aRows.set(row, colASp, obs.diffZs());
                }
            }
            if (colAEp >= 0) {
                if (endPoint.getDimension() != 1) {
                    colums.add(colAEp);
                    aRows.set(row, colAEp++, obs.diffXe());
                    colums.add(colAEp);
                    aRows.set(row, colAEp++, obs.diffYe());
                }
                if (endPoint.getDimension() != 2) {
                    colums.add(colAEp);
                    aRows.set(row, colAEp, obs.diffZe());
                }
            }
            if (obs.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix() >= 0) {
                colums.add(obs.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix());
                aRows.set(row, obs.getStartPoint().getVerticalDeflectionX().getColInJacobiMatrix(), obs.diffVerticalDeflectionXs());
            }
            if (obs.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix() >= 0) {
                colums.add(obs.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix());
                aRows.set(row, obs.getStartPoint().getVerticalDeflectionY().getColInJacobiMatrix(), obs.diffVerticalDeflectionYs());
            }
            if (obs.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix() >= 0) {
                colums.add(obs.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix());
                aRows.set(row, obs.getEndPoint().getVerticalDeflectionX().getColInJacobiMatrix(), obs.diffVerticalDeflectionXe());
            }
            if (obs.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix() >= 0) {
                colums.add(obs.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix());
                aRows.set(row, obs.getEndPoint().getVerticalDeflectionY().getColInJacobiMatrix(), obs.diffVerticalDeflectionYe());
            }
            if (obs.getColInJacobiMatrixFromOrientation() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromOrientation());
                aRows.set(row, obs.getColInJacobiMatrixFromOrientation(), obs.diffOri());
            }
            if (obs.getColInJacobiMatrixFromAdd() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromAdd());
                aRows.set(row, obs.getColInJacobiMatrixFromAdd(), obs.diffAdd());
            }
            if (obs.getColInJacobiMatrixFromScale() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromScale());
                aRows.set(row, obs.getColInJacobiMatrixFromScale(), obs.diffScale());
            }
            if (obs.getColInJacobiMatrixFromRefCoeff() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromRefCoeff());
                aRows.set(row, obs.getColInJacobiMatrixFromRefCoeff(), obs.diffRefCoeff());
            }
            if (obs.getColInJacobiMatrixFromRotationX() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromRotationX());
                aRows.set(row, obs.getColInJacobiMatrixFromRotationX(), obs.diffRotX());
            }
            if (obs.getColInJacobiMatrixFromRotationY() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromRotationY());
                aRows.set(row, obs.getColInJacobiMatrixFromRotationY(), obs.diffRotY());
            }
            if (obs.getColInJacobiMatrixFromRotationZ() >= 0) {
                colums.add(obs.getColInJacobiMatrixFromRotationZ());
                aRows.set(row, obs.getColInJacobiMatrixFromRotationZ(), obs.diffRotZ());
            }
            ++row;
        }
        DenseMatrix subR = new DenseMatrix(dim, dim);
        int dc = 0;
        while (dc < dim) {
            for (Integer col : colums) {
                double aqxx = 0.0;
                for (Integer row2 : colums) {
                    aqxx += aRows.get(dc, row2.intValue()) * this.Qxx.get(row2.intValue(), col.intValue());
                }
                int dr = 0;
                while (dr < dim) {
                    subR.set(dr, dc, subR.get(dr, dc) + aqxx * aRows.get(dr, col.intValue()));
                    ++dr;
                }
            }
            ++dc;
        }
        subR = subR.scale(-1.0);
        double rr = 0.0;
        int i = 0;
        while (i < dim) {
            Observation obs = observations.get(i);
            double qll = obs.getStdApriori() * obs.getStdApriori();
            double q_ll = Math.abs(subR.get(i, i));
            obs.setStd(Math.sqrt(q_ll));
            double qvv = qll - q_ll;
            qvv = Math.abs(qvv) < Constant.EPS || qvv < 0.0 ? 0.0 : qvv;
            subR.set(i, i, qvv);
            int j = 0;
            while (j < dim) {
                double r = 1.0 / qll * subR.get(j, i);
                subR.set(j, i, r);
                if (i == j) {
                    obs.setRedundancy(r);
                    rr += r;
                }
                ++j;
            }
            ++i;
        }
        if (isGNSS) {
            ((GNSSBaseline)observation).setBaselineRedundancyMatrix((Matrix)subR);
        }
        if (rr > SQRT_EPS) {
            ++this.numberOfHypotesis;
        }
        this.degreeOfFreedom += rr;
    }

    private void estimateRobustWeights() {
        block33: {
            double c;
            int maxNVPointComp;
            Point maxNVPoint;
            block34: {
                double v;
                int maxNVVerticalDeflectionComp;
                VerticalDeflection maxNVVerticalDeflection;
                block32: {
                    double v2;
                    double maxNV2 = Double.MIN_VALUE;
                    Object maxNVObs = null;
                    maxNVPoint = null;
                    maxNVVerticalDeflection = null;
                    maxNVPointComp = -1;
                    maxNVVerticalDeflectionComp = -1;
                    int counter = 0;
                    int i = 0;
                    while (i < this.numberOfObservations) {
                        double nv2;
                        double v3;
                        Iterator<Point> observation = this.projectObservations.get(i);
                        double u = ((Observation)((Object)observation)).getStdApriori();
                        double qll = u * u;
                        double r = ((Observation)((Object)observation)).getRedundancy();
                        double d = v3 = this.estimationType == EstimationType.SIMULATION ? 0.0 : ((Observation)((Object)observation)).getObservationalError();
                        if (qll > 0.0 && r > SQRT_EPS && (nv2 = v3 * v3 / qll / r) > maxNV2) {
                            maxNV2 = nv2;
                            maxNVObs = observation;
                        }
                        if (Math.abs(v3) >= 500.0 * u) {
                            ++counter;
                        }
                        ++i;
                    }
                    for (Point point : this.pointsWithStochasticDeflection) {
                        double nv2;
                        VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
                        VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
                        double vx = deflectionX.getValue0() - deflectionX.getValue();
                        double vy = deflectionY.getValue0() - deflectionY.getValue();
                        double rx = deflectionX.getRedundancy();
                        double ry = deflectionY.getRedundancy();
                        double ux = deflectionX.getStdApriori();
                        double uy = deflectionY.getStdApriori();
                        double qx = ux * ux;
                        double qy = uy * uy;
                        if (qx > 0.0 && rx >= SQRT_EPS && (nv2 = vx * vx / qx / rx) > maxNV2) {
                            maxNV2 = nv2;
                            maxNVVerticalDeflection = deflectionX;
                            maxNVVerticalDeflectionComp = 1;
                        }
                        if (qy > 0.0 && ry >= SQRT_EPS && (nv2 = vy * vy / qy / ry) > maxNV2) {
                            maxNV2 = nv2;
                            maxNVVerticalDeflection = deflectionY;
                            maxNVVerticalDeflectionComp = 2;
                        }
                        if (Math.abs(vx) >= 500.0 * ux) {
                            ++counter;
                        }
                        if (!(Math.abs(vy) > 500.0 * uy)) continue;
                        ++counter;
                    }
                    for (Point point : this.stochasticPoints) {
                        int dim = point.getDimension();
                        int d = 0;
                        while (d < dim) {
                            double nv2;
                            double v4 = 0.0;
                            double qll = 0.0;
                            double r = 0.0;
                            double u = 0.0;
                            if (dim != 1) {
                                if (d == 0) {
                                    v4 = point.getX0() - point.getX();
                                    u = point.getStdXApriori();
                                    qll = u * u;
                                    r = point.getRedundancyX();
                                } else if (d == 1) {
                                    v4 = point.getY0() - point.getY();
                                    u = point.getStdYApriori();
                                    qll = u * u;
                                    r = point.getRedundancyY();
                                }
                            }
                            if (dim != 2 && d == dim - 1) {
                                v4 = point.getZ0() - point.getZ();
                                u = point.getStdZApriori();
                                qll = u * u;
                                r = point.getRedundancyZ();
                            }
                            if (qll > 0.0 && r >= SQRT_EPS && (nv2 = v4 * v4 / qll / r) > maxNV2) {
                                maxNV2 = nv2;
                                maxNVPoint = point;
                                maxNVPointComp = d;
                                maxNVVerticalDeflection = null;
                                maxNVVerticalDeflectionComp = -1;
                            }
                            if (Math.abs(v4) >= 500.0 * u) {
                                ++counter;
                            }
                            ++d;
                        }
                    }
                    boolean adapteRobustBoundary = (double)counter / (double)(this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows) > 0.35;
                    double d = c = adapteRobustBoundary ? this.robustEstimationLimit + (Math.sqrt(maxNV2) - this.robustEstimationLimit) * 0.9 : this.robustEstimationLimit;
                    if (maxNVObs == null || maxNVPoint != null || maxNVVerticalDeflection != null) break block32;
                    double u = ((Observation)maxNVObs).getStdApriori();
                    double r = ((Observation)maxNVObs).getRedundancy();
                    double k = c * u * Math.sqrt(r);
                    double d2 = v2 = this.estimationType == EstimationType.SIMULATION ? 0.0 : Math.abs(((Observation)maxNVObs).getObservationalError());
                    if (!(v2 >= k) || !(k > SQRT_EPS)) break block33;
                    ((Observation)maxNVObs).setStdApriori(u * Math.sqrt(v2 / k));
                    if (this.adaptedObservationUncertainties.containsKey(maxNVObs)) break block33;
                    this.adaptedObservationUncertainties.put((Observation)maxNVObs, u);
                    break block33;
                }
                if (maxNVVerticalDeflection == null || maxNVVerticalDeflectionComp < 0) break block34;
                double u = maxNVVerticalDeflection.getStdApriori();
                double r = maxNVVerticalDeflection.getRedundancy();
                double k = c * u * Math.sqrt(r);
                double d = v = this.estimationType == EstimationType.SIMULATION ? 0.0 : Math.abs(maxNVVerticalDeflection.getValue0() - maxNVVerticalDeflection.getValue());
                if (!(v >= k) || !(k > SQRT_EPS)) break block33;
                maxNVVerticalDeflection.setStdApriori(u * Math.sqrt(v / k));
                if (this.adaptedVerticalDeflectionUncertainties.containsKey(maxNVVerticalDeflection)) break block33;
                this.adaptedVerticalDeflectionUncertainties.put(maxNVVerticalDeflection, u);
                break block33;
            }
            if (maxNVPoint != null && maxNVPointComp >= 0) {
                int dim = maxNVPoint.getDimension();
                Double[] u = new Double[dim];
                int d = 0;
                while (d < dim) {
                    double v = 0.0;
                    double k = 0.0;
                    double r = 0.0;
                    if (d == dim - 1 && dim != 2) {
                        u[d] = maxNVPoint.getStdZApriori();
                        if (maxNVPointComp == d) {
                            r = maxNVPoint.getRedundancyZ();
                            k = c * u[d] * Math.sqrt(r);
                            double d3 = v = this.estimationType == EstimationType.SIMULATION ? 0.0 : Math.abs(maxNVPoint.getZ0() - maxNVPoint.getZ());
                            if (v >= k && k > SQRT_EPS) {
                                maxNVPoint.setStdZApriori(u[d] * Math.sqrt(v / k));
                                if (!this.adaptedPointUncertainties.containsKey(maxNVPoint)) {
                                    this.adaptedPointUncertainties.put(maxNVPoint, u);
                                }
                            }
                        }
                    } else if (d == 0 && dim != 1) {
                        u[d] = maxNVPoint.getStdXApriori();
                        if (maxNVPointComp == d) {
                            r = maxNVPoint.getRedundancyX();
                            k = c * u[d] * Math.sqrt(r);
                            double d4 = v = this.estimationType == EstimationType.SIMULATION ? 0.0 : Math.abs(maxNVPoint.getX0() - maxNVPoint.getX());
                            if (v >= k && k > SQRT_EPS) {
                                maxNVPoint.setStdXApriori(u[d] * Math.sqrt(v / k));
                                if (!this.adaptedPointUncertainties.containsKey(maxNVPoint)) {
                                    this.adaptedPointUncertainties.put(maxNVPoint, u);
                                }
                            }
                        }
                    } else if (d == 1 && dim != 1) {
                        u[d] = maxNVPoint.getStdYApriori();
                        if (maxNVPointComp == d) {
                            r = maxNVPoint.getRedundancyY();
                            k = c * u[d] * Math.sqrt(r);
                            double d5 = v = this.estimationType == EstimationType.SIMULATION ? 0.0 : Math.abs(maxNVPoint.getY0() - maxNVPoint.getY());
                            if (v >= k && k > SQRT_EPS) {
                                maxNVPoint.setStdYApriori(u[d] * Math.sqrt(v / k));
                                if (!this.adaptedPointUncertainties.containsKey(maxNVPoint)) {
                                    this.adaptedPointUncertainties.put(maxNVPoint, u);
                                }
                            }
                        }
                    }
                    ++d;
                }
            }
        }
    }

    public NormalEquationSystem createNormalEquation() {
        int numberOfStrainEquations = 0;
        if (this.freeNetwork && this.congruenceAnalysis) {
            for (CongruenceAnalysisGroup tieGroup : this.congruenceAnalysisGroup) {
                StrainAnalysisEquations strainAnalysisEquations = tieGroup.getStrainAnalysisEquations();
                int nou = strainAnalysisEquations.numberOfParameters();
                int nor = strainAnalysisEquations.numberOfRestrictions();
                int not = tieGroup.size(true);
                int dim = tieGroup.getDimension();
                if (!strainAnalysisEquations.hasUnconstraintParameters() || not * dim + nor < nou) continue;
                numberOfStrainEquations += not * dim + nor;
            }
        }
        UpperSymmPackMatrix N = new UpperSymmPackMatrix(this.numberOfUnknownParameters + this.rankDefect.getDefect() + numberOfStrainEquations);
        DenseVector n = new DenseVector(N.numRows());
        if (this.estimationType == EstimationType.L1NORM) {
            this.estimateRobustWeights();
        }
        int u = 0;
        while (u < this.unknownParameters.size()) {
            if (this.interrupt) {
                return null;
            }
            UnknownParameter unknownParameterAT = this.unknownParameters.get(u);
            ObservationGroup observationGroupAT = unknownParameterAT.getObservations();
            int dimAT = 1;
            switch (unknownParameterAT.getParameterType()) {
                case POINT2D: {
                    dimAT = 2;
                    break;
                }
                case POINT3D: {
                    dimAT = 3;
                    break;
                }
                default: {
                    dimAT = 1;
                }
            }
            int i = 0;
            while (i < dimAT) {
                int colAT = unknownParameterAT.getColInJacobiMatrix() + i;
                SparseVector aTp = new SparseVector(this.numberOfObservations, observationGroupAT.size());
                int j = 0;
                while (j < observationGroupAT.size()) {
                    Observation observationAT = observationGroupAT.get(j);
                    int rowAT = observationAT.getRowInJacobiMatrix();
                    double at = 0.0;
                    if (unknownParameterAT.getParameterType() == ParameterType.POINT1D) {
                        Point p = (Point)unknownParameterAT;
                        if (p.equals(observationAT.getStartPoint())) {
                            at = observationAT.diffZs();
                        } else if (p.equals(observationAT.getEndPoint())) {
                            at = observationAT.diffZe();
                        }
                    } else if (unknownParameterAT.getParameterType() == ParameterType.POINT2D) {
                        Point p = (Point)unknownParameterAT;
                        if (p.equals(observationAT.getStartPoint())) {
                            if (i == 0) {
                                at = observationAT.diffXs();
                            } else if (i == 1) {
                                at = observationAT.diffYs();
                            }
                        } else if (p.equals(observationAT.getEndPoint())) {
                            if (i == 0) {
                                at = observationAT.diffXe();
                            } else if (i == 1) {
                                at = observationAT.diffYe();
                            }
                        }
                    } else if (unknownParameterAT.getParameterType() == ParameterType.POINT3D) {
                        Point p = (Point)unknownParameterAT;
                        if (p.equals(observationAT.getStartPoint())) {
                            if (i == 0) {
                                at = observationAT.diffXs();
                            } else if (i == 1) {
                                at = observationAT.diffYs();
                            } else if (i == 2) {
                                at = observationAT.diffZs();
                            }
                        } else if (p.equals(observationAT.getEndPoint())) {
                            if (i == 0) {
                                at = observationAT.diffXe();
                            } else if (i == 1) {
                                at = observationAT.diffYe();
                            } else if (i == 2) {
                                at = observationAT.diffZe();
                            }
                        }
                    } else if (unknownParameterAT.getParameterType() == ParameterType.VERTICAL_DEFLECTION_X) {
                        VerticalDeflectionX deflection = (VerticalDeflectionX)unknownParameterAT;
                        p = deflection.getPoint();
                        if (p.equals(observationAT.getStartPoint())) {
                            at = observationAT.diffVerticalDeflectionXs();
                        } else if (p.equals(observationAT.getEndPoint())) {
                            at = observationAT.diffVerticalDeflectionXe();
                        }
                    } else if (unknownParameterAT.getParameterType() == ParameterType.VERTICAL_DEFLECTION_Y) {
                        VerticalDeflectionY deflection = (VerticalDeflectionY)unknownParameterAT;
                        p = deflection.getPoint();
                        if (p.equals(observationAT.getStartPoint())) {
                            at = observationAT.diffVerticalDeflectionYs();
                        } else if (p.equals(observationAT.getEndPoint())) {
                            at = observationAT.diffVerticalDeflectionYe();
                        }
                    } else if (unknownParameterAT.getParameterType() == ParameterType.ORIENTATION) {
                        at = observationAT.diffOri();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.ZERO_POINT_OFFSET) {
                        at = observationAT.diffAdd();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.SCALE) {
                        at = observationAT.diffScale();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.REFRACTION_INDEX) {
                        at = observationAT.diffRefCoeff();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.ROTATION_X) {
                        at = observationAT.diffRotX();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.ROTATION_Y) {
                        at = observationAT.diffRotY();
                    } else if (unknownParameterAT.getParameterType() == ParameterType.ROTATION_Z) {
                        at = observationAT.diffRotZ();
                    }
                    double atp = at / (observationAT.getStdApriori() * observationAT.getStdApriori());
                    aTp.set(rowAT, atp);
                    n.add(colAT, atp * observationAT.getObservationalError());
                    N.add(colAT, colAT, atp * at);
                    ++j;
                }
                int uu = u;
                while (uu < this.unknownParameters.size()) {
                    UnknownParameter unknownParameterA = this.unknownParameters.get(uu);
                    ObservationGroup observationGroupA = unknownParameterA.getObservations();
                    int dimA = 1;
                    switch (unknownParameterA.getParameterType()) {
                        case POINT2D: {
                            dimA = 2;
                            break;
                        }
                        case POINT3D: {
                            dimA = 3;
                            break;
                        }
                        default: {
                            dimA = 1;
                        }
                    }
                    int ii = uu == u ? i + 1 : 0;
                    while (ii < dimA) {
                        int colA = unknownParameterA.getColInJacobiMatrix() + ii;
                        int jj = 0;
                        while (jj < observationGroupA.size()) {
                            Observation observationA = observationGroupA.get(jj);
                            int rowA = observationA.getRowInJacobiMatrix();
                            if (aTp.get(rowA) != 0.0) {
                                double a = 0.0;
                                if (unknownParameterA.getParameterType() == ParameterType.POINT1D) {
                                    p = (Point)unknownParameterA;
                                    if (p.equals(observationA.getStartPoint())) {
                                        a = observationA.diffZs();
                                    } else if (p.equals(observationA.getEndPoint())) {
                                        a = observationA.diffZe();
                                    }
                                } else if (unknownParameterA.getParameterType() == ParameterType.POINT2D) {
                                    p = (Point)unknownParameterA;
                                    if (p.equals(observationA.getStartPoint())) {
                                        if (ii == 0) {
                                            a = observationA.diffXs();
                                        } else if (ii == 1) {
                                            a = observationA.diffYs();
                                        }
                                    } else if (p.equals(observationA.getEndPoint())) {
                                        if (ii == 0) {
                                            a = observationA.diffXe();
                                        } else if (ii == 1) {
                                            a = observationA.diffYe();
                                        }
                                    }
                                } else if (unknownParameterA.getParameterType() == ParameterType.POINT3D) {
                                    p = (Point)unknownParameterA;
                                    if (p.equals(observationA.getStartPoint())) {
                                        if (ii == 0) {
                                            a = observationA.diffXs();
                                        } else if (ii == 1) {
                                            a = observationA.diffYs();
                                        } else if (ii == 2) {
                                            a = observationA.diffZs();
                                        }
                                    } else if (p.equals(observationA.getEndPoint())) {
                                        if (ii == 0) {
                                            a = observationA.diffXe();
                                        } else if (ii == 1) {
                                            a = observationA.diffYe();
                                        } else if (ii == 2) {
                                            a = observationA.diffZe();
                                        }
                                    }
                                } else if (unknownParameterA.getParameterType() == ParameterType.VERTICAL_DEFLECTION_X) {
                                    deflection = (VerticalDeflectionX)unknownParameterA;
                                    p = deflection.getPoint();
                                    if (p.equals(observationA.getStartPoint())) {
                                        a = observationA.diffVerticalDeflectionXs();
                                    } else if (p.equals(observationA.getEndPoint())) {
                                        a = observationA.diffVerticalDeflectionXe();
                                    }
                                } else if (unknownParameterA.getParameterType() == ParameterType.VERTICAL_DEFLECTION_Y) {
                                    deflection = (VerticalDeflectionY)unknownParameterA;
                                    p = deflection.getPoint();
                                    if (p.equals(observationA.getStartPoint())) {
                                        a = observationA.diffVerticalDeflectionYs();
                                    } else if (p.equals(observationA.getEndPoint())) {
                                        a = observationA.diffVerticalDeflectionYe();
                                    }
                                } else if (unknownParameterA.getParameterType() == ParameterType.ORIENTATION) {
                                    a = observationA.diffOri();
                                } else if (unknownParameterA.getParameterType() == ParameterType.ZERO_POINT_OFFSET) {
                                    a = observationA.diffAdd();
                                } else if (unknownParameterA.getParameterType() == ParameterType.SCALE) {
                                    a = observationA.diffScale();
                                } else if (unknownParameterA.getParameterType() == ParameterType.REFRACTION_INDEX) {
                                    a = observationA.diffRefCoeff();
                                } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_X) {
                                    a = observationA.diffRotX();
                                } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_Y) {
                                    a = observationA.diffRotY();
                                } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_Z) {
                                    a = observationA.diffRotZ();
                                }
                                N.add(colAT, colA, aTp.get(rowA) * a);
                            }
                            ++jj;
                        }
                        ++ii;
                    }
                    ++uu;
                }
                ++i;
            }
            ++u;
        }
        if (this.pointsWithStochasticDeflection != null && !this.pointsWithStochasticDeflection.isEmpty()) {
            for (Point point : this.pointsWithStochasticDeflection) {
                VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
                int col = deflectionX.getColInJacobiMatrix();
                double qll = deflectionX.getStdApriori() * deflectionX.getStdApriori();
                n.add(col, (deflectionX.getValue0() - deflectionX.getValue()) / qll);
                N.add(col, col, 1.0 / qll);
                VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
                col = deflectionY.getColInJacobiMatrix();
                qll = deflectionY.getStdApriori() * deflectionY.getStdApriori();
                n.add(col, (deflectionY.getValue0() - deflectionY.getValue()) / qll);
                N.add(col, col, 1.0 / qll);
            }
        }
        if (this.stochasticPoints != null && !this.stochasticPoints.isEmpty()) {
            for (Point point : this.stochasticPoints) {
                int col = point.getColInJacobiMatrix();
                if (point.getDimension() != 1) {
                    double qll = point.getStdXApriori() * point.getStdXApriori();
                    n.add(col, (point.getX0() - point.getX()) / qll);
                    N.add(col, col++, 1.0 / qll);
                    qll = point.getStdYApriori() * point.getStdYApriori();
                    n.add(col, (point.getY0() - point.getY()) / qll);
                    N.add(col, col++, 1.0 / qll);
                }
                if (point.getDimension() == 2) continue;
                double qll = point.getStdZApriori() * point.getStdZApriori();
                n.add(col, (point.getZ0() - point.getZ()) / qll);
                N.add(col, col, 1.0 / qll);
            }
        }
        if (this.freeNetwork && this.datumPoints != null && !this.datumPoints.isEmpty()) {
            int col;
            int dim;
            Point point;
            int mxyz;
            double x0 = 0.0;
            double y0 = 0.0;
            double z0 = 0.0;
            int nx = 0;
            int ny = 0;
            int nz = 0;
            int i = 0;
            while (i < this.datumPoints.size()) {
                Point p = this.datumPoints.get(i);
                int dim2 = p.getDimension();
                if (dim2 != 1) {
                    x0 += p.getX();
                    y0 += p.getY();
                    ++nx;
                    ++ny;
                }
                if (dim2 != 2) {
                    z0 += p.getZ();
                    ++nz;
                }
                ++i;
            }
            x0 = nx > 0 ? x0 / (double)nx : 0.0;
            y0 = ny > 0 ? y0 / (double)ny : 0.0;
            z0 = nz > 0 ? z0 / (double)nz : 0.0;
            Point3D centerPoint3D = new Point3D("c3D", x0, y0, z0);
            int row = N.numRows() - this.rankDefect.getDefect() - numberOfStrainEquations;
            int defectRow = 0;
            int tx = this.rankDefect.estimateTranslationX() ? defectRow++ : -1;
            int ty = this.rankDefect.estimateTranslationY() ? defectRow++ : -1;
            int tz = this.rankDefect.estimateTranslationZ() ? defectRow++ : -1;
            int rx = this.rankDefect.estimateRotationX() ? defectRow++ : -1;
            int ry = this.rankDefect.estimateRotationY() ? defectRow++ : -1;
            int rz = this.rankDefect.estimateRotationZ() ? defectRow++ : -1;
            int sx = this.rankDefect.estimateShearX() ? defectRow++ : -1;
            int sy = this.rankDefect.estimateShearY() ? defectRow++ : -1;
            int sz = this.rankDefect.estimateShearZ() ? defectRow++ : -1;
            int mx = this.rankDefect.estimateScaleX() ? defectRow++ : -1;
            int my = this.rankDefect.estimateScaleY() ? defectRow++ : -1;
            int mz = this.rankDefect.estimateScaleZ() ? defectRow++ : -1;
            int mxy = this.rankDefect.estimateScaleXY() ? defectRow++ : -1;
            int n2 = mxyz = this.rankDefect.estimateScaleXYZ() ? defectRow++ : -1;
            if (mxyz >= 0) {
                mx = mxyz;
                my = mxyz;
                mz = mxyz;
                mxy = mxyz;
            } else if (mxy >= 0) {
                mx = mxy;
                my = mxy;
            }
            double[] normColumn = new double[this.rankDefect.getDefect()];
            int i2 = 0;
            while (i2 < this.datumPoints.size()) {
                double y;
                double x;
                point = this.datumPoints.get(i2);
                dim = point.getDimension();
                col = point.getColInJacobiMatrix();
                if (dim != 2) {
                    if (tz >= 0) {
                        N.set(col + dim - 1, row + tz, 1.0);
                        int n3 = tz;
                        normColumn[n3] = normColumn[n3] + 1.0;
                    }
                    if (mz >= 0) {
                        double z = point.getZ() - centerPoint3D.getZ();
                        N.set(col + dim - 1, row + mz, z);
                        int n4 = mz;
                        normColumn[n4] = normColumn[n4] + z * z;
                    }
                }
                if (dim != 1) {
                    if (tx >= 0) {
                        N.set(col + 0, row + tx, 1.0);
                        int n5 = tx;
                        normColumn[n5] = normColumn[n5] + 1.0;
                    }
                    if (ty >= 0) {
                        N.set(col + 1, row + ty, 1.0);
                        int n6 = ty;
                        normColumn[n6] = normColumn[n6] + 1.0;
                    }
                }
                if (dim == 1) {
                    x = point.getX() - centerPoint3D.getX();
                    y = point.getY() - centerPoint3D.getY();
                    if (rx >= 0) {
                        N.set(col, row + rx, -y);
                        int n7 = rx;
                        normColumn[n7] = normColumn[n7] + y * y;
                    }
                    if (ry >= 0) {
                        N.set(col, row + ry, x);
                        int n8 = ry;
                        normColumn[n8] = normColumn[n8] + x * x;
                    }
                }
                if (dim > 1) {
                    x = point.getX() - centerPoint3D.getX();
                    y = point.getY() - centerPoint3D.getY();
                    if (rz >= 0) {
                        N.set(col + 0, row + rz, y);
                        N.set(col + 1, row + rz, -x);
                        int n9 = rz;
                        normColumn[n9] = normColumn[n9] + (x * x + y * y);
                    }
                    if (sz >= 0) {
                        N.set(col + 0, row + sz, y);
                        N.set(col + 1, row + sz, x);
                        int n10 = sz;
                        normColumn[n10] = normColumn[n10] + (x * x + y * y);
                    }
                    if (mx >= 0) {
                        N.set(col + 0, row + mx, x);
                        int n11 = mx;
                        normColumn[n11] = normColumn[n11] + x * x;
                    }
                    if (my >= 0) {
                        N.set(col + 1, row + my, y);
                        int n12 = my;
                        normColumn[n12] = normColumn[n12] + y * y;
                    }
                    if (dim == 3) {
                        double z = point.getZ() - centerPoint3D.getZ();
                        if (rx >= 0) {
                            N.set(col + 1, row + rx, z);
                            N.set(col + 2, row + rx, -y);
                            int n13 = rx;
                            normColumn[n13] = normColumn[n13] + (z * z + y * y);
                        }
                        if (ry >= 0) {
                            N.set(col + 0, row + ry, -z);
                            N.set(col + 2, row + ry, x);
                            int n14 = ry;
                            normColumn[n14] = normColumn[n14] + (z * z + x * x);
                        }
                        if (sx >= 0) {
                            N.set(col + 1, row + sx, z);
                            N.set(col + 2, row + sx, y);
                            int n15 = sx;
                            normColumn[n15] = normColumn[n15] + (z * z + y * y);
                        }
                        if (sy >= 0) {
                            N.set(col + 0, row + sy, z);
                            N.set(col + 2, row + sy, x);
                            int n16 = sy;
                            normColumn[n16] = normColumn[n16] + (z * z + x * x);
                        }
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.datumPoints.size()) {
                point = this.datumPoints.get(i2);
                dim = point.getDimension();
                col = point.getColInJacobiMatrix();
                if (dim != 2) {
                    if (tz >= 0) {
                        N.set(col + dim - 1, row + tz, N.get(col + dim - 1, row + tz) / Math.sqrt(normColumn[tz]));
                    }
                    if (mz >= 0) {
                        N.set(col + dim - 1, row + mz, N.get(col + dim - 1, row + mz) / Math.sqrt(normColumn[mz]));
                    }
                }
                if (dim != 1) {
                    if (tx >= 0) {
                        N.set(col + 0, row + tx, N.get(col + 0, row + tx) / Math.sqrt(normColumn[tx]));
                    }
                    if (ty >= 0) {
                        N.set(col + 1, row + ty, N.get(col + 1, row + ty) / Math.sqrt(normColumn[ty]));
                    }
                }
                if (dim > 1) {
                    if (rz >= 0) {
                        N.set(col + 0, row + rz, N.get(col + 0, row + rz) / Math.sqrt(normColumn[rz]));
                        N.set(col + 1, row + rz, N.get(col + 1, row + rz) / Math.sqrt(normColumn[rz]));
                    }
                    if (sz >= 0) {
                        N.set(col + 0, row + sz, N.get(col + 0, row + sz) / Math.sqrt(normColumn[sz]));
                        N.set(col + 1, row + sz, N.get(col + 1, row + sz) / Math.sqrt(normColumn[sz]));
                    }
                    if (mx >= 0) {
                        N.set(col + 0, row + mx, N.get(col + 0, row + mx) / Math.sqrt(normColumn[mx]));
                    }
                    if (my >= 0) {
                        N.set(col + 1, row + my, N.get(col + 1, row + my) / Math.sqrt(normColumn[my]));
                    }
                    if (dim == 3) {
                        if (rx >= 0) {
                            N.set(col + 1, row + rx, N.get(col + 1, row + rx) / Math.sqrt(normColumn[rx]));
                            N.set(col + 2, row + rx, N.get(col + 2, row + rx) / Math.sqrt(normColumn[rx]));
                        }
                        if (ry >= 0) {
                            N.set(col + 0, row + ry, N.get(col + 0, row + ry) / Math.sqrt(normColumn[ry]));
                            N.set(col + 2, row + ry, N.get(col + 2, row + ry) / Math.sqrt(normColumn[ry]));
                        }
                        if (sx >= 0) {
                            N.set(col + 1, row + sx, N.get(col + 1, row + sx) / Math.sqrt(normColumn[sx]));
                            N.set(col + 2, row + sx, N.get(col + 2, row + sx) / Math.sqrt(normColumn[sx]));
                        }
                        if (sy >= 0) {
                            N.set(col + 0, row + sy, N.get(col + 0, row + sy) / Math.sqrt(normColumn[sy]));
                            N.set(col + 2, row + sy, N.get(col + 2, row + sy) / Math.sqrt(normColumn[sy]));
                        }
                    }
                }
                ++i2;
            }
            if (this.congruenceAnalysis && numberOfStrainEquations > 0) {
                row = N.numRows() - numberOfStrainEquations;
                for (CongruenceAnalysisGroup tieGroup : this.congruenceAnalysisGroup) {
                    StrainAnalysisEquations strainAnalysisEquations = tieGroup.getStrainAnalysisEquations();
                    int nou = strainAnalysisEquations.numberOfParameters();
                    int nor = strainAnalysisEquations.numberOfRestrictions();
                    int not = tieGroup.size(true);
                    int dim3 = tieGroup.getDimension();
                    Equation[] equations = StrainAnalysisEquations.getEquations(dim3);
                    CoordinateComponent[] components = StrainAnalysisEquations.getCoordinateComponents(dim3);
                    if (!strainAnalysisEquations.hasUnconstraintParameters() || not * dim3 + nor < nou) continue;
                    int resIdx = 0;
                    while (resIdx < nor) {
                        RestrictionType restriction = strainAnalysisEquations.getRestriction(resIdx);
                        int parIdx = 0;
                        while (parIdx < nou) {
                            StrainParameter parameter = strainAnalysisEquations.get(parIdx);
                            int colInA = parameter.getColInJacobiMatrix();
                            N.set(colInA, row + resIdx, strainAnalysisEquations.diff(parameter, restriction));
                            n.set(row + resIdx, -strainAnalysisEquations.getContradiction(restriction));
                            ++parIdx;
                        }
                        ++resIdx;
                    }
                    row += nor;
                    int i3 = 0;
                    while (i3 < not) {
                        CongruenceAnalysisPointPair tie = tieGroup.get(i3, true);
                        Point p0 = tie.getStartPoint();
                        Point p1 = tie.getEndPoint();
                        int eqIdx = 0;
                        while (eqIdx < equations.length) {
                            Equation equation = equations[eqIdx];
                            int parIdx = 0;
                            while (parIdx < nou) {
                                StrainParameter parameter = strainAnalysisEquations.get(parIdx);
                                int colInA = parameter.getColInJacobiMatrix();
                                N.set(colInA, row, strainAnalysisEquations.diff(parameter, p0, equation));
                                n.set(row, -strainAnalysisEquations.getContradiction(p0, p1, equation));
                                ++parIdx;
                            }
                            int coordIdx = 0;
                            while (coordIdx < components.length) {
                                CoordinateComponent component = components[coordIdx];
                                Point p = component == CoordinateComponent.X1 || component == CoordinateComponent.Y1 || component == CoordinateComponent.Z1 ? p0 : p1;
                                int colInA = p.getColInJacobiMatrix();
                                if (component == CoordinateComponent.Y1 || component == CoordinateComponent.Y2) {
                                    ++colInA;
                                }
                                if (component == CoordinateComponent.Z1 || component == CoordinateComponent.Z2) {
                                    colInA += p.getDimension() - 1;
                                }
                                N.set(colInA, row, strainAnalysisEquations.diff(p0, p1, component, equation));
                                ++coordIdx;
                            }
                            ++row;
                            ++eqIdx;
                        }
                        ++i3;
                    }
                }
            }
        }
        if (this.estimationType == EstimationType.SIMULATION) {
            n.zero();
        }
        return new NormalEquationSystem(N, n);
    }

    public Matrix getCofactorMatrix() {
        return this.Qxx;
    }

    public boolean isInterrupted() {
        return this.interrupt;
    }

    public void interrupt() {
        this.interrupt = true;
    }

    private void resetVarianceComponents() {
        LinkedHashMap<VarianceComponentType, VarianceComponent> varianceComponents = new LinkedHashMap<VarianceComponentType, VarianceComponent>();
        for (VarianceComponent varianceEstimation : this.varianceComponents.values()) {
            varianceComponents.put(varianceEstimation.getVarianceComponentType(), new VarianceComponent(varianceEstimation.getVarianceComponentType()));
        }
        this.varianceComponents = varianceComponents;
    }

    public EstimationStateType estimateModel() {
        boolean applyUnscentedTransformation = this.estimationType == EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION || this.estimationType == EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION;
        this.currentMaxAbsDx = this.maxDx = Double.MIN_VALUE;
        this.numberOfHypotesis = 0;
        this.calculateStochasticParameters = false;
        this.currentEstimationStatus = EstimationStateType.BUSY;
        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
        int runs = this.maximalNumberOfIterations - 1;
        boolean isEstimated = false;
        boolean estimateCompleteModel = false;
        boolean isConverge = true;
        if (this.maximalNumberOfIterations == 0) {
            isEstimated = true;
            estimateCompleteModel = true;
        }
        if (this.estimationType == EstimationType.SIMULATION) {
            isEstimated = true;
            estimateCompleteModel = true;
        }
        this.addVerticalDeflectionToModel();
        this.addStochasticPointsAndStochasticDeflectionToModel();
        boolean bl = this.freeNetwork = this.freeNetwork || (this.referencePoints == null || this.referencePoints.isEmpty()) && (this.stochasticPoints == null || this.stochasticPoints.isEmpty());
        if (this.freeNetwork) {
            if (this.datumPoints == null || this.datumPoints.isEmpty()) {
                this.currentEstimationStatus = EstimationStateType.SINGULAR_MATRIX;
                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                return this.currentEstimationStatus;
            }
            this.detectRankDefect();
        }
        if (this.freeNetwork && this.congruenceAnalysis) {
            this.addStrainParametersToModel();
        }
        this.resetVarianceComponents();
        this.unknownParameters.resortParameters();
        try {
            double lastStepSignum = 0.0;
            int numObs = this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows;
            int numberOfEstimationSteps = this.estimationType == EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION ? 2 * numObs + 1 : (this.estimationType == EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION ? numObs + 2 : 1);
            double alpha2 = this.alphaUT * this.alphaUT;
            double weight0 = this.weightZero;
            double weighti = (1.0 - weight0) / ((double)numberOfEstimationSteps - 1.0);
            DenseVector SigmaUT = null;
            DenseVector xUT = null;
            DenseVector vUT = null;
            DenseMatrix solutionVectors = null;
            if (applyUnscentedTransformation) {
                xUT = new DenseVector(this.numberOfUnknownParameters);
                vUT = new DenseVector(numObs);
                solutionVectors = new DenseMatrix(this.numberOfUnknownParameters, numberOfEstimationSteps);
                if (this.estimationType == EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION) {
                    SigmaUT = new DenseVector(1);
                    SigmaUT.set(0, Math.sqrt(0.5 / weighti));
                } else if (this.estimationType == EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION) {
                    SigmaUT = new DenseVector(numObs);
                    if (weight0 < 0.0 || weight0 >= 1.0) {
                        throw new IllegalArgumentException("Error, zero-weight is out of range. If SUT is applied, valid values are 0 <= w0 < 1! " + weight0);
                    }
                }
                weight0 = weight0 / alpha2 + (1.0 - 1.0 / alpha2);
                weighti /= alpha2;
            }
            int estimationStep = 0;
            while (estimationStep < numberOfEstimationSteps) {
                this.currentMaxAbsDx = this.maxDx = Double.MIN_VALUE;
                runs = this.maximalNumberOfIterations - 1;
                isEstimated = false;
                estimateCompleteModel = false;
                isConverge = true;
                if (applyUnscentedTransformation) {
                    this.currentEstimationStatus = EstimationStateType.UNSCENTED_TRANSFORMATION_STEP;
                    this.change.firePropertyChange(this.currentEstimationStatus.name(), numberOfEstimationSteps, estimationStep + 1);
                    if (numberOfEstimationSteps > 1 && estimationStep != numberOfEstimationSteps - 1) {
                        this.resetDatumPoints();
                    }
                    if (this.estimationType == EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION) {
                        double signum = estimationStep == numberOfEstimationSteps - 1 ? 0.0 : (estimationStep < numObs ? 1.0 : -1.0);
                        int currentObsIdx = estimationStep % numObs;
                        if (estimationStep > 0) {
                            int lastObsIdx = currentObsIdx - 1;
                            lastObsIdx = lastObsIdx < 0 ? numObs - 1 : lastObsIdx;
                            this.prepareModifiedUnscentedTransformationObservation(lastObsIdx, -lastStepSignum * SigmaUT.get(0));
                        }
                        if (estimationStep < numberOfEstimationSteps - 1) {
                            this.prepareModifiedUnscentedTransformationObservation(currentObsIdx, signum * SigmaUT.get(0));
                        }
                        lastStepSignum = signum;
                    } else if (this.estimationType == EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION) {
                        this.prepareSphericalSimplexUnscentedTransformationObservation(estimationStep, (Vector)SigmaUT, weighti);
                    }
                }
                do {
                    this.maxDx = Double.MIN_VALUE;
                    this.numberOfHypotesis = 0;
                    this.iterationStep = this.maximalNumberOfIterations - runs;
                    this.currentEstimationStatus = EstimationStateType.ITERATE;
                    this.change.firePropertyChange(this.currentEstimationStatus.name(), this.maximalNumberOfIterations, this.iterationStep);
                    this.applySphericalVerticalDeflections();
                    NormalEquationSystem neq = this.createNormalEquation();
                    this.resetVarianceComponents();
                    if (this.interrupt || neq == null) {
                        this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        this.interrupt = false;
                        return this.currentEstimationStatus;
                    }
                    DenseVector n = neq.getVector();
                    UpperSymmPackMatrix N = neq.getMatrix();
                    DenseVector dx = n;
                    estimateCompleteModel = isEstimated;
                    try {
                        if (estimateCompleteModel && estimationStep == numberOfEstimationSteps - 1 || this.estimationType == EstimationType.L1NORM) {
                            boolean bl2 = this.calculateStochasticParameters = this.estimationType != EstimationType.L1NORM && estimateCompleteModel;
                            if (this.estimationType != EstimationType.L1NORM) {
                                this.currentEstimationStatus = EstimationStateType.INVERT_NORMAL_EQUATION_MATRIX;
                                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                            }
                            this.estimateFactorsForOutherAccracy(N, n);
                            if (this.calculateStochasticParameters) {
                                this.currentEstimationStatus = EstimationStateType.ESTIAMTE_STOCHASTIC_PARAMETERS;
                                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                            }
                        } else {
                            MathExtension.solve(N, n, false);
                        }
                        n = null;
                        N = null;
                    }
                    catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | MatrixNotSPDException | MatrixSingularException e) {
                        e.printStackTrace();
                        this.currentEstimationStatus = EstimationStateType.SINGULAR_MATRIX;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        return this.currentEstimationStatus;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        return this.currentEstimationStatus;
                    }
                    if (applyUnscentedTransformation) {
                        if (estimateCompleteModel) {
                            this.addUnscentedTransformationSolution((Vector)dx, (Vector)xUT, (Vector)vUT, (Matrix)solutionVectors, estimationStep, estimationStep < numberOfEstimationSteps - 1 ? weighti : weight0);
                        }
                        if (estimateCompleteModel && estimationStep > 0 && estimationStep == numberOfEstimationSteps - 1) {
                            this.estimateUnscentedTransformationParameterUpdateAndCovarianceMatrix((Vector)dx, (Vector)xUT, (Matrix)solutionVectors, weighti, weight0 + (1.0 - alpha2 + this.betaUT));
                        }
                    }
                    this.updateModel((Vector)dx, (Vector)vUT, estimateCompleteModel && estimationStep == numberOfEstimationSteps - 1);
                    dx = null;
                    vUT = null;
                    if (this.interrupt) {
                        this.currentEstimationStatus = EstimationStateType.INTERRUPT;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        this.interrupt = false;
                        return this.currentEstimationStatus;
                    }
                    if (Double.isInfinite(this.maxDx) || Double.isNaN(this.maxDx)) {
                        this.currentEstimationStatus = EstimationStateType.SINGULAR_MATRIX;
                        this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                        return this.currentEstimationStatus;
                    }
                    if (this.maxDx <= SQRT_EPS && runs > 0) {
                        isEstimated = true;
                        this.currentEstimationStatus = EstimationStateType.CONVERGENCE;
                        if (!applyUnscentedTransformation) {
                            this.change.firePropertyChange(this.currentEstimationStatus.name(), SQRT_EPS, this.maxDx);
                        }
                    } else if (runs-- <= 1) {
                        if (estimateCompleteModel) {
                            if (this.estimationType == EstimationType.L1NORM) {
                                this.currentEstimationStatus = EstimationStateType.ROBUST_ESTIMATION_FAILED;
                                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                                return this.currentEstimationStatus;
                            }
                            this.currentEstimationStatus = EstimationStateType.NO_CONVERGENCE;
                            this.change.firePropertyChange(this.currentEstimationStatus.name(), SQRT_EPS, this.maxDx);
                            isConverge = false;
                        }
                        isEstimated = true;
                    } else {
                        this.currentEstimationStatus = EstimationStateType.CONVERGENCE;
                        if (!applyUnscentedTransformation) {
                            this.change.firePropertyChange(this.currentEstimationStatus.name(), SQRT_EPS, this.maxDx);
                        }
                    }
                    if (this.maxDx > Double.MIN_VALUE) {
                        this.currentMaxAbsDx = this.maxDx;
                        continue;
                    }
                    this.maxDx = this.currentMaxAbsDx;
                } while (!estimateCompleteModel);
                ++estimationStep;
            }
            try {
                this.exportAdjustmentResults();
            }
            catch (IOException | IllegalArgumentException | NullPointerException e) {
                e.printStackTrace();
                this.currentEstimationStatus = EstimationStateType.EXPORT_ADJUSTMENT_RESULTS_FAILED;
                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                return this.currentEstimationStatus;
            }
            if (this.numberOfPrincipalComponents > 0) {
                this.estimatePrincipalComponentAnalysis(this.numberOfPrincipalComponents);
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            this.currentEstimationStatus = EstimationStateType.OUT_OF_MEMORY;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
            return this.currentEstimationStatus;
        }
        if (!isConverge) {
            this.currentEstimationStatus = EstimationStateType.NO_CONVERGENCE;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), SQRT_EPS, this.maxDx);
        } else if (this.currentEstimationStatus.getId() == EstimationStateType.BUSY.getId() || this.calculateStochasticParameters) {
            this.currentEstimationStatus = EstimationStateType.ERROR_FREE_ESTIMATION;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), SQRT_EPS, this.maxDx);
        }
        return this.currentEstimationStatus;
    }

    public double getMaxAbsDx() {
        return this.currentMaxAbsDx;
    }

    private void prepareSphericalSimplexUnscentedTransformationObservation(int estimationStep, Vector SigmaUT, double weight) {
        double valueY;
        int row;
        int noo = SigmaUT.size();
        int idx = 0;
        while (idx < this.numberOfObservations) {
            Observation observation = this.projectObservations.get(idx);
            row = observation.getRowInJacobiMatrix();
            double std = observation.getStdApriori();
            double value = observation.getValueApriori();
            double sigmaUT = SigmaUT.get(row);
            value -= std * sigmaUT;
            sigmaUT = 0.0;
            if (estimationStep < noo + 2 && row >= 0) {
                if (row == estimationStep - 1) {
                    sigmaUT = (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                } else if (row > estimationStep - 2) {
                    sigmaUT = -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                }
            }
            observation.setValueApriori(value += std * sigmaUT);
            SigmaUT.set(row, sigmaUT);
            ++idx;
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
            VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
            int rowX = deflectionX.getRowInJacobiMatrix();
            int rowY = deflectionY.getRowInJacobiMatrix();
            double stdX = deflectionX.getStdApriori();
            double stdY = deflectionY.getStdApriori();
            double valueX = deflectionX.getValue0();
            valueY = deflectionY.getValue0();
            double sigmaUTX = SigmaUT.get(rowX);
            double sigmaUTY = SigmaUT.get(rowY);
            valueX -= stdX * sigmaUTX;
            valueY -= stdY * sigmaUTY;
            sigmaUTX = 0.0;
            sigmaUTY = 0.0;
            if (estimationStep < noo + 2 && rowX >= 0 && rowY >= 0) {
                if (rowX == estimationStep - 1) {
                    sigmaUTX = (1.0 + (double)rowX) / Math.sqrt((1.0 + (double)rowX) * (2.0 + (double)rowX) * weight);
                } else if (rowX > estimationStep - 2) {
                    sigmaUTX = -1.0 / Math.sqrt((1.0 + (double)rowX) * (2.0 + (double)rowX) * weight);
                }
                if (rowY == estimationStep - 1) {
                    sigmaUTY = (1.0 + (double)rowY) / Math.sqrt((1.0 + (double)rowY) * (2.0 + (double)rowY) * weight);
                } else if (rowY > estimationStep - 2) {
                    sigmaUTY = -1.0 / Math.sqrt((1.0 + (double)rowY) * (2.0 + (double)rowY) * weight);
                }
            }
            deflectionX.setValue0(valueX += stdX * sigmaUTX);
            deflectionY.setValue0(valueY += stdY * sigmaUTY);
            SigmaUT.set(rowX, sigmaUTX);
            SigmaUT.set(rowY, sigmaUTY);
        }
        for (Point point : this.stochasticPoints) {
            row = point.getRowInJacobiMatrix();
            int dim = point.getDimension();
            if (row < 0) continue;
            if (dim != 1) {
                double stdX = point.getStdXApriori();
                double valueX = point.getX0();
                double sigmaUTX = SigmaUT.get(row);
                valueX -= stdX * sigmaUTX;
                sigmaUTX = 0.0;
                if (estimationStep < noo + 2) {
                    if (row == estimationStep - 1) {
                        sigmaUTX = (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                    } else if (row > estimationStep - 2) {
                        sigmaUTX = -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                    }
                }
                point.setX0(valueX += stdX * sigmaUTX);
                SigmaUT.set(row, sigmaUTX);
                double stdY = point.getStdYApriori();
                valueY = point.getY0();
                double sigmaUTY = SigmaUT.get(++row);
                valueY -= stdY * sigmaUTY;
                sigmaUTY = 0.0;
                if (estimationStep < noo + 2) {
                    if (row == estimationStep - 1) {
                        sigmaUTY = (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                    } else if (row > estimationStep - 2) {
                        sigmaUTY = -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                    }
                }
                point.setY0(valueY += stdY * sigmaUTY);
                SigmaUT.set(row, sigmaUTY);
                ++row;
            }
            if (dim == 2) continue;
            double stdZ = point.getStdZApriori();
            double valueZ = point.getZ0();
            double sigmaUTZ = SigmaUT.get(row);
            valueZ -= stdZ * sigmaUTZ;
            sigmaUTZ = 0.0;
            if (estimationStep < noo + 2) {
                if (row == estimationStep - 1) {
                    sigmaUTZ = (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                } else if (row > estimationStep - 2) {
                    sigmaUTZ = -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight);
                }
            }
            point.setZ0(valueZ += stdZ * sigmaUTZ);
            SigmaUT.set(row, sigmaUTZ);
        }
    }

    private void prepareModifiedUnscentedTransformationObservation(int index, double scale) {
        if (index < this.numberOfObservations) {
            Observation observation = this.projectObservations.get(index);
            double std = observation.getStdApriori();
            double value = observation.getValueApriori();
            observation.setValueApriori(value += scale * std);
        } else if (index < this.numberOfObservations + this.numberOfStochasticDeflectionRows) {
            int deflectionIdx = index - this.numberOfObservations;
            int deflectionType = deflectionIdx % 2;
            Point point = this.pointsWithStochasticDeflection.get(deflectionIdx /= 2);
            if (deflectionType == 0) {
                VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
                double std = deflectionX.getStdApriori();
                double value = deflectionX.getValue0();
                deflectionX.setValue0(value += scale * std);
            } else {
                VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
                double std = deflectionY.getStdApriori();
                double value = deflectionY.getValue0();
                deflectionY.setValue0(value += scale * std);
            }
        } else if (index < this.numberOfObservations + this.numberOfStochasticDeflectionRows + this.numberOfStochasticPointRows) {
            int pointIdx = index - this.numberOfObservations - this.numberOfStochasticDeflectionRows;
            int i = 0;
            int j = 0;
            while (i < this.stochasticPoints.size()) {
                Point point = this.stochasticPoints.get(i);
                int dim = point.getDimension();
                if (pointIdx < j + dim) {
                    int d = 0;
                    while (d < dim) {
                        if (pointIdx == j + d) {
                            double value;
                            double std;
                            if (dim != 1) {
                                if (d == 0) {
                                    std = point.getStdXApriori();
                                    value = point.getX0();
                                    point.setX0(value += scale * std);
                                } else if (d == 1) {
                                    std = point.getStdYApriori();
                                    value = point.getY0();
                                    point.setY0(value += scale * std);
                                }
                            }
                            if (dim != 2 && d == dim - 1) {
                                std = point.getStdZApriori();
                                value = point.getZ0();
                                point.setZ0(value += scale * std);
                            }
                        }
                        ++d;
                    }
                    break;
                }
                j += dim;
                ++i;
            }
        }
    }

    private void resetDatumPoints() {
        for (Point p : this.datumPoints) {
            p.resetCoordinates();
        }
    }

    private void estimateUnscentedTransformationParameterUpdateAndCovarianceMatrix(Vector dx, Vector xUT, Matrix solutionVectors, double weightN, double weightC) {
        int numberOfEstimationSteps = solutionVectors.numColumns();
        this.Qxx.zero();
        int c = 0;
        while (c < this.unknownParameters.size()) {
            if (this.interrupt) {
                return;
            }
            UnknownParameter unknownParameterCol = this.unknownParameters.get(c);
            int col = unknownParameterCol.getColInJacobiMatrix();
            int dimCol = 1;
            switch (unknownParameterCol.getParameterType()) {
                case POINT2D: {
                    dimCol = 2;
                    break;
                }
                case POINT3D: {
                    dimCol = 3;
                    break;
                }
                default: {
                    dimCol = 1;
                }
            }
            if (unknownParameterCol instanceof Point) {
                Point point = (Point)unknownParameterCol;
                dimCol = point.getDimension();
                if (dimCol != 1) {
                    dx.set(col + 0, xUT.get(col + 0) - point.getX());
                    dx.set(col + 1, xUT.get(col + 1) - point.getY());
                }
                if (dimCol != 2) {
                    dx.set(col + dimCol - 1, xUT.get(col + dimCol - 1) - point.getZ());
                }
            } else if (unknownParameterCol instanceof VerticalDeflection) {
                VerticalDeflection deflectionParameter = (VerticalDeflection)unknownParameterCol;
                dx.set(col, xUT.get(col) - deflectionParameter.getValue());
            } else if (unknownParameterCol instanceof AdditionalUnknownParameter) {
                AdditionalUnknownParameter additionalUnknownParameter = (AdditionalUnknownParameter)unknownParameterCol;
                dx.set(col, xUT.get(col) - additionalUnknownParameter.getValue());
            } else if (unknownParameterCol instanceof StrainParameter) {
                StrainParameter strainParameter = (StrainParameter)unknownParameterCol;
                dx.set(col, xUT.get(col) - strainParameter.getValue());
            }
            int dCol = 0;
            while (dCol < dimCol) {
                int r = c;
                while (r < this.unknownParameters.size()) {
                    if (this.interrupt) {
                        return;
                    }
                    UnknownParameter unknownParameterRow = this.unknownParameters.get(r);
                    int row = unknownParameterRow.getColInJacobiMatrix();
                    int dimRow = 1;
                    switch (unknownParameterRow.getParameterType()) {
                        case POINT2D: {
                            dimRow = 2;
                            break;
                        }
                        case POINT3D: {
                            dimRow = 3;
                            break;
                        }
                        default: {
                            dimRow = 1;
                        }
                    }
                    if (unknownParameterRow instanceof Point) {
                        Point point = (Point)unknownParameterRow;
                        dimRow = point.getDimension();
                    }
                    int dRow = 0;
                    while (dRow < dimRow) {
                        int estimationStep = 0;
                        while (estimationStep < numberOfEstimationSteps) {
                            double weight = estimationStep == numberOfEstimationSteps - 1 ? weightC : weightN;
                            double valueCol = solutionVectors.get(col + dCol, estimationStep) - xUT.get(col + dCol);
                            double valueRow = solutionVectors.get(row + dRow, estimationStep) - xUT.get(row + dRow);
                            this.Qxx.set(col + dCol, row + dRow, this.Qxx.get(col + dCol, row + dRow) + valueRow * weight * valueCol);
                            ++estimationStep;
                        }
                        ++dRow;
                    }
                    ++r;
                }
                ++dCol;
            }
            ++c;
        }
        solutionVectors = null;
        xUT = null;
    }

    private void addUnscentedTransformationSolution(Vector dX, Vector xUT, Vector vUT, Matrix solutionVectors, int solutionNumber, double weight) {
        int i = 0;
        while (i < this.unknownParameters.size()) {
            if (this.interrupt) {
                return;
            }
            UnknownParameter unknownParameter = this.unknownParameters.get(i);
            int col = unknownParameter.getColInJacobiMatrix();
            if (unknownParameter instanceof Point) {
                Point point = (Point)unknownParameter;
                int dim = point.getDimension();
                if (dim != 1) {
                    double xValue = point.getX() + dX.get(col);
                    xUT.set(col, xUT.get(col) + weight * xValue);
                    solutionVectors.set(col, solutionNumber, xValue);
                    double yValue = point.getY() + dX.get(++col);
                    xUT.set(col, xUT.get(col) + weight * yValue);
                    solutionVectors.set(col, solutionNumber, yValue);
                    ++col;
                }
                if (dim != 2) {
                    double zValue = point.getZ() + dX.get(col);
                    xUT.set(col, xUT.get(col) + weight * zValue);
                    solutionVectors.set(col, solutionNumber, zValue);
                    ++col;
                }
            } else if (unknownParameter instanceof VerticalDeflection) {
                VerticalDeflection deflectionParameter = (VerticalDeflection)unknownParameter;
                double value = deflectionParameter.getValue() + dX.get(col);
                xUT.set(col, xUT.get(col) + weight * value);
                solutionVectors.set(col, solutionNumber, value);
            } else if (unknownParameter instanceof AdditionalUnknownParameter) {
                AdditionalUnknownParameter additionalUnknownParameter = (AdditionalUnknownParameter)unknownParameter;
                double value = additionalUnknownParameter.getValue() + dX.get(col);
                xUT.set(col, xUT.get(col) + weight * value);
                solutionVectors.set(col, solutionNumber, value);
            } else if (unknownParameter instanceof StrainParameter) {
                StrainParameter strainParameter = (StrainParameter)unknownParameter;
                double value = strainParameter.getValue() + dX.get(col);
                xUT.set(col, xUT.get(col) + weight * value);
                solutionVectors.set(col, solutionNumber, value);
            }
            ++i;
        }
        if (vUT != null) {
            vUT.add(weight, this.getObservationalErrors());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateModel(Vector dX, Vector vUT, boolean updateCompleteModel) {
        block246: {
            this.omega = 0.0;
            this.degreeOfFreedom = 0.0;
            vVec = null;
            if (updateCompleteModel || this.estimationType == EstimationType.L1NORM) {
                this.addSubRedundanceAndCofactor2Observations();
                if (updateCompleteModel) {
                    i = 0;
                    while (i < this.numberOfObservations) {
                        observation = this.projectObservations.get(i);
                        if (this.adaptedObservationUncertainties.containsKey(observation)) {
                            observation.setStdApriori(this.adaptedObservationUncertainties.get(observation));
                        }
                        ++i;
                    }
                }
                if (updateCompleteModel && this.estimationType != EstimationType.SIMULATION) {
                    vVec = this.getCorrectionVector(dX);
                }
            }
            i = 0;
            while (i < this.unknownParameters.size()) {
                if (this.interrupt) {
                    return;
                }
                unknownParameter = this.unknownParameters.get(i);
                col = unknownParameter.getColInJacobiMatrix();
                if (unknownParameter instanceof Point) {
                    point = (Point)unknownParameter;
                    tmpMaxDx = this.maxDx;
                    dim = point.getDimension();
                    if (dim != 1) {
                        this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                        point.setX(point.getX() + dX.get(col++));
                        this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                        point.setY(point.getY() + dX.get(col++));
                    }
                    if (dim != 2) {
                        this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                        point.setZ(point.getZ() + dX.get(col));
                    }
                    if (updateCompleteModel && this.stochasticPoints.contains(point)) {
                        this.maxDx = tmpMaxDx;
                    }
                    if ((updateCompleteModel || this.estimationType == EstimationType.L1NORM) && point.getRowInJacobiMatrix() >= 0) {
                        this.addSubRedundanceAndCofactor2Point(point, updateCompleteModel);
                    }
                } else if (unknownParameter instanceof AdditionalUnknownParameter) {
                    this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                    additionalUnknownParameter = (AdditionalUnknownParameter)unknownParameter;
                    additionalUnknownParameter.setValue(additionalUnknownParameter.getValue() + dX.get(col));
                } else if (unknownParameter instanceof StrainParameter) {
                    this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                    strainParameter = (StrainParameter)unknownParameter;
                    strainParameter.setValue(strainParameter.getValue() + dX.get(col));
                } else if (unknownParameter instanceof VerticalDeflection) {
                    if (unknownParameter instanceof VerticalDeflectionX && (updateCompleteModel || this.estimationType == EstimationType.L1NORM) && ((VerticalDeflectionX)unknownParameter).getRowInJacobiMatrix() >= 0) {
                        point = ((VerticalDeflectionX)unknownParameter).getPoint();
                        this.addSubRedundanceAndCofactor2Deflection(point, updateCompleteModel);
                    }
                    this.maxDx = Math.max(Math.abs(dX.get(col)), this.maxDx);
                    deflectionParameter = (VerticalDeflection)unknownParameter;
                    deflectionParameter.setValue(deflectionParameter.getValue() + dX.get(col));
                }
                ++i;
            }
            if (!updateCompleteModel && this.estimationType != EstimationType.L1NORM) break block246;
            totalNumberOfNegativeResiduals = 0;
            totalNumberOfEffectiveObservations = 0;
            i = 0;
            while (i < this.numberOfObservations) {
                if (this.interrupt) {
                    return;
                }
                observation = this.projectObservations.get(i);
                qll = observation.getStdApriori() * observation.getStdApriori();
                r = observation.getRedundancy();
                v = this.estimationType == EstimationType.SIMULATION ? 0.0 : (vUT != null ? vUT.get(observation.getRowInJacobiMatrix()) : observation.getObservationalError());
                vv = v * v;
                omegaObs = vv / qll;
                observation.setOmega(omegaObs);
                this.omega += omegaObs;
                if (!updateCompleteModel) {
                    return;
                }
                observationType = observation.getObservationType();
                vcType = VarianceComponentType.getVarianceComponentTypeByObservationType(observationType);
                if (vcType != null && this.varianceComponents.containsKey((Object)vcType)) {
                    vc = this.varianceComponents.get((Object)vcType);
                    vc.setOmega(vc.getOmega() + omegaObs);
                    vc.setRedundancy(vc.getRedundancy() + r);
                    vc.setNumberOfObservations(vc.getNumberOfObservations() + 1);
                    if (r > 0.0) {
                        vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + (v < 0.0 ? 1 : 0));
                        vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + 1);
                        totalNumberOfNegativeResiduals += v < 0.0 ? 1 : 0;
                        ++totalNumberOfEffectiveObservations;
                    }
                }
                if (!observation.useGroupUncertainty()) ** GOTO lbl137
                group = observation.getObservationGroup();
                qllA = group.getStdA(observation);
                qllB = group.getStdB(observation);
                qllC = group.getStdC(observation);
                if (Math.abs(Math.sqrt((qllA *= qllA) + (qllB *= qllB) + (qllC *= qllC)) - observation.getStdApriori()) > NetworkAdjustment.SQRT_EPS) {
                    System.err.println(this.getClass().getSimpleName() + " Erweitere VKS; Beobachtungsdifferenz im stoch. Modell zu gross: " + String.valueOf(observation) + "    " + Math.abs(Math.sqrt(qllA + qllB + qllC) - observation.getStdApriori()));
                } else {
                    omegaVKS = omegaObs / qll;
                    omegaA = omegaVKS * qllA;
                    omegaB = omegaVKS * qllB;
                    omegaC = omegaVKS * qllC;
                    redundancyVKS = r / qll;
                    redundancyA = redundancyVKS * qllA;
                    redundancyB = redundancyVKS * qllB;
                    redundancyC = redundancyVKS * qllC;
                    vcType = VarianceComponentType.getZeroPointOffsetVarianceComponentTypeByObservationType(observationType);
                    if (vcType != null) {
                        if (!this.varianceComponents.containsKey((Object)vcType)) {
                            this.varianceComponents.put(vcType, new VarianceComponent(vcType));
                        }
                        vc = this.varianceComponents.get((Object)vcType);
                        vc.setOmega(vc.getOmega() + omegaA);
                        vc.setRedundancy(vc.getRedundancy() + redundancyA);
                        vc.setNumberOfObservations(vc.getNumberOfObservations() + 1);
                        if (r > 0.0) {
                            vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + (v < 0.0 ? 1 : 0));
                            vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + 1);
                        }
                    }
                    if ((vcType = VarianceComponentType.getSquareRootDistanceDependentVarianceComponentTypeByObservationType(observationType)) != null) {
                        if (!this.varianceComponents.containsKey((Object)vcType)) {
                            this.varianceComponents.put(vcType, new VarianceComponent(vcType));
                        }
                        vc = this.varianceComponents.get((Object)vcType);
                        vc.setOmega(vc.getOmega() + omegaB);
                        vc.setRedundancy(vc.getRedundancy() + redundancyB);
                        vc.setNumberOfObservations(vc.getNumberOfObservations() + 1);
                        if (r > 0.0) {
                            vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + (v < 0.0 ? 1 : 0));
                            vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + 1);
                        }
                    }
                    if ((vcType = VarianceComponentType.getDistanceDependentVarianceComponentTypeByObservationType(observationType)) != null) {
                        if (!this.varianceComponents.containsKey((Object)vcType)) {
                            this.varianceComponents.put(vcType, new VarianceComponent(vcType));
                        }
                        vc = this.varianceComponents.get((Object)vcType);
                        vc.setOmega(vc.getOmega() + omegaC);
                        vc.setRedundancy(vc.getRedundancy() + redundancyC);
                        vc.setNumberOfObservations(vc.getNumberOfObservations() + 1);
                        if (r > 0.0) {
                            vc.setNumberOfNegativeResiduals(vc.getNumberOfNegativeResiduals() + (v < 0.0 ? 1 : 0));
                            vc.setNumberOfEffectiveObservations(vc.getNumberOfEffectiveObservations() + 1);
                        }
                    }
lbl137:
                    // 6 sources

                    if (updateCompleteModel && this.estimationType != EstimationType.SIMULATION) {
                        observationLinearisationProof = vVec.get(observation.getRowInJacobiMatrix()) + v;
                        this.finalLinearisationError = Math.max(this.finalLinearisationError, Math.abs(observationLinearisationProof));
                    }
                }
                ++i;
            }
            dof = this.degreeOfFreedom();
            varianceOfUnitWeight = this.getVarianceFactorAposteriori();
            v0 = applyEmpiricalVarianceOfUnitWeight = this.applyAposterioriVarianceOfUnitWeight != false && this.estimationType != EstimationType.SIMULATION && dof > 0 && varianceOfUnitWeight > NetworkAdjustment.SQRT_EPS;
            if (this.estimationType != EstimationType.SIMULATION && this.testStatisticDefinition.getTestStatisticType() == TestStatisticType.SIDAK) {
                this.numberOfHypotesis += this.referencePoints.size();
                this.numberOfHypotesis += this.pointsWithReferenceDeflection.size();
                for (VarianceComponent varianceEstimation : this.varianceComponents.values()) {
                    r = (double)Math.round(varianceEstimation.getRedundancy() * 100000.0) / 100000.0;
                    if (!(r > 0.0)) continue;
                    ++this.numberOfHypotesis;
                }
            }
            sigma2PointMax = 0.0;
            for (Point point : this.allPoints.values()) {
                col = point.getColInJacobiMatrix();
                if (col < 0) continue;
                dim = point.getDimension();
                sigma2PointMaxi = 0.0;
                d = 0;
                while (d < dim) {
                    sigma2PointMaxi += varianceOfUnitWeight * this.Qxx.get(col + d, col + d);
                    ++d;
                }
                sigma2PointMax = Math.max(sigma2PointMaxi, sigma2PointMax);
            }
            vc = new VarianceComponent(VarianceComponentType.GLOBAL);
            vc.setRedundancy(dof);
            vc.setNumberOfObservations(this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows);
            vc.setNumberOfNegativeResiduals(totalNumberOfNegativeResiduals);
            vc.setNumberOfEffectiveObservations(totalNumberOfEffectiveObservations);
            vc.setOmega(this.omega);
            this.varianceComponents.put(vc.getVarianceComponentType(), vc);
            this.significanceTestStatisticParameters = this.getSignificanceTestStatisticParameters();
            this.binomialTestStatisticParameters = this.getBinomialTestStatisticParameters();
            this.confidenceRegionParameters = this.getConfidenceRegionParameters();
            for (VarianceComponent varianceEstimation : this.varianceComponents.values()) {
                if (!(varianceEstimation.getRedundancy() > 0.0)) continue;
                this.significanceTestStatisticParameters.getTestStatisticParameter(varianceEstimation.getRedundancy(), Infinity, varianceEstimation.getVarianceComponentType() == VarianceComponentType.GLOBAL);
                this.binomialTestStatisticParameters.getTestStatisticParameter(varianceEstimation.getNumberOfEffectiveObservations(), 0.5);
            }
            points = null;
            points = this.congruenceAnalysis != false && this.freeNetwork != false ? this.datumPoints : this.referencePoints;
            i = 0;
            while (i < points.size()) {
                if (this.interrupt) {
                    return;
                }
                point = points.get(i);
                observations = point.getObservations();
                dim = point.getDimension();
                if (!this.freeNetwork) {
                    if (dim != 1) {
                        point.setStdX(-1.0);
                        point.setStdY(-1.0);
                    }
                    if (dim != 2) {
                        point.setStdZ(-1.0);
                    }
                }
                BTPQvvPB = new DenseMatrix(dim, dim);
                BTPv = new DenseVector(dim);
                hasObservationInReferenceEpoch = this.congruenceAnalysis == false || this.freeNetwork == false;
                k = 0;
                while (k < observations.size()) {
                    observationB = observations.get(k);
                    if (this.congruenceAnalysis && this.freeNetwork && observationB.getObservationGroup().getEpoch() == Epoch.REFERENCE) {
                        hasObservationInReferenceEpoch = true;
                    } else {
                        qB = observationB.getStdApriori() * observationB.getStdApriori();
                        vB = this.estimationType == EstimationType.SIMULATION ? 0.0 : -observationB.getObservationalError();
                        b = 0.0;
                        vB = Math.abs(vB) < NetworkAdjustment.SQRT_EPS ? 0.0 : vB;
                        c = 0;
                        while (c < dim) {
                            if (observationB.getStartPoint().equals(point)) {
                                if (c == 0 && dim != 1) {
                                    b = observationB.diffXs();
                                } else if (c == 1) {
                                    b = observationB.diffYs();
                                } else if (c == 2 || dim == 1) {
                                    b = observationB.diffZs();
                                }
                            } else if (observationB.getEndPoint().equals(point)) {
                                if (c == 0 && dim != 1) {
                                    b = observationB.diffXe();
                                } else if (c == 1) {
                                    b = observationB.diffYe();
                                } else if (c == 2 || dim == 1) {
                                    b = observationB.diffZe();
                                }
                            }
                            BTPv.set(c, BTPv.get(c) + b * vB / qB);
                            j = 0;
                            while (j < observations.size()) {
                                observationBT = observations.get(j);
                                if (!this.congruenceAnalysis || !this.freeNetwork || observationBT.getObservationGroup().getEpoch() != Epoch.REFERENCE) {
                                    qll = this.getQllElement(observationBT, observationB);
                                    qBT = observationBT.getStdApriori() * observationBT.getStdApriori();
                                    pqvvp = k == j ? Math.max(1.0 / qBT - qll / qBT / qB, 0.0) : -qll / qBT / qB;
                                    r = 0;
                                    while (r < dim) {
                                        bT = 0.0;
                                        if (observationBT.getStartPoint().equals(point)) {
                                            if (r == 0 && dim != 1) {
                                                bT = observationBT.diffXs();
                                            } else if (r == 1) {
                                                bT = observationBT.diffYs();
                                            } else if (r == 2 || dim == 1) {
                                                bT = observationBT.diffZs();
                                            }
                                        } else if (observationBT.getEndPoint().equals(point)) {
                                            if (r == 0 && dim != 1) {
                                                bT = observationBT.diffXe();
                                            } else if (r == 1) {
                                                bT = observationBT.diffYe();
                                            } else if (r == 2 || dim == 1) {
                                                bT = observationBT.diffZe();
                                            }
                                        }
                                        BTPQvvPB.set(r, c, BTPQvvPB.get(r, c) + bT * pqvvp * b);
                                        ++r;
                                    }
                                }
                                ++j;
                            }
                            ++c;
                        }
                    }
                    ++k;
                }
                Qnn = new DenseMatrix(dim, dim);
                nabla = new DenseVector(dim);
                isCalculated = false;
                confidenceRegion = null;
                if (hasObservationInReferenceEpoch && observations.size() >= dim) {
                    try {
                        Qnn = MathExtension.pinv((Matrix)BTPQvvPB, -1);
                        confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                        isCalculated = true;
                    }
                    catch (NotConvergedException nce) {
                        nce.printStackTrace();
                        isCalculated = false;
                    }
                }
                if (isCalculated) {
                    if (this.estimationType == EstimationType.SIMULATION) {
                        nabla0 = new DenseVector(dim);
                        j = 0;
                        while (j < dim) {
                            nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                            ++j;
                        }
                        point.setMaximumTolerableBiases(Matrices.getArray((Vector)nabla0));
                    } else {
                        Qnn.mult((Vector)BTPv, (Vector)nabla);
                        normNabla = nabla.norm(Vector.Norm.Two);
                        point.setNablaCoVarNabla(Math.abs(nabla.dot((Vector)BTPv)));
                        point.setGrossErrors(Matrices.getArray((Vector)nabla.scale(-1.0)));
                        nabla0 = new DenseVector((Vector)nabla, true);
                        PQvvPnabla0 = new DenseVector((Vector)nabla0);
                        BTPQvvPB.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                        nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                        if (normNabla < NetworkAdjustment.SQRT_EPS || nQn0 <= 0.0) {
                            j = 0;
                            while (j < dim) {
                                nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j));
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < dim) {
                                nabla0.set(j, nabla0.get(j) / Math.sqrt(nQn0));
                                ++j;
                            }
                        }
                        point.setMaximumTolerableBiases(Matrices.getArray((Vector)nabla0));
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.pointsWithReferenceDeflection.size()) {
                if (this.interrupt) {
                    return;
                }
                point = this.pointsWithReferenceDeflection.get(i);
                isStation = false;
                deflectionX = point.getVerticalDeflectionX();
                deflectionY = point.getVerticalDeflectionY();
                observations = point.getObservations();
                dim = 2;
                BTPQvvPB = new DenseMatrix(dim, dim);
                BTPv = new DenseVector(dim);
                k = 0;
                while (k < observations.size()) {
                    observationB = observations.get(k);
                    qB = observationB.getStdApriori() * observationB.getStdApriori();
                    vB = this.estimationType == EstimationType.SIMULATION ? 0.0 : -observationB.getObservationalError();
                    b = 0.0;
                    vB = Math.abs(vB) < NetworkAdjustment.SQRT_EPS ? 0.0 : vB;
                    c = 0;
                    while (c < dim) {
                        if (observationB.getStartPoint().equals(point)) {
                            if (c == 0) {
                                b = observationB.diffVerticalDeflectionXs();
                            } else if (c == 1) {
                                b = observationB.diffVerticalDeflectionYs();
                            }
                            isStation = true;
                        } else if (observationB.getEndPoint().equals(point)) {
                            if (c == 0) {
                                b = observationB.diffVerticalDeflectionXe();
                            } else if (c == 1) {
                                b = observationB.diffVerticalDeflectionYe();
                            }
                        }
                        BTPv.set(c, BTPv.get(c) + b * vB / qB);
                        j = 0;
                        while (j < observations.size()) {
                            observationBT = observations.get(j);
                            qll = this.getQllElement(observationBT, observationB);
                            qBT = observationBT.getStdApriori() * observationBT.getStdApriori();
                            pqvvp = k == j ? Math.max(1.0 / qBT - qll / qBT / qB, 0.0) : -qll / qBT / qB;
                            r = 0;
                            while (r < dim) {
                                bT = 0.0;
                                if (observationBT.getStartPoint().equals(point)) {
                                    if (r == 0) {
                                        bT = observationBT.diffVerticalDeflectionXs();
                                    } else if (r == 1) {
                                        bT = observationBT.diffVerticalDeflectionYs();
                                    }
                                } else if (observationBT.getEndPoint().equals(point)) {
                                    if (r == 0) {
                                        bT = observationBT.diffVerticalDeflectionXe();
                                    } else if (r == 1) {
                                        bT = observationBT.diffVerticalDeflectionYe();
                                    }
                                }
                                BTPQvvPB.set(r, c, BTPQvvPB.get(r, c) + bT * pqvvp * b);
                                ++r;
                            }
                            ++j;
                        }
                        ++c;
                    }
                    ++k;
                }
                Qnn = new DenseMatrix(dim, dim);
                nabla = new DenseVector(dim);
                isCalculated = false;
                confidenceRegion = null;
                if (isStation && observations.size() >= dim) {
                    try {
                        Qnn = MathExtension.pinv((Matrix)BTPQvvPB, -1);
                        confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                        isCalculated = true;
                    }
                    catch (NotConvergedException nce) {
                        nce.printStackTrace();
                        isCalculated = false;
                    }
                }
                if (isCalculated) {
                    if (this.estimationType == EstimationType.SIMULATION) {
                        deflectionX.setMaximumTolerableBias(confidenceRegion.getMinimalDetectableBias(0));
                        deflectionY.setMaximumTolerableBias(confidenceRegion.getMinimalDetectableBias(1));
                    } else {
                        Qnn.mult((Vector)BTPv, (Vector)nabla);
                        deflectionX.setNablaCoVarNabla(Math.abs(nabla.dot((Vector)BTPv)));
                        nabla = nabla.scale(-1.0);
                        deflectionX.setGrossError(nabla.get(0));
                        deflectionY.setGrossError(nabla.get(1));
                        nabla0 = new DenseVector((Vector)nabla, true);
                        PQvvPnabla0 = new DenseVector((Vector)nabla0);
                        BTPQvvPB.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                        nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                        if (nQn0 > 0.0) {
                            deflectionX.setMaximumTolerableBias(nabla0.get(0) / Math.sqrt(nQn0));
                            deflectionY.setMaximumTolerableBias(nabla0.get(1) / Math.sqrt(nQn0));
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.referencePoints.size()) {
                if (this.interrupt) {
                    return;
                }
                point = this.referencePoints.get(i);
                dim = point.getDimension();
                point.calcStochasticParameters(varianceOfUnitWeight, dof, applyEmpiricalVarianceOfUnitWeight);
                tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
                sqrtLambda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                kPrio = tsPrio.getQuantile();
                kPost = tsPost != null ? tsPost.getQuantile() : Infinity;
                mdb = new double[dim];
                if (dim != 1) {
                    mdb[0] = point.getMaximumTolerableBiasX() * sqrtLambda;
                    mdb[1] = point.getMaximumTolerableBiasY() * sqrtLambda;
                }
                if (dim != 2) {
                    mdb[dim - 1] = point.getMaximumTolerableBiasZ() * sqrtLambda;
                }
                point.setMinimalDetectableBiases(mdb);
                if (this.estimationType == EstimationType.SIMULATION) {
                    point.setGrossErrors(mdb);
                } else {
                    tPrio = point.getTprio();
                    tPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? point.getTpost() : 0.0;
                    pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                    pPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
                    point.setProbabilityValues(pPrio, pPost);
                    point.setSignificant(tPrio > kPrio || tPost > kPost);
                }
                ++i;
            }
            i = 0;
            while (i < this.pointsWithReferenceDeflection.size()) {
                if (this.interrupt) {
                    return;
                }
                point = this.pointsWithReferenceDeflection.get(i);
                deflectionX = point.getVerticalDeflectionX();
                deflectionY = point.getVerticalDeflectionY();
                dim = 2;
                deflectionX.calcStochasticParameters(varianceOfUnitWeight, dof, applyEmpiricalVarianceOfUnitWeight);
                tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
                lamda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                kPrio = tsPrio.getQuantile();
                kPost = tsPost != null ? tsPost.getQuantile() : Infinity;
                deflectionX.setMinimalDetectableBias(lamda * deflectionX.getMaximumTolerableBias());
                deflectionY.setMinimalDetectableBias(lamda * deflectionY.getMaximumTolerableBias());
                if (this.estimationType == EstimationType.SIMULATION) {
                    deflectionX.setGrossError(deflectionX.getMinimalDetectableBias());
                    deflectionY.setGrossError(deflectionY.getMinimalDetectableBias());
                } else {
                    tPrio = deflectionX.getTprio();
                    tPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? deflectionX.getTpost() : 0.0;
                    pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                    pPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
                    deflectionX.setPprio(pPrio);
                    deflectionX.setPpost(pPost);
                    deflectionX.setSignificant(tPrio > kPrio || tPost > kPost);
                }
                ++i;
            }
            this.addStochasticParameters2Observations(varianceOfUnitWeight, dof, sigma2PointMax);
            this.traceCxxPoints = 0.0;
            i = 0;
            while (i < this.unknownParameters.size()) {
                if (this.interrupt) {
                    return;
                }
                unknownParameter = this.unknownParameters.get(i);
                col = unknownParameter.getColInJacobiMatrix();
                if (unknownParameter instanceof Point) {
                    point = (Point)unknownParameter;
                    dim = point.getDimension();
                    subCol = 0;
                    subQxx = new UpperSymmPackMatrix(dim);
                    r = 0;
                    while (r < dim) {
                        c = r;
                        while (c < dim) {
                            qxx = this.Qxx.get(col + r, col + c);
                            subQxx.set(r, c, qxx);
                            if (c == r) {
                                this.traceCxxPoints += varianceOfUnitWeight * qxx;
                            }
                            ++c;
                        }
                        ++r;
                    }
                    try {
                        confidenceRegion = new ConfidenceRegion(this.confidenceRegionParameters, (Matrix)subQxx, varianceOfUnitWeight, applyEmpiricalVarianceOfUnitWeight != false ? (double)dof : Infinity);
                        if (confidenceRegion != null) {
                            point.setConfidenceRegion(confidenceRegion);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (point.getRowInJacobiMatrix() >= 0 || this.congruenceAnalysis && this.freeNetwork) {
                        point.calcStochasticParameters(varianceOfUnitWeight, dof, applyEmpiricalVarianceOfUnitWeight);
                        tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                        tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
                        lamda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                        Kprio = tsPrio.getQuantile();
                        Kpost = tsPost != null ? tsPost.getQuantile() : Infinity;
                        mdb = new double[dim];
                        ep = new double[dim];
                        if (dim != 1) {
                            mdb[0] = point.getMaximumTolerableBiasX() * lamda;
                            mdb[1] = point.getMaximumTolerableBiasY() * lamda;
                            ep[0] = point.getInfluenceOnPointPositionX() * lamda;
                            ep[1] = point.getInfluenceOnPointPositionY() * lamda;
                        }
                        if (dim != 2) {
                            mdb[dim - 1] = point.getMaximumTolerableBiasZ() * lamda;
                            ep[dim - 1] = point.getInfluenceOnPointPositionZ() * lamda;
                        }
                        point.setMinimalDetectableBiases(mdb);
                        if (this.estimationType == EstimationType.SIMULATION) {
                            point.setInfluenceOnNetworkDistortion(point.getInfluenceOnNetworkDistortion() * lamda * Math.sqrt(sigma2PointMax));
                            point.setGrossErrors(mdb);
                            point.setInfluencesOnPointPosition(ep);
                        } else {
                            point.setInfluenceOnNetworkDistortion(point.getInfluenceOnNetworkDistortion() * Math.sqrt(sigma2PointMax));
                            tPrio = point.getTprio();
                            tPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? point.getTpost() : 0.0;
                            pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                            pPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
                            point.setProbabilityValues(pPrio, pPost);
                            point.setSignificant(tPrio > Kprio || tPost > Kpost || this.adaptedPointUncertainties.containsKey(point) != false);
                        }
                    }
                    if (dim != 1) {
                        stdX = Math.sqrt(Math.abs(varianceOfUnitWeight * subQxx.get(subCol, subCol++)));
                        stdY = Math.sqrt(Math.abs(varianceOfUnitWeight * subQxx.get(subCol, subCol++)));
                        point.setStdX(stdX);
                        point.setStdY(stdY);
                    }
                    if (dim != 2) {
                        stdZ = Math.sqrt(Math.abs(varianceOfUnitWeight * subQxx.get(subCol, subCol++)));
                        point.setStdZ(stdZ);
                    }
                } else if (unknownParameter instanceof VerticalDeflection) {
                    if (unknownParameter instanceof VerticalDeflectionX) {
                        deflectionX = (VerticalDeflectionX)unknownParameter;
                        deflectionY = deflectionX.getPoint().getVerticalDeflectionY();
                        cols = new int[]{deflectionX.getColInJacobiMatrix(), deflectionY.getColInJacobiMatrix()};
                        subQxx = new UpperSymmPackMatrix(2);
                        r = 0;
                        while (r < cols.length) {
                            c = r;
                            while (c < cols.length) {
                                qxx = this.Qxx.get(cols[r], cols[c]);
                                subQxx.set(r, c, qxx);
                                ++c;
                            }
                            ++r;
                        }
                        try {
                            confidence = new ConfidenceRegion(this.confidenceRegionParameters, (Matrix)subQxx, varianceOfUnitWeight, applyEmpiricalVarianceOfUnitWeight != false ? (double)dof : Infinity);
                            if (confidence != null) {
                                deflectionX.setConfidence(confidence.getConfidenceRegionAxis(0));
                                deflectionY.setConfidence(confidence.getConfidenceRegionAxis(1));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        deflectionX.setStd(Math.sqrt(Math.abs(varianceOfUnitWeight * subQxx.get(0, 0))));
                        deflectionY.setStd(Math.sqrt(Math.abs(varianceOfUnitWeight * subQxx.get(1, 1))));
                        if (deflectionX.getRowInJacobiMatrix() >= 0 && deflectionY.getRowInJacobiMatrix() >= 0 || this.congruenceAnalysis && this.freeNetwork) {
                            dim = 2;
                            deflectionX.calcStochasticParameters(varianceOfUnitWeight, dof, applyEmpiricalVarianceOfUnitWeight);
                            tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                            tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
                            lamda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                            Kprio = tsPrio.getQuantile();
                            Kpost = tsPost != null ? tsPost.getQuantile() : Infinity;
                            deflectionX.setMinimalDetectableBias(deflectionX.getMaximumTolerableBias() * lamda);
                            deflectionY.setMinimalDetectableBias(deflectionY.getMaximumTolerableBias() * lamda);
                            if (this.estimationType == EstimationType.SIMULATION) {
                                deflectionX.setGrossError(deflectionX.getMinimalDetectableBias());
                                deflectionY.setGrossError(deflectionY.getMinimalDetectableBias());
                            } else {
                                tPrio = deflectionX.getTprio();
                                tPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? deflectionX.getTpost() : 0.0;
                                pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                                pPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
                                deflectionX.setPprio(pPrio);
                                deflectionX.setPpost(pPost);
                                deflectionX.setSignificant(tPrio > Kprio || tPost > Kpost || this.adaptedVerticalDeflectionUncertainties.containsKey(deflectionX) != false || this.adaptedVerticalDeflectionUncertainties.containsKey(deflectionY) != false);
                            }
                        }
                    }
                } else if (unknownParameter instanceof AdditionalUnknownParameter) {
                    additionalUnknownParameter = (AdditionalUnknownParameter)unknownParameter;
                    qxxPrio = Math.abs(this.Qxx.get(col, col));
                    qxxPost = varianceOfUnitWeight * qxxPrio;
                    tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(1.0, Infinity);
                    tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(1.0, dof) : null;
                    lambda = tsPrio.getNoncentralityParameter();
                    kPrio = tsPrio.getQuantile();
                    kPost = tsPost != null ? tsPost.getQuantile() : Infinity;
                    confLevelPrio = this.confidenceRegionParameters.getTestStatisticParameter(1.0, Infinity);
                    confLevelPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? this.confidenceRegionParameters.getTestStatisticParameter(1.0, dof) : null;
                    value = additionalUnknownParameter.getValue();
                    if ((additionalUnknownParameter.getParameterType() == ParameterType.ORIENTATION || additionalUnknownParameter.getParameterType() == ParameterType.ROTATION_X || additionalUnknownParameter.getParameterType() == ParameterType.ROTATION_Y || additionalUnknownParameter.getParameterType() == ParameterType.ROTATION_Z) && Math.abs(6.283185307179586 - (value = MathExtension.MOD(value, 6.283185307179586))) < Math.abs(value)) {
                        value -= 6.283185307179586;
                    }
                    nabla = value - additionalUnknownParameter.getExpectationValue();
                    v1 = tPrio = qxxPrio < Constant.EPS ? Infinity : nabla * nabla / qxxPrio;
                    tPost = applyEmpiricalVarianceOfUnitWeight && dof > 0 ? (qxxPost < Constant.EPS ? Infinity : nabla * nabla / qxxPost) : 0.0;
                    pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, 1.0);
                    pPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, 1.0, dof) : 0.0;
                    nabla0 = Math.signum(nabla) * Math.sqrt(Math.abs(lambda * qxxPrio));
                    additionalUnknownParameter.setTprio(tPrio);
                    additionalUnknownParameter.setTpost(tPost);
                    additionalUnknownParameter.setPprio(pPrio);
                    additionalUnknownParameter.setPpost(pPost);
                    additionalUnknownParameter.setStd(Math.sqrt(qxxPost));
                    additionalUnknownParameter.setGrossError(nabla);
                    additionalUnknownParameter.setSignificant(tPrio > kPrio || tPost > kPost);
                    additionalUnknownParameter.setMinimalDetectableBias(nabla0);
                    additionalUnknownParameter.setConfidence(Math.sqrt(qxxPost * (applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? confLevelPost.getQuantile() : confLevelPrio.getQuantile())));
                } else if (!(unknownParameter instanceof StrainParameter)) {
                    System.err.println(String.valueOf(this.getClass()) + " Fehler, unbekannter Parametertyp! " + String.valueOf(unknownParameter));
                }
                ++i;
            }
            if (this.congruenceAnalysisGroup != null && !this.congruenceAnalysisGroup.isEmpty()) {
                for (CongruenceAnalysisGroup tieGroup : this.congruenceAnalysisGroup) {
                    dim = tieGroup.getDimension();
                    strainAnalysisEquations = tieGroup.getStrainAnalysisEquations();
                    v2 = new boolean[2];
                    v2[1] = true;
                    dim = v2;
                    qxxPost = v2.length;
                    cols = 0;
                    while (cols < qxxPost) {
                        flag = dim[cols];
                        tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                        tsPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof) : null;
                        sqrtLambda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                        kPrio = tsPrio.getQuantile();
                        kPost = tsPost != null ? tsPost.getQuantile() : Infinity;
                        tieIdx = 0;
                        while (tieIdx < tieGroup.size(flag)) {
                            tie = tieGroup.get(tieIdx, flag);
                            if (this.interrupt) {
                                return;
                            }
                            p0 = tie.getStartPoint();
                            p1 = tie.getEndPoint();
                            colP0 = p0.getColInJacobiMatrix();
                            colP1 = p1.getColInJacobiMatrix();
                            tieQxx = new UpperSymmPackMatrix(dim);
                            if (colP0 >= 0 || colP1 >= 0) {
                                if (colP0 < 0) {
                                    if (dim == 1 && p1.getDimension() == 3) {
                                        colP1 += 2;
                                    }
                                    r = 0;
                                    while (r < dim) {
                                        c = r;
                                        while (c < dim) {
                                            q22 = this.Qxx.get(colP1 + r, colP1 + c);
                                            tieQxx.set(r, c, q22);
                                            ++c;
                                        }
                                        ++r;
                                    }
                                } else if (colP1 < 0) {
                                    if (dim == 1 && p0.getDimension() == 3) {
                                        colP0 += 2;
                                    }
                                    r = 0;
                                    while (r < dim) {
                                        c = r;
                                        while (c < dim) {
                                            q11 = this.Qxx.get(colP0 + r, colP0 + c);
                                            tieQxx.set(r, c, q11);
                                            ++c;
                                        }
                                        ++r;
                                    }
                                } else {
                                    if (dim == 1 && p0.getDimension() == 3) {
                                        colP0 += 2;
                                    }
                                    if (dim == 1 && p1.getDimension() == 3) {
                                        colP1 += 2;
                                    }
                                    r = 0;
                                    while (r < dim) {
                                        c = r;
                                        while (c < dim) {
                                            q11 = this.Qxx.get(colP0 + r, colP0 + c);
                                            q22 = this.Qxx.get(colP1 + r, colP1 + c);
                                            q12 = this.Qxx.get(colP0 + r, colP1 + c);
                                            q21 = this.Qxx.get(colP1 + r, colP0 + c);
                                            tieQxx.set(r, c, q11 - q12 - q21 + q22);
                                            ++c;
                                        }
                                        ++r;
                                    }
                                }
                                nabla = new double[dim];
                                mdb = new double[dim];
                                normNabla = 0.0;
                                if (dim != 1) {
                                    nabla[0] = p0.getX() - p1.getX();
                                    nabla[1] = p0.getY() - p1.getY();
                                }
                                if (dim != 2) {
                                    nabla[dim - 1] = p0.getZ() - p1.getZ();
                                }
                                r = 0;
                                while (r < dim) {
                                    normNabla += nabla[r] * nabla[r];
                                    ++r;
                                }
                                normNabla = Math.sqrt(normNabla);
                                tiePxx = null;
                                try {
                                    tiePxx = MathExtension.pinv((Matrix)tieQxx, -1);
                                }
                                catch (NotConvergedException nce) {
                                    nce.printStackTrace();
                                }
                                if (tiePxx != null && normNabla > NetworkAdjustment.SQRT_EPS) {
                                    tPost = 0.0;
                                    tPrio = 0.0;
                                    r = 0;
                                    while (r < dim) {
                                        tmp = 0.0;
                                        c = 0;
                                        while (c < dim) {
                                            tmp += tiePxx.get(r, c) * nabla[c];
                                            ++c;
                                        }
                                        tPrio += tmp * nabla[r];
                                        ++r;
                                    }
                                    tPost = applyEmpiricalVarianceOfUnitWeight != false && varianceOfUnitWeight > NetworkAdjustment.SQRT_EPS ? (tPrio /= (double)dim) / varianceOfUnitWeight : 0.0;
                                    nabla0 = new DenseVector(nabla, true);
                                    PxxNabla0 = new DenseVector((Vector)nabla0, true);
                                    tiePxx.mult((Vector)nabla0, (Vector)PxxNabla0);
                                    nPn0 = nabla0.dot((Vector)PxxNabla0);
                                    if (nPn0 > 0.0) {
                                        j = 0;
                                        while (j < dim) {
                                            mdb[j] = sqrtLambda * nabla0.get(j) / Math.sqrt(nPn0);
                                            ++j;
                                        }
                                    }
                                    tie.setTeststatisticValues(tPrio, tPost);
                                }
                                sigma = new double[dim];
                                i = 0;
                                while (i < dim) {
                                    sigma[i] = Math.sqrt(Math.abs(varianceOfUnitWeight * tieQxx.get(i, i)));
                                    ++i;
                                }
                                try {
                                    confidenceRegion = new ConfidenceRegion(this.confidenceRegionParameters, (Matrix)tieQxx, varianceOfUnitWeight, applyEmpiricalVarianceOfUnitWeight != false ? (double)dof : Infinity);
                                    if (confidenceRegion != null) {
                                        tie.setConfidenceRegion(confidenceRegion);
                                        if (normNabla < NetworkAdjustment.SQRT_EPS) {
                                            i = 0;
                                            while (i < dim) {
                                                mdb[i] = sqrtLambda * confidenceRegion.getMinimalDetectableBias(i);
                                                if (this.estimationType != EstimationType.SIMULATION) {
                                                    nabla[i] = mdb[i];
                                                }
                                                ++i;
                                            }
                                        }
                                    }
                                    confidenceRegion = null;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                tie.setMinimalDetectableBiases(mdb);
                                tie.setGrossErrors(nabla);
                                tie.setSigma(sigma);
                                tPrio = tie.getTprio();
                                tPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? tie.getTpost() : 0.0;
                                pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                                pPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof) : 0.0;
                                tie.setProbabilityValues(pPrio, pPost);
                                tie.setSignificant(tPrio > kPrio || tPost > kPost);
                            }
                            ++tieIdx;
                        }
                        ++cols;
                    }
                    nou = strainAnalysisEquations.numberOfParameters();
                    nor = strainAnalysisEquations.numberOfRestrictions();
                    not = tieGroup.size(true);
                    if (!this.congruenceAnalysis || !this.freeNetwork || !strainAnalysisEquations.hasUnconstraintParameters() || not * dim + nor < nou) continue;
                    tsPrioParam = this.significanceTestStatisticParameters.getTestStatisticParameter(1.0, Infinity);
                    tsPostParam = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(1.0, dof) : null;
                    confLevelPrio = this.confidenceRegionParameters.getTestStatisticParameter(1.0, Infinity);
                    confLevelPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? this.confidenceRegionParameters.getTestStatisticParameter(1.0, dof) : null;
                    sqrtLambdaParam = Math.sqrt(Math.abs(tsPrioParam.getNoncentralityParameter()));
                    kPrioParam = tsPrioParam.getQuantile();
                    kPostParam = tsPostParam != null ? tsPostParam.getQuantile() : Infinity;
                    tsPrioTie = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Infinity);
                    tsPostTie = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
                    sqrtLambdaTie = Math.sqrt(Math.abs(tsPrioTie.getNoncentralityParameter()));
                    kPrioTie = tsPrioTie.getQuantile();
                    kPostTie = tsPostTie != null ? tsPostTie.getQuantile() : Infinity;
                    subQxx = new UpperSymmPackMatrix(strainAnalysisEquations.numberOfParameters());
                    r = 0;
                    while (r < subQxx.numRows()) {
                        row = strainAnalysisEquations.get(r).getColInJacobiMatrix();
                        c = r;
                        while (c < subQxx.numRows()) {
                            col = strainAnalysisEquations.get(c).getColInJacobiMatrix();
                            subQxx.set(r, c, this.Qxx.get(row, col));
                            ++c;
                        }
                        ++r;
                    }
                    strainAnalysisEquations.expandParameters(varianceOfUnitWeight, (Matrix)subQxx, applyEmpiricalVarianceOfUnitWeight);
                    i = 0;
                    while (i < strainAnalysisEquations.numberOfParameters()) {
                        parameter = strainAnalysisEquations.get(i);
                        parameter.setMinimalDetectableBias(parameter.getMinimalDetectableBias() * sqrtLambdaParam);
                        tPrio = parameter.getTprio();
                        tPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? parameter.getTpost() : 0.0;
                        pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, 1.0);
                        pPost = applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, 1.0, dof) : 0.0;
                        parameter.setConfidence(parameter.getStd() * (applyEmpiricalVarianceOfUnitWeight != false && dof > 0 ? Math.sqrt(confLevelPost.getQuantile()) : Math.sqrt(confLevelPrio.getQuantile())));
                        parameter.setPprio(pPrio);
                        parameter.setPpost(pPost);
                        parameter.setSignificant(tPrio > kPrioParam || tPost > kPostParam);
                        ++i;
                    }
                    tieIdx = 0;
                    while (tieIdx < tieGroup.size(true)) {
                        tie = tieGroup.get(tieIdx, true);
                        if (this.interrupt) {
                            return;
                        }
                        point = tie.getEndPoint();
                        if (tie.getStartPoint().getColInJacobiMatrix() >= 0 && tie.getEndPoint().getColInJacobiMatrix() >= 0) {
                            observations = point.getObservations();
                            BTPQvvPB = new DenseMatrix(dim, dim);
                            BTPv = new DenseVector(dim);
                            k = 0;
                            while (k < observations.size()) {
                                observationB = observations.get(k);
                                qB = observationB.getStdApriori() * observationB.getStdApriori();
                                vB = this.estimationType == EstimationType.SIMULATION ? 0.0 : -observationB.getObservationalError();
                                b = 0.0;
                                vB = Math.abs(vB) < NetworkAdjustment.SQRT_EPS ? 0.0 : vB;
                                c = 0;
                                while (c < dim) {
                                    if (observationB.getStartPoint().equals(point)) {
                                        if (c == 0 && dim != 1) {
                                            b = observationB.diffXs();
                                        } else if (c == 1) {
                                            b = observationB.diffYs();
                                        } else if (c == 2 || dim == 1) {
                                            b = observationB.diffZs();
                                        }
                                    } else if (observationB.getEndPoint().equals(point)) {
                                        if (c == 0 && dim != 1) {
                                            b = observationB.diffXe();
                                        } else if (c == 1) {
                                            b = observationB.diffYe();
                                        } else if (c == 2 || dim == 1) {
                                            b = observationB.diffZe();
                                        }
                                    }
                                    BTPv.set(c, BTPv.get(c) + b * vB / qB);
                                    j = 0;
                                    while (j < observations.size()) {
                                        observationBT = observations.get(j);
                                        qll = this.getQllElement(observationBT, observationB);
                                        qBT = observationBT.getStdApriori() * observationBT.getStdApriori();
                                        pqvvp = k == j ? Math.max(1.0 / qBT - qll / qBT / qB, 0.0) : -qll / qBT / qB;
                                        r = 0;
                                        while (r < dim) {
                                            bT = 0.0;
                                            if (observationBT.getStartPoint().equals(point)) {
                                                if (r == 0 && dim != 1) {
                                                    bT = observationBT.diffXs();
                                                } else if (r == 1) {
                                                    bT = observationBT.diffYs();
                                                } else if (r == 2 || dim == 1) {
                                                    bT = observationBT.diffZs();
                                                }
                                            } else if (observationBT.getEndPoint().equals(point)) {
                                                if (r == 0 && dim != 1) {
                                                    bT = observationBT.diffXe();
                                                } else if (r == 1) {
                                                    bT = observationBT.diffYe();
                                                } else if (r == 2 || dim == 1) {
                                                    bT = observationBT.diffZe();
                                                }
                                            }
                                            BTPQvvPB.set(r, c, BTPQvvPB.get(r, c) + bT * pqvvp * b);
                                            ++r;
                                        }
                                        ++j;
                                    }
                                    ++c;
                                }
                                ++k;
                            }
                            Qnn = new DenseMatrix(dim, dim);
                            nabla = new DenseVector(dim);
                            isCalculated = false;
                            confidenceRegion = null;
                            try {
                                if (not * dim + nor > nou) {
                                    Qnn = MathExtension.pinv((Matrix)BTPQvvPB, -1);
                                }
                                confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                                isCalculated = true;
                            }
                            catch (NotConvergedException nce) {
                                isCalculated = false;
                            }
                            if (isCalculated) {
                                if (this.estimationType == EstimationType.SIMULATION) {
                                    nabla0 = new DenseVector(dim);
                                    j = 0;
                                    while (j < dim) {
                                        nabla0.set(j, sqrtLambdaTie * confidenceRegion.getMinimalDetectableBias(j));
                                        ++j;
                                    }
                                    tie.setMinimalDetectableBiases(Matrices.getArray((Vector)nabla0));
                                } else {
                                    Qnn.mult((Vector)BTPv, (Vector)nabla);
                                    NablaQnnNabla = BTPv.dot((Vector)nabla);
                                    sigma2apostTie = dof - dim > 0 ? (this.omega - NablaQnnNabla) / (double)(dof - dim) : 0.0;
                                    tPrio = NablaQnnNabla / (double)dim;
                                    tPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 && sigma2apostTie > NetworkAdjustment.SQRT_EPS ? tPrio / sigma2apostTie : 0.0;
                                    nabla = nabla.scale(-1.0);
                                    nabla0 = new DenseVector((Vector)nabla, true);
                                    PQvvPnabla0 = new DenseVector((Vector)nabla0);
                                    BTPQvvPB.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                                    nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                                    if (nQn0 > 0.0) {
                                        j = 0;
                                        while (j < dim) {
                                            nabla0.set(j, sqrtLambdaTie * nabla0.get(j) / Math.sqrt(nQn0));
                                            ++j;
                                        }
                                    }
                                    tie.setMinimalDetectableBiases(Matrices.getArray((Vector)nabla0));
                                    tie.setGrossErrors(Matrices.getArray((Vector)nabla));
                                    pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
                                    pPost = applyEmpiricalVarianceOfUnitWeight != false && dof - dim > 0 ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
                                    tie.setTeststatisticValues(tPrio, tPost);
                                    tie.setProbabilityValues(pPrio, pPost);
                                    tie.setSignificant(tPrio > kPrioTie || tPost > kPostTie);
                                }
                            }
                        }
                        ++tieIdx;
                    }
                }
            } else {
                this.congruenceAnalysisGroup = new ArrayList<CongruenceAnalysisGroup>(0);
            }
        }
    }

    private void addSubRedundanceAndCofactor2Observations() {
        LinkedHashSet<Integer> gnssObsIds = new LinkedHashSet<Integer>();
        int i = 0;
        while (i < this.numberOfObservations) {
            boolean isGNSS;
            Observation observation = this.projectObservations.get(i);
            boolean bl = isGNSS = observation.getObservationType() == ObservationType.GNSS1D || observation.getObservationType() == ObservationType.GNSS2D || observation.getObservationType() == ObservationType.GNSS3D;
            if (!isGNSS || !gnssObsIds.contains(observation.getId())) {
                if (isGNSS) {
                    gnssObsIds.add(observation.getId());
                }
                this.addSubRedundanceAndCofactor(observation);
            }
            ++i;
        }
    }

    private void addStochasticParameters2Observations(double sigma2apost, int dof, double sigma2PointMax) {
        LinkedHashSet<Integer> gnssObsIds = new LinkedHashSet<Integer>();
        int i = 0;
        while (i < this.numberOfObservations) {
            boolean isGNSS;
            Observation observation = this.projectObservations.get(i);
            boolean isCalculated = false;
            double nPn = 0.0;
            boolean bl = isGNSS = observation.getObservationType() == ObservationType.GNSS1D || observation.getObservationType() == ObservationType.GNSS2D || observation.getObservationType() == ObservationType.GNSS3D;
            if (!isGNSS || !gnssObsIds.contains(observation.getId())) {
                if (isGNSS) {
                    int j;
                    gnssObsIds.add(observation.getId());
                    GNSSBaseline gnss = (GNSSBaseline)observation;
                    int dim = gnss.getDimension();
                    TestStatisticParameterSet tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Double.POSITIVE_INFINITY);
                    double sqrtLambda = Math.sqrt(Math.abs(tsPrio.getNoncentralityParameter()));
                    List<Observation> baseline = gnss.getBaselineComponents();
                    double traceR = 0.0;
                    Matrix subPQvvP = gnss.getBaselineRedundancyMatrix();
                    Matrix ATQxxBP = this.ATQxxBP_GNSS_EP.remove(gnss.getId());
                    Matrix PAzTQzzAzP = this.PAzTQzzAzP_GNSS_EF.remove(gnss.getId());
                    if (subPQvvP == null) {
                        subPQvvP = new DenseMatrix(dim, dim);
                    }
                    if (ATQxxBP == null) {
                        ATQxxBP = new DenseMatrix(dim, dim);
                    }
                    if (PAzTQzzAzP == null) {
                        PAzTQzzAzP = new DenseMatrix(dim, dim);
                    }
                    DenseMatrix subPsubPQvvP = new DenseMatrix(subPQvvP);
                    int k = 0;
                    while (k < dim) {
                        Observation obs = baseline.get(k);
                        double qll = obs.getStdApriori() * obs.getStdApriori();
                        traceR += Math.abs(subPQvvP.get(k, k));
                        j = 0;
                        while (j < dim) {
                            double pqvvp = 1.0 / qll * subPQvvP.get(k, j);
                            subPQvvP.set(k, j, pqvvp);
                            subPsubPQvvP.set(k, j, k == j ? Math.max(1.0 / qll - pqvvp, 0.0) : -pqvvp);
                            ++j;
                        }
                        ++k;
                    }
                    DenseMatrix Qnn = new DenseMatrix(dim, dim);
                    ConfidenceRegion confidenceRegion = null;
                    try {
                        Qnn = MathExtension.pinv(subPQvvP, -1);
                        confidenceRegion = new ConfidenceRegion((Matrix)Qnn);
                        isCalculated = true;
                    }
                    catch (NotConvergedException nce) {
                        isCalculated = false;
                        nce.printStackTrace();
                    }
                    if (isCalculated && traceR > SQRT_EPS) {
                        if (this.estimationType == EstimationType.SIMULATION) {
                            DenseVector nabla0 = new DenseVector(dim);
                            DenseVector ep = new DenseVector(gnss.getDimension());
                            j = 0;
                            while (j < dim) {
                                nabla0.set(j, confidenceRegion.getMinimalDetectableBias(j) * sqrtLambda);
                                ++j;
                            }
                            ATQxxBP.mult((Vector)nabla0, (Vector)ep);
                            DenseVector Mnabla0 = new DenseVector(dim);
                            PAzTQzzAzP.mult((Vector)nabla0, (Vector)Mnabla0);
                            double uz2 = nabla0.dot((Vector)Mnabla0);
                            subPsubPQvvP.mult((Vector)nabla0, (Vector)Mnabla0);
                            du2 = nabla0.dot((Vector)Mnabla0);
                            int j2 = 0;
                            while (j2 < dim) {
                                double nablaJ = nabla0.get(j2);
                                baseline.get(j2).setMinimalDetectableBias(nablaJ);
                                baseline.get(j2).setMaximumTolerableBias(confidenceRegion.getMinimalDetectableBias(j2));
                                baseline.get(j2).setGrossError(nablaJ);
                                baseline.get(j2).setInfluenceOnPointPosition(ep.get(j2));
                                baseline.get(j2).setInfluenceOnNetworkDistortion(Math.sqrt(sigma2PointMax * Math.abs(du2 - uz2)));
                                ++j2;
                            }
                        } else {
                            DenseVector subPv = new DenseVector(dim);
                            int j3 = 0;
                            while (j3 < dim) {
                                subPv.set(j3, baseline.get(j3).getObservationalError() / baseline.get(j3).getStdApriori() / baseline.get(j3).getStdApriori());
                                ++j3;
                            }
                            DenseVector nabla = new DenseVector(gnss.getDimension());
                            DenseVector ep = new DenseVector(gnss.getDimension());
                            Qnn.mult((Vector)subPv, (Vector)nabla);
                            nPn = subPv.dot((Vector)nabla);
                            nabla = nabla.scale(-1.0);
                            ATQxxBP.mult((Vector)nabla, (Vector)ep);
                            DenseVector Mnabla = new DenseVector(dim);
                            PAzTQzzAzP.mult((Vector)nabla, (Vector)Mnabla);
                            double uz2 = nabla.dot((Vector)Mnabla);
                            subPsubPQvvP.mult((Vector)nabla, (Vector)Mnabla);
                            double du2 = nabla.dot((Vector)Mnabla);
                            DenseVector nabla0 = new DenseVector((Vector)nabla, true);
                            DenseVector PQvvPnabla0 = new DenseVector((Vector)nabla0);
                            subPQvvP.mult((Vector)nabla0, (Vector)PQvvPnabla0);
                            double nQn0 = nabla0.dot((Vector)PQvvPnabla0);
                            int j4 = 0;
                            while (j4 < dim) {
                                double mtb = 0.0;
                                if (nQn0 > 0.0) {
                                    mtb = nabla0.get(j4) / Math.sqrt(nQn0);
                                }
                                baseline.get(j4).setMinimalDetectableBias(mtb * sqrtLambda);
                                baseline.get(j4).setMaximumTolerableBias(mtb);
                                baseline.get(j4).setGrossError(nabla.get(j4));
                                baseline.get(j4).setInfluenceOnPointPosition(ep.get(j4));
                                baseline.get(j4).setInfluenceOnNetworkDistortion(Math.sqrt(sigma2PointMax * Math.abs(du2 - uz2)));
                                ++j4;
                            }
                        }
                    }
                    int j5 = 0;
                    while (j5 < dim) {
                        this.addStochasticParameters2Observation(baseline.get(j5), sigma2apost, dof, nPn);
                        ++j5;
                    }
                } else {
                    TestStatisticParameterSet tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(1.0, Double.POSITIVE_INFINITY);
                    double lamda = Math.abs(tsPrio.getNoncentralityParameter());
                    double qll = observation.getStdApriori() * observation.getStdApriori();
                    double r = observation.getRedundancy();
                    double v = this.estimationType == EstimationType.SIMULATION ? 0.0 : observation.getObservationalError();
                    double pvv = v * v / qll;
                    double mdb = r > SQRT_EPS ? Math.sqrt(Math.abs(lamda * qll / r)) : 0.0;
                    double mtb = r > SQRT_EPS ? Math.sqrt(Math.abs(qll / r)) : 0.0;
                    observation.setMinimalDetectableBias(mdb);
                    observation.setMaximumTolerableBias(mtb);
                    double dist = 1.0;
                    if (observation.getObservationType() == ObservationType.DIRECTION || observation.getObservationType() == ObservationType.ZENITH_ANGLE) {
                        dist = observation.getStartPoint().getDimension() == 3 && observation.getEndPoint().getDimension() == 3 ? observation.getCalculatedDistance3D() : observation.getCalculatedDistance2D();
                    }
                    if (r > SQRT_EPS) {
                        if (this.estimationType != EstimationType.SIMULATION) {
                            nPn = pvv / r;
                            double nabla = v / r;
                            double uz2 = nabla * observation.getInfluenceOnNetworkDistortion() * nabla;
                            double du2 = nabla * (1.0 - r) / qll * nabla;
                            observation.setGrossError(nabla);
                            observation.setInfluenceOnPointPosition(observation.getInfluenceOnPointPosition() * nabla * dist);
                            observation.setInfluenceOnNetworkDistortion(Math.sqrt(sigma2PointMax * Math.abs(du2 - uz2)));
                            observation.setMinimalDetectableBias(Math.signum(v) * mdb);
                            observation.setMaximumTolerableBias(Math.signum(v) * mtb);
                        } else {
                            double uz2 = mdb * observation.getInfluenceOnNetworkDistortion() * mdb;
                            du2 = mdb * (1.0 - r) / qll * mdb;
                            observation.setGrossError(mdb);
                            observation.setInfluenceOnPointPosition(observation.getInfluenceOnPointPosition() * mdb * dist);
                            observation.setInfluenceOnNetworkDistortion(Math.sqrt(sigma2PointMax * Math.abs(du2 - uz2)));
                        }
                    } else {
                        observation.setInfluenceOnPointPosition(0.0);
                        observation.setInfluenceOnNetworkDistortion(0.0);
                    }
                    this.addStochasticParameters2Observation(observation, sigma2apost, dof, nPn);
                }
            }
            ++i;
        }
    }

    private void addStochasticParameters2Observation(Observation obs, double sigma2apost, int dof, double nPn) {
        double sigma = obs.getStd();
        if (sigma > 0.0) {
            obs.setStd(Math.sqrt(sigma2apost * sigma * sigma));
        }
        if (this.estimationType != EstimationType.SIMULATION) {
            int dim = obs.getObservationType() == ObservationType.GNSS1D || obs.getObservationType() == ObservationType.GNSS2D || obs.getObservationType() == ObservationType.GNSS3D ? ((GNSSBaseline)obs).getDimension() : 1;
            double omega = sigma2apost * (double)dof;
            double sigma2apostObs = dof - dim > 0 && omega > nPn ? (omega - nPn) / (double)(dof - dim) : 0.0;
            sigma2apostObs = sigma2apostObs > SQRT_EPS ? sigma2apostObs : 0.0;
            boolean applyEmpiricalVarianceOfUnitWeight = this.applyAposterioriVarianceOfUnitWeight && dof - dim > 0 && sigma2apostObs > SQRT_EPS;
            double tPrio = nPn / (double)dim;
            double tPost = applyEmpiricalVarianceOfUnitWeight ? tPrio / sigma2apostObs : 0.0;
            double pPrio = TestStatistic.getLogarithmicProbabilityValue(tPrio, dim);
            double pPost = applyEmpiricalVarianceOfUnitWeight ? TestStatistic.getLogarithmicProbabilityValue(tPost, dim, dof - dim) : 0.0;
            obs.setTestAndProbabilityValues(tPrio, tPost, pPrio, pPost);
            TestStatisticParameterSet tsPrio = this.significanceTestStatisticParameters.getTestStatisticParameter(dim, Double.POSITIVE_INFINITY);
            TestStatisticParameterSet tsPost = applyEmpiricalVarianceOfUnitWeight ? this.significanceTestStatisticParameters.getTestStatisticParameter(dim, dof - dim) : null;
            double kPrio = tsPrio.getQuantile();
            double kPost = tsPost != null ? tsPost.getQuantile() : Double.POSITIVE_INFINITY;
            obs.setSignificant(obs.getTprio() > kPrio || obs.getTpost() > kPost || this.adaptedObservationUncertainties.containsKey(obs));
        }
    }

    private void addVerticalDeflectionToModel() {
        for (Point point : this.pointsWithUnknownDeflection) {
            this.addUnknownParameter(point.getVerticalDeflectionX());
            this.addUnknownParameter(point.getVerticalDeflectionY());
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            this.addUnknownParameter(point.getVerticalDeflectionX());
            this.addUnknownParameter(point.getVerticalDeflectionY());
        }
    }

    private void addStochasticPointsAndStochasticDeflectionToModel() {
        VarianceComponentType vcType;
        int row = this.numberOfObservations;
        for (Point point : this.pointsWithStochasticDeflection) {
            point.getVerticalDeflectionX().setRowInJacobiMatrix(row++);
            point.getVerticalDeflectionY().setRowInJacobiMatrix(row++);
            this.numberOfStochasticDeflectionRows += 2;
        }
        for (Point point : this.stochasticPoints) {
            point.setRowInJacobiMatrix(row);
            row += point.getDimension();
            this.addUnknownParameter(point);
        }
        if (this.numberOfStochasticDeflectionRows > 0 && (vcType = VarianceComponentType.STOCHASTIC_DEFLECTION_COMPONENT) != null && !this.varianceComponents.containsKey((Object)vcType)) {
            this.varianceComponents.put(vcType, new VarianceComponent(vcType));
        }
    }

    private void addStrainParametersToModel() {
        for (CongruenceAnalysisGroup tieGroup : this.congruenceAnalysisGroup) {
            StrainAnalysisEquations strainAnalysisEquations = tieGroup.getStrainAnalysisEquations();
            int nou = strainAnalysisEquations.numberOfParameters();
            int nor = strainAnalysisEquations.numberOfRestrictions();
            int not = tieGroup.size(true);
            int dim = tieGroup.getDimension();
            if (!strainAnalysisEquations.hasUnconstraintParameters() || not * dim + nor < nou) continue;
            int i = 0;
            while (i < strainAnalysisEquations.numberOfParameters()) {
                if (strainAnalysisEquations.get(i).getColInJacobiMatrix() < 0) {
                    this.addUnknownParameter(strainAnalysisEquations.get(i));
                }
                ++i;
            }
        }
    }

    public boolean addDatumPoint(Point point, VerticalDeflectionType verticalDeflectionType) {
        if ((this.stochasticPoints == null || this.stochasticPoints.isEmpty()) && (this.referencePoints == null || this.referencePoints.isEmpty()) && this.addNewPoint(point, verticalDeflectionType)) {
            this.datumPoints.add(point);
            this.freeNetwork = true;
            return true;
        }
        return false;
    }

    public boolean addReferencePoint(Point point, VerticalDeflectionType verticalDeflectionType) {
        if (this.freeNetwork || this.allPoints.containsKey(point.getName())) {
            System.err.println(String.valueOf(this.getClass()) + " Fehler, ein Punkt mit der ID " + point.getName() + " existiert bereits!");
            return false;
        }
        point.setColInDesignmatrixOfModelErros(this.numberOfFixPointRows);
        this.numberOfFixPointRows += point.getDimension();
        this.referencePoints.add(point);
        this.addObservations(point);
        this.allPoints.put(point.getName(), point);
        if (verticalDeflectionType != null) {
            if (verticalDeflectionType == VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION) {
                this.pointsWithReferenceDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION) {
                this.pointsWithStochasticDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                this.pointsWithUnknownDeflection.add(point);
            }
        }
        return true;
    }

    public boolean addStochasticPoint(Point point, VerticalDeflectionType verticalDeflectionType) {
        VarianceComponentType vcType;
        if (this.freeNetwork || this.allPoints.containsKey(point.getName())) {
            System.err.println(String.valueOf(this.getClass()) + " Fehler, ein Punkt mit der ID " + point.getName() + " existiert bereits!");
            return false;
        }
        this.stochasticPoints.add(point);
        this.allPoints.put(point.getName(), point);
        this.numberOfStochasticPointRows += point.getDimension();
        if (verticalDeflectionType != null) {
            if (verticalDeflectionType == VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION) {
                this.pointsWithReferenceDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION) {
                this.pointsWithStochasticDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                this.pointsWithUnknownDeflection.add(point);
            }
        }
        if ((vcType = VarianceComponentType.getComponentTypeByPointDimension(point.getDimension())) != null && !this.varianceComponents.containsKey((Object)vcType)) {
            this.varianceComponents.put(vcType, new VarianceComponent(vcType));
        }
        return true;
    }

    public boolean addNewPoint(Point point, VerticalDeflectionType verticalDeflectionType) {
        int dim = point.getDimension();
        if (verticalDeflectionType != null && verticalDeflectionType == VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
            dim += 2;
        }
        if (this.allPoints.containsKey(point.getName())) {
            System.err.println(String.valueOf(this.getClass()) + "\nFehler, ein Punkt mit der ID " + point.getName() + " existiert bereits!");
            return false;
        }
        if (dim > point.getObservations().size()) {
            System.err.println(String.valueOf(this.getClass()) + "\nFehler, Punkt " + point.getName() + " besitzt nicht genuegend Beobachtungen um bestimmt zu werden! Punkt wird ignoriert. Dim = " + dim + ", Obs = " + point.getObservations().size());
            return false;
        }
        this.addUnknownParameter(point);
        this.allPoints.put(point.getName(), point);
        if (verticalDeflectionType != null) {
            if (verticalDeflectionType == VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION) {
                this.pointsWithReferenceDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION) {
                this.pointsWithStochasticDeflection.add(point);
            } else if (verticalDeflectionType == VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                this.pointsWithUnknownDeflection.add(point);
            }
        }
        return true;
    }

    public boolean addAdditionalUnknownParameter(AdditionalUnknownParameter additionalUnknownParameter) {
        if (this.unknownParameters.contains(additionalUnknownParameter)) {
            System.err.println(String.valueOf(this.getClass()) + "\nFehler, der Parameter wurde bereits hinzugefuegt!");
            return false;
        }
        if (additionalUnknownParameter.getObservations().size() == 0) {
            System.err.println(String.valueOf(this.getClass()) + "\nFehler, Parameter hat keine Verknuepfung zu Beobachtungen und kann somit\nnicht bestimmt werden! Parameter wird ignoriert.\n" + String.valueOf(additionalUnknownParameter));
            return false;
        }
        this.addUnknownParameter(additionalUnknownParameter);
        return true;
    }

    private void addUnknownParameter(UnknownParameter unknownParameter) {
        this.addObservations(unknownParameter);
        this.unknownParameters.add(unknownParameter);
        this.numberOfUnknownParameters = this.unknownParameters.columnsInJacobi();
    }

    private void addObservations(UnknownParameter unknownParameter) {
        int i = 0;
        while (i < unknownParameter.getObservations().size()) {
            Observation observation = unknownParameter.getObservations().get(i);
            if (observation.getRowInJacobiMatrix() < 0) {
                observation.setRowInJacobiMatrix(this.numberOfObservations++);
                this.projectObservations.add(observation);
                VarianceComponentType vcType = VarianceComponentType.getVarianceComponentTypeByObservationType(observation.getObservationType());
                if (vcType != null && !this.varianceComponents.containsKey((Object)vcType)) {
                    this.varianceComponents.put(vcType, new VarianceComponent(vcType));
                }
            }
            ++i;
        }
    }

    public boolean addCongruenceAnalysisGroup(CongruenceAnalysisGroup congruenceAnalysisGroup) {
        if (!this.congruenceAnalysisGroup.contains(congruenceAnalysisGroup) && congruenceAnalysisGroup.totalSize() > 0) {
            this.congruenceAnalysisGroup.add(congruenceAnalysisGroup);
            return true;
        }
        return false;
    }

    public UnknownParameters getUnknownParameters() {
        return this.unknownParameters;
    }

    public RankDefect detectRankDefect() {
        if (!this.freeNetwork || this.rankDefect.isUserDefinedRankDefect()) {
            return this.rankDefect;
        }
        this.rankDefect.reset();
        boolean is3DNet = false;
        boolean is2DNet = false;
        boolean is1DNet = false;
        int eigenValueDefectCounter = -1;
        int i = 0;
        while (i < this.datumPoints.size()) {
            Point point = this.datumPoints.get(i);
            if (point.getDimension() != 2) {
                this.rankDefect.setTranslationZ(DefectType.FREE);
            }
            if (point.getDimension() != 1) {
                this.rankDefect.setTranslationX(DefectType.FREE);
                this.rankDefect.setTranslationY(DefectType.FREE);
            }
            if (!is3DNet && point.getDimension() == 3) {
                is3DNet = true;
                is2DNet = false;
                is1DNet = false;
            } else if (!is3DNet && !is2DNet && point.getDimension() == 2) {
                is2DNet = true;
            } else if (!is3DNet && !is1DNet && point.getDimension() == 1) {
                is1DNet = true;
            }
            ++i;
        }
        if (this.proofOfDatumDefectDetection) {
            try {
                int maxDefect = 0;
                maxDefect = is1DNet ? 2 : (is2DNet ? 4 : 7);
                maxDefect = Math.min(maxDefect, this.numberOfUnknownParameters);
                NormalEquationSystem neq = this.createNormalEquation();
                UpperSymmPackMatrix N = neq.getMatrix();
                Matrix[] eig = MathExtension.eig(N, this.numberOfUnknownParameters, 1, maxDefect, false);
                double[] values = new double[maxDefect];
                double threshold = 0.0;
                int i2 = 0;
                while (i2 < maxDefect) {
                    values[i2] = Math.abs(eig[0].get(i2, i2));
                    if (is1DNet && i2 < 1) {
                        threshold += values[i2];
                    } else if (is2DNet && i2 < 2) {
                        threshold += values[i2] / 2.0;
                    } else if (is3DNet && i2 < 3) {
                        threshold += values[i2] / 3.0;
                    }
                    ++i2;
                }
                threshold = 10.0 * (threshold + SQRT_EPS);
                eigenValueDefectCounter = 0;
                i2 = 0;
                while (i2 < maxDefect) {
                    eigenValueDefectCounter += Math.abs(eig[0].get(i2, i2)) < threshold ? 1 : 0;
                    ++i2;
                }
            }
            catch (IllegalArgumentException | NotConvergedException e) {
                eigenValueDefectCounter = -1;
                e.printStackTrace();
            }
        }
        if (is1DNet) {
            this.rankDefect.setScaleZ(DefectType.FREE);
            this.rankDefect.setRotationX(DefectType.FREE);
            this.rankDefect.setRotationY(DefectType.FREE);
        }
        if (is2DNet) {
            this.rankDefect.setScaleXY(DefectType.FREE);
            this.rankDefect.setRotationZ(DefectType.FREE);
        }
        if (is3DNet) {
            this.rankDefect.setScaleXYZ(DefectType.FREE);
            this.rankDefect.setRotationX(DefectType.FREE);
            this.rankDefect.setRotationY(DefectType.FREE);
            this.rankDefect.setRotationZ(DefectType.FREE);
        }
        int deltaH2PointsWithKnownDeflections = 0;
        int zenithangleStationsWithKnownDeflections = 0;
        HashSet<Pair> zenithangleStationNamesWithKnownDeflections = new HashSet<Pair>();
        int i3 = 0;
        while (i3 < this.numberOfObservations) {
            Observation observation = this.projectObservations.get(i3);
            ObservationGroup observationGroup = observation.getObservationGroup();
            int numberOfAddParams = observationGroup.numberOfAdditionalUnknownParameter();
            int groupSize = observationGroup.size();
            if (groupSize > numberOfAddParams) {
                if (observation instanceof DeltaZ) {
                    if (observation.getStartPoint().getDimension() != 2 && observation.getEndPoint().getDimension() != 2 && (!observation.getStartPoint().hasUnknownDeflectionParameters() || !observation.getEndPoint().hasUnknownDeflectionParameters() || observation.getStartPoint().hasUnknownDeflectionParameters() && observation.getStartPoint().hasObservedDeflectionParameters() || observation.getEndPoint().hasUnknownDeflectionParameters() && observation.getEndPoint().hasObservedDeflectionParameters())) {
                        if (!observation.getStartPoint().hasUnknownDeflectionParameters()) {
                            ++deltaH2PointsWithKnownDeflections;
                        }
                        if (!observation.getEndPoint().hasUnknownDeflectionParameters()) {
                            ++deltaH2PointsWithKnownDeflections;
                        }
                    }
                    if (!is3DNet) {
                        if (!((DeltaZ)observation).getScale().isEnable()) {
                            this.rankDefect.setScaleZ(DefectType.FIXED);
                        } else if (this.rankDefect.getScaleZ() != DefectType.FIXED) {
                            this.rankDefect.setScaleZ(DefectType.FREE);
                        }
                    } else if (!((DeltaZ)observation).getScale().isEnable()) {
                        this.rankDefect.setScaleXYZ(DefectType.FIXED);
                    } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                        this.rankDefect.setScaleXYZ(DefectType.FREE);
                    }
                } else if (observation instanceof Direction) {
                    if (!((Direction)observation).getOrientation().isEnable()) {
                        this.rankDefect.setRotationZ(DefectType.FIXED);
                    } else if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                        this.rankDefect.setRotationZ(DefectType.FREE);
                    }
                } else if (observation instanceof HorizontalDistance) {
                    if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                        this.rankDefect.setRotationZ(DefectType.FREE);
                    }
                    if (!is3DNet) {
                        if (!((HorizontalDistance)observation).getScale().isEnable()) {
                            this.rankDefect.setScaleXY(DefectType.FIXED);
                        } else if (this.rankDefect.getScaleXY() != DefectType.FIXED) {
                            this.rankDefect.setScaleXY(DefectType.FREE);
                        }
                    } else if (!((HorizontalDistance)observation).getScale().isEnable()) {
                        this.rankDefect.setScaleXYZ(DefectType.FIXED);
                    } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                        this.rankDefect.setScaleXYZ(DefectType.FREE);
                    }
                } else if (observation instanceof SlopeDistance) {
                    if (this.rankDefect.getRotationX() != DefectType.FIXED) {
                        this.rankDefect.setRotationX(DefectType.FREE);
                    }
                    if (this.rankDefect.getRotationY() != DefectType.FIXED) {
                        this.rankDefect.setRotationY(DefectType.FREE);
                    }
                    if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                        this.rankDefect.setRotationZ(DefectType.FREE);
                    }
                    if (!((SlopeDistance)observation).getScale().isEnable()) {
                        this.rankDefect.setScaleXYZ(DefectType.FIXED);
                    } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                        this.rankDefect.setScaleXYZ(DefectType.FREE);
                    }
                } else if (observation instanceof ZenithAngle) {
                    if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                        this.rankDefect.setRotationZ(DefectType.FREE);
                    }
                    Pair stationAndTargetNames = new Pair((Object)observation.getStartPoint().getName(), (Object)observation.getEndPoint().getName());
                    if (observation.getStartPoint().getDimension() == 3 && !zenithangleStationNamesWithKnownDeflections.contains(stationAndTargetNames) && (!observation.getStartPoint().hasUnknownDeflectionParameters() || observation.getStartPoint().hasUnknownDeflectionParameters() && observation.getStartPoint().hasObservedDeflectionParameters())) {
                        ++zenithangleStationsWithKnownDeflections;
                        zenithangleStationNamesWithKnownDeflections.add(stationAndTargetNames);
                    }
                } else if (observation instanceof GNSSBaseline1D) {
                    if (((GNSSBaseline1D)observation).getDimension() >= 1) {
                        double gnssZ = ((GNSSBaseline1D)observation).getBaselineComponent(ComponentType.Z).getValueApriori();
                        ObservationGroup startPointObservations = observation.getStartPoint().getObservations();
                        ObservationGroup endPointObservations = observation.getEndPoint().getObservations();
                        int gnssCompCntStart = 0;
                        int j = 0;
                        while (j < startPointObservations.size()) {
                            if (startPointObservations.get(j) instanceof GNSSBaseline1D && ((GNSSBaseline1D)observation).getDimension() >= 1 && ++gnssCompCntStart > 1) break;
                            ++j;
                        }
                        int gnssCompCntEnd = 0;
                        int j2 = 0;
                        while (j2 < endPointObservations.size()) {
                            if (endPointObservations.get(j2) instanceof GNSSBaseline1D && ((GNSSBaseline1D)observation).getDimension() >= 1 && ++gnssCompCntEnd > 1) break;
                            ++j2;
                        }
                        if (gnssZ != 0.0) {
                            if (!is3DNet) {
                                if (!((GNSSBaseline1D)observation).getScale().isEnable()) {
                                    this.rankDefect.setScaleZ(DefectType.FIXED);
                                } else if (this.rankDefect.getScaleZ() != DefectType.FIXED) {
                                    this.rankDefect.setScaleZ(DefectType.FREE);
                                }
                            } else if (!((GNSSBaseline1D)observation).getScale().isEnable()) {
                                this.rankDefect.setScaleXYZ(DefectType.FIXED);
                            } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                                this.rankDefect.setScaleXYZ(DefectType.FREE);
                            }
                        }
                        if (gnssCompCntStart > 1 || gnssCompCntEnd > 1) {
                            if (!((GNSSBaseline1D)observation).getRotationX().isEnable()) {
                                this.rankDefect.setRotationX(DefectType.FIXED);
                            } else if (this.rankDefect.getRotationX() != DefectType.FIXED) {
                                this.rankDefect.setRotationX(DefectType.FREE);
                            }
                            if (!((GNSSBaseline1D)observation).getRotationY().isEnable()) {
                                this.rankDefect.setRotationY(DefectType.FIXED);
                            } else if (this.rankDefect.getRotationY() != DefectType.FIXED) {
                                this.rankDefect.setRotationY(DefectType.FREE);
                            }
                        }
                    }
                } else if (observation instanceof GNSSBaseline2D) {
                    if (((GNSSBaseline2D)observation).getDimension() >= 2) {
                        double gnssX = ((GNSSBaseline2D)observation).getBaselineComponent(ComponentType.X).getValueApriori();
                        double gnssY = ((GNSSBaseline2D)observation).getBaselineComponent(ComponentType.Y).getValueApriori();
                        if (gnssX != 0.0 || gnssY != 0.0) {
                            ObservationGroup startPointObservations = observation.getStartPoint().getObservations();
                            ObservationGroup endPointObservations = observation.getEndPoint().getObservations();
                            int gnssCompCntStart = 0;
                            int j = 0;
                            while (j < startPointObservations.size()) {
                                if (startPointObservations.get(j) instanceof GNSSBaseline2D && ((GNSSBaseline2D)observation).getDimension() >= 2 && ++gnssCompCntStart > 2) break;
                                ++j;
                            }
                            int gnssCompCntEnd = 0;
                            int j3 = 0;
                            while (j3 < endPointObservations.size()) {
                                if (endPointObservations.get(j3) instanceof GNSSBaseline2D && ((GNSSBaseline2D)observation).getDimension() >= 2 && ++gnssCompCntEnd > 2) break;
                                ++j3;
                            }
                            if (!is3DNet) {
                                if (!((GNSSBaseline2D)observation).getScale().isEnable()) {
                                    this.rankDefect.setScaleXY(DefectType.FIXED);
                                } else if (this.rankDefect.getScaleXY() != DefectType.FIXED) {
                                    this.rankDefect.setScaleXY(DefectType.FREE);
                                }
                            } else if (!((GNSSBaseline2D)observation).getScale().isEnable()) {
                                this.rankDefect.setScaleXYZ(DefectType.FIXED);
                            } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                                this.rankDefect.setScaleXYZ(DefectType.FREE);
                            }
                            if (gnssCompCntStart > 2 || gnssCompCntEnd > 2) {
                                if (!((GNSSBaseline2D)observation).getRotationZ().isEnable()) {
                                    this.rankDefect.setRotationZ(DefectType.FIXED);
                                } else if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                                    this.rankDefect.setRotationZ(DefectType.FREE);
                                }
                            }
                        }
                    }
                } else if (observation instanceof GNSSBaseline3D && ((GNSSBaseline3D)observation).getDimension() >= 3) {
                    double gnssX = ((GNSSBaseline3D)observation).getBaselineComponent(ComponentType.X).getValueApriori();
                    double gnssY = ((GNSSBaseline3D)observation).getBaselineComponent(ComponentType.Y).getValueApriori();
                    double gnssZ = ((GNSSBaseline3D)observation).getBaselineComponent(ComponentType.Z).getValueApriori();
                    if (gnssX != 0.0 || gnssY != 0.0 || gnssZ != 0.0) {
                        ObservationGroup startPointObservations = observation.getStartPoint().getObservations();
                        ObservationGroup endPointObservations = observation.getEndPoint().getObservations();
                        int gnssCompCntStart = 0;
                        int j = 0;
                        while (j < startPointObservations.size()) {
                            if (startPointObservations.get(j) instanceof GNSSBaseline3D && ((GNSSBaseline3D)observation).getDimension() >= 3 && ++gnssCompCntStart > 3) break;
                            ++j;
                        }
                        int gnssCompCntEnd = 0;
                        int j4 = 0;
                        while (j4 < endPointObservations.size()) {
                            if (endPointObservations.get(j4) instanceof GNSSBaseline3D && ((GNSSBaseline3D)observation).getDimension() >= 3 && ++gnssCompCntEnd > 3) break;
                            ++j4;
                        }
                        if (!((GNSSBaseline3D)observation).getScale().isEnable()) {
                            this.rankDefect.setScaleXYZ(DefectType.FIXED);
                        } else if (this.rankDefect.getScaleXYZ() != DefectType.FIXED) {
                            this.rankDefect.setScaleXYZ(DefectType.FREE);
                        }
                        if (gnssCompCntStart > 3 || gnssCompCntEnd > 3) {
                            if (gnssY != 0.0 || gnssZ != 0.0) {
                                if (!((GNSSBaseline3D)observation).getRotationX().isEnable()) {
                                    this.rankDefect.setRotationX(DefectType.FIXED);
                                } else if (this.rankDefect.getRotationX() != DefectType.FIXED) {
                                    this.rankDefect.setRotationX(DefectType.FREE);
                                }
                            }
                            if (gnssX != 0.0 || gnssZ != 0.0) {
                                if (!((GNSSBaseline3D)observation).getRotationY().isEnable()) {
                                    this.rankDefect.setRotationY(DefectType.FIXED);
                                } else if (this.rankDefect.getRotationY() != DefectType.FIXED) {
                                    this.rankDefect.setRotationY(DefectType.FREE);
                                }
                            }
                            if (gnssX != 0.0 || gnssY != 0.0) {
                                if (!((GNSSBaseline3D)observation).getRotationZ().isEnable()) {
                                    this.rankDefect.setRotationZ(DefectType.FIXED);
                                } else if (this.rankDefect.getRotationZ() != DefectType.FIXED) {
                                    this.rankDefect.setRotationZ(DefectType.FREE);
                                }
                            }
                        }
                    }
                }
            }
            ++i3;
        }
        if (deltaH2PointsWithKnownDeflections > 1) {
            this.rankDefect.setRotationX(DefectType.FIXED);
            this.rankDefect.setRotationY(DefectType.FIXED);
        }
        if (zenithangleStationsWithKnownDeflections > 1) {
            this.rankDefect.setRotationX(DefectType.FIXED);
            this.rankDefect.setRotationY(DefectType.FIXED);
        }
        if (!is1DNet && deltaH2PointsWithKnownDeflections == 1) {
            if (this.rankDefect.getRotationX() == DefectType.FREE) {
                this.rankDefect.setRotationX(DefectType.FIXED);
            } else if (this.rankDefect.getRotationY() == DefectType.FREE) {
                this.rankDefect.setRotationY(DefectType.FIXED);
            }
        }
        if (zenithangleStationsWithKnownDeflections == 1) {
            if (this.rankDefect.getRotationX() == DefectType.FREE) {
                this.rankDefect.setRotationX(DefectType.FIXED);
            } else if (this.rankDefect.getRotationY() == DefectType.FREE) {
                this.rankDefect.setRotationY(DefectType.FIXED);
            }
        }
        if (is2DNet && this.rankDefect.getScaleXY() == DefectType.NOT_SET) {
            this.rankDefect.setScaleXY(DefectType.FREE);
        }
        if (is3DNet && this.rankDefect.getScaleXYZ() == DefectType.NOT_SET) {
            this.rankDefect.setScaleXYZ(DefectType.FREE);
        }
        if (this.proofOfDatumDefectDetection && eigenValueDefectCounter != -1 && eigenValueDefectCounter != this.rankDefect.getDefect()) {
            System.err.println("Error, the defect of the normal equations system is not equal to its theoretical value: " + eigenValueDefectCounter + " vs. " + this.rankDefect.getDefect());
        }
        return this.rankDefect;
    }

    public RankDefect getRankDefect() {
        return this.rankDefect;
    }

    private Vector getCorrectionVector(Vector dx) {
        DenseVector v = new DenseVector(this.numberOfStochasticPointRows + this.numberOfObservations + this.numberOfStochasticDeflectionRows);
        int i = 0;
        while (i < this.numberOfObservations) {
            VerticalDeflectionY deflY;
            int dim;
            Observation observation = this.projectObservations.get(i);
            ObservationGroup observationGroup = observation.getObservationGroup();
            Point startPoint = observation.getStartPoint();
            Point endPoint = observation.getStartPoint();
            int row = observation.getRowInJacobiMatrix();
            int colInJacobiStart = startPoint.getColInJacobiMatrix();
            int colInJacobiEnd = endPoint.getColInJacobiMatrix();
            int dimStart = startPoint.getDimension();
            int dimEnd = endPoint.getDimension();
            double aDx = 0.0;
            if (colInJacobiStart >= 0) {
                dim = 0;
                if (dimStart != 1) {
                    aDx += dx.get(colInJacobiStart + dim) * observation.diffXs();
                    aDx += dx.get(colInJacobiStart + ++dim) * observation.diffYs();
                    ++dim;
                }
                if (dimStart != 2) {
                    aDx += dx.get(colInJacobiStart + dim) * observation.diffZs();
                }
            }
            if (colInJacobiEnd >= 0) {
                dim = 0;
                if (dimEnd != 1) {
                    aDx += dx.get(colInJacobiEnd + dim) * observation.diffXe();
                    aDx += dx.get(colInJacobiEnd + ++dim) * observation.diffYe();
                    ++dim;
                }
                if (dimEnd != 2) {
                    aDx += dx.get(colInJacobiEnd + dim) * observation.diffZe();
                }
            }
            if (startPoint.hasUnknownDeflectionParameters()) {
                VerticalDeflectionX deflX = startPoint.getVerticalDeflectionX();
                deflY = startPoint.getVerticalDeflectionY();
                aDx += dx.get(deflX.getColInJacobiMatrix()) * observation.diffVerticalDeflectionXs();
                aDx += dx.get(deflY.getColInJacobiMatrix()) * observation.diffVerticalDeflectionYs();
            }
            if (endPoint.hasUnknownDeflectionParameters()) {
                VerticalDeflectionX deflX = endPoint.getVerticalDeflectionX();
                deflY = endPoint.getVerticalDeflectionY();
                aDx += dx.get(deflX.getColInJacobiMatrix()) * observation.diffVerticalDeflectionXe();
                aDx += dx.get(deflY.getColInJacobiMatrix()) * observation.diffVerticalDeflectionYe();
            }
            if (observationGroup.numberOfAdditionalUnknownParameter() > 0) {
                AdditionalUnknownParameter addPar;
                if (observation instanceof DeltaZ) {
                    AdditionalUnknownParameter addPar2 = ((DeltaZ)observation).getScale();
                    if (addPar2.isEnable()) {
                        aDx += dx.get(addPar2.getColInJacobiMatrix()) * observation.diffScale();
                    }
                } else if (observation instanceof Direction) {
                    AdditionalUnknownParameter addPar3 = ((Direction)observation).getOrientation();
                    if (addPar3.isEnable()) {
                        aDx += dx.get(addPar3.getColInJacobiMatrix()) * observation.diffOri();
                    }
                } else if (observation instanceof HorizontalDistance) {
                    AdditionalUnknownParameter addPar4 = ((HorizontalDistance)observation).getScale();
                    if (addPar4.isEnable()) {
                        aDx += dx.get(addPar4.getColInJacobiMatrix()) * observation.diffScale();
                    }
                    if ((addPar4 = ((HorizontalDistance)observation).getZeroPointOffset()).isEnable()) {
                        aDx += dx.get(addPar4.getColInJacobiMatrix()) * observation.diffAdd();
                    }
                } else if (observation instanceof SlopeDistance) {
                    AdditionalUnknownParameter addPar5 = ((SlopeDistance)observation).getScale();
                    if (addPar5.isEnable()) {
                        aDx += dx.get(addPar5.getColInJacobiMatrix()) * observation.diffScale();
                    }
                    if ((addPar5 = ((SlopeDistance)observation).getZeroPointOffset()).isEnable()) {
                        aDx += dx.get(addPar5.getColInJacobiMatrix()) * observation.diffAdd();
                    }
                } else if (observation instanceof ZenithAngle && (addPar = ((ZenithAngle)observation).getRefractionCoefficient()).isEnable()) {
                    aDx += dx.get(addPar.getColInJacobiMatrix()) * observation.diffRefCoeff();
                }
            }
            v.set(row, aDx - observation.getObservationalError());
            ++i;
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            int col = point.getVerticalDeflectionX().getColInJacobiMatrix();
            int row = point.getVerticalDeflectionX().getRowInJacobiMatrix();
            v.set(row, dx.get(col));
            col = point.getVerticalDeflectionY().getColInJacobiMatrix();
            row = point.getVerticalDeflectionY().getRowInJacobiMatrix();
            v.set(row, dx.get(col));
        }
        for (Point point : this.stochasticPoints) {
            int row = point.getRowInJacobiMatrix();
            int col = point.getColInJacobiMatrix();
            int dim = point.getDimension();
            if (row < 0) continue;
            int j = 0;
            while (j < dim) {
                v.set(row + j, dx.get(col + j));
                ++j;
            }
        }
        return v;
    }

    public TestStatisticParameters getConfidenceRegionParameters() {
        if (this.confidenceRegionParameters != null) {
            return this.confidenceRegionParameters;
        }
        this.confidenceRegionParameters = new TestStatisticParameters(this.getTestStatistic(this.confidenceRegionDefinition));
        return this.confidenceRegionParameters;
    }

    public TestStatisticParameters getSignificanceTestStatisticParameters() {
        if (this.significanceTestStatisticParameters != null) {
            return this.significanceTestStatisticParameters;
        }
        this.significanceTestStatisticParameters = new TestStatisticParameters(this.getTestStatistic(this.testStatisticDefinition));
        return this.significanceTestStatisticParameters;
    }

    public BinomialTestStatisticParameters getBinomialTestStatisticParameters() {
        if (this.binomialTestStatisticParameters != null) {
            return this.binomialTestStatisticParameters;
        }
        this.binomialTestStatisticParameters = new BinomialTestStatisticParameters(this.getTestStatistic(this.testStatisticDefinition));
        return this.binomialTestStatisticParameters;
    }

    TestStatistic getTestStatistic(TestStatisticDefinition testStatisticDefinition) {
        double alpha = testStatisticDefinition.getProbabilityValue();
        double beta = testStatisticDefinition.getPowerOfTest();
        int dof = this.degreeOfFreedom();
        return switch (testStatisticDefinition.getTestStatisticType()) {
            case TestStatisticType.SIDAK -> new SidakTestStatistic(this.numberOfHypotesis, alpha, beta, testStatisticDefinition.isFamilywiseErrorRate());
            case TestStatisticType.BAARDA_METHOD -> new BaardaMethodTestStatistic(testStatisticDefinition.isFamilywiseErrorRate() ? dof : 1, alpha, beta);
            case TestStatisticType.NONE -> new UnadjustedTestStatitic(alpha, beta);
            default -> throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, unknown test statistic method " + String.valueOf((Object)testStatisticDefinition.getTestStatisticType()));
        };
    }

    public EstimationStateType getEstimationStateType() {
        return this.currentEstimationStatus;
    }

    public boolean isEstimateModel() {
        return this.currentEstimationStatus == EstimationStateType.ERROR_FREE_ESTIMATION;
    }

    public int getCurrentIterationStep() {
        return this.iterationStep < 0 ? 0 : this.iterationStep;
    }

    public int degreeOfFreedom() {
        return (int)Math.rint(this.degreeOfFreedom);
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    public int getNumberOfUnknownParameters() {
        return this.numberOfUnknownParameters;
    }

    public double getOmega() {
        return this.omega;
    }

    @Override
    public void run() {
        this.estimateModel();
    }

    public boolean calculateStochasticParameters() {
        return this.calculateStochasticParameters;
    }

    public void setConfidenceRegionDefinition(TestStatisticDefinition confidenceRegionDefinition) {
        this.confidenceRegionDefinition = confidenceRegionDefinition;
    }

    public void setTestStatisticDefinition(TestStatisticDefinition testStatisticDefinition) {
        this.testStatisticDefinition = testStatisticDefinition;
    }

    public double getConvergenceThreshold() {
        return SQRT_EPS;
    }

    public int getMaximalNumberOfIterations() {
        return this.maximalNumberOfIterations;
    }

    public EstimationType getEstimationType() {
        return this.estimationType;
    }

    public void setMaximalNumberOfIterations(int maximalNumberOfIterations) {
        this.maximalNumberOfIterations = maximalNumberOfIterations < 0 || maximalNumberOfIterations > DefaultValue.getMaximumNumberOfIterations() ? DefaultValue.getMaximumNumberOfIterations() : maximalNumberOfIterations;
    }

    public void setEstimationType(EstimationType estimationType) {
        this.estimationType = estimationType;
    }

    public void setApplyAposterioriVarianceOfUnitWeight(boolean applyAposterioriVarianceOfUnitWeight) {
        this.applyAposterioriVarianceOfUnitWeight = applyAposterioriVarianceOfUnitWeight;
    }

    public void setCongruenceAnalysis(boolean congruenceAnalysis) {
        this.congruenceAnalysis = congruenceAnalysis;
    }

    public double getFinalLinearisationError() {
        return this.finalLinearisationError;
    }

    public void setRobustEstimationLimit(double robustEstimationLimit) {
        this.robustEstimationLimit = robustEstimationLimit > 0.0 ? robustEstimationLimit : DefaultValue.getRobustEstimationLimit();
    }

    public double getUnscentedTransformationScaling() {
        return this.alphaUT;
    }

    public double getUnscentedTransformationDamping() {
        return this.betaUT;
    }

    public double getUnscentedTransformationWeightZero() {
        return this.weightZero;
    }

    public void setUnscentedTransformationScaling(double alpha) {
        if (alpha > 0.0) {
            this.alphaUT = alpha;
        }
    }

    public void setUnscentedTransformationDamping(double beta) {
        this.betaUT = beta;
    }

    public void setUnscentedTransformationWeightZero(double w0) {
        if (w0 < 1.0) {
            this.weightZero = w0;
        }
    }

    Matrix getJacobiMatrix() {
        DenseMatrix A = new DenseMatrix(this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows, this.numberOfUnknownParameters);
        int u = 0;
        while (u < this.unknownParameters.size()) {
            UnknownParameter unknownParameterA = this.unknownParameters.get(u);
            ObservationGroup observaionGroupA = unknownParameterA.getObservations();
            int colA = unknownParameterA.getColInJacobiMatrix();
            int dimA = 1;
            switch (unknownParameterA.getParameterType()) {
                case POINT2D: {
                    dimA = 2;
                    break;
                }
                case POINT3D: {
                    dimA = 3;
                    break;
                }
                default: {
                    dimA = 1;
                }
            }
            int i = 0;
            while (i < dimA) {
                colA = unknownParameterA.getColInJacobiMatrix() + i;
                int j = 0;
                while (j < observaionGroupA.size()) {
                    Observation observationA = observaionGroupA.get(j);
                    double a = 0.0;
                    int rowA = observationA.getRowInJacobiMatrix();
                    if (unknownParameterA.getParameterType() == ParameterType.POINT1D) {
                        p = (Point)unknownParameterA;
                        if (p.equals(observationA.getStartPoint())) {
                            a = observationA.diffZs();
                        } else if (p.equals(observationA.getEndPoint())) {
                            a = observationA.diffZe();
                        }
                    } else if (unknownParameterA.getParameterType() == ParameterType.POINT2D) {
                        p = (Point)unknownParameterA;
                        if (p.equals(observationA.getStartPoint())) {
                            if (i == 0) {
                                a = observationA.diffXs();
                            } else if (i == 1) {
                                a = observationA.diffYs();
                            }
                        } else if (p.equals(observationA.getEndPoint())) {
                            if (i == 0) {
                                a = observationA.diffXe();
                            } else if (i == 1) {
                                a = observationA.diffYe();
                            }
                        }
                    } else if (unknownParameterA.getParameterType() == ParameterType.POINT3D) {
                        p = (Point)unknownParameterA;
                        if (p.equals(observationA.getStartPoint())) {
                            if (i == 0) {
                                a = observationA.diffXs();
                            } else if (i == 1) {
                                a = observationA.diffYs();
                            } else if (i == 2) {
                                a = observationA.diffZs();
                            }
                        } else if (p.equals(observationA.getEndPoint())) {
                            if (i == 0) {
                                a = observationA.diffXe();
                            } else if (i == 1) {
                                a = observationA.diffYe();
                            } else if (i == 2) {
                                a = observationA.diffZe();
                            }
                        }
                    } else if (unknownParameterA.getParameterType() == ParameterType.VERTICAL_DEFLECTION_X) {
                        deflection = (VerticalDeflectionX)unknownParameterA;
                        p = deflection.getPoint();
                        if (p.equals(observationA.getStartPoint())) {
                            a = observationA.diffVerticalDeflectionXs();
                        } else if (p.equals(observationA.getEndPoint())) {
                            a = observationA.diffVerticalDeflectionXe();
                        }
                    } else if (unknownParameterA.getParameterType() == ParameterType.VERTICAL_DEFLECTION_Y) {
                        deflection = (VerticalDeflectionY)unknownParameterA;
                        p = deflection.getPoint();
                        if (p.equals(observationA.getStartPoint())) {
                            a = observationA.diffVerticalDeflectionYs();
                        } else if (p.equals(observationA.getEndPoint())) {
                            a = observationA.diffVerticalDeflectionYe();
                        }
                    } else if (unknownParameterA.getParameterType() == ParameterType.ORIENTATION) {
                        a = observationA.diffOri();
                    } else if (unknownParameterA.getParameterType() == ParameterType.ZERO_POINT_OFFSET) {
                        a = observationA.diffAdd();
                    } else if (unknownParameterA.getParameterType() == ParameterType.SCALE) {
                        a = observationA.diffScale();
                    } else if (unknownParameterA.getParameterType() == ParameterType.REFRACTION_INDEX) {
                        a = observationA.diffRefCoeff();
                    } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_X) {
                        a = observationA.diffRotX();
                    } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_Y) {
                        a = observationA.diffRotY();
                    } else if (unknownParameterA.getParameterType() == ParameterType.ROTATION_Z) {
                        a = observationA.diffRotZ();
                    }
                    A.set(rowA, colA, a);
                    ++j;
                }
                ++i;
            }
            ++u;
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
            VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
            A.set(deflectionX.getRowInJacobiMatrix(), deflectionX.getColInJacobiMatrix(), 1.0);
            A.set(deflectionY.getRowInJacobiMatrix(), deflectionY.getColInJacobiMatrix(), 1.0);
        }
        for (Point point : this.stochasticPoints) {
            int col = point.getColInJacobiMatrix();
            int row = point.getRowInJacobiMatrix();
            if (point.getDimension() != 1) {
                A.set(row++, col++, 1.0);
                A.set(row++, col++, 1.0);
            }
            if (point.getDimension() == 2) continue;
            A.set(row, col, 1.0);
        }
        return A;
    }

    Vector getWeightedMatrix() {
        DenseVector W = new DenseVector(this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows);
        int i = 0;
        while (i < this.numberOfObservations) {
            Observation observation = this.projectObservations.get(i);
            W.set(observation.getRowInJacobiMatrix(), 1.0 / observation.getStdApriori() / observation.getStdApriori());
            ++i;
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
            VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
            W.set(deflectionX.getRowInJacobiMatrix(), 1.0 / deflectionX.getStdApriori() / deflectionX.getStdApriori());
            W.set(deflectionY.getRowInJacobiMatrix(), 1.0 / deflectionY.getStdApriori() / deflectionY.getStdApriori());
        }
        for (Point point : this.stochasticPoints) {
            int dim = point.getDimension();
            int row = point.getRowInJacobiMatrix();
            if (dim != 1) {
                W.set(row++, 1.0 / point.getStdXApriori() / point.getStdXApriori());
                W.set(row++, 1.0 / point.getStdYApriori() / point.getStdYApriori());
            }
            if (dim == 2) continue;
            W.set(row++, 1.0 / point.getStdZApriori() / point.getStdZApriori());
        }
        return W;
    }

    private Vector getObservationalErrors() {
        DenseVector e = new DenseVector(this.numberOfObservations + this.numberOfStochasticPointRows + this.numberOfStochasticDeflectionRows);
        int i = 0;
        while (i < this.numberOfObservations) {
            Observation observation = this.projectObservations.get(i);
            e.set(observation.getRowInJacobiMatrix(), observation.getObservationalError());
            ++i;
        }
        for (Point point : this.pointsWithStochasticDeflection) {
            VerticalDeflectionX deflectionX = point.getVerticalDeflectionX();
            VerticalDeflectionY deflectionY = point.getVerticalDeflectionY();
            if (deflectionX.getRowInJacobiMatrix() < 0 || deflectionY.getRowInJacobiMatrix() < 0) continue;
            e.set(deflectionX.getRowInJacobiMatrix(), deflectionX.getValue0() - deflectionX.getValue());
            e.set(deflectionY.getRowInJacobiMatrix(), deflectionY.getValue0() - deflectionY.getValue());
        }
        for (Point point : this.stochasticPoints) {
            int dim = point.getDimension();
            int row = point.getRowInJacobiMatrix();
            if (dim != 1) {
                e.set(row++, point.getX0() - point.getX());
                e.set(row++, point.getY0() - point.getY());
            }
            if (dim == 2) continue;
            e.set(row++, point.getZ0() - point.getZ());
        }
        return e;
    }

    public double getVarianceFactorAposteriori() {
        return this.degreeOfFreedom > 0.0 && this.omega > 0.0 && this.estimationType != EstimationType.SIMULATION && this.applyAposterioriVarianceOfUnitWeight ? Math.abs(this.omega / this.degreeOfFreedom) : 1.0;
    }

    public Map<VarianceComponentType, VarianceComponent> getVarianceComponents() {
        return this.varianceComponents;
    }

    public double getMeanRedundancy() {
        int nd = this.degreeOfFreedom() + this.numberOfUnknownParameters;
        return nd > 0 ? 1.0 - (double)this.numberOfUnknownParameters / (double)nd : 0.0;
    }

    public double getTraceOfCovarianceMatrixOfPoints() {
        return this.traceCxxPoints;
    }

    public void setNumberOfPrincipalComponents(int numberOfPrincipalComponents) {
        this.numberOfPrincipalComponents = numberOfPrincipalComponents < 0 ? 0 : numberOfPrincipalComponents;
    }

    public PrincipalComponent[] getPrincipalComponents() {
        return this.principalComponents;
    }

    private void estimatePrincipalComponentAnalysis(int numberOfComponents) {
        block13: {
            try {
                this.currentEstimationStatus = EstimationStateType.PRINCIPAL_COMPONENT_ANALYSIS;
                this.change.firePropertyChange(this.currentEstimationStatus.name(), false, true);
                double sigma2apost = this.getVarianceFactorAposteriori();
                int n = this.unknownParameters.columnsOfPoints();
                if (this.Qxx == null || n <= 0 || numberOfComponents <= 0) break block13;
                Matrix[] evalEvec = MathExtension.eig(this.Qxx, n, Math.max(n - numberOfComponents + 1, 1), n, true);
                UpperSymmBandMatrix eval = (UpperSymmBandMatrix)evalEvec[0];
                DenseMatrix evec = (DenseMatrix)evalEvec[1];
                numberOfComponents = eval.numColumns();
                double sqrtFPC = 0.0;
                this.principalComponents = new PrincipalComponent[numberOfComponents];
                int i = 0;
                while (i < numberOfComponents) {
                    PrincipalComponent principalComponent;
                    this.principalComponents[i] = principalComponent = new PrincipalComponent(n - i, Math.abs(sigma2apost * eval.get(numberOfComponents - 1 - i, numberOfComponents - 1 - i)));
                    if (i == 0) {
                        sqrtFPC = Math.sqrt(principalComponent.getValue());
                    }
                    ++i;
                }
                i = 0;
                while (i < this.unknownParameters.size()) {
                    if (this.interrupt) {
                        return;
                    }
                    try {
                        UnknownParameter unknownParameter = this.unknownParameters.get(i);
                        int row = unknownParameter.getColInJacobiMatrix();
                        int col = numberOfComponents - 1;
                        if (unknownParameter instanceof Point && row >= 0) {
                            Point point = (Point)unknownParameter;
                            int dim = point.getDimension();
                            double[] principalComponents = new double[dim];
                            if (dim != 1) {
                                principalComponents[0] = sqrtFPC * evec.get(row++, col);
                                principalComponents[1] = sqrtFPC * evec.get(row++, col);
                            }
                            if (dim != 2) {
                                principalComponents[dim - 1] = sqrtFPC * evec.get(row++, col);
                            }
                            point.setFirstPrincipalComponents(principalComponents);
                        }
                        ++i;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            finally {
                this.Qxx = null;
            }
        }
    }

    private void applySphericalVerticalDeflections() {
        if (this.sphericalDeflectionModel != null) {
            for (Point point : this.allPoints.values()) {
                this.sphericalDeflectionModel.setSphericalDeflections(point);
            }
        }
    }

    public void setSphericalDeflectionModel(SphericalDeflectionModel sphericalDeflectionModel) {
        this.sphericalDeflectionModel = sphericalDeflectionModel;
    }

    public boolean hasAdjustmentResultWriter() {
        return this.adjustmentResultWriter != null;
    }

    public void setAdjustmentResultWritable(AdjustmentResultWritable adjustmentResultWriter) {
        this.adjustmentResultWriter = adjustmentResultWriter;
    }

    private void exportAdjustmentResults() throws NullPointerException, IOException {
        if (this.adjustmentResultWriter == null) {
            return;
        }
        this.currentEstimationStatus = EstimationStateType.EXPORT_ADJUSTMENT_RESULTS;
        if (this.adjustmentResultWriter instanceof NetworkAdjustmentResultWriter) {
            this.change.firePropertyChange(this.currentEstimationStatus.name(), null, ((NetworkAdjustmentResultWriter)this.adjustmentResultWriter).getExportPathAndFileBaseName());
        }
        this.adjustmentResultWriter.export(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    public void clearMatrices() {
        this.Qxx = null;
        this.ATQxxBP_GNSS_EP = null;
        this.PAzTQzzAzP_GNSS_EF = null;
    }
}

