/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import java.io.BufferedInputStream;
import java.util.Properties;

public final class DefaultUncertainty {
    private static final double ANGLE_ZERO_POINT_OFFSET = 4.7123889803846896E-6;
    private static final double ANGLE_SQUARE_ROOT_DISTANCE_DEPENDENT = 0.0;
    private static final double ANGLE_DISTANCE_DEPENDENT = 5.0E-4;
    private static final double DISTANCE_ZERO_POINT_OFFSET = 0.002;
    private static final double DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT = 0.0;
    private static final double DISTANCE_DISTANCE_DEPENDENT = 2.0E-6;
    private static final double LEVELING_ZERO_POINT_OFFSET = 1.0E-4;
    private static final double LEVELING_SQUARE_ROOT_DISTANCE_DEPENDENT = 0.001;
    private static final double LEVELING_DISTANCE_DEPENDENT = 0.0;
    private static final double GNSS_ZERO_POINT_OFFSET = 0.025;
    private static final double GNSS_SQUARE_ROOT_DISTANCE_DEPENDENT = 0.0;
    private static final double GNSS_DISTANCE_DEPENDENT = 5.0E-5;
    private static final double X = 0.002;
    private static final double Y = 0.002;
    private static final double Z = 0.002;
    private static final double DEFLECTION_X = 1.5707963267948967E-5;
    private static final double DEFLECTION_Y = 1.5707963267948967E-5;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/uncertainties.default";
        try {
            try {
                if (DefaultUncertainty.class.getClassLoader().getResourceAsStream("properties/uncertainties.default") != null) {
                    bis = new BufferedInputStream(DefaultUncertainty.class.getClassLoader().getResourceAsStream("properties/uncertainties.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultUncertainty() {
    }

    public static double getUncertaintyAngleZeroPointOffset() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("ANGLE_ZERO_POINT_OFFSET"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : 4.7123889803846896E-6;
    }

    public static double getUncertaintyAngleSquareRootDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("ANGLE_SQUARE_ROOT_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.0;
    }

    public static double getUncertaintyAngleDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("ANGLE_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 5.0E-4;
    }

    public static double getUncertaintyDistanceZeroPointOffset() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DISTANCE_ZERO_POINT_OFFSET"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : 0.002;
    }

    public static double getUncertaintyDistanceSquareRootDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DISTANCE_SQUARE_ROOT_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.0;
    }

    public static double getUncertaintyDistanceDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DISTANCE_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 2.0E-6;
    }

    public static double getUncertaintyLevelingZeroPointOffset() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("LEVELING_ZERO_POINT_OFFSET"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : 1.0E-4;
    }

    public static double getUncertaintyLevelingSquareRootDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("LEVELING_SQUARE_ROOT_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.001;
    }

    public static double getUncertaintyLevelingDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("LEVELING_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.0;
    }

    public static double getUncertaintyGNSSZeroPointOffset() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS_ZERO_POINT_OFFSET"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : 0.025;
    }

    public static double getUncertaintyGNSSSquareRootDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS_SQUARE_ROOT_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.0;
    }

    public static double getUncertaintyGNSSDistanceDependent() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS_DISTANCE_DEPENDENT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 5.0E-5;
    }

    public static double getUncertaintyX() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("X"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.002;
    }

    public static double getUncertaintyY() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("Y"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.002;
    }

    public static double getUncertaintyZ() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("Z"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 0.002;
    }

    public static double getUncertaintyDeflectionX() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DEFLECTION_X"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 1.5707963267948967E-5;
    }

    public static double getUncertaintyDeflectionY() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DEFLECTION_Y"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value >= 0.0 ? value : 1.5707963267948967E-5;
    }
}

