/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network;

import java.io.BufferedInputStream;
import java.util.Properties;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.ObservationType;

public class DefaultAverageThreshold {
    private static final double LEVELING = DefaultUncertainty.getUncertaintyLevelingZeroPointOffset() * 10.0;
    private static final double DIRECTION = DefaultUncertainty.getUncertaintyAngleZeroPointOffset() * 10.0;
    private static final double ZENITH_ANGLE = DefaultUncertainty.getUncertaintyAngleZeroPointOffset() * 10.0;
    private static final double HORIZONTAL_DISTANCE = DefaultUncertainty.getUncertaintyDistanceZeroPointOffset() * 10.0;
    private static final double SLOPE_DISTANCE = DefaultUncertainty.getUncertaintyDistanceZeroPointOffset() * 10.0;
    private static final double GNSS1D = DefaultUncertainty.getUncertaintyGNSSZeroPointOffset() * 10.0;
    private static final double GNSS2D = DefaultUncertainty.getUncertaintyGNSSZeroPointOffset() * 10.0;
    private static final double GNSS3D = DefaultUncertainty.getUncertaintyGNSSZeroPointOffset() * 10.0;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/averagethresholds.default";
        try {
            try {
                if (DefaultAverageThreshold.class.getClassLoader().getResourceAsStream("properties/averagethresholds.default") != null) {
                    bis = new BufferedInputStream(DefaultAverageThreshold.class.getClassLoader().getResourceAsStream("properties/averagethresholds.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultAverageThreshold() {
    }

    public static double getThresholdLeveling() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("LEVELING"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : LEVELING;
    }

    public static double getThresholdDirection() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("DIRECTION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : DIRECTION;
    }

    public static double getThresholdZenithAngle() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("ZENITH_ANGLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : ZENITH_ANGLE;
    }

    public static double getThresholdHorizontalDistance() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("HORIZONTAL_DISTANCE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : HORIZONTAL_DISTANCE;
    }

    public static double getThresholdSlopeDistance() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("SLOPE_DISTANCE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : SLOPE_DISTANCE;
    }

    public static double getThresholdGNSSBaseline1D() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS1D"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : GNSS1D;
    }

    public static double getThresholdGNSSBaseline2D() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS2D"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : GNSS2D;
    }

    public static double getThresholdGNSSBaseline3D() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("GNSS3D"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : GNSS3D;
    }

    public static double getThreshold(ObservationType type) {
        switch (type) {
            case LEVELING: {
                return DefaultAverageThreshold.getThresholdLeveling();
            }
            case DIRECTION: {
                return DefaultAverageThreshold.getThresholdDirection();
            }
            case HORIZONTAL_DISTANCE: {
                return DefaultAverageThreshold.getThresholdHorizontalDistance();
            }
            case SLOPE_DISTANCE: {
                return DefaultAverageThreshold.getThresholdSlopeDistance();
            }
            case ZENITH_ANGLE: {
                return DefaultAverageThreshold.getThresholdZenithAngle();
            }
            case GNSS1D: {
                return DefaultAverageThreshold.getThresholdGNSSBaseline1D();
            }
            case GNSS2D: {
                return DefaultAverageThreshold.getThresholdGNSSBaseline2D();
            }
            case GNSS3D: {
                return DefaultAverageThreshold.getThresholdGNSSBaseline3D();
            }
        }
        return 0.0;
    }
}

