/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface.primitive;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Surface;

public class Plane
extends Surface {
    private Map<ParameterType, UnknownParameter> parameters;
    private ProductSumRestriction vectorLengthRestriction;

    public Plane() {
        this.init();
    }

    public void setInitialGuess(double nx, double ny, double nz, double d) throws IllegalArgumentException {
        UnknownParameter Nx = this.parameters.get((Object)ParameterType.VECTOR_X);
        UnknownParameter Ny = this.parameters.get((Object)ParameterType.VECTOR_Y);
        UnknownParameter Nz = this.parameters.get((Object)ParameterType.VECTOR_Z);
        UnknownParameter D0 = this.parameters.get((Object)ParameterType.LENGTH);
        if (Nx.getProcessingType() == ProcessingType.ADJUSTMENT) {
            Nx.setValue0(nx);
        }
        if (Ny.getProcessingType() == ProcessingType.ADJUSTMENT) {
            Ny.setValue0(ny);
        }
        if (Nz.getProcessingType() == ProcessingType.ADJUSTMENT) {
            Nz.setValue0(nz);
        }
        if (D0.getProcessingType() == ProcessingType.ADJUSTMENT) {
            D0.setValue0(d);
        }
    }

    @Override
    public void jacobianElements(FeaturePoint point, Matrix Jx, Matrix Jv, int rowIndex) {
        Point centerOfMass = this.getCenterOfMass();
        double xi = point.getX() - centerOfMass.getX0();
        double yi = point.getY() - centerOfMass.getY0();
        double zi = point.getZ() - centerOfMass.getZ0();
        UnknownParameter nx = this.parameters.get((Object)ParameterType.VECTOR_X);
        UnknownParameter ny = this.parameters.get((Object)ParameterType.VECTOR_Y);
        UnknownParameter nz = this.parameters.get((Object)ParameterType.VECTOR_Z);
        if (Jx != null) {
            UnknownParameter d = this.parameters.get((Object)ParameterType.LENGTH);
            if (nx.getColumn() >= 0) {
                Jx.set(rowIndex, nx.getColumn(), xi);
            }
            if (ny.getColumn() >= 0) {
                Jx.set(rowIndex, ny.getColumn(), yi);
            }
            if (nz.getColumn() >= 0) {
                Jx.set(rowIndex, nz.getColumn(), zi);
            }
            if (d.getColumn() >= 0) {
                Jx.set(rowIndex, d.getColumn(), -1.0);
            }
        }
        if (Jv != null) {
            Jv.set(rowIndex, 0, nx.getValue());
            Jv.set(rowIndex, 1, ny.getValue());
            Jv.set(rowIndex, 2, nz.getValue());
        }
    }

    @Override
    public double getMisclosure(FeaturePoint point) {
        Point centerOfMass = this.getCenterOfMass();
        double xi = point.getX() - centerOfMass.getX0();
        double yi = point.getY() - centerOfMass.getY0();
        double zi = point.getZ() - centerOfMass.getZ0();
        double nx = this.parameters.get((Object)ParameterType.VECTOR_X).getValue();
        double ny = this.parameters.get((Object)ParameterType.VECTOR_Y).getValue();
        double nz = this.parameters.get((Object)ParameterType.VECTOR_Z).getValue();
        double d = this.parameters.get((Object)ParameterType.LENGTH).getValue();
        return nx * xi + ny * yi + nz * zi - d;
    }

    @Override
    public void setCenterOfMass(Point centerOfMass) {
        Point prevCenterOfMass = this.getCenterOfMass();
        boolean equalComponents = centerOfMass.equalsCoordinateComponents(prevCenterOfMass);
        super.setCenterOfMass(centerOfMass);
        if (equalComponents) {
            return;
        }
        Point currCenterOfMass = this.getCenterOfMass();
        double nx = this.parameters.get((Object)ParameterType.VECTOR_X).getValue();
        double ny = this.parameters.get((Object)ParameterType.VECTOR_Y).getValue();
        double nz = this.parameters.get((Object)ParameterType.VECTOR_Z).getValue();
        UnknownParameter d = this.parameters.get((Object)ParameterType.LENGTH);
        double dist = d.getValue();
        dist += nx * prevCenterOfMass.getX0() + ny * prevCenterOfMass.getY0() + nz * prevCenterOfMass.getZ0();
        d.setValue(dist -= nx * currCenterOfMass.getX0() + ny * currCenterOfMass.getY0() + nz * currCenterOfMass.getZ0());
    }

    @Override
    public void reverseCenterOfMass(UpperSymmPackMatrix Dp) {
        Point centerOfMass = this.getCenterOfMass();
        UnknownParameter nx = this.parameters.get((Object)ParameterType.VECTOR_X);
        UnknownParameter ny = this.parameters.get((Object)ParameterType.VECTOR_Y);
        UnknownParameter nz = this.parameters.get((Object)ParameterType.VECTOR_Z);
        UnknownParameter d = this.parameters.get((Object)ParameterType.LENGTH);
        if (Dp != null) {
            int nou = Dp.numColumns();
            DenseMatrix J = Matrices.identity((int)nou);
            if (d.getColumn() >= 0) {
                if (nx.getColumn() >= 0) {
                    J.set(d.getColumn(), nx.getColumn(), centerOfMass.getX0());
                }
                if (ny.getColumn() >= 0) {
                    J.set(d.getColumn(), ny.getColumn(), centerOfMass.getY0());
                }
                if (nz.getColumn() >= 0) {
                    J.set(d.getColumn(), nz.getColumn(), centerOfMass.getZ0());
                }
                J.set(d.getColumn(), d.getColumn(), 1.0);
                DenseMatrix JDp = new DenseMatrix(nou, nou);
                J.mult((Matrix)Dp, (Matrix)JDp);
                JDp.transBmult((Matrix)J, (Matrix)Dp);
            }
        }
        double dist = d.getValue() + nx.getValue() * centerOfMass.getX0() + ny.getValue() * centerOfMass.getY0() + nz.getValue() * centerOfMass.getZ0();
        d.setValue(dist);
    }

    @Override
    public Collection<Restriction> getRestrictions() {
        return List.of(this.vectorLengthRestriction);
    }

    @Override
    public Collection<UnknownParameter> getUnknownParameters() {
        return this.parameters.values();
    }

    @Override
    public UnknownParameter getUnknownParameter(ParameterType parameterType) {
        return this.parameters.get((Object)parameterType);
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.parameters.get((Object)((UnknownParameter)object).getParameterType()) == object;
    }

    private void init() {
        this.parameters = new LinkedHashMap<ParameterType, UnknownParameter>();
        this.parameters.put(ParameterType.VECTOR_X, new UnknownParameter(ParameterType.VECTOR_X, true, 0.0));
        this.parameters.put(ParameterType.VECTOR_Y, new UnknownParameter(ParameterType.VECTOR_Y, true, 0.0));
        this.parameters.put(ParameterType.VECTOR_Z, new UnknownParameter(ParameterType.VECTOR_Z, true, 1.0));
        this.parameters.put(ParameterType.LENGTH, new UnknownParameter(ParameterType.LENGTH, true));
        this.parameters.put(ParameterType.VECTOR_LENGTH, new UnknownParameter(ParameterType.VECTOR_LENGTH, true, 1.0, true, ProcessingType.FIXED));
        UnknownParameter normalX = this.parameters.get((Object)ParameterType.VECTOR_X);
        UnknownParameter normalY = this.parameters.get((Object)ParameterType.VECTOR_Y);
        UnknownParameter normalZ = this.parameters.get((Object)ParameterType.VECTOR_Z);
        UnknownParameter vectorLength = this.parameters.get((Object)ParameterType.VECTOR_LENGTH);
        List<UnknownParameter> normalVector = List.of(normalX, normalY, normalZ);
        this.vectorLengthRestriction = new ProductSumRestriction(true, normalVector, normalVector, vectorLength);
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.PLANE;
    }

    @Override
    public String toLaTex() {
        return "$\\mathbf{n^\\mathrm{T}} \\mathbf{P}_i = d \\\\ \\mathbf{n} = \\left( \\begin{array}{c} n_x \\\\ n_y \\\\ n_z \\end{array} \\right)$";
    }
}

