/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.SpatialCircleFeature;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Sphere;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Torus;

public class TorusFeature
extends SurfaceFeature {
    private final Torus torus = new Torus();

    public TorusFeature() {
        super(true);
        UnknownParameter vectorLength = this.torus.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        vectorLength.setVisible(false);
        this.add(this.torus);
    }

    public Torus getTorus() {
        return this.torus;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, TorusFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        TorusFeature.deriveInitialGuess(points, feature.torus);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Torus torus) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int nop = 0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            if (torus.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + torus.getDimension() + " != " + point.getDimension());
        }
        if (nop < 7) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 7 points are needed.");
        }
        Sphere sphere = new Sphere();
        Plane plane = new Plane();
        SpatialCircleFeature.deriveInitialGuess(points, sphere, plane);
        double x0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_X).getValue0();
        double y0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Y).getValue0();
        double z0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Z).getValue0();
        double a = sphere.getUnknownParameter(ParameterType.RADIUS).getValue0();
        double nx = plane.getUnknownParameter(ParameterType.VECTOR_X).getValue0();
        double ny = plane.getUnknownParameter(ParameterType.VECTOR_Y).getValue0();
        double nz = plane.getUnknownParameter(ParameterType.VECTOR_Z).getValue0();
        double d = plane.getUnknownParameter(ParameterType.LENGTH).getValue0();
        double epsilon = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double dx = point.getX0() - x0;
            double dy = point.getY0() - y0;
            double dz = point.getZ0() - z0;
            double resSphere = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double resPlane = Math.abs(point.getX0() * nx + point.getY0() * ny + point.getZ0() * nz - d);
            double res = Math.sqrt(Math.abs(resSphere * resSphere - resPlane * resPlane)) - a;
            epsilon += res * res;
        }
        double c = epsilon > Math.sqrt(Constant.EPS) ? Math.sqrt(epsilon / (double)nop) : Math.sqrt(Constant.EPS);
        torus.setInitialGuess(x0, y0, z0, nx, ny, nz, a, c);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        TorusFeature.deriveInitialGuess(this.torus.getFeaturePoints(), this.torus);
    }
}

