/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;

public class SpatialLineFeature
extends SurfaceFeature {
    private final Plane planeU = new Plane();
    private final Plane planeV = new Plane();
    private UnknownParameter xCoordinateInPlaneU = new UnknownParameter(ParameterType.COORDINATE_X, true, 0.0, false, ProcessingType.FIXED);
    private UnknownParameter yCoordinateInPlaneU = new UnknownParameter(ParameterType.COORDINATE_Y, true, 0.0, false, ProcessingType.FIXED);
    private UnknownParameter zCoordinateInPlaneU = new UnknownParameter(ParameterType.COORDINATE_Z, true, 0.0, false, ProcessingType.FIXED);

    public SpatialLineFeature() {
        super(true);
        UnknownParameter xOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter yOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter zOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter xNormal = new UnknownParameter(ParameterType.VECTOR_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter yNormal = new UnknownParameter(ParameterType.VECTOR_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter zNormal = new UnknownParameter(ParameterType.VECTOR_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter dotProductUV = new UnknownParameter(ParameterType.LENGTH, false, 0.0, false, ProcessingType.FIXED);
        UnknownParameter ux = this.planeU.getUnknownParameter(ParameterType.VECTOR_X);
        UnknownParameter uy = this.planeU.getUnknownParameter(ParameterType.VECTOR_Y);
        UnknownParameter uz = this.planeU.getUnknownParameter(ParameterType.VECTOR_Z);
        UnknownParameter du = this.planeU.getUnknownParameter(ParameterType.LENGTH);
        UnknownParameter u = this.planeU.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        UnknownParameter vx = this.planeV.getUnknownParameter(ParameterType.VECTOR_X);
        UnknownParameter vy = this.planeV.getUnknownParameter(ParameterType.VECTOR_Y);
        UnknownParameter vz = this.planeV.getUnknownParameter(ParameterType.VECTOR_Z);
        UnknownParameter dv = this.planeV.getUnknownParameter(ParameterType.LENGTH);
        UnknownParameter v = this.planeU.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        ux.setVisible(false);
        uy.setVisible(false);
        uz.setVisible(false);
        du.setVisible(false);
        u.setVisible(false);
        vx.setVisible(false);
        vy.setVisible(false);
        vz.setVisible(false);
        dv.setVisible(false);
        v.setVisible(false);
        List<UnknownParameter> normalVectorU = List.of(ux, uy, uz);
        List<UnknownParameter> normalVectorV = List.of(vx, vy, vz);
        List<UnknownParameter> arbitraryPoint = List.of(this.xCoordinateInPlaneU, this.yCoordinateInPlaneU, this.zCoordinateInPlaneU);
        ProductSumRestriction arbitraryPointInPlaneURestriction = new ProductSumRestriction(true, normalVectorU, arbitraryPoint, du);
        ProductSumRestriction orthogonalVectorsUVRestriction = new ProductSumRestriction(true, normalVectorU, normalVectorV, dotProductUV);
        this.add(this.planeU);
        this.add(this.planeV);
        this.getRestrictions().add(arbitraryPointInPlaneURestriction);
        this.getRestrictions().add(orthogonalVectorsUVRestriction);
        ArrayList<UnknownParameter> newOrderedUnknownParameters = new ArrayList<UnknownParameter>();
        newOrderedUnknownParameters.add(xOrigin);
        newOrderedUnknownParameters.add(yOrigin);
        newOrderedUnknownParameters.add(zOrigin);
        newOrderedUnknownParameters.add(xNormal);
        newOrderedUnknownParameters.add(yNormal);
        newOrderedUnknownParameters.add(zNormal);
        newOrderedUnknownParameters.add(dotProductUV);
        newOrderedUnknownParameters.add(this.xCoordinateInPlaneU);
        newOrderedUnknownParameters.add(this.yCoordinateInPlaneU);
        newOrderedUnknownParameters.add(this.zCoordinateInPlaneU);
        newOrderedUnknownParameters.addAll((Collection<UnknownParameter>)((Object)this.getUnknownParameters()));
        this.getUnknownParameters().setAll(newOrderedUnknownParameters);
        ProductSumRestriction multAddX = new ProductSumRestriction(false, List.of(ux, vx), List.of(du, dv), xOrigin);
        ProductSumRestriction multAddY = new ProductSumRestriction(false, List.of(uy, vy), List.of(du, dv), yOrigin);
        ProductSumRestriction multAddZ = new ProductSumRestriction(false, List.of(uz, vz), List.of(du, dv), zOrigin);
        List<ProductSumRestriction.SignType> signs = List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS);
        ProductSumRestriction crossProductX = new ProductSumRestriction(false, List.of(uy, uz), List.of(vz, vy), signs, xNormal);
        ProductSumRestriction crossProductY = new ProductSumRestriction(false, List.of(uz, ux), List.of(vx, vz), signs, yNormal);
        ProductSumRestriction crossProductZ = new ProductSumRestriction(false, List.of(ux, uy), List.of(vy, vx), signs, zNormal);
        this.getPostProcessingCalculations().addAll(new Restriction[]{multAddX, multAddY, multAddZ, crossProductX, crossProductY, crossProductZ});
    }

    public Plane getPlaneU() {
        return this.planeU;
    }

    public Plane getPlaneV() {
        return this.planeV;
    }

    @Override
    public void setCenterOfMass(Point centerOfMass) {
        Point prevCenterOfMass = this.getCenterOfMass();
        if (centerOfMass.equalsCoordinateComponents(prevCenterOfMass)) {
            return;
        }
        super.setCenterOfMass(centerOfMass);
        this.adaptArbitraryPointInPlaneRestriction();
    }

    @Override
    public void prepareIteration() {
        this.adaptArbitraryPointInPlaneRestriction();
    }

    private void adaptArbitraryPointInPlaneRestriction() {
        double ux = this.planeU.getUnknownParameter(ParameterType.VECTOR_X).getValue();
        double uy = this.planeU.getUnknownParameter(ParameterType.VECTOR_Y).getValue();
        double uz = this.planeU.getUnknownParameter(ParameterType.VECTOR_Z).getValue();
        double du = this.planeU.getUnknownParameter(ParameterType.LENGTH).getValue();
        double vx = this.planeV.getUnknownParameter(ParameterType.VECTOR_X).getValue();
        double vy = this.planeV.getUnknownParameter(ParameterType.VECTOR_Y).getValue();
        double vz = this.planeV.getUnknownParameter(ParameterType.VECTOR_Z).getValue();
        double dv = this.planeV.getUnknownParameter(ParameterType.LENGTH).getValue();
        double x0 = ux * du + vx * dv;
        double y0 = uy * du + vy * dv;
        double z0 = uz * du + vz * dv;
        this.xCoordinateInPlaneU.setValue(x0 += vx);
        this.yCoordinateInPlaneU.setValue(y0 += vy);
        this.zCoordinateInPlaneU.setValue(z0 += vz);
    }

    public static void deriveInitialGuess(Collection<? extends FeaturePoint> points, SpatialLineFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        SpatialLineFeature.deriveInitialGuess(points, feature.planeU, feature.planeV);
    }

    public static void deriveInitialGuess(Collection<? extends FeaturePoint> points, Plane planeU, Plane planeV) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int i;
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        for (FeaturePoint featurePoint : points) {
            if (!featurePoint.isEnable()) continue;
            ++nop;
            x0 += featurePoint.getX0();
            y0 += featurePoint.getY0();
            z0 += featurePoint.getZ0();
            if (planeU.getDimension() <= featurePoint.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + planeU.getDimension() + " != " + featurePoint.getDimension());
        }
        if (nop < 2) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 2 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        UpperSymmPackMatrix upperSymmPackMatrix = new UpperSymmPackMatrix(3);
        for (FeaturePoint featurePoint : points) {
            if (!featurePoint.isEnable()) continue;
            double xi = featurePoint.getX0() - x0;
            double yi = featurePoint.getY0() - y0;
            double zi = featurePoint.getZ0() - z0;
            i = 0;
            while (i < 3) {
                double hi = 0.0;
                if (i == 0) {
                    hi = xi;
                } else if (i == 1) {
                    hi = yi;
                } else if (i == 2) {
                    hi = zi;
                }
                int j = i;
                while (j < 3) {
                    double hj = 0.0;
                    if (j == 0) {
                        hj = xi;
                    } else if (j == 1) {
                        hj = yi;
                    } else if (j == 2) {
                        hj = zi;
                    }
                    upperSymmPackMatrix.set(i, j, upperSymmPackMatrix.get(i, j) + hi * hj);
                    ++j;
                }
                ++i;
            }
        }
        SymmPackEVD symmPackEVD = new SymmPackEVD(3, true, true);
        symmPackEVD.factor(upperSymmPackMatrix);
        DenseMatrix eigVec = symmPackEVD.getEigenvectors();
        double[] eigVal = symmPackEVD.getEigenvalues();
        int indexMaxEigVal = 0;
        double maxEigVal = eigVal[indexMaxEigVal];
        int i2 = indexMaxEigVal + 1;
        while (i2 < eigVal.length) {
            if (maxEigVal < eigVal[i2]) {
                maxEigVal = eigVal[i2];
                indexMaxEigVal = i2;
            }
            ++i2;
        }
        double[] u = new double[3];
        double[] v = new double[3];
        i = 0;
        while (i < 3) {
            if (indexMaxEigVal == 0) {
                u[i] = eigVec.get(i, 1);
                v[i] = eigVec.get(i, 2);
            } else if (indexMaxEigVal == 1) {
                u[i] = eigVec.get(i, 0);
                v[i] = eigVec.get(i, 2);
            } else {
                u[i] = eigVec.get(i, 0);
                v[i] = eigVec.get(i, 1);
            }
            ++i;
        }
        double du = u[0] * x0 + u[1] * y0 + u[2] * z0;
        double dv = v[0] * x0 + v[1] * y0 + v[2] * z0;
        planeU.setInitialGuess(u[0], u[1], u[2], du);
        planeV.setInitialGuess(v[0], v[1], v[2], dv);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        HashSet<FeaturePoint> uniquePointSet = new HashSet<FeaturePoint>();
        uniquePointSet.addAll((Collection<FeaturePoint>)((Object)this.planeU.getFeaturePoints()));
        uniquePointSet.addAll((Collection<FeaturePoint>)((Object)this.planeV.getFeaturePoints()));
        SpatialLineFeature.deriveInitialGuess(uniquePointSet, this.planeU, this.planeV);
    }
}

