/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;

public class PlaneFeature
extends SurfaceFeature {
    private final Plane plane = new Plane();

    public PlaneFeature() {
        super(true);
        UnknownParameter vectorLength = this.plane.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        vectorLength.setVisible(false);
        this.add(this.plane);
    }

    public Plane getPlane() {
        return this.plane;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, PlaneFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        PlaneFeature.deriveInitialGuess(points, feature.plane);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Plane plane) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double nz;
        double ny;
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            z0 += point.getZ0();
            if (plane.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + plane.getDimension() + " != " + point.getDimension());
        }
        if (nop < 3) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 3 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(3);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            double zi = point.getZ0() - z0;
            int i = 0;
            while (i < 3) {
                double hi = 0.0;
                hi = i == 0 ? xi : (i == 1 ? yi : zi);
                int j = i;
                while (j < 3) {
                    double hj = 0.0;
                    hj = j == 0 ? xi : (j == 1 ? yi : zi);
                    H.set(i, j, H.get(i, j) + hi * hj);
                    ++j;
                }
                ++i;
            }
        }
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(H);
        DenseMatrix eigVec = evd.getEigenvectors();
        double[] eigVal = evd.getEigenvalues();
        int indexMinEigVal = 0;
        double minEigVal = eigVal[indexMinEigVal];
        int i = indexMinEigVal + 1;
        while (i < eigVal.length) {
            if (minEigVal > eigVal[i]) {
                minEigVal = eigVal[i];
                indexMinEigVal = i;
            }
            ++i;
        }
        double nx = eigVec.get(0, indexMinEigVal);
        double d = nx * x0 + (ny = eigVec.get(1, indexMinEigVal)) * y0 + (nz = eigVec.get(2, indexMinEigVal)) * z0;
        if (d < 0.0) {
            nx = -nx;
            ny = -ny;
            nz = -nz;
            d = -d;
        }
        plane.setInitialGuess(nx, ny, nz, d);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        PlaneFeature.deriveInitialGuess(this.plane.getFeaturePoints(), this.plane);
    }
}

