/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.Quaternion;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.FeatureUtil;
import org.applied_geodesy.adjustment.geometry.surface.QuadraticSurfaceFeature;
import org.applied_geodesy.adjustment.geometry.surface.SpatialEllipseFeature;
import org.applied_geodesy.adjustment.geometry.surface.SphereFeature;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cylinder;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Paraboloid;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;
import org.applied_geodesy.adjustment.geometry.surface.primitive.QuadraticSurface;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Sphere;

public class ParaboloidFeature
extends SurfaceFeature {
    private final Paraboloid paraboloid = new Paraboloid();

    public ParaboloidFeature() {
        super(true);
        this.add(this.paraboloid);
    }

    public Paraboloid getParaboloid() {
        return this.paraboloid;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, ParaboloidFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ParaboloidFeature.deriveInitialGuess(points, feature.paraboloid);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Paraboloid paraboloid) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int nop = 0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            if (paraboloid.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + paraboloid.getDimension() + " != " + point.getDimension());
        }
        if (nop < 8) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 8 points are needed.");
        }
        if (nop > 8) {
            ParaboloidFeature.deriveInitialGuessByQuadraticFunction(points, paraboloid);
        } else {
            ParaboloidFeature.deriveInitialGuessByEllipse(points, paraboloid);
        }
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ParaboloidFeature.deriveInitialGuess(this.paraboloid.getFeaturePoints(), this.paraboloid);
    }

    private static void deriveInitialGuessByEllipse(Collection<FeaturePoint> points, Paraboloid paraboloid) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double det;
        Cylinder cylinder = new Cylinder();
        Plane plane = new Plane();
        Sphere sphere = new Sphere();
        SphereFeature.deriveInitialGuess(points, sphere);
        SpatialEllipseFeature.deriveInitialGuess(points, cylinder, plane);
        double x0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_X).getValue0();
        double y0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Y).getValue0();
        double z0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Z).getValue0();
        double x1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_X).getValue0();
        double y1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_Y).getValue0();
        double z1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_Z).getValue0();
        double x2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_X).getValue0();
        double y2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_Y).getValue0();
        double z2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_Z).getValue0();
        double ac = cylinder.getUnknownParameter(ParameterType.MAJOR_AXIS_COEFFICIENT).getValue0();
        double wx = plane.getUnknownParameter(ParameterType.VECTOR_X).getValue0();
        double wy = plane.getUnknownParameter(ParameterType.VECTOR_Y).getValue0();
        double wz = plane.getUnknownParameter(ParameterType.VECTOR_Z).getValue0();
        double ux = x2 - x1;
        double uy = y2 - y1;
        double uz = z2 - z1;
        double bc = Math.sqrt(ac * ac - 0.25 * (ux * ux + uy * uy + uz * uz));
        double normU = Math.sqrt(ux * ux + uy * uy + uz * uz);
        double vx = wy * (uz /= normU) - wz * (uy /= normU);
        double vy = wz * (ux /= normU) - wx * uz;
        double vz = wx * uy - wy * ux;
        double normV = Math.sqrt(vx * vx + vy * vy + vz * vz);
        vx /= normV;
        vy /= normV;
        vz /= normV;
        DenseVector shift = new DenseVector(new double[]{x0, y0, z0}, false);
        DenseVector axis = new DenseVector(new double[]{wx, wy, wz}, false);
        double dPlane0 = shift.dot((Vector)axis);
        double closestLateralDistance = Double.MAX_VALUE;
        double closestRadialDistance = 0.0;
        double furthestLateralDistance = -1.0;
        double furthestRadialDistance = 0.0;
        for (FeaturePoint point : points) {
            DenseVector surfacePoint = new DenseVector(new double[]{point.getX0(), point.getY0(), point.getZ0()}, false);
            double radialDistance = surfacePoint.dot((Vector)axis) - dPlane0;
            surfacePoint.add(-1.0, (Vector)shift);
            DenseVector cross = MathExtension.cross((Vector)surfacePoint, (Vector)axis);
            double lateralDist = cross.norm(Vector.Norm.Two);
            if (lateralDist < closestLateralDistance) {
                closestLateralDistance = lateralDist;
                closestRadialDistance = radialDistance;
            }
            if (!(lateralDist > furthestLateralDistance)) continue;
            furthestLateralDistance = lateralDist;
            furthestRadialDistance = radialDistance;
        }
        shift.add(closestRadialDistance, (Vector)axis);
        x0 = shift.get(0);
        y0 = shift.get(1);
        z0 = shift.get(2);
        if (furthestRadialDistance < closestRadialDistance) {
            wx = -wx;
            wy = -wy;
            wz = -wz;
        }
        if ((det = ux * vy * wz + vx * wy * uz + wx * uy * vz - wx * vy * uz - vx * uy * wz - ux * wy * vz) < 0.0) {
            ux = -ux;
            uy = -uy;
            uz = -uz;
        }
        Quaternion q = FeatureUtil.getQuaternionHz(new double[]{wx, wy, wz});
        Collection<FeaturePoint> rotatedPoints = FeatureUtil.getRotatedFeaturePoints(points, new double[]{0.0, 0.0, 0.0}, q);
        Quaternion rotatedApexQ = q.rotate(new double[]{x0, y0, z0});
        double rx0 = rotatedApexQ.getQ1();
        double ry0 = rotatedApexQ.getQ2();
        double rz0 = rotatedApexQ.getQ3();
        double a = 0.0;
        double b = 0.0;
        int nop = 0;
        for (FeaturePoint point : rotatedPoints) {
            if (!point.isEnable()) continue;
            ++nop;
            double rxi = point.getX0();
            double ryi = point.getY0();
            double rzi = point.getZ0();
            double dx = rxi - rx0;
            double dy = ryi - ry0;
            double dz = rzi - rz0;
            a += Math.abs(dz / (dx * dx + dy * dy));
        }
        a = b = Math.sqrt(a / (double)nop);
        double avg = 0.5 * (ac + bc);
        a = ac * a / avg;
        b = bc * b / avg;
        paraboloid.setInitialGuess(x0, y0, z0, a, b, ux, uy, uz, vx, vy, vz, wx, wy, wz);
    }

    private static void deriveInitialGuessByQuadraticFunction(Collection<FeaturePoint> points, Paraboloid paraboloid) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double det;
        int dim = 3;
        double SQRT2 = Math.sqrt(2.0);
        QuadraticSurface quadraticSurface = new QuadraticSurface();
        QuadraticSurfaceFeature.deriveInitialGuess(points, quadraticSurface);
        double a = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_A).getValue0();
        double b = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_B).getValue0();
        double c = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_C).getValue0();
        double d = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_D).getValue0();
        double e = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_E).getValue0();
        double f = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_F).getValue0();
        double g = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_G).getValue0();
        double h = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_H).getValue0();
        double i = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_I).getValue0();
        double length = quadraticSurface.getUnknownParameter(ParameterType.LENGTH).getValue0();
        DenseVector u = new DenseVector(new double[]{g, h, i}, false);
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(3);
        H.set(0, 0, a);
        H.set(0, 1, d / SQRT2);
        H.set(0, 2, e / SQRT2);
        H.set(1, 1, b);
        H.set(1, 2, f / SQRT2);
        H.set(2, 2, c);
        UpperSymmPackMatrix U = new UpperSymmPackMatrix((Matrix)H);
        Matrix invU = MathExtension.pinv((Matrix)U, 2);
        DenseVector invUu = new DenseVector(3);
        invU.mult((Vector)u, (Vector)invUu);
        DenseVector shift = new DenseVector((Vector)invUu, true);
        shift.scale(-0.5);
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(H);
        DenseMatrix evec = evd.getEigenvectors();
        double[] eval = evd.getEigenvalues();
        int minEvalIdx = 0;
        double minEval = Double.MAX_VALUE;
        int idx = 0;
        while (idx < 3) {
            if (minEval > Math.abs(eval[idx])) {
                minEval = Math.abs(eval[idx]);
                minEvalIdx = idx;
            }
            ++idx;
        }
        double r11 = evec.get(0, 0);
        double r12 = evec.get(0, 1);
        double r13 = evec.get(0, 2);
        double r21 = evec.get(1, 0);
        double r22 = evec.get(1, 1);
        double r23 = evec.get(1, 2);
        double r31 = evec.get(2, 0);
        double r32 = evec.get(2, 1);
        double r33 = evec.get(2, 2);
        DenseVector minEvec = new DenseVector(new double[]{evec.get(0, minEvalIdx), evec.get(1, minEvalIdx), evec.get(2, minEvalIdx)}, false);
        DenseVector canonicalShift = new DenseVector(3);
        evec.transMult((Vector)shift, (Vector)canonicalShift);
        double m = -u.dot((Vector)minEvec);
        m = Math.abs(m) > Math.sqrt(Constant.EPS) ? m : 1.0;
        d = -0.25 * u.dot((Vector)invUu) + length;
        canonicalShift.set(minEvalIdx, d / m);
        evec.mult((Vector)canonicalShift, (Vector)shift);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        if (minEvalIdx == 0) {
            if (Math.abs(eval[1]) > Math.abs(eval[2])) {
                int[] nArray2 = new int[3];
                nArray2[0] = 1;
                nArray2[1] = 2;
                order = nArray2;
                a = Math.sqrt(Math.abs(eval[1] / m));
                b = Math.sqrt(Math.abs(eval[2] / m));
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 2;
                nArray3[1] = 1;
                order = nArray3;
                a = Math.sqrt(Math.abs(eval[2] / m));
                b = Math.sqrt(Math.abs(eval[1] / m));
            }
        } else if (minEvalIdx == 1) {
            if (Math.abs(eval[0]) > Math.abs(eval[2])) {
                int[] nArray4 = new int[3];
                nArray4[1] = 2;
                nArray4[2] = 1;
                order = nArray4;
                a = Math.sqrt(Math.abs(eval[0] / m));
                b = Math.sqrt(Math.abs(eval[2] / m));
            } else {
                int[] nArray5 = new int[3];
                nArray5[0] = 2;
                nArray5[2] = 1;
                order = nArray5;
                a = Math.sqrt(Math.abs(eval[2] / m));
                b = Math.sqrt(Math.abs(eval[0] / m));
            }
        } else if (Math.abs(eval[0]) > Math.abs(eval[1])) {
            int[] nArray6 = new int[3];
            nArray6[1] = 1;
            nArray6[2] = 2;
            order = nArray6;
            a = Math.sqrt(Math.abs(eval[0] / m));
            b = Math.sqrt(Math.abs(eval[1] / m));
        } else {
            int[] nArray7 = new int[3];
            nArray7[0] = 1;
            nArray7[2] = 2;
            order = nArray7;
            a = Math.sqrt(Math.abs(eval[1] / m));
            b = Math.sqrt(Math.abs(eval[0] / m));
        }
        DenseMatrix rotation = new DenseMatrix(3, 3);
        int row = 0;
        while (row < 3) {
            int column = 0;
            while (column < 3) {
                int idx2 = order[column];
                rotation.set(row, column, evec.get(row, idx2));
                ++column;
            }
            ++row;
        }
        double dPlane0 = shift.dot((Vector)minEvec);
        double closestLateralDistance = Double.MAX_VALUE;
        double closestRadialDistance = 0.0;
        double furthestLateralDistance = -1.0;
        double furthestRadialDistance = 0.0;
        for (FeaturePoint point : points) {
            DenseVector surfacePoint = new DenseVector(new double[]{point.getX0(), point.getY0(), point.getZ0()}, false);
            double radialDistance = surfacePoint.dot((Vector)minEvec) - dPlane0;
            surfacePoint.add(-1.0, (Vector)shift);
            DenseVector cross = MathExtension.cross((Vector)surfacePoint, (Vector)minEvec);
            double lateralDist = cross.norm(Vector.Norm.Two);
            if (lateralDist < closestLateralDistance) {
                closestLateralDistance = lateralDist;
                closestRadialDistance = radialDistance;
            }
            if (!(lateralDist > furthestLateralDistance)) continue;
            furthestLateralDistance = lateralDist;
            furthestRadialDistance = radialDistance;
        }
        shift.add(closestRadialDistance, (Vector)minEvec);
        double x0 = shift.get(0);
        double y0 = shift.get(1);
        double z0 = shift.get(2);
        r11 = rotation.get(0, 0);
        r12 = rotation.get(1, 0);
        r13 = rotation.get(2, 0);
        r21 = rotation.get(0, 1);
        r22 = rotation.get(1, 1);
        r23 = rotation.get(2, 1);
        r31 = rotation.get(0, 2);
        r32 = rotation.get(1, 2);
        r33 = rotation.get(2, 2);
        if (furthestRadialDistance < closestRadialDistance) {
            r31 = -r31;
            r32 = -r32;
            r33 = -r33;
        }
        if ((det = r11 * r22 * r33 + r12 * r23 * r31 + r13 * r21 * r32 - r13 * r22 * r31 - r12 * r21 * r33 - r11 * r23 * r32) < 0.0) {
            r11 = -r11;
            r12 = -r12;
            r13 = -r13;
        }
        paraboloid.setInitialGuess(x0, y0, z0, a, b, r11, r12, r13, r21, r22, r23, r31, r32, r33);
    }
}

