/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.ArrayList;
import java.util.Collection;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.geometry.Quaternion;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;

class FeatureUtil {
    private FeatureUtil() {
    }

    static Quaternion getQuaternionHz(double[] principleAxis) {
        double[] u = new double[]{principleAxis[1], -principleAxis[0], 0.0};
        double phi = Math.acos(principleAxis[2]);
        if (Math.abs(phi) < Constant.EPS || Math.abs(Math.abs(phi) - Math.PI) < Constant.EPS) {
            u = new double[]{1.0, 1.0, 0.0};
        }
        return new Quaternion(u, phi);
    }

    static Collection<FeaturePoint> getRotatedFeaturePoints(Collection<FeaturePoint> points, double[] centerOfMass, Quaternion q) {
        ArrayList<FeaturePoint> rotatedPoints = new ArrayList<FeaturePoint>();
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - centerOfMass[0];
            double yi = point.getY0() - centerOfMass[1];
            double zi = point.getZ0() - centerOfMass[2];
            Quaternion resultQ = q.rotate(new double[]{xi, yi, zi});
            rotatedPoints.add(new FeaturePoint(point.getName(), resultQ.getQ1(), resultQ.getQ2(), resultQ.getQ3()));
        }
        return rotatedPoints;
    }
}

