/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import javafx.util.Pair;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.QuadraticSurfaceFeature;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Ellipsoid;
import org.applied_geodesy.adjustment.geometry.surface.primitive.QuadraticSurface;

public class EllipsoidFeature
extends SurfaceFeature {
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final double SQRT05 = Math.sqrt(0.5);
    private final Ellipsoid ellipsoid = new Ellipsoid();

    public EllipsoidFeature() {
        super(true);
        this.add(this.ellipsoid);
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, EllipsoidFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        EllipsoidFeature.deriveInitialGuess(points, feature.ellipsoid);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Ellipsoid ellipsoid) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Pair<Double, Ellipsoid> approximation1 = EllipsoidFeature.deriveInitialGuessViaPanouBalodimouOverLeastSquares(points);
        Pair<Double, Ellipsoid> approximation2 = EllipsoidFeature.deriveInitialGuessViaPanouBalodimouOverEig(points);
        Pair<Double, Ellipsoid> approximation3 = EllipsoidFeature.deriveInitialGuessViaLiGriffiths(points);
        Pair<Double, Ellipsoid> bestApproximation = (Double)approximation1.getKey() <= (Double)approximation2.getKey() && (Double)approximation1.getKey() <= (Double)approximation3.getKey() ? approximation1 : ((Double)approximation2.getKey() <= (Double)approximation1.getKey() && (Double)approximation2.getKey() <= (Double)approximation3.getKey() ? approximation2 : approximation3);
        Ellipsoid bestInitialGuessEllipsoid = (Ellipsoid)bestApproximation.getValue();
        Collection<UnknownParameter> parameters = ellipsoid.getUnknownParameters();
        for (UnknownParameter parameter : parameters) {
            parameter.setValue0(bestInitialGuessEllipsoid.getUnknownParameter(parameter.getParameterType()).getValue0());
        }
    }

    private static Pair<Double, Ellipsoid> deriveInitialGuessViaPanouBalodimouOverEig(Collection<FeaturePoint> points) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Ellipsoid ellipsoid = new Ellipsoid();
        QuadraticSurface quadraticSurface = new QuadraticSurface();
        QuadraticSurfaceFeature.deriveInitialGuess(points, quadraticSurface);
        double a = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_A).getValue0();
        double b = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_B).getValue0();
        double c = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_C).getValue0();
        double d = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_D).getValue0();
        double e = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_E).getValue0();
        double f = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_F).getValue0();
        double g = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_G).getValue0();
        double h = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_H).getValue0();
        double i = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_I).getValue0();
        double length = quadraticSurface.getUnknownParameter(ParameterType.LENGTH).getValue0();
        a = -a / length;
        b = -b / length;
        c = -c / length;
        d = -d * SQRT2 / length;
        e = -e * SQRT2 / length;
        f = -f * SQRT2 / length;
        g = -g / length;
        h = -h / length;
        i = -i / length;
        double[] ellispoidParams = EllipsoidFeature.deriveInitialGuessViaPanouBalodimou(new double[]{a, b, c, d, e, f, g, h, i});
        double x0 = ellispoidParams[0];
        double y0 = ellispoidParams[1];
        double z0 = ellispoidParams[2];
        double axis1 = ellispoidParams[3];
        double axis2 = ellispoidParams[4];
        double axis3 = ellispoidParams[5];
        double r11 = ellispoidParams[6];
        double r12 = ellispoidParams[7];
        double r13 = ellispoidParams[8];
        double r21 = ellispoidParams[9];
        double r22 = ellispoidParams[10];
        double r23 = ellispoidParams[11];
        double r31 = ellispoidParams[12];
        double r32 = ellispoidParams[13];
        double r33 = ellispoidParams[14];
        ellipsoid.setInitialGuess(x0, y0, z0, axis1, axis2, axis3, r11, r12, r13, r21, r22, r23, r31, r32, r33);
        Collection<UnknownParameter> parameters = ellipsoid.getUnknownParameters();
        for (UnknownParameter parameter : parameters) {
            parameter.setValue(parameter.getValue0());
        }
        double epsilon = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double res = ellipsoid.getMisclosure(point);
            epsilon += res * res;
        }
        return new Pair((Object)epsilon, (Object)ellipsoid);
    }

    private static Pair<Double, Ellipsoid> deriveInitialGuessViaPanouBalodimouOverLeastSquares(Collection<FeaturePoint> points) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Ellipsoid ellipsoid = new Ellipsoid();
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            z0 += point.getZ0();
            if (ellipsoid.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + ellipsoid.getDimension() + " != " + point.getDimension());
        }
        if (nop < 9) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 9 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        UpperSymmPackMatrix N = new UpperSymmPackMatrix(9);
        DenseVector u = new DenseVector(9);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            double zi = point.getZ0() - z0;
            double xx = xi * xi;
            double yy = yi * yi;
            double zz = zi * zi;
            double xy = xi * yi;
            double xz = xi * zi;
            double yz = yi * zi;
            N.add(0, 0, xx * xx);
            N.add(0, 1, xx * yy);
            N.add(0, 2, xx * zz);
            N.add(0, 3, xx * xy);
            N.add(0, 4, xx * xz);
            N.add(0, 5, xx * yz);
            N.add(0, 6, xx * xi);
            N.add(0, 7, xx * yi);
            N.add(0, 8, xx * zi);
            N.add(1, 1, yy * yy);
            N.add(1, 2, yy * zz);
            N.add(1, 3, yy * xy);
            N.add(1, 4, yy * xz);
            N.add(1, 5, yy * yz);
            N.add(1, 6, yy * xi);
            N.add(1, 7, yy * yi);
            N.add(1, 8, yy * zi);
            N.add(2, 2, zz * zz);
            N.add(2, 3, zz * xy);
            N.add(2, 4, zz * xz);
            N.add(2, 5, zz * yz);
            N.add(2, 6, zz * xi);
            N.add(2, 7, zz * yi);
            N.add(2, 8, zz * zi);
            N.add(3, 3, xy * xy);
            N.add(3, 4, xy * xz);
            N.add(3, 5, xy * yz);
            N.add(3, 6, xy * xi);
            N.add(3, 7, xy * yi);
            N.add(3, 8, xy * zi);
            N.add(4, 4, xz * xz);
            N.add(4, 5, xz * yz);
            N.add(4, 6, xz * xi);
            N.add(4, 7, xz * yi);
            N.add(4, 8, xz * zi);
            N.add(5, 5, yz * yz);
            N.add(5, 6, yz * xi);
            N.add(5, 7, yz * yi);
            N.add(5, 8, yz * zi);
            N.add(6, 6, xi * xi);
            N.add(6, 7, xi * yi);
            N.add(6, 8, xi * zi);
            N.add(7, 7, yi * yi);
            N.add(7, 8, yi * zi);
            N.add(8, 8, zi * zi);
            u.add(0, xx);
            u.add(1, yy);
            u.add(2, zz);
            u.add(3, xy);
            u.add(4, xz);
            u.add(5, yz);
            u.add(6, xi);
            u.add(7, yi);
            u.add(8, zi);
        }
        MathExtension.solve(N, u, false);
        double[] ellispoidParams = EllipsoidFeature.deriveInitialGuessViaPanouBalodimou(u.getData());
        double dx = ellispoidParams[0];
        double dy = ellispoidParams[1];
        double dz = ellispoidParams[2];
        double axis1 = ellispoidParams[3];
        double axis2 = ellispoidParams[4];
        double axis3 = ellispoidParams[5];
        double r11 = ellispoidParams[6];
        double r12 = ellispoidParams[7];
        double r13 = ellispoidParams[8];
        double r21 = ellispoidParams[9];
        double r22 = ellispoidParams[10];
        double r23 = ellispoidParams[11];
        double r31 = ellispoidParams[12];
        double r32 = ellispoidParams[13];
        double r33 = ellispoidParams[14];
        ellipsoid.setInitialGuess(x0 += dx, y0 += dy, z0 += dz, axis1, axis2, axis3, r11, r12, r13, r21, r22, r23, r31, r32, r33);
        Collection<UnknownParameter> parameters = ellipsoid.getUnknownParameters();
        for (UnknownParameter parameter : parameters) {
            parameter.setValue(parameter.getValue0());
        }
        double epsilon = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double res = ellipsoid.getMisclosure(point);
            epsilon += res * res;
        }
        return new Pair((Object)epsilon, (Object)ellipsoid);
    }

    private static double[] deriveInitialGuessViaPanouBalodimou(double[] params) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double cxx = params[0];
        double cyy = params[1];
        double czz = params[2];
        double cxy = params[3];
        double cxz = params[4];
        double cyz = params[5];
        double cx = params[6];
        double cy = params[7];
        double cz = params[8];
        double f1 = 4.0 * cyy * czz - cyz * cyz;
        double f2 = cxz * cyz - 2.0 * cxy * czz;
        double f3 = cxy * cyz - 2.0 * cxz * cyy;
        double g2 = 4.0 * cxx * czz - cxz * cxz;
        double g3 = cxy * cxz - 2.0 * cxx * cyz;
        double h3 = 4.0 * cxx * cyy - cxy * cxy;
        double e = 2.0 * cxx * f1 + cxy * f2 + cxz * f3;
        double x0 = -(f1 * cx + f2 * cy + f3 * cz) / e;
        double y0 = -(f2 * cx + g2 * cy + g3 * cz) / e;
        double z0 = -(f3 * cx + g3 * cy + h3 * cz) / e;
        double d = 1.0 + cxx * x0 * x0 + cyy * y0 * y0 + czz * z0 * z0 + cxy * x0 * y0 + cxz * x0 * z0 + cyz * y0 * z0;
        UpperSymmPackMatrix Q = new UpperSymmPackMatrix(3);
        Q.set(0, 0, 2.0 * d * f1 / e);
        Q.set(0, 1, 2.0 * d * f2 / e);
        Q.set(0, 2, 2.0 * d * f3 / e);
        Q.set(1, 1, 2.0 * d * g2 / e);
        Q.set(1, 2, 2.0 * d * g3 / e);
        Q.set(2, 2, 2.0 * d * h3 / e);
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(Q);
        DenseMatrix evec = evd.getEigenvectors();
        double[] eval = evd.getEigenvalues();
        double axis1 = 1.0 / Math.sqrt(Math.abs(eval[0]));
        double axis2 = 1.0 / Math.sqrt(Math.abs(eval[1]));
        double axis3 = 1.0 / Math.sqrt(Math.abs(eval[2]));
        double r11 = evec.get(0, 0);
        double r12 = evec.get(1, 0);
        double r13 = evec.get(2, 0);
        double r21 = evec.get(0, 1);
        double r22 = evec.get(1, 1);
        double r23 = evec.get(2, 1);
        double r31 = evec.get(0, 2);
        double r32 = evec.get(1, 2);
        double r33 = evec.get(2, 2);
        double det = r11 * r22 * r33 + r12 * r23 * r31 + r13 * r21 * r32 - r13 * r22 * r31 - r12 * r21 * r33 - r11 * r23 * r32;
        if (det < 0.0) {
            r31 = -r31;
            r32 = -r32;
            r33 = -r33;
        }
        return new double[]{x0, y0, z0, axis1, axis2, axis3, r11, r12, r13, r21, r22, r23, r31, r32, r33};
    }

    private static Pair<Double, Ellipsoid> deriveInitialGuessViaLiGriffiths(Collection<FeaturePoint> points) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Ellipsoid ellipsoid = new Ellipsoid();
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            z0 += point.getZ0();
            if (ellipsoid.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + ellipsoid.getDimension() + " != " + point.getDimension());
        }
        if (nop < 9) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 9 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        UpperSymmPackMatrix A1TA1 = new UpperSymmPackMatrix(6);
        UpperSymmPackMatrix A2TA2 = new UpperSymmPackMatrix(4);
        DenseMatrix A1TA2 = new DenseMatrix(6, 4);
        double k = 4.0;
        UpperSymmPackMatrix invC = new UpperSymmPackMatrix(6);
        invC.set(0, 0, -0.0);
        invC.set(0, 1, 0.5);
        invC.set(0, 2, 0.5);
        invC.set(1, 1, -0.0);
        invC.set(1, 2, 0.5);
        invC.set(2, 2, -0.0);
        invC.set(3, 3, -0.5);
        invC.set(4, 4, -0.5);
        invC.set(5, 5, -0.5);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            double zi = point.getZ0() - z0;
            double xx = xi * xi;
            double yy = yi * yi;
            double zz = zi * zi;
            double xy = xi * yi;
            double xz = xi * zi;
            double yz = yi * zi;
            A1TA1.add(0, 0, xx * xx);
            A1TA1.add(0, 1, xx * yy);
            A1TA1.add(0, 2, xx * zz);
            A1TA1.add(0, 3, xx * SQRT2 * xy);
            A1TA1.add(0, 4, xx * SQRT2 * xz);
            A1TA1.add(0, 5, xx * SQRT2 * yz);
            A1TA1.add(1, 1, yy * yy);
            A1TA1.add(1, 2, yy * zz);
            A1TA1.add(1, 3, yy * SQRT2 * xy);
            A1TA1.add(1, 4, yy * SQRT2 * xz);
            A1TA1.add(1, 5, yy * SQRT2 * yz);
            A1TA1.add(2, 2, zz * zz);
            A1TA1.add(2, 3, zz * SQRT2 * xy);
            A1TA1.add(2, 4, zz * SQRT2 * xz);
            A1TA1.add(2, 5, zz * SQRT2 * yz);
            A1TA1.add(3, 3, 2.0 * xy * xy);
            A1TA1.add(3, 4, 2.0 * xy * xz);
            A1TA1.add(3, 5, 2.0 * xy * yz);
            A1TA1.add(4, 4, 2.0 * xz * xz);
            A1TA1.add(4, 5, 2.0 * xz * yz);
            A1TA1.add(5, 5, 2.0 * yz * yz);
            A2TA2.add(0, 0, xx);
            A2TA2.add(0, 1, xy);
            A2TA2.add(0, 2, xz);
            A2TA2.add(0, 3, xi);
            A2TA2.add(1, 1, yy);
            A2TA2.add(1, 2, yz);
            A2TA2.add(1, 3, yi);
            A2TA2.add(2, 2, zz);
            A2TA2.add(2, 3, zi);
            A2TA2.add(3, 3, 1.0);
            A1TA2.add(0, 0, xx * xi);
            A1TA2.add(0, 1, xx * yi);
            A1TA2.add(0, 2, xx * zi);
            A1TA2.add(0, 3, xx);
            A1TA2.add(1, 0, yy * xi);
            A1TA2.add(1, 1, yy * yi);
            A1TA2.add(1, 2, yy * zi);
            A1TA2.add(1, 3, yy);
            A1TA2.add(2, 0, zz * xi);
            A1TA2.add(2, 1, zz * yi);
            A1TA2.add(2, 2, zz * zi);
            A1TA2.add(2, 3, zz);
            A1TA2.add(3, 0, SQRT2 * xy * xi);
            A1TA2.add(3, 1, SQRT2 * xy * yi);
            A1TA2.add(3, 2, SQRT2 * xy * zi);
            A1TA2.add(3, 3, SQRT2 * xy);
            A1TA2.add(4, 0, SQRT2 * xz * xi);
            A1TA2.add(4, 1, SQRT2 * xz * yi);
            A1TA2.add(4, 2, SQRT2 * xz * zi);
            A1TA2.add(4, 3, SQRT2 * xz);
            A1TA2.add(5, 0, SQRT2 * yz * xi);
            A1TA2.add(5, 1, SQRT2 * yz * yi);
            A1TA2.add(5, 2, SQRT2 * yz * zi);
            A1TA2.add(5, 3, SQRT2 * yz);
        }
        Matrix invA2TA2 = MathExtension.pinv((Matrix)A2TA2);
        DenseMatrix invA2TA2timesA1TA2 = new DenseMatrix(4, 6);
        invA2TA2.transBmult((Matrix)A1TA2, (Matrix)invA2TA2timesA1TA2);
        invA2TA2 = null;
        UpperSymmPackMatrix A1TA2invA2TA2timesA1TA2 = new UpperSymmPackMatrix(6);
        A1TA2.mult((Matrix)invA2TA2timesA1TA2, (Matrix)A1TA2invA2TA2timesA1TA2);
        A1TA1.add(-1.0, (Matrix)A1TA2invA2TA2timesA1TA2);
        A1TA2 = null;
        A1TA2invA2TA2timesA1TA2 = null;
        DenseMatrix invCtimesA = new DenseMatrix(6, 6);
        invC.mult((Matrix)A1TA1, (Matrix)invCtimesA);
        A1TA1 = null;
        EVD evd = new EVD(6, false, true);
        evd.factor(invCtimesA);
        invCtimesA = null;
        DenseMatrix evec = evd.getRightEigenvectors();
        double[] eval = evd.getRealEigenvalues();
        evd = null;
        int indexLargestPosEval = 0;
        double maxEval = eval[indexLargestPosEval];
        int idx = indexLargestPosEval + 1;
        while (idx < eval.length) {
            if (eval[idx] >= maxEval) {
                maxEval = eval[idx];
                indexLargestPosEval = idx;
            }
            ++idx;
        }
        DenseVector u1 = new DenseVector(6);
        DenseVector u2 = new DenseVector(4);
        int i = 0;
        while (i < 6) {
            double x = evec.get(i, indexLargestPosEval);
            u1.set(i, x);
            ++i;
        }
        invA2TA2timesA1TA2.mult(-1.0, (Vector)u1, (Vector)u2);
        double a = u1.get(0);
        double b = u1.get(1);
        double c = u1.get(2);
        double d = u1.get(3);
        double e = u1.get(4);
        double f = u1.get(5);
        double g = u2.get(0);
        double h = u2.get(1);
        double i2 = u2.get(2);
        double length = u2.get(3);
        DenseVector dT = new DenseVector(new double[]{g, h, i2}, false);
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(dT.size());
        H.set(0, 0, a);
        H.set(0, 1, d / SQRT2);
        H.set(0, 2, e / SQRT2);
        H.set(1, 1, b);
        H.set(1, 2, f / SQRT2);
        H.set(2, 2, c);
        MathExtension.solve(H, dT, false);
        double dx = -0.5 * dT.get(0);
        double dy = -0.5 * dT.get(1);
        double dz = -0.5 * dT.get(2);
        length = a * dx * dx + b * dy * dy + c * dz * dz + SQRT2 * (d * dx * dy + e * dx * dz + f * dy * dz) - length;
        H = new UpperSymmPackMatrix(dT.size());
        H.set(0, 0, a);
        H.set(0, 1, d * SQRT05);
        H.set(0, 2, e * SQRT05);
        H.set(1, 1, b);
        H.set(1, 2, f * SQRT05);
        H.set(2, 2, c);
        SymmPackEVD sevd = new SymmPackEVD(3, true, true);
        sevd.factor(H);
        evec = sevd.getEigenvectors();
        eval = sevd.getEigenvalues();
        x0 += dx;
        y0 += dy;
        z0 += dz;
        double axis1 = Math.sqrt(Math.abs(eval[0] / length));
        double axis2 = Math.sqrt(Math.abs(eval[1] / length));
        double axis3 = Math.sqrt(Math.abs(eval[2] / length));
        double r11 = evec.get(0, 0);
        double r12 = evec.get(1, 0);
        double r13 = evec.get(2, 0);
        double r21 = evec.get(0, 1);
        double r22 = evec.get(1, 1);
        double r23 = evec.get(2, 1);
        double r31 = evec.get(0, 2);
        double r32 = evec.get(1, 2);
        double r33 = evec.get(2, 2);
        double det = r11 * r22 * r33 + r12 * r23 * r31 + r13 * r21 * r32 - r13 * r22 * r31 - r12 * r21 * r33 - r11 * r23 * r32;
        if (det < 0.0) {
            r31 = -r31;
            r32 = -r32;
            r33 = -r33;
        }
        ellipsoid.setInitialGuess(x0, y0, z0, axis1, axis2, axis3, r11, r12, r13, r21, r22, r23, r31, r32, r33);
        Collection<UnknownParameter> parameters = ellipsoid.getUnknownParameters();
        for (UnknownParameter parameter : parameters) {
            parameter.setValue(parameter.getValue0());
        }
        double epsilon = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double res = ellipsoid.getMisclosure(point);
            epsilon += res * res;
        }
        return new Pair((Object)epsilon, (Object)ellipsoid);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        EllipsoidFeature.deriveInitialGuess(this.ellipsoid.getFeaturePoints(), this.ellipsoid);
    }
}

