/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.Quaternion;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.FeatureUtil;
import org.applied_geodesy.adjustment.geometry.surface.QuadraticSurfaceFeature;
import org.applied_geodesy.adjustment.geometry.surface.SpatialEllipseFeature;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cone;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cylinder;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;
import org.applied_geodesy.adjustment.geometry.surface.primitive.QuadraticSurface;

public class ConeFeature
extends SurfaceFeature {
    private final Cone cone = new Cone();

    public ConeFeature() {
        super(true);
        this.add(this.cone);
    }

    public Cone getCone() {
        return this.cone;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, ConeFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ConeFeature.deriveInitialGuess(points, feature.cone);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int nop = 0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            if (cone.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + cone.getDimension() + " != " + point.getDimension());
        }
        if (nop < 8) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 8 points are needed.");
        }
        if (nop > 8) {
            ConeFeature.deriveInitialGuessByQuadraticFunction(points, cone);
        } else {
            ConeFeature.deriveInitialGuessByEllipse(points, cone);
        }
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ConeFeature.deriveInitialGuess(this.cone.getFeaturePoints(), this.cone);
    }

    private static void deriveInitialGuessByEllipse(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Cylinder cylinder = new Cylinder();
        Plane plane = new Plane();
        SpatialEllipseFeature.deriveInitialGuess(points, cylinder, plane);
        double x1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_X).getValue0();
        double y1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_Y).getValue0();
        double z1 = cylinder.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_Z).getValue0();
        double x2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_X).getValue0();
        double y2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_Y).getValue0();
        double z2 = cylinder.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_Z).getValue0();
        double wx = plane.getUnknownParameter(ParameterType.VECTOR_X).getValue0();
        double wy = plane.getUnknownParameter(ParameterType.VECTOR_Y).getValue0();
        double wz = plane.getUnknownParameter(ParameterType.VECTOR_Z).getValue0();
        double ac = cylinder.getUnknownParameter(ParameterType.MAJOR_AXIS_COEFFICIENT).getValue0();
        double x0 = 0.5 * (x1 + x2);
        double y0 = 0.5 * (y1 + y2);
        double z0 = 0.5 * (z1 + z2);
        double ux = x2 - x1;
        double uy = y2 - y1;
        double uz = z2 - z1;
        double bc = Math.sqrt(ac * ac - 0.25 * (ux * ux + uy * uy + uz * uz));
        double normU = Math.sqrt(ux * ux + uy * uy + uz * uz);
        double vx = wy * (uz /= normU) - wz * (uy /= normU);
        double vy = wz * (ux /= normU) - wx * uz;
        double vz = wx * uy - wy * ux;
        double normV = Math.sqrt(vx * vx + vy * vy + vz * vz);
        double det = ux * (vy /= normV) * wz + (vx /= normV) * wy * uz + wx * uy * (vz /= normV) - wx * vy * uz - vx * uy * wz - ux * wy * vz;
        if (det < 0.0) {
            wx = -wx;
            wy = -wy;
            wz = -wz;
        }
        Quaternion q = FeatureUtil.getQuaternionHz(new double[]{wx, wy, wz});
        Collection<FeaturePoint> rotatedPoints = FeatureUtil.getRotatedFeaturePoints(points, new double[]{0.0, 0.0, 0.0}, q);
        Quaternion rotatedApexQ = q.rotate(new double[]{x0, y0, z0});
        double rx0 = rotatedApexQ.getQ1();
        double ry0 = rotatedApexQ.getQ2();
        double rz0 = rotatedApexQ.getQ3();
        double a = 0.0;
        double b = 0.0;
        int nop = 0;
        for (FeaturePoint point : rotatedPoints) {
            if (!point.isEnable()) continue;
            ++nop;
            double rxi = point.getX0();
            double ryi = point.getY0();
            double rzi = point.getZ0();
            double dx = rxi - rx0;
            double dy = ryi - ry0;
            double dz = rzi - rz0;
            a += Math.abs(dz * dz / (dx * dx + dy * dy));
        }
        a = b = Math.sqrt(a / (double)nop);
        double avg = 0.5 * (ac + bc);
        a = ac * a / avg;
        b = bc * b / avg;
        cone.setInitialGuess(x0, y0, z0, a, b, ux, uy, uz, vx, vy, vz, wx, wy, wz);
    }

    private static void deriveInitialGuessByQuadraticFunction(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int dim = 3;
        double INV_SQRT2 = Math.sqrt(2.0);
        QuadraticSurface quadraticSurface = new QuadraticSurface();
        QuadraticSurfaceFeature.deriveInitialGuess(points, quadraticSurface);
        double a = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_A).getValue0();
        double b = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_B).getValue0();
        double c = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_C).getValue0();
        double d = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_D).getValue0();
        double e = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_E).getValue0();
        double f = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_F).getValue0();
        double g = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_G).getValue0();
        double h = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_H).getValue0();
        double i = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_I).getValue0();
        DenseVector u = new DenseVector(new double[]{g, h, i}, false);
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(3);
        H.set(0, 0, a);
        H.set(0, 1, d / INV_SQRT2);
        H.set(0, 2, e / INV_SQRT2);
        H.set(1, 1, b);
        H.set(1, 2, f / INV_SQRT2);
        H.set(2, 2, c);
        UpperSymmPackMatrix U = new UpperSymmPackMatrix((Matrix)H);
        MathExtension.solve(U, u, false);
        double x0 = -0.5 * u.get(0);
        double y0 = -0.5 * u.get(1);
        double z0 = -0.5 * u.get(2);
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(H);
        DenseMatrix evec = evd.getEigenvectors();
        double[] eval = evd.getEigenvalues();
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        if (Math.signum(eval[0]) == Math.signum(eval[1])) {
            a = Math.sqrt(Math.abs(eval[0] / eval[2]));
            if (a > (c = Math.sqrt(Math.abs(eval[1] / eval[2])))) {
                int[] nArray2 = new int[3];
                nArray2[1] = 1;
                nArray2[2] = 2;
                order = nArray2;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 1;
                nArray3[2] = 2;
                order = nArray3;
                tmp = a;
                a = c;
                c = tmp;
            }
        } else if (Math.signum(eval[0]) == Math.signum(eval[2])) {
            a = Math.sqrt(Math.abs(eval[0] / eval[1]));
            if (a > (c = Math.sqrt(Math.abs(eval[2] / eval[1])))) {
                int[] nArray4 = new int[3];
                nArray4[1] = 2;
                nArray4[2] = 1;
                order = nArray4;
            } else {
                int[] nArray5 = new int[3];
                nArray5[0] = 2;
                nArray5[2] = 1;
                order = nArray5;
                tmp = a;
                a = c;
                c = tmp;
            }
        } else {
            a = Math.sqrt(Math.abs(eval[1] / eval[0]));
            if (a > (c = Math.sqrt(Math.abs(eval[2] / eval[0])))) {
                int[] nArray6 = new int[3];
                nArray6[0] = 1;
                nArray6[1] = 2;
                order = nArray6;
            } else {
                int[] nArray7 = new int[3];
                nArray7[0] = 2;
                nArray7[1] = 1;
                order = nArray7;
                tmp = a;
                a = c;
                c = tmp;
            }
        }
        DenseMatrix rotation = new DenseMatrix(3, 3);
        int row = 0;
        while (row < 3) {
            int column = 0;
            while (column < 3) {
                int idx = order[column];
                rotation.set(row, column, evec.get(row, idx));
                ++column;
            }
            ++row;
        }
        double r11 = rotation.get(0, 0);
        double r12 = rotation.get(1, 0);
        double r13 = rotation.get(2, 0);
        double r21 = rotation.get(0, 1);
        double r22 = rotation.get(1, 1);
        double r23 = rotation.get(2, 1);
        double r31 = rotation.get(0, 2);
        double r32 = rotation.get(1, 2);
        double r33 = rotation.get(2, 2);
        cone.setInitialGuess(x0, y0, z0, a, c, r11, r12, r13, r21, r22, r23, r31, r32, r33);
    }
}

