/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.surface;

import java.util.Collection;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.Quaternion;
import org.applied_geodesy.adjustment.geometry.SurfaceFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.TrigonometricRestriction;
import org.applied_geodesy.adjustment.geometry.surface.FeatureUtil;
import org.applied_geodesy.adjustment.geometry.surface.QuadraticSurfaceFeature;
import org.applied_geodesy.adjustment.geometry.surface.SpatialCircleFeature;
import org.applied_geodesy.adjustment.geometry.surface.SphereFeature;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cone;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;
import org.applied_geodesy.adjustment.geometry.surface.primitive.QuadraticSurface;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Sphere;

public class CircularConeFeature
extends SurfaceFeature {
    private final Cone cone = new Cone();

    public CircularConeFeature() {
        super(true);
        UnknownParameter A = this.cone.getUnknownParameter(ParameterType.MAJOR_AXIS_COEFFICIENT);
        UnknownParameter C = this.cone.getUnknownParameter(ParameterType.MINOR_AXIS_COEFFICIENT);
        UnknownParameter R21 = this.cone.getUnknownParameter(ParameterType.ROTATION_COMPONENT_R21);
        A.setVisible(false);
        C.setVisible(false);
        R21.setProcessingType(ProcessingType.FIXED);
        UnknownParameter invB = new UnknownParameter(ParameterType.MIDDLE_AXIS_COEFFICIENT, false, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter oneHalf = new UnknownParameter(ParameterType.CONSTANT, false, 0.5, false, ProcessingType.FIXED);
        UnknownParameter phi = new UnknownParameter(ParameterType.ANGLE, false, 0.0, true, ProcessingType.POSTPROCESSING);
        AverageRestriction AequalsCRestriction = new AverageRestriction(true, List.of(A), C);
        ProductSumRestriction invertedBRestriction = new ProductSumRestriction(false, List.of(A, C), List.of(oneHalf, oneHalf), -1.0, invB);
        TrigonometricRestriction trigonometricRestriction = new TrigonometricRestriction(false, TrigonometricRestriction.TrigonometricFunctionType.TANGENT, Boolean.TRUE, invB, phi);
        this.add(this.cone);
        this.getUnknownParameters().addAll(new UnknownParameter[]{phi, invB, oneHalf});
        this.getRestrictions().add(AequalsCRestriction);
        this.getPostProcessingCalculations().addAll(new Restriction[]{invertedBRestriction, trigonometricRestriction});
    }

    public Cone getCone() {
        return this.cone;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, CircularConeFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        CircularConeFeature.deriveInitialGuess(points, feature.cone);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int nop = 0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            if (cone.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + cone.getDimension() + " != " + point.getDimension());
        }
        if (nop < 6) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 6 points are needed.");
        }
        if (nop > 8) {
            CircularConeFeature.deriveInitialGuessByQuadraticFunction(points, cone);
        } else {
            CircularConeFeature.deriveInitialGuessByCircle(points, cone);
        }
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        CircularConeFeature.deriveInitialGuess(this.cone.getFeaturePoints(), this.cone);
    }

    private static void deriveInitialGuessByQuadraticFunction(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Sphere sphere = new Sphere();
        SphereFeature.deriveInitialGuess(points, sphere);
        double xS = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_X).getValue0();
        double yS = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Y).getValue0();
        double zS = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Z).getValue0();
        int dim = 3;
        double INV_SQRT2 = Math.sqrt(2.0);
        QuadraticSurface quadraticSurface = new QuadraticSurface();
        QuadraticSurfaceFeature.deriveInitialGuess(points, quadraticSurface);
        double a = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_A).getValue0();
        double b = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_B).getValue0();
        double c = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_C).getValue0();
        double d = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_D).getValue0();
        double e = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_E).getValue0();
        double f = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_F).getValue0();
        double g = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_G).getValue0();
        double h = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_H).getValue0();
        double i = quadraticSurface.getUnknownParameter(ParameterType.POLYNOMIAL_COEFFICIENT_I).getValue0();
        DenseVector u = new DenseVector(new double[]{g, h, i}, false);
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(3);
        H.set(0, 0, a);
        H.set(0, 1, d / INV_SQRT2);
        H.set(0, 2, e / INV_SQRT2);
        H.set(1, 1, b);
        H.set(1, 2, f / INV_SQRT2);
        H.set(2, 2, c);
        UpperSymmPackMatrix U = new UpperSymmPackMatrix((Matrix)H);
        MathExtension.solve(U, u, false);
        double x0 = -0.5 * u.get(0);
        double y0 = -0.5 * u.get(1);
        double z0 = -0.5 * u.get(2);
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(H);
        DenseMatrix evec = evd.getEigenvectors();
        double[] eval = evd.getEigenvalues();
        double wx = xS - x0;
        double wy = yS - y0;
        double wz = zS - z0;
        double normw = Math.sqrt(wx * wx + wy * wy + wz * wz);
        double rx = Math.atan2(wy /= normw, wz /= normw);
        double ry = Math.atan2(-(wx /= normw), Math.hypot(wy, wz));
        double ux = Math.cos(ry);
        double uy = Math.sin(rx) * Math.sin(ry);
        double uz = Math.cos(rx) * Math.sin(ry);
        double vx = 0.0;
        double vy = Math.cos(rx);
        double vz = -Math.sin(rx);
        wx = -Math.sin(ry);
        wy = Math.sin(rx) * Math.cos(ry);
        wz = Math.cos(rx) * Math.cos(ry);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        if (Math.signum(eval[0]) == Math.signum(eval[1])) {
            a = Math.sqrt(Math.abs(eval[0] / eval[2]));
            if (a > (c = Math.sqrt(Math.abs(eval[1] / eval[2])))) {
                int[] nArray2 = new int[3];
                nArray2[1] = 1;
                nArray2[2] = 2;
                order = nArray2;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 1;
                nArray3[2] = 2;
                order = nArray3;
                tmp = a;
                a = c;
                c = tmp;
            }
        } else if (Math.signum(eval[0]) == Math.signum(eval[2])) {
            a = Math.sqrt(Math.abs(eval[0] / eval[1]));
            if (a > (c = Math.sqrt(Math.abs(eval[2] / eval[1])))) {
                int[] nArray4 = new int[3];
                nArray4[1] = 2;
                nArray4[2] = 1;
                order = nArray4;
            } else {
                int[] nArray5 = new int[3];
                nArray5[0] = 2;
                nArray5[2] = 1;
                order = nArray5;
                tmp = a;
                a = c;
                c = tmp;
            }
        } else {
            a = Math.sqrt(Math.abs(eval[1] / eval[0]));
            if (a > (c = Math.sqrt(Math.abs(eval[2] / eval[0])))) {
                int[] nArray6 = new int[3];
                nArray6[0] = 1;
                nArray6[1] = 2;
                order = nArray6;
            } else {
                int[] nArray7 = new int[3];
                nArray7[0] = 2;
                nArray7[1] = 1;
                order = nArray7;
                tmp = a;
                a = c;
                c = tmp;
            }
        }
        DenseMatrix rotation = new DenseMatrix(3, 3);
        int row = 0;
        while (row < 3) {
            int column = 0;
            while (column < 3) {
                int idx = order[column];
                rotation.set(row, column, evec.get(row, idx));
                ++column;
            }
            ++row;
        }
        double r11 = rotation.get(0, 0);
        double r12 = rotation.get(1, 0);
        double r13 = rotation.get(2, 0);
        double r21 = rotation.get(0, 1);
        double r22 = rotation.get(1, 1);
        double r23 = rotation.get(2, 1);
        double r31 = rotation.get(0, 2);
        double r32 = rotation.get(1, 2);
        double r33 = rotation.get(2, 2);
        rx = Math.atan2(r32, r33);
        ry = Math.atan2(-r31, Math.hypot(r32, r33));
        r11 = Math.cos(ry);
        r12 = Math.sin(rx) * Math.sin(ry);
        r13 = Math.cos(rx) * Math.sin(ry);
        r21 = 0.0;
        r22 = Math.cos(rx);
        r23 = -Math.sin(rx);
        r31 = -Math.sin(ry);
        r32 = Math.sin(rx) * Math.cos(ry);
        r33 = Math.cos(rx) * Math.cos(ry);
        b = 0.5 * (a + c);
        if (Math.abs(Math.abs(a) - Math.abs(c)) > Math.pow(Constant.EPS, 0.3333333333333333)) {
            cone.setInitialGuess(x0, y0, z0, b, b, ux, uy, uz, vx, vy, vz, wx, wy, wz);
        } else {
            cone.setInitialGuess(x0, y0, z0, b, b, r11, r12, r13, r21, r22, r23, r31, r32, r33);
        }
    }

    private static void deriveInitialGuessByCircle(Collection<FeaturePoint> points, Cone cone) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        Sphere sphere = new Sphere();
        Plane plane = new Plane();
        SpatialCircleFeature.deriveInitialGuess(points, sphere, plane);
        double x0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_X).getValue0();
        double y0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Y).getValue0();
        double z0 = sphere.getUnknownParameter(ParameterType.ORIGIN_COORDINATE_Z).getValue0();
        double wx = plane.getUnknownParameter(ParameterType.VECTOR_X).getValue0();
        double wy = plane.getUnknownParameter(ParameterType.VECTOR_Y).getValue0();
        double wz = plane.getUnknownParameter(ParameterType.VECTOR_Z).getValue0();
        double rx = Math.atan2(wy, wz);
        double ry = Math.atan2(-wx, Math.hypot(wy, wz));
        double ux = Math.cos(ry);
        double uy = Math.sin(rx) * Math.sin(ry);
        double uz = Math.cos(rx) * Math.sin(ry);
        double vx = 0.0;
        double vy = Math.cos(rx);
        double vz = -Math.sin(rx);
        wx = -Math.sin(ry);
        wy = Math.sin(rx) * Math.cos(ry);
        wz = Math.cos(rx) * Math.cos(ry);
        Quaternion q = FeatureUtil.getQuaternionHz(new double[]{wx, wy, wz});
        Collection<FeaturePoint> rotatedPoints = FeatureUtil.getRotatedFeaturePoints(points, new double[]{0.0, 0.0, 0.0}, q);
        Quaternion rotatedApexQ = q.rotate(new double[]{x0, y0, z0});
        double rx0 = rotatedApexQ.getQ1();
        double ry0 = rotatedApexQ.getQ2();
        double rz0 = rotatedApexQ.getQ3();
        double r = 0.0;
        int nop = 0;
        for (FeaturePoint point : rotatedPoints) {
            if (!point.isEnable()) continue;
            ++nop;
            double rxi = point.getX0();
            double ryi = point.getY0();
            double rzi = point.getZ0();
            double dx = rxi - rx0;
            double dy = ryi - ry0;
            double dz = rzi - rz0;
            r += Math.abs(dz * dz / (dx * dx + dy * dy));
        }
        r = Math.sqrt(r / (double)nop);
        cone.setInitialGuess(x0, y0, z0, r, r, ux, uy, uz, vx, vy, vz, wx, wy, wz);
    }
}

