/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.restriction;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;

public class VectorAngleRestriction
extends Restriction {
    private ObservableList<UnknownParameter> regressorsA = FXCollections.observableArrayList();
    private ObservableList<UnknownParameter> regressorsB = FXCollections.observableArrayList();

    public VectorAngleRestriction() {
        this(false, new ArrayList<UnknownParameter>(0), new ArrayList<UnknownParameter>(0), null);
    }

    public VectorAngleRestriction(boolean indispensable, List<UnknownParameter> regressorsA, List<UnknownParameter> regressorsB, UnknownParameter regressand) {
        super(RestrictionType.VECTOR_ANGLE, indispensable);
        this.setRegressand(regressand);
        this.regressorsA.setAll(regressorsA);
        this.regressorsB.setAll(regressorsB);
        this.check();
    }

    public ObservableList<UnknownParameter> getRegressorsA() {
        return this.regressorsA;
    }

    public ObservableList<UnknownParameter> getRegressorsB() {
        return this.regressorsB;
    }

    @Override
    public double getMisclosure() {
        this.check();
        double dotAB = 0.0;
        double dotAA = 0.0;
        double dotBB = 0.0;
        int length = this.regressorsA.size();
        int i = 0;
        while (i < length) {
            double ai = ((UnknownParameter)this.regressorsA.get(i)).getValue();
            double bi = ((UnknownParameter)this.regressorsB.get(i)).getValue();
            dotAB += ai * bi;
            dotAA += ai * ai;
            dotBB += bi * bi;
            ++i;
        }
        return Math.acos(dotAB / Math.sqrt(dotAA) / Math.sqrt(dotBB)) - ((UnknownParameter)this.regressand.get()).getValue();
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        this.check();
        int rowIndex = this.getRow();
        double dotAB = 0.0;
        double dotAA = 0.0;
        double dotBB = 0.0;
        int length = this.regressorsA.size();
        int i = 0;
        while (i < length) {
            double ai = ((UnknownParameter)this.regressorsA.get(i)).getValue();
            double bi = ((UnknownParameter)this.regressorsB.get(i)).getValue();
            dotAB += ai * bi;
            dotAA += ai * ai;
            dotBB += bi * bi;
            ++i;
        }
        i = 0;
        while (i < length) {
            UnknownParameter ai = (UnknownParameter)this.regressorsA.get(i);
            UnknownParameter bi = (UnknownParameter)this.regressorsB.get(i);
            if (ai.getColumn() >= 0) {
                JrT.add(ai.getColumn(), rowIndex, -(bi.getValue() / Math.sqrt(dotAA) / Math.sqrt(dotBB) - ai.getValue() * dotAB / Math.pow(dotAA, 1.5) / Math.sqrt(dotBB)) / Math.sqrt(1.0 - dotAB * dotAB / dotAA / dotBB));
            }
            if (bi.getColumn() >= 0) {
                JrT.add(bi.getColumn(), rowIndex, -(ai.getValue() / Math.sqrt(dotAA) / Math.sqrt(dotBB) - bi.getValue() * dotAB / Math.sqrt(dotAA) / Math.pow(dotBB, 1.5)) / Math.sqrt(1.0 - dotAB * dotAB / dotAA / dotBB));
            }
            ++i;
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.regressorsA.contains(object) || this.regressorsB.contains(object);
    }

    @Override
    public String toLaTex() {
        return "$\\arccos{\\left(\\frac{\\mathbf a^{\\mathrm T} \\mathbf b} {\\vert \\mathbf a \\vert \\vert \\mathbf b \\vert}\\right)} = c$";
    }

    private void check() {
        if (this.regressorsA.size() != this.regressorsB.size()) {
            throw new IllegalArgumentException("Error, unequal size of factorsA and factorsB " + this.regressorsA.size() + " != " + this.regressorsB.size());
        }
    }
}

