/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.restriction;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;

public class TrigonometricRestriction
extends Restriction {
    private ObjectProperty<TrigonometricFunctionType> trigonometricFunctionType = new SimpleObjectProperty((Object)this, "trigonometricFunctionType", (Object)TrigonometricFunctionType.TANGENT);
    private ObjectProperty<UnknownParameter> regressor = new SimpleObjectProperty((Object)this, "regressor");
    private ObjectProperty<Boolean> invert = new SimpleObjectProperty((Object)this, "invert", (Object)Boolean.FALSE);

    public TrigonometricRestriction() {
        this(false, TrigonometricFunctionType.TANGENT, Boolean.FALSE, null, null);
    }

    public TrigonometricRestriction(boolean indispensable, TrigonometricFunctionType trigonometricFunctionType, boolean invert, UnknownParameter regressor, UnknownParameter regressand) {
        super(RestrictionType.TRIGONOMERTIC_FUNCTION, indispensable);
        this.setRegressand(regressand);
        this.setRegressor(regressor);
        this.setInvert(invert);
        this.setTrigonometricFunctionType(trigonometricFunctionType);
    }

    public UnknownParameter getRegressor() {
        return (UnknownParameter)this.regressor.get();
    }

    public void setRegressor(UnknownParameter regressor) {
        this.regressor.set((Object)regressor);
    }

    public ObjectProperty<UnknownParameter> regressorProperty() {
        return this.regressor;
    }

    public TrigonometricFunctionType getTrigonometricFunctionType() {
        return (TrigonometricFunctionType)((Object)this.trigonometricFunctionType.get());
    }

    public void setTrigonometricFunctionType(TrigonometricFunctionType trigonometricFunctionType) {
        this.trigonometricFunctionType.set((Object)trigonometricFunctionType);
    }

    public ObjectProperty<TrigonometricFunctionType> trigonometricFunctionTypeProperty() {
        return this.trigonometricFunctionType;
    }

    public void setInvert(boolean invert) {
        this.invert.set((Object)invert);
    }

    public boolean isInvert() {
        return (Boolean)this.invert.get();
    }

    public ObjectProperty<Boolean> invertProperty() {
        return this.invert;
    }

    @Override
    public double getMisclosure() {
        double a = ((UnknownParameter)this.regressor.get()).getValue();
        double c = ((UnknownParameter)this.regressand.get()).getValue();
        TrigonometricFunctionType type = (TrigonometricFunctionType)((Object)this.trigonometricFunctionType.get());
        switch (type) {
            case SINE: {
                return this.isInvert() ? Math.asin(a) - c : Math.sin(a) - c;
            }
            case COSINE: {
                return this.isInvert() ? Math.acos(a) - c : Math.cos(a) - c;
            }
            case TANGENT: {
                return this.isInvert() ? Math.atan(a) - c : Math.tan(a) - c;
            }
            case COTANGENT: {
                return this.isInvert() ? MathExtension.acot(a) - c : 1.0 / MathExtension.cot(a) - c;
            }
        }
        throw new IllegalArgumentException("Error, unsupported trigonometric function type " + String.valueOf((Object)this.getTrigonometricFunctionType()) + "!");
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        int rowIndex = this.getRow();
        TrigonometricFunctionType type = (TrigonometricFunctionType)((Object)this.trigonometricFunctionType.get());
        if (((UnknownParameter)this.regressor.get()).getColumn() >= 0) {
            int columnIndex = ((UnknownParameter)this.regressor.get()).getColumn();
            double a = ((UnknownParameter)this.regressor.get()).getValue();
            switch (type) {
                case SINE: {
                    JrT.add(columnIndex, rowIndex, this.isInvert() ? 1.0 / Math.sqrt(1.0 - a * a) : Math.cos(a));
                    break;
                }
                case COSINE: {
                    JrT.add(columnIndex, rowIndex, this.isInvert() ? -1.0 / Math.sqrt(1.0 - a * a) : -Math.sin(a));
                    break;
                }
                case TANGENT: {
                    JrT.add(columnIndex, rowIndex, this.isInvert() ? 1.0 / (1.0 + a * a) : 1.0 / Math.cos(a) / Math.cos(a));
                    break;
                }
                case COTANGENT: {
                    JrT.add(columnIndex, rowIndex, this.isInvert() ? -1.0 / (1.0 + a * a) : -1.0 / Math.sin(a) / Math.sin(a));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unsupported trigonometric function type " + String.valueOf((Object)this.getTrigonometricFunctionType()) + "!");
                }
            }
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.regressor.get() == object;
    }

    @Override
    public String toLaTex() {
        return "$\\mathrm{trigon} \\left( a \\right) = c$";
    }

    public static enum TrigonometricFunctionType {
        SINE,
        COSINE,
        TANGENT,
        COTANGENT;

    }
}

