/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.restriction;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;

public class ProductSumRestriction
extends Restriction {
    private ObservableList<UnknownParameter> regressorsA = FXCollections.observableArrayList();
    private ObservableList<UnknownParameter> regressorsB = FXCollections.observableArrayList();
    private ObjectProperty<Double> exponent = new SimpleObjectProperty((Object)this, "exponent", (Object)1.0);
    private ObservableList<SignType> coefficientSigns = FXCollections.observableArrayList();

    public ProductSumRestriction() {
        this(false, new ArrayList<UnknownParameter>(0), new ArrayList<UnknownParameter>(0), new ArrayList<SignType>(0), null);
    }

    public ProductSumRestriction(boolean indispensable, List<UnknownParameter> regressorsA, List<UnknownParameter> regressorsB, UnknownParameter regressand) {
        this(indispensable, regressorsA, regressorsB, 1.0, ProductSumRestriction.createSignTypeList(regressorsA.size()), regressand);
    }

    public ProductSumRestriction(boolean indispensable, List<UnknownParameter> regressorsA, List<UnknownParameter> regressorsB, List<SignType> coefficientSigns, UnknownParameter regressand) {
        this(indispensable, regressorsA, regressorsB, 1.0, coefficientSigns, regressand);
    }

    public ProductSumRestriction(boolean indispensable, List<UnknownParameter> regressorsA, List<UnknownParameter> regressorsB, double exponent, UnknownParameter regressand) {
        this(indispensable, regressorsA, regressorsB, exponent, ProductSumRestriction.createSignTypeList(regressorsA.size()), regressand);
    }

    public ProductSumRestriction(boolean indispensable, List<UnknownParameter> regressorsA, List<UnknownParameter> regressorsB, double exponent, List<SignType> coefficientSigns, UnknownParameter regressand) {
        super(RestrictionType.PRODUCT_SUM, indispensable);
        this.setRegressand(regressand);
        this.regressorsA.setAll(regressorsA);
        this.regressorsB.setAll(regressorsB);
        this.setExponent(exponent);
        this.coefficientSigns.setAll(coefficientSigns);
        this.check();
    }

    private static List<SignType> createSignTypeList(int size) {
        ArrayList<SignType> signTypeList = new ArrayList<SignType>(size);
        int i = 0;
        while (i < size) {
            signTypeList.add(SignType.PLUS);
            ++i;
        }
        return signTypeList;
    }

    public void setExponent(double exponent) {
        this.exponent.set((Object)exponent);
    }

    public double getExponent() {
        return (Double)this.exponent.get();
    }

    public ObjectProperty<Double> exponentProperty() {
        return this.exponent;
    }

    public ObservableList<UnknownParameter> getRegressorsA() {
        return this.regressorsA;
    }

    public ObservableList<UnknownParameter> getRegressorsB() {
        return this.regressorsB;
    }

    public ObservableList<SignType> getCoefficientSigns() {
        return this.coefficientSigns;
    }

    @Override
    public double getMisclosure() {
        this.check();
        double d = 0.0;
        int length = this.coefficientSigns.size();
        int i = 0;
        while (i < length) {
            d += ((SignType)((Object)this.coefficientSigns.get(i))).getSign() * ((UnknownParameter)this.regressorsA.get(i)).getValue() * ((UnknownParameter)this.regressorsB.get(i)).getValue();
            ++i;
        }
        return Math.pow(d, (Double)this.exponent.get()) - ((UnknownParameter)this.regressand.get()).getValue();
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        this.check();
        int rowIndex = this.getRow();
        int length = this.coefficientSigns.size();
        int i = 0;
        while (i < length) {
            if (((UnknownParameter)this.regressorsA.get(i)).getColumn() >= 0) {
                JrT.add(((UnknownParameter)this.regressorsA.get(i)).getColumn(), rowIndex, ((SignType)((Object)this.coefficientSigns.get(i))).getSign() * ((UnknownParameter)this.regressorsB.get(i)).getValue());
            }
            if (((UnknownParameter)this.regressorsB.get(i)).getColumn() >= 0) {
                JrT.add(((UnknownParameter)this.regressorsB.get(i)).getColumn(), rowIndex, ((SignType)((Object)this.coefficientSigns.get(i))).getSign() * ((UnknownParameter)this.regressorsA.get(i)).getValue());
            }
            ++i;
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
        if ((Double)this.exponent.get() != 1.0) {
            double outer = 0.0;
            int i2 = 0;
            while (i2 < length) {
                outer += ((SignType)((Object)this.coefficientSigns.get(i2))).getSign() * ((UnknownParameter)this.regressorsA.get(i2)).getValue() * ((UnknownParameter)this.regressorsB.get(i2)).getValue();
                ++i2;
            }
            outer = (Double)this.exponent.get() * Math.pow(outer, (Double)this.exponent.get() - 1.0);
            int columnIndex = 0;
            while (columnIndex < JrT.numRows()) {
                JrT.set(columnIndex, rowIndex, JrT.get(columnIndex, rowIndex) * outer);
                ++columnIndex;
            }
        }
    }

    private void check() {
        if (this.regressorsA.size() != this.regressorsB.size()) {
            throw new IllegalArgumentException("Error, unequal size of factorsA and factorsB " + this.regressorsA.size() + " != " + this.regressorsB.size());
        }
        if (this.regressorsA.size() != this.coefficientSigns.size()) {
            throw new IllegalArgumentException("Error, unequal size of factors and signs " + this.regressorsA.size() + " != " + this.coefficientSigns.size());
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.regressorsA.contains(object) || this.regressorsB.contains(object);
    }

    @Override
    public String toLaTex() {
        return "$\\left(\\pm a_1 b_1 \\pm a_i b_i \\pm \\cdots \\pm a_n b_n\\right)^{k} = c$";
    }

    public static enum SignType {
        PLUS('+'),
        MINUS('-');

        private final char label;

        private SignType(char label) {
            this.label = label;
        }

        public final double getSign() {
            return this.label == '-' ? -1.0 : 1.0;
        }

        public String toString() {
            return String.valueOf(this.label);
        }
    }
}

