/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.restriction;

import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;

public class FeaturePointRestriction
extends Restriction {
    private ObjectProperty<FeaturePoint> featurePoint = new SimpleObjectProperty((Object)this, "featurePoint");
    private ObjectProperty<GeometricPrimitive> geometricPrimitive = new SimpleObjectProperty((Object)this, "geometricPrimitive");

    public FeaturePointRestriction() {
        this(false, null, null);
    }

    public FeaturePointRestriction(boolean indispensable, GeometricPrimitive geometricPrimitive, FeaturePoint featurePoint) {
        super(RestrictionType.FEATURE_POINT, indispensable);
        this.setGeometricPrimitive(geometricPrimitive);
        this.setFeaturePoint(featurePoint);
    }

    public void setGeometricPrimitive(GeometricPrimitive geometricPrimitive) {
        this.geometricPrimitive.set((Object)geometricPrimitive);
    }

    public GeometricPrimitive getGeometricPrimitive() {
        return (GeometricPrimitive)this.geometricPrimitive.get();
    }

    public ObjectProperty<GeometricPrimitive> geometricPrimitiveProperty() {
        return this.geometricPrimitive;
    }

    public void setFeaturePoint(FeaturePoint featurePoint) {
        this.featurePoint.set((Object)featurePoint);
    }

    public FeaturePoint getFeaturePoint() {
        return (FeaturePoint)this.featurePoint.get();
    }

    public ObjectProperty<FeaturePoint> featurePointProperty() {
        return this.featurePoint;
    }

    @Override
    public double getMisclosure() {
        return this.getGeometricPrimitive().getMisclosure(this.getFeaturePoint());
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        Collection<UnknownParameter> unknownParameters = this.getGeometricPrimitive().getUnknownParameters();
        int rowIndex = this.getRow();
        DenseMatrix jx = new DenseMatrix(1, JrT.numRows());
        this.getGeometricPrimitive().jacobianElements(this.getFeaturePoint(), (Matrix)jx, null, 0);
        for (UnknownParameter unknownParameter : unknownParameters) {
            int column = unknownParameter.getColumn();
            if (column < 0) continue;
            JrT.set(column, rowIndex, jx.get(0, column));
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return this.getFeaturePoint() == object || this.getGeometricPrimitive() == object;
    }

    @Override
    public String toLaTex() {
        return "$f\\left(x, p\\right) = 0$";
    }
}

