/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.point;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;

public class Point {
    private static int ID_CNT = 0;
    private ReadOnlyObjectProperty<Integer> id;
    private ObjectProperty<String> name = new SimpleObjectProperty((Object)this, "name", (Object)"");
    private ObjectProperty<Double> x0 = new SimpleObjectProperty((Object)this, "x0", (Object)0.0);
    private ObjectProperty<Double> y0 = new SimpleObjectProperty((Object)this, "y0", (Object)0.0);
    private ObjectProperty<Double> z0 = new SimpleObjectProperty((Object)this, "z0", (Object)0.0);
    private ReadOnlyObjectProperty<Integer> dimension;

    public Point(Point point) {
        this(point.getName(), point.getX0(), point.getY0(), point.getZ0(), point.getDimension());
    }

    public Point(String name, double x0, double y0) {
        this(name, x0, y0, 0.0, 2);
    }

    public Point(String name, double x0, double y0, double z0) {
        this(name, x0, y0, z0, 3);
    }

    private Point(String name, double x0, double y0, double z0, int dimension) {
        this.id = new ReadOnlyObjectWrapper((Object)this, "id", (Object)ID_CNT++);
        this.dimension = new ReadOnlyObjectWrapper((Object)this, "dimension", (Object)dimension);
        this.setName(name);
        this.setX0(x0);
        this.setY0(y0);
        this.setZ0(z0);
    }

    public final int getId() {
        return (Integer)this.id.get();
    }

    public ReadOnlyObjectProperty<Integer> idProperty() {
        return this.id;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public ObjectProperty<String> nameProperty() {
        return this.name;
    }

    public int getDimension() {
        return (Integer)this.dimension.get();
    }

    public ReadOnlyObjectProperty<Integer> dimensionProperty() {
        return this.dimension;
    }

    public double getX0() {
        return (Double)this.x0.get();
    }

    public void setX0(double x0) {
        this.x0.set((Object)x0);
    }

    public ObjectProperty<Double> x0Property() {
        return this.x0;
    }

    public double getY0() {
        return (Double)this.y0.get();
    }

    public void setY0(double y0) {
        this.y0.set((Object)y0);
    }

    public ObjectProperty<Double> y0Property() {
        return this.y0;
    }

    public double getZ0() {
        return (Double)this.z0.get();
    }

    public void setZ0(double z0) {
        this.z0.set((Object)z0);
    }

    public ObjectProperty<Double> z0Property() {
        return this.z0;
    }

    public String toString() {
        return "Point#" + String.valueOf(this.id.get()) + " [name=" + (String)this.name.get() + ", x0=" + String.valueOf(this.x0.get()) + ", y0=" + String.valueOf(this.y0.get()) + ", z0=" + String.valueOf(this.z0.get()) + ", dimension=" + String.valueOf(this.dimension.get()) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimension == null ? 0 : ((Integer)this.dimension.get()).hashCode());
        result = 31 * result + (this.id == null ? 0 : ((Integer)this.id.get()).hashCode());
        result = 31 * result + (this.x0 == null ? 0 : ((Double)this.x0.get()).hashCode());
        result = 31 * result + (this.y0 == null ? 0 : ((Double)this.y0.get()).hashCode());
        result = 31 * result + (this.z0 == null ? 0 : ((Double)this.z0.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.equalsCoordinateComponents(other);
    }

    public boolean equalsCoordinateComponents(Point point) {
        if (this == point) {
            return true;
        }
        if (point == null) {
            return false;
        }
        if (this.getDimension() != point.getDimension()) {
            return false;
        }
        if (this.getX0() != point.getX0()) {
            return false;
        }
        if (this.getY0() != point.getY0()) {
            return false;
        }
        return this.getZ0() == point.getZ0();
    }
}

