/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.point;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UnitUpperTriangBandMatrix;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.TestStatistic;
import org.applied_geodesy.adjustment.geometry.VarianceComponent;
import org.applied_geodesy.adjustment.geometry.point.Point;

public class FeaturePoint
extends Point
implements Iterable<GeometricPrimitive> {
    private ReadOnlyObjectProperty<TestStatistic> testStatistic = new ReadOnlyObjectWrapper((Object)this, "testStatistic", (Object)new TestStatistic());
    private ObjectProperty<Boolean> enable = new SimpleObjectProperty((Object)this, "enable", (Object)Boolean.TRUE);
    private ObjectProperty<Double> residualX = new SimpleObjectProperty((Object)this, "residualX", (Object)0.0);
    private ObjectProperty<Double> residualY = new SimpleObjectProperty((Object)this, "residualY", (Object)0.0);
    private ObjectProperty<Double> residualZ = new SimpleObjectProperty((Object)this, "residualZ", (Object)0.0);
    private ObjectProperty<Double> redundancyX = new SimpleObjectProperty((Object)this, "redundancyX", (Object)0.0);
    private ObjectProperty<Double> redundancyY = new SimpleObjectProperty((Object)this, "redundancyY", (Object)0.0);
    private ObjectProperty<Double> redundancyZ = new SimpleObjectProperty((Object)this, "redundancyZ", (Object)0.0);
    private ObjectProperty<Double> grossErrorX = new SimpleObjectProperty((Object)this, "grossErrorX", (Object)0.0);
    private ObjectProperty<Double> grossErrorY = new SimpleObjectProperty((Object)this, "grossErrorY", (Object)0.0);
    private ObjectProperty<Double> grossErrorZ = new SimpleObjectProperty((Object)this, "grossErrorZ", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasX = new SimpleObjectProperty((Object)this, "minimalDetectableBiasX", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasY = new SimpleObjectProperty((Object)this, "minimalDetectableBiasY", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasZ = new SimpleObjectProperty((Object)this, "minimalDetectableBiasZ", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasX = new SimpleObjectProperty((Object)this, "maximumTolerableBiasX", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasY = new SimpleObjectProperty((Object)this, "maximumTolerableBiasY", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasZ = new SimpleObjectProperty((Object)this, "maximumTolerableBiasZ", (Object)0.0);
    private ObjectProperty<Double> cofactorX = new SimpleObjectProperty((Object)this, "cofactorX", (Object)0.0);
    private ObjectProperty<Double> cofactorY = new SimpleObjectProperty((Object)this, "cofactorY", (Object)0.0);
    private ObjectProperty<Double> cofactorZ = new SimpleObjectProperty((Object)this, "cofactorZ", (Object)0.0);
    private ObjectBinding<Double> x;
    private ObjectBinding<Double> y;
    private ObjectBinding<Double> z;
    private ObjectBinding<Double> uncertaintyX;
    private ObjectBinding<Double> uncertaintyY;
    private ObjectBinding<Double> uncertaintyZ;
    private ReadOnlyObjectWrapper<Double> testStatisticApriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> testStatisticAposteriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticAposteriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueApriori = new ReadOnlyObjectWrapper((Object)this, "pValueApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueAposteriori = new ReadOnlyObjectWrapper((Object)this, "pValueAposteriori", (Object)0.0);
    private ObjectBinding<Boolean> significant;
    private ObjectProperty<Matrix> dispersionApriori = new SimpleObjectProperty((Object)this, "dispersionApriori");
    private ObjectProperty<Double> fisherQuantileApriori = new SimpleObjectProperty((Object)this, "fisherQuantileApriori", (Object)Double.MAX_VALUE);
    private ObjectProperty<Double> fisherQuantileAposteriori = new SimpleObjectProperty((Object)this, "fisherQuantileAposteriori", (Object)Double.MAX_VALUE);
    private Set<GeometricPrimitive> geometries = new LinkedHashSet<GeometricPrimitive>();

    public FeaturePoint(String name, double x0, double y0) throws IllegalArgumentException {
        this(name, x0, y0, MathExtension.identity(2));
    }

    public FeaturePoint(String name, double x0, double y0, Matrix dispersion) throws IllegalArgumentException {
        super(name, x0, y0);
        this.setDispersionApriori(dispersion);
        this.init(this.getDimension());
    }

    public FeaturePoint(String name, double x0, double y0, double z0) throws IllegalArgumentException {
        this(name, x0, y0, z0, MathExtension.identity(3));
    }

    public FeaturePoint(String name, double x0, double y0, double z0, Matrix dispersion) throws IllegalArgumentException {
        super(name, x0, y0, z0);
        this.setDispersionApriori(dispersion);
        this.init(this.getDimension());
    }

    private void init(int dim) {
        this.x = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)FeaturePoint.this.x0Property().get() + (Double)FeaturePoint.this.residualX.get();
            }
        };
        this.y = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)FeaturePoint.this.y0Property().get() + (Double)FeaturePoint.this.residualY.get();
            }
        };
        this.z = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)FeaturePoint.this.z0Property().get() + (Double)FeaturePoint.this.residualZ.get();
            }
        };
        this.uncertaintyX = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorX.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorX.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).variance0Property().get()));
            }
        };
        this.uncertaintyY = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorY.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorY.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).variance0Property().get()));
            }
        };
        this.uncertaintyZ = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorZ.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)FeaturePoint.this.cofactorZ.get() * (Double)((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).variance0Property().get()));
            }
        };
        this.testStatisticApriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAprioriProperty());
        this.testStatisticAposteriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAposterioriProperty());
        this.pValueApriori.bind(((TestStatistic)this.testStatistic.get()).pValueAprioriProperty());
        this.pValueAposteriori.bind(((TestStatistic)this.testStatistic.get()).pValueAposterioriProperty());
        this.significant = new ObjectBinding<Boolean>(){

            protected Boolean computeValue() {
                boolean significant;
                boolean bl = significant = (Double)FeaturePoint.this.testStatisticApriori.get() > (Double)FeaturePoint.this.fisherQuantileApriori.get();
                if (((VarianceComponent)((TestStatistic)FeaturePoint.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    if (!significant && !((Double)FeaturePoint.this.testStatisticAposteriori.get() > (Double)FeaturePoint.this.fisherQuantileAposteriori.get())) {
                        return false;
                    }
                    return true;
                }
                return significant;
            }
        };
    }

    public double getX() {
        return (Double)this.x.get();
    }

    public ObjectBinding<Double> xProperty() {
        return this.x;
    }

    public double getY() {
        return (Double)this.y.get();
    }

    public ObjectBinding<Double> yProperty() {
        return this.y;
    }

    public double getZ() {
        return (Double)this.z.get();
    }

    public ObjectBinding<Double> zProperty() {
        return this.z;
    }

    public boolean isEnable() {
        return (Boolean)this.enable.get();
    }

    public void setEnable(boolean enable) {
        this.enable.set((Object)enable);
    }

    public ObjectProperty<Boolean> enableProperty() {
        return this.enable;
    }

    public double getResidualX() {
        return (Double)this.residualX.get();
    }

    public void setResidualX(double residualX) {
        this.residualX.set((Object)residualX);
    }

    public ObjectProperty<Double> residualXProperty() {
        return this.residualX;
    }

    public double getResidualY() {
        return (Double)this.residualY.get();
    }

    public void setResidualY(double residualY) {
        this.residualY.set((Object)residualY);
    }

    public ObjectProperty<Double> residualYProperty() {
        return this.residualY;
    }

    public double getResidualZ() {
        return (Double)this.residualZ.get();
    }

    public void setResidualZ(double residualZ) {
        this.residualZ.set((Object)residualZ);
    }

    public ObjectProperty<Double> residualZProperty() {
        return this.residualZ;
    }

    public double getRedundancyX() {
        return (Double)this.redundancyX.get();
    }

    public void setRedundancyX(double redundancyX) {
        this.redundancyX.set((Object)redundancyX);
    }

    public ObjectProperty<Double> redundancyXProperty() {
        return this.redundancyX;
    }

    public double getRedundancyY() {
        return (Double)this.redundancyY.get();
    }

    public void setRedundancyY(double redundancyY) {
        this.redundancyY.set((Object)redundancyY);
    }

    public ObjectProperty<Double> redundancyYProperty() {
        return this.redundancyY;
    }

    public double getRedundancyZ() {
        return (Double)this.redundancyZ.get();
    }

    public void setRedundancyZ(double redundancyZ) {
        this.redundancyZ.set((Object)redundancyZ);
    }

    public ObjectProperty<Double> redundancyZProperty() {
        return this.redundancyZ;
    }

    public double getMinimalDetectableBiasX() {
        return (Double)this.minimalDetectableBiasX.get();
    }

    public void setMinimalDetectableBiasX(double minimalDetectableBiasX) {
        this.minimalDetectableBiasX.set((Object)minimalDetectableBiasX);
    }

    public ObjectProperty<Double> minimalDetectableBiasXProperty() {
        return this.minimalDetectableBiasX;
    }

    public double getMinimalDetectableBiasY() {
        return (Double)this.minimalDetectableBiasY.get();
    }

    public void setMinimalDetectableBiasY(double minimalDetectableBiasY) {
        this.minimalDetectableBiasY.set((Object)minimalDetectableBiasY);
    }

    public ObjectProperty<Double> minimalDetectableBiasYProperty() {
        return this.minimalDetectableBiasY;
    }

    public double getMinimalDetectableBiasZ() {
        return (Double)this.minimalDetectableBiasZ.get();
    }

    public void setMinimalDetectableBiasZ(double minimalDetectableBiasZ) {
        this.minimalDetectableBiasZ.set((Object)minimalDetectableBiasZ);
    }

    public ObjectProperty<Double> minimalDetectableBiasZProperty() {
        return this.minimalDetectableBiasZ;
    }

    public double getMaximumTolerableBiasX() {
        return (Double)this.maximumTolerableBiasX.get();
    }

    public void setMaximumTolerableBiasX(double maximumTolerableBiasX) {
        this.maximumTolerableBiasX.set((Object)maximumTolerableBiasX);
    }

    public ObjectProperty<Double> maximumTolerableBiasXProperty() {
        return this.maximumTolerableBiasX;
    }

    public double getMaximumTolerableBiasY() {
        return (Double)this.maximumTolerableBiasY.get();
    }

    public void setMaximumTolerableBiasY(double maximumTolerableBiasY) {
        this.maximumTolerableBiasY.set((Object)maximumTolerableBiasY);
    }

    public ObjectProperty<Double> maximumTolerableBiasYProperty() {
        return this.maximumTolerableBiasY;
    }

    public double getMaximumTolerableBiasZ() {
        return (Double)this.maximumTolerableBiasZ.get();
    }

    public void setMaximumTolerableBiasZ(double maximumTolerableBiasZ) {
        this.maximumTolerableBiasZ.set((Object)maximumTolerableBiasZ);
    }

    public ObjectProperty<Double> maximumTolerableBiasZProperty() {
        return this.maximumTolerableBiasZ;
    }

    public double getGrossErrorX() {
        return (Double)this.grossErrorX.get();
    }

    public void setGrossErrorX(double grossErrorX) {
        this.grossErrorX.set((Object)grossErrorX);
    }

    public ObjectProperty<Double> grossErrorXProperty() {
        return this.grossErrorX;
    }

    public double getGrossErrorY() {
        return (Double)this.grossErrorY.get();
    }

    public void setGrossErrorY(double grossErrorY) {
        this.grossErrorY.set((Object)grossErrorY);
    }

    public ObjectProperty<Double> grossErrorYProperty() {
        return this.grossErrorY;
    }

    public double getGrossErrorZ() {
        return (Double)this.grossErrorZ.get();
    }

    public void setGrossErrorZ(double grossErrorZ) {
        this.grossErrorZ.set((Object)grossErrorZ);
    }

    public ObjectProperty<Double> grossErrorZProperty() {
        return this.grossErrorZ;
    }

    public ObjectProperty<Matrix> dispersionAprioriProperty() {
        return this.dispersionApriori;
    }

    public Matrix getDispersionApriori() {
        return (Matrix)this.dispersionApriori.get();
    }

    public double getUncertaintyX() {
        return (Double)this.uncertaintyX.get();
    }

    public ObjectBinding<Double> uncertaintyXProperty() {
        return this.uncertaintyX;
    }

    public double getUncertaintyY() {
        return (Double)this.uncertaintyY.get();
    }

    public ObjectBinding<Double> uncertaintyYProperty() {
        return this.uncertaintyY;
    }

    public double getUncertaintyZ() {
        return (Double)this.uncertaintyZ.get();
    }

    public ObjectBinding<Double> uncertaintyZProperty() {
        return this.uncertaintyZ;
    }

    public double getCofactorX() {
        return (Double)this.cofactorX.get();
    }

    public void setCofactorX(double cofactorX) {
        this.cofactorX.set((Object)cofactorX);
    }

    public ObjectProperty<Double> cofactorXProperty() {
        return this.cofactorX;
    }

    public double getCofactorY() {
        return (Double)this.cofactorY.get();
    }

    public void setCofactorY(double cofactorY) {
        this.cofactorY.set((Object)cofactorY);
    }

    public ObjectProperty<Double> cofactorYProperty() {
        return this.cofactorY;
    }

    public double getCofactorZ() {
        return (Double)this.cofactorZ.get();
    }

    public void setCofactorZ(double cofactorZ) {
        this.cofactorZ.set((Object)cofactorZ);
    }

    public ObjectProperty<Double> cofactorZProperty() {
        return this.cofactorZ;
    }

    private void checkDispersionMatrix(Matrix dispersion) throws IllegalArgumentException {
        if (!dispersion.isSquare() || this.getDimension() != dispersion.numColumns()) {
            throw new IllegalArgumentException("Error, dispersion matrix must be a squared matrix of dimension " + this.getDimension() + " x " + this.getDimension() + "!");
        }
        if (!(dispersion instanceof UpperSymmBandMatrix || dispersion instanceof UnitUpperTriangBandMatrix || dispersion instanceof UpperSymmPackMatrix)) {
            throw new IllegalArgumentException("Error, dispersion matrix must be of type UpperSymmBandMatrix, UnitUpperTriangBandMatrix, or UpperSymmPackMatrix!");
        }
        if (dispersion instanceof UpperSymmBandMatrix && ((UpperSymmBandMatrix)dispersion).numSuperDiagonals() != 0 || dispersion instanceof UnitUpperTriangBandMatrix && ((UnitUpperTriangBandMatrix)dispersion).numSuperDiagonals() != 0) {
            throw new IllegalArgumentException("Error, dispersion matrix must be a diagonal matrix, if BandMatrix type is used!");
        }
        if (dispersion instanceof UpperSymmBandMatrix || dispersion instanceof UpperSymmPackMatrix) {
            int row = 0;
            while (row < dispersion.numRows()) {
                double varI = dispersion.get(row, row);
                if (varI <= 0.0) {
                    throw new IllegalArgumentException("Error, element (" + row + ", " + row + ": " + varI + ") on main diagonal of dispersion matrix is less than or equal to zero but must be greater than zero!");
                }
                if (dispersion instanceof UpperSymmPackMatrix) {
                    int col = row + 1;
                    while (col < dispersion.numColumns()) {
                        double varJ = dispersion.get(col, col);
                        double covarIJ = dispersion.get(row, col);
                        if (varJ <= 0.0) {
                            throw new IllegalArgumentException("Error, element (" + col + ", " + col + ": " + varJ + ") on main diagonal of dispersion matrix is less than or equal to zero but must be greater than zero!");
                        }
                        if (Math.abs(covarIJ) >= Math.sqrt(varI * varJ)) {
                            throw new IllegalArgumentException("Error, invalid dispersion matrix, as correlation coefficient of element (" + row + ", " + col + ") is not between -1 and 1!");
                        }
                        ++col;
                    }
                }
                ++row;
            }
        }
    }

    public void setDispersionApriori(Matrix dispersion) throws IllegalArgumentException {
        this.checkDispersionMatrix(dispersion);
        this.dispersionApriori.set((Object)dispersion);
    }

    public Matrix getInvertedDispersion(boolean inplace) throws MatrixSingularException, IllegalArgumentException {
        Matrix dispersionApriori = this.getDispersionApriori();
        int size = dispersionApriori.numColumns();
        if (dispersionApriori instanceof UnitUpperTriangBandMatrix) {
            return dispersionApriori;
        }
        if (dispersionApriori instanceof UpperSymmBandMatrix) {
            Matrix W = inplace ? dispersionApriori : new UpperSymmBandMatrix(size, 0);
            for (MatrixEntry entry : dispersionApriori) {
                double value = entry.get();
                if (value <= 0.0) {
                    throw new MatrixSingularException("Error, matrix is a singular matrix!");
                }
                W.set(entry.row(), entry.column(), 1.0 / value);
            }
            return W;
        }
        if (dispersionApriori instanceof UpperSymmPackMatrix) {
            UpperSymmPackMatrix W = inplace ? (UpperSymmPackMatrix)dispersionApriori : new UpperSymmPackMatrix(dispersionApriori, true);
            MathExtension.inv(W);
            return W;
        }
        throw new IllegalArgumentException("Error, dispersion matrix must be of type UpperSymmBandMatrix, UnitUpperTriangBandMatrix, or UpperSymmPackMatrix!");
    }

    public boolean add(GeometricPrimitive geometry) {
        return this.geometries.add(geometry);
    }

    public boolean remove(GeometricPrimitive geometry) {
        return this.geometries.remove(geometry);
    }

    public int getNumberOfGeomtries() {
        return this.geometries.size();
    }

    public TestStatistic getTestStatistic() {
        return (TestStatistic)this.testStatistic.get();
    }

    public ReadOnlyObjectProperty<TestStatistic> testStatisticProperty() {
        return this.testStatistic;
    }

    public ReadOnlyObjectWrapper<Double> testStatisticAprioriProperty() {
        return this.testStatisticApriori;
    }

    public ReadOnlyObjectWrapper<Double> testStatisticAposterioriProperty() {
        return this.testStatisticAposteriori;
    }

    public ReadOnlyObjectWrapper<Double> pValueAprioriProperty() {
        return this.pValueApriori;
    }

    public ReadOnlyObjectWrapper<Double> pValueAposterioriProperty() {
        return this.pValueAposteriori;
    }

    public ObjectBinding<Boolean> significantProperty() {
        return this.significant;
    }

    public boolean isSignificant() {
        return (Boolean)this.significant.get();
    }

    public void setFisherQuantileApriori(double fisherQuantileApriori) {
        this.fisherQuantileApriori.set((Object)fisherQuantileApriori);
    }

    public double getFisherQuantileApriori() {
        return (Double)this.fisherQuantileApriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAprioriProperty() {
        return this.fisherQuantileApriori;
    }

    public void setFisherQuantileAposteriori(double fisherQuantileAposteriori) {
        this.fisherQuantileAposteriori.set((Object)fisherQuantileAposteriori);
    }

    public double getFisherQuantileAposteriori() {
        return (Double)this.fisherQuantileAposteriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAposterioriProperty() {
        return this.fisherQuantileAposteriori;
    }

    @Override
    public Iterator<GeometricPrimitive> iterator() {
        return this.geometries.iterator();
    }

    public void reset() {
        this.setResidualX(0.0);
        this.setResidualY(0.0);
        this.setResidualZ(0.0);
        this.setRedundancyX(0.0);
        this.setRedundancyY(0.0);
        this.setRedundancyZ(0.0);
        this.setGrossErrorX(0.0);
        this.setGrossErrorY(0.0);
        this.setGrossErrorZ(0.0);
        this.setMinimalDetectableBiasX(0.0);
        this.setMinimalDetectableBiasY(0.0);
        this.setMinimalDetectableBiasZ(0.0);
        this.setMaximumTolerableBiasX(0.0);
        this.setMaximumTolerableBiasY(0.0);
        this.setMaximumTolerableBiasZ(0.0);
        this.setCofactorX(0.0);
        this.setCofactorY(0.0);
        this.setCofactorZ(0.0);
        ((TestStatistic)this.testStatistic.get()).setFisherTestNumerator(0.0);
        ((TestStatistic)this.testStatistic.get()).setDegreeOfFreedom(0);
    }

    public void clear() {
        this.reset();
        this.geometries.clear();
    }
}

