/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.curve;

import java.util.Collection;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.CurveFeature;
import org.applied_geodesy.adjustment.geometry.curve.primitive.QuadraticCurve;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;

public class QuadraticCurveFeature
extends CurveFeature {
    private final QuadraticCurve quadraticCurve = new QuadraticCurve();
    private static final double SQRT2 = Math.sqrt(2.0);

    public QuadraticCurveFeature() {
        super(true);
        UnknownParameter vectorLength = this.quadraticCurve.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        vectorLength.setVisible(false);
        this.add(this.quadraticCurve);
    }

    public QuadraticCurve getQuadraticCurve() {
        return this.quadraticCurve;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, QuadraticCurveFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        QuadraticCurveFeature.deriveInitialGuess(points, feature.quadraticCurve);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, QuadraticCurve quadraticCurve) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            if (quadraticCurve.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + quadraticCurve.getDimension() + " != " + point.getDimension());
        }
        if (nop < 5) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 5 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        UpperSymmPackMatrix A1TA1 = new UpperSymmPackMatrix(3);
        UpperSymmPackMatrix A2TA2 = new UpperSymmPackMatrix(3);
        DenseMatrix A1TA2 = new DenseMatrix(3, 3);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            double xx = xi * xi;
            double yy = yi * yi;
            double xy = xi * yi;
            A1TA1.add(0, 0, xx * xx);
            A1TA1.add(0, 1, xx * yy);
            A1TA1.add(0, 2, xx * SQRT2 * xy);
            A1TA1.add(1, 1, yy * yy);
            A1TA1.add(1, 2, yy * SQRT2 * xy);
            A1TA1.add(2, 2, 2.0 * xy * xy);
            A2TA2.add(0, 0, xx);
            A2TA2.add(0, 1, xy);
            A2TA2.add(0, 2, xi);
            A2TA2.add(1, 1, yy);
            A2TA2.add(1, 2, yi);
            A2TA2.add(2, 2, 1.0);
            A1TA2.add(0, 0, xx * xi);
            A1TA2.add(0, 1, xx * yi);
            A1TA2.add(0, 2, xx);
            A1TA2.add(1, 0, yy * xi);
            A1TA2.add(1, 1, yy * yi);
            A1TA2.add(1, 2, yy);
            A1TA2.add(2, 0, SQRT2 * xy * xi);
            A1TA2.add(2, 1, SQRT2 * xy * yi);
            A1TA2.add(2, 2, SQRT2 * xy);
        }
        MathExtension.inv(A2TA2);
        DenseMatrix invA2TA2timesA1TA2 = new DenseMatrix(3, 3);
        A2TA2.transBmult((Matrix)A1TA2, (Matrix)invA2TA2timesA1TA2);
        UpperSymmPackMatrix A1TA2invA2TA2timesA1TA2 = new UpperSymmPackMatrix(3);
        A1TA2.mult((Matrix)invA2TA2timesA1TA2, (Matrix)A1TA2invA2TA2timesA1TA2);
        A1TA1.add(-1.0, (Matrix)A1TA2invA2TA2timesA1TA2);
        SymmPackEVD evd = new SymmPackEVD(3, true, true);
        evd.factor(A1TA1);
        DenseMatrix evec = evd.getEigenvectors();
        double[] eval = evd.getEigenvalues();
        int indexMinEval = 0;
        double minEval = Math.abs(eval[indexMinEval]);
        int idx = indexMinEval + 1;
        while (idx < eval.length) {
            if (minEval > Math.abs(eval[idx])) {
                minEval = Math.abs(eval[idx]);
                indexMinEval = idx;
            }
            ++idx;
        }
        DenseVector u1 = new DenseVector(3);
        DenseVector u2 = new DenseVector(3);
        int i = 0;
        while (i < 3) {
            double x = evec.get(i, indexMinEval);
            u1.set(i, x);
            ++i;
        }
        invA2TA2timesA1TA2.mult(-1.0, (Vector)u1, (Vector)u2);
        double a = u1.get(0);
        double b = u1.get(1);
        double c = u1.get(2);
        double d = u2.get(0);
        double e = u2.get(1);
        double length = u2.get(1);
        quadraticCurve.setInitialGuess(a, b, c, d, e, length -= a * x0 * x0 + b * y0 * y0 + c * SQRT2 * x0 * y0 + (d -= 2.0 * (a * x0 + c / SQRT2 * y0)) * x0 + (e -= 2.0 * (c / SQRT2 * x0 + b * y0)) * y0);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        QuadraticCurveFeature.deriveInitialGuess(this.quadraticCurve.getFeaturePoints(), this.quadraticCurve);
    }
}

