/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.curve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.CurveFeature;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Line;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;

public class LineFeature
extends CurveFeature {
    private final Line line = new Line();

    public LineFeature() {
        super(true);
        UnknownParameter ux = this.line.getUnknownParameter(ParameterType.VECTOR_X);
        UnknownParameter uy = this.line.getUnknownParameter(ParameterType.VECTOR_Y);
        UnknownParameter du = this.line.getUnknownParameter(ParameterType.LENGTH);
        ux.setVisible(false);
        uy.setVisible(false);
        du.setVisible(false);
        UnknownParameter xOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter yOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter xNormal = new UnknownParameter(ParameterType.VECTOR_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter yNormal = new UnknownParameter(ParameterType.VECTOR_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter positiveOne = new UnknownParameter(ParameterType.CONSTANT, true, 1.0, false, ProcessingType.FIXED);
        UnknownParameter negativeOne = new UnknownParameter(ParameterType.CONSTANT, true, -1.0, false, ProcessingType.FIXED);
        ProductSumRestriction xOriginRestriction = new ProductSumRestriction(false, List.of(ux), List.of(du), xOrigin);
        ProductSumRestriction yOriginRestriction = new ProductSumRestriction(false, List.of(uy), List.of(du), yOrigin);
        ProductSumRestriction xNormalRestriction = new ProductSumRestriction(false, List.of(uy), List.of(positiveOne), xNormal);
        ProductSumRestriction yNormalRestriction = new ProductSumRestriction(false, List.of(ux), List.of(negativeOne), yNormal);
        this.add(this.line);
        ArrayList<UnknownParameter> newOrderedUnknownParameters = new ArrayList<UnknownParameter>();
        newOrderedUnknownParameters.add(xOrigin);
        newOrderedUnknownParameters.add(yOrigin);
        newOrderedUnknownParameters.add(xNormal);
        newOrderedUnknownParameters.add(yNormal);
        newOrderedUnknownParameters.addAll((Collection<UnknownParameter>)((Object)this.getUnknownParameters()));
        newOrderedUnknownParameters.add(positiveOne);
        newOrderedUnknownParameters.add(negativeOne);
        this.getUnknownParameters().setAll(newOrderedUnknownParameters);
        this.getPostProcessingCalculations().addAll(new Restriction[]{xOriginRestriction, yOriginRestriction, xNormalRestriction, yNormalRestriction});
    }

    public Line getLine() {
        return this.line;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, LineFeature feature) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        LineFeature.deriveInitialGuess(points, feature.line);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Line line) throws IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double ny;
        int i;
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            if (line.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + line.getDimension() + " != " + point.getDimension());
        }
        if (nop < 2) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 2 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        UpperSymmPackMatrix H = new UpperSymmPackMatrix(2);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            i = 0;
            while (i < 2) {
                double hi = 0.0;
                hi = i == 0 ? xi : yi;
                int j = i;
                while (j < 2) {
                    double hj = 0.0;
                    hj = j == 0 ? xi : yi;
                    H.set(i, j, H.get(i, j) + hi * hj);
                    ++j;
                }
                ++i;
            }
        }
        SymmPackEVD evd = new SymmPackEVD(2, true, true);
        evd.factor(H);
        DenseMatrix eigVec = evd.getEigenvectors();
        double[] eigVal = evd.getEigenvalues();
        int indexMinEigVal = 0;
        double minEigVal = eigVal[indexMinEigVal];
        i = indexMinEigVal + 1;
        while (i < eigVal.length) {
            if (minEigVal > eigVal[i]) {
                minEigVal = eigVal[i];
                indexMinEigVal = i;
            }
            ++i;
        }
        double nx = eigVec.get(0, indexMinEigVal);
        double d = nx * x0 + (ny = eigVec.get(1, indexMinEigVal)) * y0;
        if (d < 0.0) {
            nx = -nx;
            ny = -ny;
            d = -d;
        }
        line.setInitialGuess(nx, ny, d, 1.0);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        LineFeature.deriveInitialGuess(this.line.getFeaturePoints(), this.line);
    }
}

