/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry.curve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.CurveFeature;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Ellipse;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;

public class EllipseFeature
extends CurveFeature {
    private final Ellipse ellipse = new Ellipse();

    public EllipseFeature() {
        super(true);
        UnknownParameter xFocal1 = this.ellipse.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_X);
        UnknownParameter yFocal1 = this.ellipse.getUnknownParameter(ParameterType.PRIMARY_FOCAL_COORDINATE_Y);
        UnknownParameter xFocal2 = this.ellipse.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_X);
        UnknownParameter yFocal2 = this.ellipse.getUnknownParameter(ParameterType.SECONDARY_FOCAL_COORDINATE_Y);
        UnknownParameter majorAxis = this.ellipse.getUnknownParameter(ParameterType.MAJOR_AXIS_COEFFICIENT);
        UnknownParameter xOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter yOrigin = new UnknownParameter(ParameterType.ORIGIN_COORDINATE_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter minorAxis = new UnknownParameter(ParameterType.MINOR_AXIS_COEFFICIENT, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter xEccentricity = new UnknownParameter(ParameterType.VECTOR_X, false, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter yEccentricity = new UnknownParameter(ParameterType.VECTOR_Y, false, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter eccentricity = new UnknownParameter(ParameterType.LENGTH, false, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter one = new UnknownParameter(ParameterType.CONSTANT, false, 1.0, false, ProcessingType.FIXED);
        AverageRestriction xOriginRestriction = new AverageRestriction(false, List.of(xFocal1, xFocal2), xOrigin);
        AverageRestriction yOriginRestriction = new AverageRestriction(false, List.of(yFocal1, yFocal2), yOrigin);
        List<ProductSumRestriction.SignType> signs = List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS);
        ProductSumRestriction xEccentricityRestriction = new ProductSumRestriction(false, List.of(xFocal1, xOrigin), List.of(one, one), signs, xEccentricity);
        ProductSumRestriction yEccentricityRestriction = new ProductSumRestriction(false, List.of(yFocal1, yOrigin), List.of(one, one), signs, yEccentricity);
        ProductSumRestriction eccentricityRestriction = new ProductSumRestriction(false, List.of(xEccentricity, yEccentricity), List.of(xEccentricity, yEccentricity), 0.5, eccentricity);
        ProductSumRestriction minorAxisRestriction = new ProductSumRestriction(false, List.of(majorAxis, eccentricity), List.of(majorAxis, eccentricity), 0.5, signs, minorAxis);
        this.add(this.ellipse);
        ArrayList<UnknownParameter> newOrderedUnknownParameters = new ArrayList<UnknownParameter>();
        newOrderedUnknownParameters.add(xOrigin);
        newOrderedUnknownParameters.add(yOrigin);
        newOrderedUnknownParameters.addAll((Collection<UnknownParameter>)((Object)this.getUnknownParameters()));
        newOrderedUnknownParameters.add(minorAxis);
        newOrderedUnknownParameters.add(eccentricity);
        newOrderedUnknownParameters.add(xEccentricity);
        newOrderedUnknownParameters.add(yEccentricity);
        newOrderedUnknownParameters.add(one);
        this.getUnknownParameters().setAll(newOrderedUnknownParameters);
        this.getPostProcessingCalculations().addAll(new Restriction[]{xOriginRestriction, yOriginRestriction, xEccentricityRestriction, yEccentricityRestriction, eccentricityRestriction, minorAxisRestriction});
    }

    public Ellipse getEllipse() {
        return this.ellipse;
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, EllipseFeature feature) throws MatrixSingularException, IllegalArgumentException, UnsupportedOperationException, NotConvergedException {
        EllipseFeature.deriveInitialGuess(points, feature.ellipse);
    }

    public static void deriveInitialGuess(Collection<FeaturePoint> points, Ellipse ellipse) throws MatrixSingularException, IllegalArgumentException, UnsupportedOperationException, NotConvergedException {
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            ++nop;
            x0 += point.getX0();
            y0 += point.getY0();
            if (ellipse.getDimension() <= point.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + ellipse.getDimension() + " != " + point.getDimension());
        }
        if (nop < 5) {
            throw new IllegalArgumentException("Error, the number of points is not sufficient; at least 5 points are needed.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        UpperSymmPackMatrix S1 = new UpperSymmPackMatrix(3);
        UpperSymmPackMatrix S3 = new UpperSymmPackMatrix(3);
        DenseMatrix S2 = new DenseMatrix(3, 3);
        for (FeaturePoint point : points) {
            if (!point.isEnable()) continue;
            double xi = point.getX0() - x0;
            double yi = point.getY0() - y0;
            double xx = xi * xi;
            double xy = xi * yi;
            double yy = yi * yi;
            S1.add(0, 0, xx * xx);
            S1.add(0, 1, xx * xy);
            S1.add(0, 2, xx * yy);
            S1.add(1, 1, xy * xy);
            S1.add(1, 2, xy * yy);
            S1.add(2, 2, yy * yy);
            S3.add(0, 0, xx);
            S3.add(0, 1, xy);
            S3.add(0, 2, xi);
            S3.add(1, 1, yy);
            S3.add(1, 2, yi);
            S3.add(2, 2, 1.0);
            S2.add(0, 0, xx * xi);
            S2.add(0, 1, xx * yi);
            S2.add(0, 2, xx);
            S2.add(1, 0, xy * xi);
            S2.add(1, 1, xy * yi);
            S2.add(1, 2, xy);
            S2.add(2, 0, yy * xi);
            S2.add(2, 1, yy * yi);
            S2.add(2, 2, yy);
        }
        MathExtension.inv(S3);
        DenseMatrix T = new DenseMatrix(3, 3);
        S3.transBmult(-1.0, (Matrix)S2, (Matrix)T);
        DenseMatrix M = new DenseMatrix((Matrix)S1, true);
        S2.multAdd((Matrix)T, (Matrix)M);
        DenseMatrix C = new DenseMatrix(3, 3);
        C.set(0, 2, 0.5);
        C.set(1, 1, -1.0);
        C.set(2, 0, 0.5);
        C.mult((Matrix)M, (Matrix)S2);
        EVD evd = new EVD(3, false, true);
        evd.factor(S2);
        DenseMatrix evec = evd.getRightEigenvectors();
        int idx = 0;
        int i = 0;
        while (i < 3) {
            double cond = 4.0 * evec.get(0, i) * evec.get(2, i) - evec.get(1, i) * evec.get(1, i);
            if (cond > 0.0) {
                idx = i;
                break;
            }
            ++i;
        }
        DenseVector u = new DenseVector(6);
        int i2 = 0;
        while (i2 < 3) {
            double ui = evec.get(i2, idx);
            u.set(i2, ui);
            ui = 0.0;
            int j = 0;
            while (j < 3) {
                ui += T.get(i2, j) * evec.get(j, idx);
                ++j;
            }
            u.add(3 + i2, ui);
            ++i2;
        }
        double a = u.get(0);
        double b = u.get(1);
        double c = u.get(2);
        double d = u.get(3);
        double f = u.get(4);
        double g = u.get(5);
        g = g + a * x0 * x0 + b * x0 * y0 + c * y0 * y0 - d * x0 - f * y0;
        f = 0.5 * (f - 2.0 * c * y0 - b * x0);
        d = 0.5 * (d - 2.0 * a * x0 - b * y0);
        double k = (b *= 0.5) * b - a * c;
        x0 = (c * d - b * f) / k;
        y0 = (a * f - b * d) / k;
        double D = Math.sqrt(Math.abs((a - c) * (a - c) + 4.0 * b * b));
        double an = k * (D - (a + c));
        double bn = k * (-D - (a + c));
        double z = 2.0 * (a * f * f + c * d * d + g * b * b - 2.0 * b * d * f - a * c * g);
        double major = Math.sqrt(Math.abs(z / an));
        double minor = Math.sqrt(Math.abs(z / bn));
        double phi = 0.0;
        if (major > minor) {
            phi = 1.5707963267948966 + 0.5 * Math.atan2(2.0 * b, a - c);
        } else {
            phi = 0.5 * Math.atan2(2.0 * b, a - c);
            double tmp = major;
            major = minor;
            minor = tmp;
        }
        double ext = Math.sqrt(major * major - minor * minor);
        double x1 = x0 + ext * Math.cos(phi);
        double y1 = y0 + ext * Math.sin(phi);
        double x2 = x0 - ext * Math.cos(phi);
        double y2 = y0 - ext * Math.sin(phi);
        ellipse.setInitialGuess(x1, y1, x2, y2, major);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, UnsupportedOperationException, NotConvergedException {
        EllipseFeature.deriveInitialGuess(this.ellipse.getFeaturePoints(), this.ellipse);
    }
}

