/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry;

import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.geometry.VarianceComponentType;

public class VarianceComponent {
    private ReadOnlyObjectProperty<VarianceComponentType> varianceComponentType;
    private ObjectProperty<Boolean> applyAposterioriVarianceOfUnitWeight = new SimpleObjectProperty((Object)this, "applyAposterioriVarianceOfUnitWeight", (Object)DefaultValue.applyVarianceOfUnitWeight());
    private ObjectProperty<Double> variance0 = new SimpleObjectProperty((Object)this, "variance0", (Object)1.0);
    private ObjectProperty<Double> redundancy = new SimpleObjectProperty((Object)this, "redundancy", (Object)0.0);
    private ObjectProperty<Integer> numberOfObservations = new SimpleObjectProperty((Object)this, "numberOfObservations", (Object)0);
    private ObjectProperty<Double> omega = new SimpleObjectProperty((Object)this, "omega", (Object)0.0);
    private ObjectProperty<Boolean> significant = new SimpleObjectProperty((Object)this, "significant", (Object)Boolean.FALSE);
    private ObjectBinding<Double> variance;
    private ObjectBinding<Double> unitVariance;
    private ObjectBinding<Double> unitOmega;

    public VarianceComponent(VarianceComponentType varianceComponentType) {
        this.varianceComponentType = new ReadOnlyObjectWrapper((Object)this, "varianceComponentType", (Object)varianceComponentType);
        this.variance = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)VarianceComponent.this.omega.get() > 0.0 && (Double)VarianceComponent.this.redundancy.get() > 0.0 ? (Double)VarianceComponent.this.omega.get() / (Double)VarianceComponent.this.redundancy.get() : (Double)VarianceComponent.this.variance0.get();
            }
        };
        this.unitVariance = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)VarianceComponent.this.variance.get() / (Double)VarianceComponent.this.variance0.get();
            }
        };
        this.unitOmega = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)VarianceComponent.this.omega.get() / (Double)VarianceComponent.this.variance0.get();
            }
        };
    }

    public ObservableObjectValue<VarianceComponentType> varianceComponentTypeProperty() {
        return this.varianceComponentType;
    }

    public double getVariance0() {
        return (Double)this.variance0.get();
    }

    public void setVariance0(double variance0) {
        this.variance0.set((Object)variance0);
    }

    public double getUnitVariance() {
        return (Double)this.unitVariance.get();
    }

    public double getVariance() {
        return (Double)this.variance.get();
    }

    public double getUnitOmega() {
        return (Double)this.unitOmega.get();
    }

    public double getOmega() {
        return (Double)this.omega.get();
    }

    public void setOmega(double omega) {
        this.omega.set((Object)omega);
    }

    public int getNumberOfObservations() {
        return (Integer)this.numberOfObservations.get();
    }

    public void setNumberOfObservations(int numberOfObservations) {
        this.numberOfObservations.set((Object)numberOfObservations);
    }

    public double getRedundancy() {
        return (Double)this.redundancy.get();
    }

    public void setRedundancy(double redundancy) {
        this.redundancy.set((Object)redundancy);
    }

    public void setSignificant(boolean significant) {
        this.significant.set((Object)significant);
    }

    public boolean isSignificant() {
        return (Boolean)this.significant.get();
    }

    public boolean isApplyAposterioriVarianceOfUnitWeight() {
        return (Boolean)this.applyAposterioriVarianceOfUnitWeight.get();
    }

    public void setApplyAposterioriVarianceOfUnitWeight(boolean apply) {
        this.applyAposterioriVarianceOfUnitWeight.set((Object)apply);
    }

    public ObjectProperty<Double> variance0Property() {
        return this.variance0;
    }

    public ObservableObjectValue<Double> varianceProperty() {
        return this.variance;
    }

    public ObservableObjectValue<Double> unitVarianceProperty() {
        return this.unitVariance;
    }

    public ObjectProperty<Double> omegaProperty() {
        return this.omega;
    }

    public ObservableObjectValue<Double> unitOmegaProperty() {
        return this.unitOmega;
    }

    public ObjectProperty<Double> redundancyProperty() {
        return this.redundancy;
    }

    public ObjectProperty<Integer> numberOfObservationsProperty() {
        return this.numberOfObservations;
    }

    public ObjectProperty<Boolean> applyAposterioriVarianceOfUnitWeightProperty() {
        return this.applyAposterioriVarianceOfUnitWeight;
    }

    public ObjectProperty<Boolean> significantProperty() {
        return this.significant;
    }

    public VarianceComponentType getVarianceComponentType() {
        return (VarianceComponentType)((Object)this.varianceComponentType.get());
    }
}

