/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry;

import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.geometry.VarianceComponent;
import org.applied_geodesy.adjustment.geometry.VarianceComponentType;

public class TestStatistic {
    private ObjectProperty<VarianceComponent> varianceComponent = new SimpleObjectProperty((Object)this, "varianceComponent", (Object)new VarianceComponent(VarianceComponentType.GLOBAL));
    private ObjectProperty<Double> fisherTestNumerator = new SimpleObjectProperty((Object)this, "fisherTestNumerator", (Object)0.0);
    private ObjectProperty<Integer> degreeOfFreedom = new SimpleObjectProperty((Object)this, "degreeOfFreedom", (Object)0);
    private ObjectBinding<Double> testStatisticApriori = new ObjectBinding<Double>(){

        protected Double computeValue() {
            double sigma2aprio = ((VarianceComponent)TestStatistic.this.varianceComponent.get()).getVariance0();
            return (Integer)TestStatistic.this.degreeOfFreedom.get() > 0 ? Math.abs((Double)TestStatistic.this.fisherTestNumerator.get() / (double)((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue() / sigma2aprio) : 0.0;
        }
    };
    private ObjectBinding<Double> testStatisticAposteriori;
    private ObjectBinding<Double> pValueApriori = new ObjectBinding<Double>(){

        protected Double computeValue() {
            return org.applied_geodesy.adjustment.statistic.TestStatistic.getLogarithmicProbabilityValue((Double)TestStatistic.this.testStatisticApriori.get(), ((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue());
        }
    };
    private ObjectBinding<Double> pValueAposteriori;

    public TestStatistic() {
        this.testStatisticAposteriori = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if ((Integer)TestStatistic.this.degreeOfFreedom.get() == 0 || (Double)TestStatistic.this.fisherTestNumerator.get() == 0.0 || !((VarianceComponent)TestStatistic.this.varianceComponent.get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return 0.0;
                }
                double omega = ((VarianceComponent)TestStatistic.this.varianceComponent.get()).getOmega();
                double redundancy = ((VarianceComponent)TestStatistic.this.varianceComponent.get()).getRedundancy();
                double unbiasedVariance = (omega - (Double)TestStatistic.this.fisherTestNumerator.get()) / (redundancy - (double)((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue());
                if (unbiasedVariance < Math.sqrt(Constant.EPS) || redundancy - (double)((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue() <= 0.0) {
                    return 0.0;
                }
                return (Integer)TestStatistic.this.degreeOfFreedom.get() > 0 ? Math.abs((Double)TestStatistic.this.fisherTestNumerator.get() / (unbiasedVariance * (double)((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue())) : 0.0;
            }
        };
        this.pValueAposteriori = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if ((Integer)TestStatistic.this.degreeOfFreedom.get() == 0 || (Double)TestStatistic.this.fisherTestNumerator.get() == 0.0 || !((VarianceComponent)TestStatistic.this.varianceComponent.get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return 0.0;
                }
                double redundancy = ((VarianceComponent)TestStatistic.this.varianceComponent.get()).getRedundancy();
                return org.applied_geodesy.adjustment.statistic.TestStatistic.getLogarithmicProbabilityValue((Double)TestStatistic.this.testStatisticApriori.get(), ((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue(), redundancy - (double)((Integer)TestStatistic.this.degreeOfFreedom.get()).intValue());
            }
        };
    }

    public void setVarianceComponent(VarianceComponent varianceComponent) {
        this.varianceComponent.set((Object)varianceComponent);
    }

    public void setFisherTestNumerator(double numerator) {
        this.fisherTestNumerator.set((Object)numerator);
    }

    public void setDegreeOfFreedom(int degreeOfFreedom) {
        this.degreeOfFreedom.set((Object)degreeOfFreedom);
    }

    public double getPValueApriori() {
        return (Double)this.pValueApriori.get();
    }

    public double getPValueAposteriori() {
        return (Double)this.pValueAposteriori.get();
    }

    public double getTestStatisticApriori() {
        return (Double)this.testStatisticApriori.get();
    }

    public double getTestStatisticAposteriori() {
        return (Double)this.testStatisticAposteriori.get();
    }

    public ObjectProperty<Double> fisherTestNumeratorProperty() {
        return this.fisherTestNumerator;
    }

    public ObjectProperty<Integer> degreeOfFreedomProperty() {
        return this.degreeOfFreedom;
    }

    public ObjectProperty<VarianceComponent> varianceComponentProperty() {
        return this.varianceComponent;
    }

    public ObjectBinding<Double> testStatisticAprioriProperty() {
        return this.testStatisticApriori;
    }

    public ObjectBinding<Double> testStatisticAposterioriProperty() {
        return this.testStatisticAposteriori;
    }

    public ObjectBinding<Double> pValueAprioriProperty() {
        return this.pValueApriori;
    }

    public ObjectBinding<Double> pValueAposterioriProperty() {
        return this.pValueAposteriori;
    }
}

