/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.Geometrizable;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public abstract class GeometricPrimitive
implements Iterable<FeaturePoint>,
Geometrizable {
    private ObservableUniqueList<FeaturePoint> featurePointList = new ObservableUniqueList();
    private Point centerOfMass;
    private ObjectProperty<String> name = new SimpleObjectProperty((Object)this, "name");
    private static int ID_CNT = 0;
    private ReadOnlyObjectProperty<Integer> id = new ReadOnlyObjectWrapper((Object)this, "id", (Object)ID_CNT++);

    public abstract Collection<UnknownParameter> getUnknownParameters();

    public abstract PrimitiveType getPrimitiveType();

    public abstract UnknownParameter getUnknownParameter(ParameterType var1);

    public boolean contains(Object object) {
        return this.getUnknownParameters().contains(object);
    }

    public abstract void reverseCenterOfMass(UpperSymmPackMatrix var1);

    public abstract void jacobianElements(FeaturePoint var1, Matrix var2, Matrix var3, int var4);

    public abstract double getMisclosure(FeaturePoint var1);

    public abstract int getDimension();

    public GeometricPrimitive() {
        this.featurePointList.addListener(new FeaturePointListChangeListener());
    }

    public final int getId() {
        return (Integer)this.id.get();
    }

    public ReadOnlyObjectProperty<Integer> idProperty() {
        return this.id;
    }

    public ObservableUniqueList<FeaturePoint> getFeaturePoints() {
        return this.featurePointList;
    }

    public void setCenterOfMass(Point centerOfMass) {
        this.centerOfMass = centerOfMass;
    }

    public Point getCenterOfMass() {
        if (this.centerOfMass == null) {
            if (this.getDimension() == 2) {
                this.centerOfMass = new Point("CENTER_OF_MASS", 0.0, 0.0);
            } else if (this.getDimension() == 3) {
                this.centerOfMass = new Point("CENTER_OF_MASS", 0.0, 0.0, 0.0);
            }
        }
        return this.centerOfMass;
    }

    public Collection<Restriction> getRestrictions() {
        return Collections.emptySet();
    }

    public int getNumberOfPoints() {
        return this.featurePointList.size();
    }

    @Override
    public Iterator<FeaturePoint> iterator() {
        return this.featurePointList.iterator();
    }

    public ObjectProperty<String> nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public abstract String toLaTex();

    public String toString() {
        return this.getName();
    }

    private class FeaturePointListChangeListener
    implements ListChangeListener<FeaturePoint> {
        private FeaturePointListChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends FeaturePoint> change) {
            while (change.next()) {
                if (change.wasRemoved()) {
                    for (FeaturePoint featurePoint : change.getRemoved()) {
                        featurePoint.remove(GeometricPrimitive.this);
                        featurePoint.reset();
                    }
                    continue;
                }
                if (!change.wasAdded()) continue;
                for (FeaturePoint featurePoint : change.getAddedSubList()) {
                    featurePoint.add(GeometricPrimitive.this);
                    featurePoint.reset();
                }
            }
        }
    }
}

