/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.UpperTriangPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.NormalEquationSystem;
import org.applied_geodesy.adjustment.UnscentedTransformationParameter;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.VarianceComponent;
import org.applied_geodesy.adjustment.geometry.VarianceComponentType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.statistic.BaardaMethodTestStatistic;
import org.applied_geodesy.adjustment.statistic.SidakTestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameters;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.adjustment.statistic.UnadjustedTestStatitic;
import org.applied_geodesy.util.ObservableUniqueList;

public class FeatureAdjustment {
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    private List<EventListener> listenerList = new ArrayList<EventListener>();
    private Feature feature;
    private List<UnknownParameter> parameters = new ArrayList<UnknownParameter>();
    private List<Restriction> restrictions = new ArrayList<Restriction>();
    private List<GeometricPrimitive> geometricPrimitives = new ArrayList<GeometricPrimitive>();
    private List<FeaturePoint> points = new ArrayList<FeaturePoint>();
    private EstimationStateType currentEstimationStatus = EstimationStateType.BUSY;
    private EstimationType estimationType = EstimationType.L2NORM;
    private TestStatisticDefinition testStatisticDefinition = new TestStatisticDefinition();
    private TestStatisticParameters testStatisticParameters = null;
    private static double SQRT_EPS = Math.sqrt(Constant.EPS);
    private int maximalNumberOfIterations = DefaultValue.getMaximumNumberOfIterations();
    private int iterationStep = 0;
    private int numberOfModelEquations = 0;
    private int numberOfUnknownParameters = 0;
    private int maximumNumberOfGeometricPrimitivesPerPoint = 0;
    private boolean interrupt = false;
    private boolean calculateStochasticParameters = false;
    private boolean adjustModelParametersOnly = false;
    private boolean preconditioning = true;
    private boolean deriveFirstAdaptedDampingValue = false;
    private double maxAbsDx = 0.0;
    private double maxAbsRestriction = 0.0;
    private double lastValidmaxAbsDx = 0.0;
    private double dampingValue = 0.0;
    private double adaptedDampingValue = 0.0;
    private double alphaUT = UnscentedTransformationParameter.getAlpha();
    private double betaUT = UnscentedTransformationParameter.getBeta();
    private double weightZero = UnscentedTransformationParameter.getWeightZero();
    private VarianceComponent varianceComponentOfUnitWeight = new VarianceComponent(VarianceComponentType.GLOBAL);
    private UpperSymmPackMatrix Qxx = null;

    public void init() {
        int nog = this.geometricPrimitives.size();
        if (nog > 0) {
            ArrayList<FeaturePoint> nonUniquePoints = new ArrayList<FeaturePoint>();
            for (GeometricPrimitive geometry : this.geometricPrimitives) {
                nonUniquePoints.addAll((Collection<FeaturePoint>)((Object)geometry.getFeaturePoints()));
            }
            LinkedHashSet uniquePoints = new LinkedHashSet(nonUniquePoints);
            nonUniquePoints.clear();
            for (FeaturePoint featurePoint : uniquePoints) {
                featurePoint.reset();
            }
            FilteredList enabledUniquePoints = new FilteredList(FXCollections.observableArrayList(uniquePoints));
            enabledUniquePoints.setPredicate((Predicate)new Predicate<FeaturePoint>(){

                @Override
                public boolean test(FeaturePoint featurePoint) {
                    return featurePoint.isEnable();
                }
            });
            uniquePoints.clear();
            this.points = new ArrayList<FeaturePoint>((Collection<FeaturePoint>)enabledUniquePoints);
            this.numberOfModelEquations = 0;
            for (FeaturePoint featurePoint : this.points) {
                int numberOfGeometries = featurePoint.getNumberOfGeomtries();
                this.maximumNumberOfGeometricPrimitivesPerPoint = Math.max(this.maximumNumberOfGeometricPrimitivesPerPoint, numberOfGeometries);
                this.numberOfModelEquations += numberOfGeometries;
                featurePoint.getTestStatistic().setVarianceComponent(this.varianceComponentOfUnitWeight);
            }
            this.testStatisticParameters = this.getTestStatisticParameters(this.testStatisticDefinition);
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        if (this.feature != null) {
            this.fireFeatureChanged(this.feature, FeatureEvent.FeatureEventType.FEATURE_REMOVED);
        }
        this.reset();
        this.feature = feature;
        if (this.feature != null) {
            this.parameters = this.feature.getUnknownParameters();
            this.restrictions = this.feature.getRestrictions();
            this.geometricPrimitives = this.feature.getGeometricPrimitives();
            this.fireFeatureChanged(this.feature, FeatureEvent.FeatureEventType.FEATURE_ADDED);
        }
    }

    private void reset() {
        this.varianceComponentOfUnitWeight.setVariance0(1.0);
        this.varianceComponentOfUnitWeight.setOmega(0.0);
        this.varianceComponentOfUnitWeight.setRedundancy(0.0);
        this.varianceComponentOfUnitWeight.setNumberOfObservations(0);
        this.varianceComponentOfUnitWeight.setSignificant(false);
        this.geometricPrimitives.clear();
        this.parameters.clear();
        this.restrictions.clear();
        this.points.clear();
        this.Qxx = null;
    }

    private void prepareIterationProcess(Point centerOfMass) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        this.feature.applyInitialGuess();
        this.feature.getCenterOfMass().setX0(0.0);
        this.feature.getCenterOfMass().setY0(0.0);
        this.feature.getCenterOfMass().setZ0(0.0);
        if (this.feature.isEstimateCenterOfMass()) {
            this.feature.setCenterOfMass(centerOfMass);
        }
        this.numberOfUnknownParameters = 0;
        int parColumn = 0;
        for (UnknownParameter unknownParameter : this.parameters) {
            if (unknownParameter.getProcessingType() == ProcessingType.ADJUSTMENT) {
                unknownParameter.setColumn(parColumn++);
                ++this.numberOfUnknownParameters;
                continue;
            }
            unknownParameter.setColumn(-1);
        }
        for (Restriction restriction : this.restrictions) {
            restriction.setRow(parColumn++);
        }
        ObservableUniqueList<Restriction> calculations = this.feature.getPostProcessingCalculations();
        Iterator<Object> iterator = calculations.iterator();
        while (iterator.hasNext()) {
            Restriction restriction = (Restriction)iterator.next();
            restriction.setRow(-1);
        }
        for (FeaturePoint featurePoint : this.points) {
            featurePoint.reset();
        }
        this.updateResiduals((Vector)new DenseVector(this.numberOfUnknownParameters), false);
    }

    /*
     * Exception decompiling
     */
    public EstimationStateType estimateModel() throws NotConvergedException, MatrixSingularException, OutOfMemoryError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private double getEstimateVarianceOfUnitWeightApriori() {
        double vari = 0.0;
        int cnt = 0;
        for (FeaturePoint point : this.points) {
            if (this.interrupt) {
                return 1.0;
            }
            int dim = point.getDimension();
            Matrix D = point.getDispersionApriori();
            int rowD = 0;
            while (rowD < dim) {
                double var = D.get(rowD, rowD);
                vari += var;
                ++cnt;
                ++rowD;
            }
        }
        return vari / (double)cnt;
    }

    private void reverseCenterOfMass() {
        for (GeometricPrimitive geometricPrimitive : this.geometricPrimitives) {
            geometricPrimitive.reverseCenterOfMass(this.Qxx);
        }
        this.feature.getCenterOfMass().setX0(0.0);
        this.feature.getCenterOfMass().setY0(0.0);
        this.feature.getCenterOfMass().setZ0(0.0);
    }

    private void postProcessing() {
        ObservableUniqueList<Restriction> calculations = this.feature.getPostProcessingCalculations();
        int numberOfUnknownParameters = this.numberOfUnknownParameters;
        Iterator iterator = calculations.iterator();
        while (iterator.hasNext()) {
            Restriction restriction = (Restriction)iterator.next();
            UnknownParameter parameter = restriction.getRegressand();
            if (parameter.getProcessingType() != ProcessingType.POSTPROCESSING) continue;
            if (this.Qxx != null) {
                int rows = this.Qxx.numRows();
                int columns = this.Qxx.numColumns();
                int column = -1;
                column = parameter.getColumn() < 0 ? columns++ : parameter.getColumn();
                restriction.setRow(column);
                DenseMatrix JrT = new DenseMatrix(rows, columns);
                int i = 0;
                while (i < rows) {
                    if (i != column) {
                        JrT.set(i, i, 1.0);
                    }
                    ++i;
                }
                restriction.transposedJacobianElements((Matrix)JrT);
                DenseMatrix DpJrT = new DenseMatrix(rows, columns);
                this.Qxx.mult((Matrix)JrT, (Matrix)DpJrT);
                this.Qxx = new UpperSymmPackMatrix(columns);
                JrT.transAmult((Matrix)DpJrT, (Matrix)this.Qxx);
                parameter.setColumn(column);
            } else if (parameter.getColumn() < 0) {
                parameter.setColumn(numberOfUnknownParameters++);
            }
            double estimate = restriction.getMisclosure();
            parameter.setValue(estimate);
        }
    }

    private NormalEquationSystem createNormalEquation() {
        int nou = this.numberOfUnknownParameters;
        int nor = this.restrictions.size();
        UpperSymmPackMatrix N = new UpperSymmPackMatrix(nou + nor);
        UpperSymmBandMatrix V = this.preconditioning ? new UpperSymmBandMatrix(nou + nor, 0) : null;
        DenseVector n = new DenseVector(nou + nor);
        for (FeaturePoint point : this.points) {
            if (this.interrupt) {
                return null;
            }
            int nog = point.getNumberOfGeomtries();
            int dim = point.getDimension();
            DenseMatrix Jx = new DenseMatrix(nog, nou);
            DenseMatrix Jv = new DenseMatrix(nog, dim);
            DenseVector misclosures = new DenseVector(nog);
            DenseVector residuals = new DenseVector(dim);
            if (dim != 1) {
                residuals.set(0, point.getResidualX());
                residuals.set(1, point.getResidualY());
            }
            if (dim != 2) {
                residuals.set(dim - 1, point.getResidualZ());
            }
            int geoIdx = 0;
            for (GeometricPrimitive geometricPrimitive : point) {
                geometricPrimitive.jacobianElements(point, (Matrix)Jx, (Matrix)Jv, geoIdx);
                misclosures.set(geoIdx, geometricPrimitive.getMisclosure(point));
                ++geoIdx;
            }
            Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            residuals = null;
            UpperSymmPackMatrix W = this.getWeightedMatrixOfMisclosures(point, (Matrix)Jv);
            Jv = null;
            DenseMatrix WJx = new DenseMatrix(nog, nou);
            W.mult((Matrix)Jx, (Matrix)WJx);
            W = null;
            int rowJxT = 0;
            while (rowJxT < this.parameters.size()) {
                if (this.interrupt) {
                    return null;
                }
                int rowN = this.parameters.get(rowJxT).getColumn();
                if (rowN >= 0) {
                    int colWJx = rowJxT;
                    while (colWJx < this.parameters.size()) {
                        int colN = this.parameters.get(colWJx).getColumn();
                        if (colN >= 0) {
                            double mat = 0.0;
                            double vec = 0.0;
                            int colJxT = 0;
                            while (colJxT < nog) {
                                mat += Jx.get(colJxT, colN) * WJx.get(colJxT, rowN);
                                if (colWJx == rowJxT) {
                                    vec += -WJx.get(colJxT, rowN) * misclosures.get(colJxT);
                                }
                                ++colJxT;
                            }
                            N.add(rowN, colN, mat);
                            if (colWJx == rowJxT) {
                                n.add(rowN, vec);
                            }
                        }
                        ++colWJx;
                    }
                }
                ++rowJxT;
            }
        }
        for (Restriction restriction : this.restrictions) {
            if (this.interrupt) {
                return null;
            }
            restriction.transposedJacobianElements((Matrix)N);
            double misclosure = restriction.getMisclosure();
            this.maxAbsRestriction = Math.max(Math.abs(misclosure), this.maxAbsRestriction);
            n.set(restriction.getRow(), -misclosure);
        }
        if (this.deriveFirstAdaptedDampingValue) {
            double maxElement = 0.0;
            for (UnknownParameter unknownParameter : this.parameters) {
                int column = unknownParameter.getColumn();
                if (column < 0) continue;
                maxElement = Math.max(maxElement, N.get(column, column));
            }
            this.adaptedDampingValue = this.dampingValue * maxElement;
            this.deriveFirstAdaptedDampingValue = false;
        }
        if (this.adaptedDampingValue > 0.0) {
            for (UnknownParameter unknownParameter : this.parameters) {
                int column = unknownParameter.getColumn();
                if (column < 0) continue;
                N.add(column, column, this.adaptedDampingValue);
            }
        }
        if (this.preconditioning) {
            int column = 0;
            while (column < N.numColumns()) {
                if (this.interrupt) {
                    return null;
                }
                double value = N.get(column, column);
                V.set(column, column, value > Constant.EPS ? 1.0 / Math.sqrt(value) : 1.0);
                ++column;
            }
        }
        if (this.estimationType == EstimationType.SIMULATION) {
            n.zero();
        }
        return new NormalEquationSystem(N, n, V);
    }

    private void applyPrecondition(NormalEquationSystem neq) {
        this.applyPrecondition(neq.getPreconditioner(), neq.getMatrix(), (Vector)neq.getVector());
    }

    private void applyPrecondition(UpperSymmBandMatrix V, UpperSymmPackMatrix M, Vector m) {
        if (V == null) {
            return;
        }
        int row = 0;
        while (row < V.numRows()) {
            if (m != null) {
                m.set(row, V.get(row, row) * m.get(row));
            }
            if (M != null) {
                int column = row;
                while (column < V.numColumns()) {
                    M.set(row, column, V.get(column, column) * M.get(row, column) * V.get(row, row));
                    ++column;
                }
            }
            ++row;
        }
    }

    private void updateModel(Vector dxk, boolean estimateCompleteModel) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        Vector dx;
        Vector vector = dx = dxk.size() == this.numberOfUnknownParameters ? dxk : Matrices.getSubVector((Vector)dxk, (int[])Matrices.index((int)0, (int)this.numberOfUnknownParameters));
        if (this.adaptedDampingValue > 0.0) {
            if (this.adaptedDampingValue != 0.0) {
                double alpha = 0.25 * Math.pow(this.adaptedDampingValue, -0.05);
                alpha = Math.min(alpha, 0.75);
                dxk.scale(alpha);
            }
            double prevOmega = this.varianceComponentOfUnitWeight.getOmega();
            double curOmega = this.getOmega(dx);
            prevOmega = prevOmega <= 0.0 ? Double.MAX_VALUE : prevOmega;
            boolean lmaConverge = prevOmega >= curOmega;
            this.varianceComponentOfUnitWeight.setOmega(curOmega);
            double lastAdaptedDampingValue = this.adaptedDampingValue;
            if (lmaConverge) {
                this.adaptedDampingValue *= 0.2;
            } else {
                this.adaptedDampingValue *= 5.0;
                if (this.adaptedDampingValue > 1.0 / SQRT_EPS) {
                    this.adaptedDampingValue = 1.0 / SQRT_EPS;
                    this.varianceComponentOfUnitWeight.setOmega(0.0);
                }
            }
            this.currentEstimationStatus = EstimationStateType.LEVENBERG_MARQUARDT_STEP;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), lastAdaptedDampingValue, this.adaptedDampingValue);
            if (!lmaConverge) {
                this.maxAbsDx = this.lastValidmaxAbsDx;
                dx.zero();
                return;
            }
        }
        if (this.interrupt) {
            return;
        }
        double omega = this.updateResiduals(dx, !this.adjustModelParametersOnly && estimateCompleteModel && this.Qxx != null && this.adaptedDampingValue == 0.0);
        this.varianceComponentOfUnitWeight.setOmega(omega);
        this.lastValidmaxAbsDx = this.maxAbsDx = this.updateUnknownParameters(dx);
        if (this.interrupt) {
            return;
        }
        if (estimateCompleteModel) {
            double varianceOfUnitWeight;
            this.reverseCenterOfMass();
            this.postProcessing();
            double d = varianceOfUnitWeight = this.varianceComponentOfUnitWeight.isApplyAposterioriVarianceOfUnitWeight() ? this.varianceComponentOfUnitWeight.getVariance() : this.varianceComponentOfUnitWeight.getVariance0();
            if (this.varianceComponentOfUnitWeight.getRedundancy() > 0.0) {
                TestStatisticParameterSet globalTestStatistic = this.testStatisticParameters.getTestStatisticParameter(this.varianceComponentOfUnitWeight.getRedundancy(), Double.POSITIVE_INFINITY, Boolean.TRUE);
                double quantil = Math.max(globalTestStatistic.getQuantile(), 1.0 + Math.sqrt(Constant.EPS));
                boolean significant = this.varianceComponentOfUnitWeight.getVariance() / this.varianceComponentOfUnitWeight.getVariance0() > quantil;
                this.varianceComponentOfUnitWeight.setSignificant(significant);
            }
            if (this.Qxx != null) {
                Iterator<UnknownParameter> iterator = this.parameters.iterator();
                while (iterator.hasNext()) {
                    UnknownParameter unknownParameter;
                    int column = (unknownParameter = iterator.next()).getColumn();
                    unknownParameter.setUncertainty(column >= 0 ? Math.sqrt(Math.abs(varianceOfUnitWeight * this.Qxx.get(column, column))) : 0.0);
                }
            }
        }
    }

    private double updateUnknownParameters(Vector dx) {
        double maxAbsDx = 0.0;
        for (UnknownParameter unknownParameter : this.parameters) {
            if (this.interrupt) {
                return 0.0;
            }
            int column = unknownParameter.getColumn();
            if (column < 0) continue;
            double value = unknownParameter.getValue();
            double dvalue = dx.get(column);
            maxAbsDx = Math.max(Math.abs(dvalue), maxAbsDx);
            unknownParameter.setValue(value + dvalue);
        }
        return maxAbsDx;
    }

    private double getOmega(Vector dx) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        double omega = 0.0;
        int nou = this.numberOfUnknownParameters;
        for (FeaturePoint point : this.points) {
            if (this.interrupt) {
                return 0.0;
            }
            int nog = point.getNumberOfGeomtries();
            int dim = point.getDimension();
            DenseMatrix Jx = new DenseMatrix(nog, nou);
            DenseMatrix Jv = new DenseMatrix(nog, dim);
            DenseVector misclosures = new DenseVector(nog);
            DenseVector residuals = new DenseVector(dim);
            if (dim != 1) {
                residuals.set(0, point.getResidualX());
                residuals.set(1, point.getResidualY());
            }
            if (dim != 2) {
                residuals.set(dim - 1, point.getResidualZ());
            }
            int geoIdx = 0;
            for (GeometricPrimitive geometricPrimitive : point) {
                geometricPrimitive.jacobianElements(point, (Matrix)Jx, (Matrix)Jv, geoIdx);
                misclosures.set(geoIdx, geometricPrimitive.getMisclosure(point));
                ++geoIdx;
            }
            Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            Jx.multAdd(dx, (Vector)misclosures);
            UpperSymmPackMatrix Ww = this.getWeightedMatrixOfMisclosures(point, (Matrix)Jv);
            DenseVector Wv = new DenseVector(nog);
            Ww.mult((Vector)misclosures, (Vector)Wv);
            omega += misclosures.dot((Vector)Wv);
        }
        return omega;
    }

    private double updateResiduals(Vector dx, boolean estimateStochasticParameters) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        double omega = 0.0;
        int nou = this.numberOfUnknownParameters;
        for (FeaturePoint point : this.points) {
            if (this.interrupt) {
                return 0.0;
            }
            int nog = point.getNumberOfGeomtries();
            int dim = point.getDimension();
            DenseMatrix Jx = new DenseMatrix(nog, nou);
            DenseMatrix Jv = new DenseMatrix(nog, dim);
            DenseVector misclosures = new DenseVector(nog);
            DenseVector residuals = new DenseVector(dim);
            if (dim != 1) {
                residuals.set(0, point.getResidualX());
                residuals.set(1, point.getResidualY());
            }
            if (dim != 2) {
                residuals.set(dim - 1, point.getResidualZ());
            }
            int geoIdx = 0;
            for (GeometricPrimitive geometricPrimitive : point) {
                geometricPrimitive.jacobianElements(point, (Matrix)Jx, (Matrix)Jv, geoIdx);
                misclosures.set(geoIdx, geometricPrimitive.getMisclosure(point));
                ++geoIdx;
            }
            Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            Jx.multAdd(dx, (Vector)misclosures);
            if (!estimateStochasticParameters) {
                Jx = null;
            }
            UpperSymmPackMatrix Ww = this.getWeightedMatrixOfMisclosures(point, (Matrix)Jv);
            DenseVector Wv = new DenseVector(nog);
            Ww.mult((Vector)misclosures, (Vector)Wv);
            if (!estimateStochasticParameters) {
                Ww = null;
            }
            omega += misclosures.dot((Vector)Wv);
            DenseVector JvTWv = new DenseVector(dim);
            Jv.transMult((Vector)Wv, (Vector)JvTWv);
            Wv = null;
            if (!estimateStochasticParameters) {
                Jv = null;
            }
            Matrix D = point.getDispersionApriori();
            D.mult(-1.0 / this.varianceComponentOfUnitWeight.getVariance0(), (Vector)JvTWv, (Vector)residuals);
            if (dim != 1) {
                point.setResidualX(residuals.get(0));
                point.setResidualY(residuals.get(1));
            }
            if (dim != 2) {
                point.setResidualZ(residuals.get(dim - 1));
            }
            if (!estimateStochasticParameters) continue;
            int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
            int rank = Math.min(nog, dim);
            TestStatisticParameterSet testStatisticParametersAprio = this.testStatisticParameters.getTestStatisticParameter(rank, Double.POSITIVE_INFINITY);
            double noncentralityParameter = Math.sqrt(Math.abs(testStatisticParametersAprio.getNoncentralityParameter()));
            point.setFisherQuantileApriori(testStatisticParametersAprio.getQuantile());
            if (dof - rank > 0) {
                TestStatisticParameterSet testStatisticParametersApost = this.testStatisticParameters.getTestStatisticParameter(rank, dof - rank);
                point.setFisherQuantileAposteriori(testStatisticParametersApost.getQuantile());
            }
            this.addStochasticParameters(point, (Matrix)Jx, (Matrix)Jv, Ww, noncentralityParameter);
        }
        return omega;
    }

    private UpperSymmPackMatrix getDispersionOfMisclosures(FeaturePoint point, Matrix Jv) {
        int dim = point.getDimension();
        int nog = point.getNumberOfGeomtries();
        Matrix D = point.getDispersionApriori();
        UpperSymmPackMatrix Dw = new UpperSymmPackMatrix(nog);
        DenseMatrix JvD = new DenseMatrix(nog, dim);
        Jv.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), D, (Matrix)JvD);
        JvD.transBmult(Jv, (Matrix)Dw);
        return Dw;
    }

    private UpperSymmPackMatrix inv(UpperSymmPackMatrix D, boolean inplace) throws MatrixSingularException, IllegalArgumentException {
        UpperSymmPackMatrix W;
        UpperSymmPackMatrix upperSymmPackMatrix = W = inplace ? D : new UpperSymmPackMatrix((Matrix)D, true);
        if (D.numColumns() == 1) {
            double variance = W.get(0, 0);
            if (variance <= 0.0) {
                throw new MatrixSingularException("Error, dispersion matrix is singular!");
            }
            W.set(0, 0, 1.0 / variance);
        } else {
            MathExtension.inv(W);
        }
        return W;
    }

    private UpperSymmPackMatrix getWeightedMatrixOfMisclosures(FeaturePoint point, Matrix Jv) throws MatrixSingularException, IllegalArgumentException {
        UpperSymmPackMatrix D = this.getDispersionOfMisclosures(point, Jv);
        return this.inv(D, true);
    }

    private void addStochasticParameters(FeaturePoint point, Matrix Jx, Matrix Jv, UpperSymmPackMatrix Ww, double nonCentralityParameter) throws NotConvergedException, MatrixSingularException, IllegalArgumentException {
        int row;
        int nou = this.numberOfUnknownParameters;
        int nog = point.getNumberOfGeomtries();
        int dim = point.getDimension();
        int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
        DenseMatrix QxxJxT = new DenseMatrix(nou, nog);
        this.Qxx.transBmult(Jx, (Matrix)QxxJxT);
        UpperSymmPackMatrix JxQxxJxT = new UpperSymmPackMatrix(nog);
        Jx.mult((Matrix)QxxJxT, (Matrix)JxQxxJxT);
        QxxJxT = null;
        DenseMatrix JxQxxJxTW = new DenseMatrix(nog, nog);
        JxQxxJxT.mult((Matrix)Ww, (Matrix)JxQxxJxTW);
        JxQxxJxT = null;
        UpperSymmPackMatrix WJxQxxJxTW = new UpperSymmPackMatrix(nog);
        Ww.mult((Matrix)JxQxxJxTW, (Matrix)WJxQxxJxTW);
        JxQxxJxTW = null;
        int row2 = 0;
        while (row2 < nog) {
            int column = row2;
            while (column < nog) {
                WJxQxxJxTW.set(row2, column, Ww.get(row2, column) - WJxQxxJxTW.get(row2, column));
                ++column;
            }
            ++row2;
        }
        Ww = null;
        Matrix Qll = point.getDispersionApriori();
        DenseMatrix JvQll = new DenseMatrix(nog, dim);
        Jv.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), Qll, (Matrix)JvQll);
        DenseMatrix WJxQxxJxTWJvQll = new DenseMatrix(nog, dim);
        WJxQxxJxTW.mult((Matrix)JvQll, (Matrix)WJxQxxJxTWJvQll);
        UpperSymmPackMatrix QllJvTWJxQxxJxTWJvQll = new UpperSymmPackMatrix(dim);
        JvQll.transAmult((Matrix)WJxQxxJxTWJvQll, (Matrix)QllJvTWJxQxxJxTWJvQll);
        WJxQxxJxTWJvQll = null;
        Matrix P = point.getInvertedDispersion(false);
        DenseMatrix R = new DenseMatrix(dim, dim);
        double redundancy = 0.0;
        if (dof > 0) {
            P.mult(this.varianceComponentOfUnitWeight.getVariance0(), (Matrix)QllJvTWJxQxxJxTWJvQll, (Matrix)R);
            row = 0;
            while (row < dim) {
                double r = R.get(row, row);
                if (r > 0.0) {
                    if (row == 0 && dim != 1) {
                        point.setRedundancyX(r);
                    } else if (row == 1 && dim != 1) {
                        point.setRedundancyY(r);
                    } else if (dim != 2) {
                        point.setRedundancyZ(r);
                    }
                    redundancy += r;
                }
                ++row;
            }
        }
        row = 0;
        while (row < dim) {
            if (row == 0 && dim != 1) {
                point.setCofactorX(Qll.get(row, row) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row, row));
            } else if (row == 1 && dim != 1) {
                point.setCofactorY(Qll.get(row, row) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row, row));
            } else if (dim != 2) {
                point.setCofactorZ(Qll.get(row, row) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row, row));
            }
            ++row;
        }
        QllJvTWJxQxxJxTWJvQll = null;
        if (dof > 0 && redundancy > SQRT_EPS) {
            UpperSymmPackMatrix PQvvP = new UpperSymmPackMatrix(dim);
            R.mult(this.varianceComponentOfUnitWeight.getVariance0(), P, (Matrix)PQvvP);
            DenseVector residuals = new DenseVector(dim);
            if (dim != 1) {
                residuals.set(0, point.getResidualX());
                residuals.set(1, point.getResidualY());
            }
            if (dim != 2) {
                residuals.set(dim - 1, point.getResidualZ());
            }
            DenseVector weightedResiduals = new DenseVector(dim);
            P.mult(this.varianceComponentOfUnitWeight.getVariance0(), (Vector)residuals, (Vector)weightedResiduals);
            DenseVector grossErrors = new DenseVector(dim);
            Matrix invPQvvP = MathExtension.pinv((Matrix)PQvvP, nog);
            invPQvvP.mult(-1.0, (Vector)weightedResiduals, (Vector)grossErrors);
            if (dim != 1) {
                point.setGrossErrorX(grossErrors.get(0));
                point.setGrossErrorY(grossErrors.get(1));
            }
            if (dim != 2) {
                point.setGrossErrorZ(grossErrors.get(dim - 1));
            }
            DenseVector minimalDetectableBias = new DenseVector((Vector)grossErrors, true);
            DenseVector weightedMinimalDetectableBias = new DenseVector(dim);
            PQvvP.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), (Vector)minimalDetectableBias, (Vector)weightedMinimalDetectableBias);
            double nQn0 = minimalDetectableBias.dot((Vector)weightedMinimalDetectableBias);
            int j = 0;
            while (j < dim) {
                if (nQn0 > 0.0) {
                    minimalDetectableBias.set(j, minimalDetectableBias.get(j) / Math.sqrt(nQn0));
                }
                ++j;
            }
            if (dim != 1) {
                point.setMinimalDetectableBiasX(nonCentralityParameter * minimalDetectableBias.get(0));
                point.setMinimalDetectableBiasY(nonCentralityParameter * minimalDetectableBias.get(1));
                point.setMaximumTolerableBiasX(minimalDetectableBias.get(0));
                point.setMaximumTolerableBiasY(minimalDetectableBias.get(1));
            }
            if (dim != 2) {
                point.setMinimalDetectableBiasZ(nonCentralityParameter * minimalDetectableBias.get(dim - 1));
                point.setMaximumTolerableBiasZ(minimalDetectableBias.get(dim - 1));
            }
            double T = -weightedResiduals.dot((Vector)grossErrors);
            point.getTestStatistic().setFisherTestNumerator(T);
            point.getTestStatistic().setDegreeOfFreedom(nog);
        }
    }

    public TestStatisticParameters getTestStatisticParameters() {
        return this.testStatisticParameters;
    }

    public TestStatisticDefinition getTestStatisticDefinition() {
        return this.testStatisticDefinition;
    }

    public UpperSymmPackMatrix getCorrelationMatrix() {
        if (this.Qxx == null) {
            return null;
        }
        int size = this.Qxx.numColumns();
        UpperSymmPackMatrix corr = new UpperSymmPackMatrix(size);
        int r = 0;
        while (r < size) {
            UnknownParameter parameterR = this.parameters.get(r);
            int row = parameterR.getColumn();
            if (row >= 0) {
                corr.set(row, row, 1.0);
                double varR = Math.abs(this.Qxx.get(row, row));
                if (!(varR < SQRT_EPS)) {
                    int c = r + 1;
                    while (c < size) {
                        double varC;
                        UnknownParameter parameterC = this.parameters.get(c);
                        int column = parameterC.getColumn();
                        if (column >= 0 && !((varC = this.Qxx.get(column, column)) < SQRT_EPS)) {
                            corr.set(row, column, this.Qxx.get(row, column) / Math.sqrt(varR) / Math.sqrt(varC));
                        }
                        ++c;
                    }
                }
            }
            ++r;
        }
        return corr;
    }

    TestStatisticParameters getTestStatisticParameters(TestStatisticDefinition testStatisticDefinition) {
        double alpha = testStatisticDefinition.getProbabilityValue();
        double beta = testStatisticDefinition.getPowerOfTest();
        int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
        int numberOfHypotesis = this.points.size() + (dof > 0 ? 1 : 0);
        int dim = this.maximumNumberOfGeometricPrimitivesPerPoint;
        return new TestStatisticParameters(switch (testStatisticDefinition.getTestStatisticType()) {
            case TestStatisticType.SIDAK -> new SidakTestStatistic(numberOfHypotesis, alpha, beta, testStatisticDefinition.isFamilywiseErrorRate());
            case TestStatisticType.BAARDA_METHOD -> new BaardaMethodTestStatistic(testStatisticDefinition.isFamilywiseErrorRate() ? dof : dim, alpha, beta);
            case TestStatisticType.NONE -> new UnadjustedTestStatitic(alpha, beta);
            default -> throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, unknown test statistic method " + String.valueOf((Object)testStatisticDefinition.getTestStatisticType()));
        });
    }

    private void prepareSphericalSimplexUnscentedTransformationObservation(int estimationStep, double[][] SigmaUT, double weight) throws IllegalArgumentException, MatrixNotSPDException {
        int dim = this.getFeature().getFeatureType() == FeatureType.CURVE ? 2 : 3;
        int noo = this.points.size() * dim;
        int row = 0;
        for (FeaturePoint point : this.points) {
            UpperTriangPackMatrix G = new UpperTriangPackMatrix(point.getDispersionApriori(), true);
            MathExtension.chol(G);
            DenseVector sigmaUT = new DenseVector(SigmaUT[row], false);
            DenseVector delta = new DenseVector(dim);
            G.transMult((Vector)sigmaUT, (Vector)delta);
            if (dim != 1) {
                point.setX0(point.getX0() - delta.get(0));
                point.setY0(point.getY0() - delta.get(1));
            }
            if (dim != 2) {
                point.setZ0(point.getZ0() - delta.get(dim - 1));
            }
            sigmaUT.zero();
            if (dim != 1) {
                if (estimationStep >= 0 && estimationStep < noo + 2) {
                    if (row == estimationStep - 1) {
                        sigmaUT.set(0, (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    } else if (row > estimationStep - 2) {
                        sigmaUT.set(0, -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    }
                }
                ++row;
                if (estimationStep >= 0 && estimationStep < noo + 2) {
                    if (row == estimationStep - 1) {
                        sigmaUT.set(1, (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    } else if (row > estimationStep - 2) {
                        sigmaUT.set(1, -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    }
                }
                ++row;
            }
            if (dim != 2) {
                if (estimationStep >= 0 && estimationStep < noo + 2) {
                    if (row == estimationStep - 1) {
                        sigmaUT.set(dim - 1, (1.0 + (double)row) / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    } else if (row > estimationStep - 2) {
                        sigmaUT.set(dim - 1, -1.0 / Math.sqrt((1.0 + (double)row) * (2.0 + (double)row) * weight));
                    }
                }
                ++row;
            }
            if (estimationStep < 0) continue;
            delta = new DenseVector(dim);
            G.transMult((Vector)sigmaUT, (Vector)delta);
            if (dim != 1) {
                point.setX0(point.getX0() + delta.get(0));
                point.setY0(point.getY0() + delta.get(1));
            }
            if (dim == 2) continue;
            point.setZ0(point.getZ0() + delta.get(dim - 1));
        }
    }

    private void addUnscentedTransformationSolution(Vector xUT, Vector vUT, Matrix solutionVectors, int solutionNumber, double weight) {
        for (UnknownParameter unknownParameter : this.parameters) {
            if (this.interrupt) {
                return;
            }
            int col = unknownParameter.getColumn();
            if (col < 0) continue;
            double value = unknownParameter.getValue();
            xUT.set(col, xUT.get(col) + weight * value);
            solutionVectors.set(col, solutionNumber, value);
        }
        if (vUT != null) {
            int row = 0;
            for (FeaturePoint point : this.points) {
                int dim = point.getDimension();
                if (dim != 1) {
                    double vx = point.getResidualX();
                    double vy = point.getResidualY();
                    vUT.set(row, vUT.get(row++) + weight * vx);
                    vUT.set(row, vUT.get(row++) + weight * vy);
                }
                if (dim == 2) continue;
                double vz = point.getResidualZ();
                vUT.set(row, vUT.get(row++) + weight * vz);
            }
        }
    }

    private void estimateUnscentedTransformationParameterUpdateAndDispersion(Vector xUT, Matrix solutionVectors, Vector vUT, double weightN, double weightC) {
        int numberOfEstimationSteps = solutionVectors.numColumns();
        if (this.Qxx == null) {
            this.Qxx = new UpperSymmPackMatrix(xUT.size());
        }
        this.Qxx.zero();
        int r = 0;
        while (r < this.parameters.size()) {
            if (this.interrupt) {
                return;
            }
            UnknownParameter unknownParameterRow = this.parameters.get(r);
            int row = unknownParameterRow.getColumn();
            if (row >= 0) {
                unknownParameterRow.setValue(xUT.get(row));
                int c = r;
                while (c < this.parameters.size()) {
                    if (this.interrupt) {
                        return;
                    }
                    UnknownParameter unknownParameterCol = this.parameters.get(c);
                    int col = unknownParameterCol.getColumn();
                    if (col >= 0) {
                        int estimationStep = 0;
                        while (estimationStep < numberOfEstimationSteps) {
                            double weight = estimationStep == numberOfEstimationSteps - 1 ? weightC : weightN;
                            double valueCol = solutionVectors.get(col, estimationStep) - xUT.get(col);
                            double valueRow = solutionVectors.get(row, estimationStep) - xUT.get(row);
                            this.Qxx.set(row, col, this.Qxx.get(row, col) + valueRow * weight * valueCol);
                            ++estimationStep;
                        }
                    }
                    ++c;
                }
            }
            ++r;
        }
        solutionVectors = null;
        xUT = null;
        int row = 0;
        for (FeaturePoint point : this.points) {
            if (this.interrupt) {
                return;
            }
            int dim = point.getDimension();
            if (dim != 1) {
                double vx = vUT.get(row++);
                double vy = vUT.get(row++);
                point.setResidualX(vx);
                point.setResidualY(vy);
            }
            if (dim == 2) continue;
            double vz = vUT.get(row++);
            point.setResidualZ(vz);
        }
        double varianceOfUnitWeight = this.varianceComponentOfUnitWeight.isApplyAposterioriVarianceOfUnitWeight() ? this.varianceComponentOfUnitWeight.getVariance() : this.varianceComponentOfUnitWeight.getVariance0();
        varianceOfUnitWeight /= this.varianceComponentOfUnitWeight.getVariance0();
        if (this.varianceComponentOfUnitWeight.getRedundancy() > 0.0) {
            TestStatisticParameterSet globalTestStatistic = this.testStatisticParameters.getTestStatisticParameter(this.varianceComponentOfUnitWeight.getRedundancy(), Double.POSITIVE_INFINITY, Boolean.TRUE);
            double quantil = Math.max(globalTestStatistic.getQuantile(), 1.0 + Math.sqrt(Constant.EPS));
            boolean significant = this.varianceComponentOfUnitWeight.getVariance() / this.varianceComponentOfUnitWeight.getVariance0() > quantil;
            this.varianceComponentOfUnitWeight.setSignificant(significant);
        }
        Iterator<UnknownParameter> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter;
            int column = (unknownParameter = iterator.next()).getColumn();
            unknownParameter.setUncertainty(column >= 0 ? Math.sqrt(Math.abs(varianceOfUnitWeight * this.Qxx.get(column, column))) : 0.0);
        }
    }

    public VarianceComponent getVarianceComponentOfUnitWeight() {
        return this.varianceComponentOfUnitWeight;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    private void fireFeatureChanged(Feature feature, FeatureEvent.FeatureEventType eventType) {
        FeatureEvent evt = new FeatureEvent(feature, eventType);
        Object[] listeners = this.listenerList.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof FeatureChangeListener) {
                ((FeatureChangeListener)listeners[i]).featureChanged(evt);
            }
            ++i;
        }
    }

    public void setLevenbergMarquardtDampingValue(double lambda) {
        this.dampingValue = Math.abs(lambda);
    }

    public double getLevenbergMarquardtDampingValue() {
        return this.dampingValue;
    }

    public int getMaximalNumberOfIterations() {
        return this.maximalNumberOfIterations;
    }

    public void setMaximalNumberOfIterations(int maximalNumberOfIterations) {
        this.maximalNumberOfIterations = maximalNumberOfIterations;
    }

    public boolean isAdjustModelParametersOnly() {
        return this.adjustModelParametersOnly;
    }

    public void setAdjustModelParametersOnly(boolean adjustModelParametersOnly) {
        this.adjustModelParametersOnly = adjustModelParametersOnly;
    }

    public boolean isPreconditioning() {
        return this.preconditioning;
    }

    public void setPreconditioning(boolean preconditioning) {
        this.preconditioning = preconditioning;
    }

    public void addFeatureChangeListener(FeatureChangeListener l) {
        this.listenerList.add(l);
    }

    public void removeFeatureChangeListener(FeatureChangeListener l) {
        this.listenerList.remove(l);
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public EstimationType getEstimationType() {
        return this.estimationType;
    }

    public void setEstimationType(EstimationType estimationType) throws IllegalArgumentException {
        if (estimationType != EstimationType.L2NORM && estimationType != EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION) {
            throw new IllegalArgumentException("Error, unsupported estimation type " + String.valueOf((Object)estimationType) + "!");
        }
        this.estimationType = estimationType;
    }

    public double getUnscentedTransformationScaling() {
        return this.alphaUT;
    }

    public double getUnscentedTransformationDamping() {
        return this.betaUT;
    }

    public double getUnscentedTransformationWeightZero() {
        return this.weightZero;
    }

    public void setUnscentedTransformationScaling(double alpha) {
        if (alpha > 0.0) {
            this.alphaUT = alpha;
        }
    }

    public void setUnscentedTransformationDamping(double beta) {
        this.betaUT = beta;
    }

    public void setUnscentedTransformationWeightZero(double w0) {
        if (w0 < 1.0) {
            this.weightZero = w0;
        }
    }
}

