/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.Geometrizable;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public abstract class Feature
implements Iterable<GeometricPrimitive>,
Geometrizable {
    private ReadOnlyObjectProperty<Boolean> immutable;
    private ObservableUniqueList<GeometricPrimitive> geometricPrimitives = new ObservableUniqueList();
    private ObservableUniqueList<UnknownParameter> unknownParameters = null;
    private ObservableUniqueList<Restriction> restrictions = null;
    private ObservableUniqueList<Restriction> postprocessingCalculations = new ObservableUniqueList();
    private ObjectProperty<Boolean> estimateInitialGuess = new SimpleObjectProperty((Object)this, "estimateInitialGuess", (Object)Boolean.TRUE);
    private ObjectProperty<Boolean> estimateCenterOfMass = new SimpleObjectProperty((Object)this, "estimateCenterOfMass", (Object)Boolean.TRUE);
    private Point centerOfMass;

    Feature(boolean immutable) {
        this.immutable = new ReadOnlyObjectWrapper((Object)this, "immutable", (Object)immutable);
        this.setCenterOfMass(this.getCenterOfMass());
        this.geometricPrimitives.addListener(new GeometricPrimitiveListChangeListener());
    }

    public void setCenterOfMass(Point centerOfMass) {
        Iterator<GeometricPrimitive> iterator = this.geometricPrimitives.iterator();
        while (iterator.hasNext()) {
            GeometricPrimitive geometricPrimitive = iterator.next();
            geometricPrimitive.setCenterOfMass(centerOfMass);
        }
        this.centerOfMass = centerOfMass;
    }

    public abstract FeatureType getFeatureType();

    public final Point getCenterOfMass() {
        if (this.centerOfMass == null) {
            this.centerOfMass = this.getFeatureType() == FeatureType.CURVE ? new Point("CENTER_OF_MASS", 0.0, 0.0) : new Point("CENTER_OF_MASS", 0.0, 0.0, 0.0);
        }
        return this.centerOfMass;
    }

    public void prepareIteration() {
    }

    public final ObservableUniqueList<Restriction> getPostProcessingCalculations() {
        return this.postprocessingCalculations;
    }

    public ObjectProperty<Boolean> estimateCenterOfMassProperty() {
        return this.estimateCenterOfMass;
    }

    public void setEstimateCenterOfMass(boolean estimateCenterOfMass) {
        this.estimateCenterOfMass.set((Object)estimateCenterOfMass);
    }

    public boolean isEstimateCenterOfMass() {
        return (Boolean)this.estimateCenterOfMass.get();
    }

    public ObjectProperty<Boolean> estimateInitialGuessProperty() {
        return this.estimateInitialGuess;
    }

    public void setEstimateInitialGuess(boolean estimateInitialGuess) {
        this.estimateInitialGuess.set((Object)estimateInitialGuess);
    }

    public boolean isEstimateInitialGuess() {
        return (Boolean)this.estimateInitialGuess.get();
    }

    public ReadOnlyObjectProperty<Boolean> immutableProperty() {
        return this.immutable;
    }

    public boolean isImmutable() {
        return (Boolean)this.immutable.get();
    }

    public final ObservableUniqueList<UnknownParameter> getUnknownParameters() {
        if (this.unknownParameters == null) {
            this.unknownParameters = new ObservableUniqueList();
            Iterator<GeometricPrimitive> iterator = this.geometricPrimitives.iterator();
            while (iterator.hasNext()) {
                GeometricPrimitive geometricPrimitive = iterator.next();
                this.unknownParameters.addAll(geometricPrimitive.getUnknownParameters());
            }
        }
        return this.unknownParameters;
    }

    public final ObservableUniqueList<Restriction> getRestrictions() {
        if (this.restrictions == null) {
            this.restrictions = new ObservableUniqueList();
            Iterator<GeometricPrimitive> iterator = this.geometricPrimitives.iterator();
            while (iterator.hasNext()) {
                GeometricPrimitive geometricPrimitive = iterator.next();
                this.restrictions.addAll(geometricPrimitive.getRestrictions());
            }
        }
        return this.restrictions;
    }

    public void add(GeometricPrimitive geometricPrimitive) throws IllegalArgumentException {
        geometricPrimitive.setCenterOfMass(this.centerOfMass);
        this.geometricPrimitives.add(geometricPrimitive);
    }

    @Override
    public Iterator<GeometricPrimitive> iterator() {
        return this.geometricPrimitives.iterator();
    }

    public ObservableUniqueList<GeometricPrimitive> getGeometricPrimitives() {
        return this.geometricPrimitives;
    }

    public List<FeaturePoint> getFeaturePoints() {
        ObservableList nonUniquePoints = FXCollections.observableArrayList();
        Iterator<GeometricPrimitive> iterator = this.geometricPrimitives.iterator();
        while (iterator.hasNext()) {
            GeometricPrimitive geometry = iterator.next();
            nonUniquePoints.addAll(geometry.getFeaturePoints());
        }
        FilteredList enabledNonUniquePoints = new FilteredList(nonUniquePoints);
        enabledNonUniquePoints.setPredicate((Predicate)new Predicate<FeaturePoint>(){

            @Override
            public boolean test(FeaturePoint featurePoint) {
                return featurePoint.isEnable();
            }
        });
        return new ArrayList<FeaturePoint>(new LinkedHashSet(enabledNonUniquePoints));
    }

    public abstract void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException;

    public void applyInitialGuess() {
        Iterator<UnknownParameter> iterator = this.unknownParameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter = iterator.next();
            unknownParameter.setValue(unknownParameter.getValue0());
        }
    }

    public static Point deriveCenterOfMass(Collection<FeaturePoint> featurePoints) {
        int nop = 0;
        int dim = -1;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        for (FeaturePoint featurePoint : featurePoints) {
            if (!featurePoint.isEnable()) continue;
            ++nop;
            x0 += featurePoint.getX0();
            y0 += featurePoint.getY0();
            z0 += featurePoint.getZ0();
            if (dim < 0) {
                dim = featurePoint.getDimension();
            }
            if (dim == featurePoint.getDimension()) continue;
            throw new IllegalArgumentException("Error, could not estimate center of mass because dimension of points is inconsistent, " + dim + " != " + featurePoint.getDimension());
        }
        if (nop == 0) {
            throw new IllegalArgumentException("Error, could not estimate center of mass because of an empty point list!");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        if (dim == 2) {
            return new Point("CENTER_OF_MASS", x0, y0);
        }
        return new Point("CENTER_OF_MASS", x0, y0, z0);
    }

    private class GeometricPrimitiveListChangeListener
    implements ListChangeListener<GeometricPrimitive> {
        private GeometricPrimitiveListChangeListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void onChanged(ListChangeListener.Change<? extends GeometricPrimitive> change) {
            if (Feature.this.unknownParameters != null) ** GOTO lbl22
            return;
lbl-1000:
            // 1 sources

            {
                if (change.wasRemoved()) {
                    for (GeometricPrimitive geometricPrimitive : change.getRemoved()) {
                        if (Feature.this.unknownParameters != null) {
                            Feature.this.unknownParameters.removeAll(geometricPrimitive.getUnknownParameters());
                        }
                        if (Feature.this.restrictions == null) continue;
                        Feature.this.restrictions.removeAll(geometricPrimitive.getRestrictions());
                    }
                } else {
                    if (!change.wasAdded()) continue;
                    for (GeometricPrimitive geometricPrimitive : change.getAddedSubList()) {
                        if (Feature.this.unknownParameters != null) {
                            Feature.this.unknownParameters.addAll(geometricPrimitive.getUnknownParameters());
                        }
                        if (Feature.this.restrictions == null) continue;
                        Feature.this.restrictions.addAll(geometricPrimitive.getRestrictions());
                    }
                }
lbl22:
                // 4 sources

                ** while (change.next())
            }
lbl23:
            // 1 sources

        }
    }
}

