/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import no.uib.cipr.matrix.UnitUpperTriangBandMatrix;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.UpperTriangPackMatrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CompDiagMatrix;
import org.applied_geodesy.adjustment.Constant;
import org.netlib.util.intW;

public final class MathExtension {
    public static final double SIGN(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static final double MOD(double x, double y) {
        return x - Math.floor(x / y) * y;
    }

    public static double cond(Matrix M) throws NotConvergedException {
        int m;
        SVD uwv = SVD.factorize((Matrix)M);
        double[] s = uwv.getS();
        if (s[m = Math.min(M.numColumns(), M.numRows()) - 1] != 0.0) {
            return s[0] / s[m];
        }
        return 0.0;
    }

    public static Matrix pinv(Matrix M) throws NotConvergedException {
        return MathExtension.pinv(M, 0.0);
    }

    public static Matrix pinv(Matrix M, double tol) throws NotConvergedException {
        SVD uwv = SVD.factorize((Matrix)M);
        DenseMatrix U = uwv.getU();
        DenseMatrix VT = uwv.getVt();
        double[] s = uwv.getS();
        CompDiagMatrix W = new CompDiagMatrix(VT.numColumns(), U.numColumns());
        if (tol < Constant.EPS) {
            double norm2 = 0.0;
            int i = 0;
            while (i < s.length) {
                norm2 = Math.max(norm2, Math.abs(s[i]));
                ++i;
            }
            tol = (double)Math.max(M.numColumns(), M.numRows()) * norm2 * (tol < 0.0 ? Math.sqrt(Constant.EPS) : Constant.EPS);
        }
        int i = 0;
        while (i < s.length) {
            if (Math.abs(s[i]) > tol) {
                W.set(i, i, 1.0 / s[i]);
            }
            ++i;
        }
        s = null;
        DenseMatrix VW = new DenseMatrix(VT.numRows(), W.numColumns());
        VT.transAmult((Matrix)W, (Matrix)VW);
        W = null;
        VT = null;
        DenseMatrix Q = new DenseMatrix(M.numColumns(), M.numRows());
        VW.transBmult((Matrix)U, (Matrix)Q);
        return Q;
    }

    public static Matrix pinv(Matrix M, int rank) throws NotConvergedException {
        if (rank <= 0) {
            return MathExtension.pinv(M, (double)rank);
        }
        SVD uwv = SVD.factorize((Matrix)M);
        DenseMatrix U = uwv.getU();
        DenseMatrix VT = uwv.getVt();
        double[] s = uwv.getS();
        CompDiagMatrix W = new CompDiagMatrix(VT.numColumns(), U.numColumns());
        rank = Math.max(0, Math.min(rank, s.length));
        int i = 0;
        while (i < rank) {
            if (Math.abs(s[i]) > 0.0) {
                W.set(i, i, 1.0 / s[i]);
            }
            ++i;
        }
        s = null;
        DenseMatrix VW = new DenseMatrix(VT.numRows(), W.numColumns());
        VT.transAmult((Matrix)W, (Matrix)VW);
        W = null;
        VT = null;
        DenseMatrix Q = new DenseMatrix(M.numColumns(), M.numRows());
        VW.transBmult((Matrix)U, (Matrix)Q);
        return Q;
    }

    public static Matrix identity(int size) {
        return new UnitUpperTriangBandMatrix(size, 0);
    }

    public static void solve(UpperSymmPackMatrix N, DenseVector n, int numRows, boolean invert) throws MatrixSingularException, IllegalArgumentException {
        String UPLO = "U";
        double[] nd = n.getData();
        double[] Nd = N.getData();
        int[] ipiv = new int[numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dspsv("U", numRows, 1, Nd, ipiv, nd, Math.max(1, numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        if (invert) {
            double[] work = new double[numRows];
            LAPACK.getInstance().dsptri("U", numRows, Nd, ipiv, work, info);
            if (info.val > 0) {
                throw new MatrixSingularException();
            }
            if (info.val < 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void solve(UpperSymmPackMatrix N, DenseVector n, boolean invert) throws MatrixSingularException, IllegalArgumentException {
        MathExtension.solve(N, n, N.numRows(), invert);
    }

    public static void inv(UpperSymmPackMatrix N) throws MatrixSingularException, IllegalArgumentException {
        MathExtension.inv(N, N.numRows());
    }

    public static void inv(UpperSymmPackMatrix N, int numRows) throws MatrixSingularException, IllegalArgumentException {
        String UPLO = "U";
        int[] ipiv = new int[numRows];
        intW info = new intW(0);
        double[] qd = N.getData();
        LAPACK.getInstance().dsptrf("U", numRows, qd, ipiv, info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        double[] work = new double[numRows];
        LAPACK.getInstance().dsptri("U", numRows, qd, ipiv, work, info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
    }

    public static Matrix[] eig(UpperSymmPackMatrix N, int n, int il, int iu, boolean vectors) throws NotConvergedException, IllegalArgumentException {
        int n2 = n = n < 0 ? N.numRows() : n;
        if (il < 1) {
            throw new IllegalArgumentException("Error, lower index of eigenvalue must be il >= 1: il = " + il);
        }
        if (iu > n) {
            throw new IllegalArgumentException("Error, upper index of eigenvalue must be iu > n: iu = " + iu + ", n = " + n);
        }
        String jobz = vectors ? "V" : "N";
        String range = "I";
        String uplo = "U";
        double[] ap = N.getData();
        double vl = 0.0;
        double vu = 0.0;
        double abstol = 2.0 * LAPACK.getInstance().dlamch("S");
        intW m = new intW(0);
        double[] evalArray = new double[n];
        DenseMatrix evec = vectors ? new DenseMatrix(n, iu - il + 1) : new DenseMatrix(0, 0);
        int ldz = Math.max(1, n);
        double[] work = new double[8 * n];
        int[] iwork = new int[5 * n];
        int[] ifail = vectors ? new int[n] : new int[]{};
        intW info = new intW(0);
        if (il <= 0 || il > iu && n > 0 || iu > n) {
            throw new IllegalArgumentException("Error, invalid or wrong arguments, i.e., il <= 0 || il > iu && n > 0 || iu > n! il = " + il + ", iu = " + iu + ", n = " + n);
        }
        LAPACK.getInstance().dspevx(jobz, "I", "U", n, ap, vl, vu, il, iu, abstol, m, evalArray, evec.getData(), ldz, work, iwork, ifail, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Breakdown);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException("Error, invalid or wrong argument for function call dspevx() " + info.val + "!");
        }
        work = null;
        iwork = null;
        ifail = null;
        UpperSymmBandMatrix eval = new UpperSymmBandMatrix(iu - il + 1, 0);
        System.arraycopy(evalArray, 0, eval.getData(), 0, iu - il + 1);
        return new Matrix[]{eval, evec};
    }

    public static void print(Matrix M) {
        int i = 0;
        while (i < M.numRows()) {
            int j = 0;
            while (j < M.numColumns()) {
                System.out.print(M.get(i, j) + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void print(Vector v) {
        int i = 0;
        while (i < v.size()) {
            System.out.println(v.get(i));
            ++i;
        }
    }

    public static DenseVector cross(Vector a, Vector b) throws IllegalArgumentException {
        if (a.size() != 3 || b.size() != 3) {
            throw new IllegalArgumentException("Error, cross-product can only applied to 3 x 1 - vectors, " + a.size() + " and " + b.size());
        }
        DenseVector c = new DenseVector(3);
        c.set(0, a.get(1) * b.get(2) - a.get(2) * b.get(1));
        c.set(1, a.get(2) * b.get(0) - a.get(0) * b.get(2));
        c.set(2, a.get(0) * b.get(1) - a.get(1) * b.get(0));
        return c;
    }

    public static void chol(UpperTriangPackMatrix M) throws IllegalArgumentException, MatrixNotSPDException {
        MathExtension.packChol(M.numRows(), M.getData());
    }

    public static void chol(UpperSymmPackMatrix M) throws IllegalArgumentException, MatrixNotSPDException {
        MathExtension.packChol(M.numRows(), M.getData());
    }

    private static void packChol(int size, double[] data) throws IllegalArgumentException, MatrixNotSPDException {
        String uplo = "U";
        intW info = new intW(0);
        LAPACK.getInstance().dpptrf("U", size, data, info);
        if (info.val > 0) {
            throw new MatrixNotSPDException("Error, matrix must be positive definite!");
        }
        if (info.val < 0) {
            throw new IllegalArgumentException("Error, invalid or wrong argument for function call dpptrf() " + info.val + "!");
        }
    }

    public static double cot(double x) {
        return 1.0 / Math.tan(x);
    }

    public static double acot(double x) {
        return Math.atan(1.0 / x);
    }

    public static double acot2(double x, double y) {
        return Math.atan2(y, x);
    }

    public static double[] rotationMatrix3D2EulerAngles(Matrix R, EulerAngleConventionType convention) {
        double r11 = R.get(0, 0);
        double r12 = R.get(0, 1);
        double r13 = R.get(0, 2);
        double r21 = R.get(1, 0);
        double r22 = R.get(1, 1);
        double r23 = R.get(1, 2);
        double r31 = R.get(2, 0);
        double r32 = R.get(2, 1);
        double r33 = R.get(2, 2);
        double cy = 0.0;
        double eps = Constant.EPS;
        double phi = 0.0;
        double psi = 0.0;
        double theta = 0.0;
        switch (convention) {
            case ZYX: {
                cy = Math.hypot(r11, r21);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r21, r11);
                    theta = Math.atan2(-r31, cy);
                    psi = Math.atan2(r32, r33);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(-r31, cy);
                psi = Math.atan2(-r23, r22);
                break;
            }
            case ZXY: {
                cy = Math.hypot(r22, r12);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r12, r22);
                    theta = -Math.atan2(-r32, cy);
                    psi = -Math.atan2(r31, r33);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(-r32, cy);
                psi = -Math.atan2(-r13, r11);
                break;
            }
            case YXZ: {
                cy = Math.hypot(r33, r13);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r13, r33);
                    theta = Math.atan2(-r23, cy);
                    psi = Math.atan2(r21, r22);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(-r23, cy);
                psi = Math.atan2(-r12, r11);
                break;
            }
            case YZX: {
                cy = Math.hypot(r11, r31);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r31, r11);
                    theta = -Math.atan2(-r21, cy);
                    psi = -Math.atan2(r23, r22);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(-r21, cy);
                psi = -Math.atan2(-r32, r33);
                break;
            }
            case XYZ: {
                cy = Math.hypot(r33, r23);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r23, r33);
                    theta = -Math.atan2(-r13, cy);
                    psi = -Math.atan2(r12, r11);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(-r13, cy);
                psi = -Math.atan2(-r21, r22);
                break;
            }
            case XZY: {
                cy = Math.hypot(r22, r32);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r32, r22);
                    theta = Math.atan2(-r12, cy);
                    psi = Math.atan2(r13, r11);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(-r12, cy);
                psi = Math.atan2(-r31, r33);
                break;
            }
            case ZYZ: {
                cy = Math.hypot(r32, r31);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r23, -r13);
                    theta = -Math.atan2(cy, r33);
                    psi = -Math.atan2(r32, r31);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(cy, r33);
                psi = -Math.atan2(-r21, r22);
                break;
            }
            case ZXZ: {
                cy = Math.hypot(r32, r31);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r13, -r23);
                    theta = Math.atan2(cy, r33);
                    psi = Math.atan2(r31, r32);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(cy, r33);
                psi = Math.atan2(-r12, r11);
                break;
            }
            case YZY: {
                cy = Math.hypot(r23, r21);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r32, -r12);
                    theta = Math.atan2(cy, r22);
                    psi = Math.atan2(r23, r21);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(cy, r22);
                psi = Math.atan2(-r31, r33);
                break;
            }
            case YXY: {
                cy = Math.hypot(r23, r21);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r12, -r32);
                    theta = -Math.atan2(cy, r22);
                    psi = -Math.atan2(r21, r23);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(cy, r22);
                psi = -Math.atan2(-r13, r11);
                break;
            }
            case XZX: {
                cy = Math.hypot(r13, r12);
                if (cy > 16.0 * eps) {
                    phi = -Math.atan2(r31, -r21);
                    theta = -Math.atan2(cy, r11);
                    psi = -Math.atan2(r13, r12);
                    break;
                }
                phi = 0.0;
                theta = -Math.atan2(cy, r11);
                psi = -Math.atan2(-r32, r33);
                break;
            }
            case XYX: {
                cy = Math.hypot(r12, r13);
                if (cy > 16.0 * eps) {
                    phi = Math.atan2(r21, -r31);
                    theta = Math.atan2(cy, r11);
                    psi = Math.atan2(r12, r13);
                    break;
                }
                phi = 0.0;
                theta = Math.atan2(cy, r11);
                psi = Math.atan2(-r23, r22);
            }
        }
        return new double[]{MathExtension.MOD(phi, Math.PI * 2), MathExtension.MOD(theta, Math.PI * 2), MathExtension.MOD(psi, Math.PI * 2)};
    }

    public static enum EulerAngleConventionType {
        ZYX,
        ZXY,
        YXZ,
        YZX,
        XYZ,
        XZY,
        ZYZ,
        ZXZ,
        YZY,
        YXY,
        XZX,
        XYX;

    }
}

