/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment;

import java.io.BufferedInputStream;
import java.util.Properties;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.statistic.DefaultTestStatisticValue;

public class DefaultValue {
    private static final int MAXIMUM_ITERATIONS = 5000;
    private static final double ROBUST_ESTIMATION_LIMIT = 3.5;
    private static final double CONFIDENCE_LEVEL = 1.0 - DefaultTestStatisticValue.getProbabilityValue();
    private static final EstimationType ESTIMATION_TYPE = EstimationType.L2NORM;
    private static final boolean APPLY_VARIANCE_OF_UNIT_WEIGHT = Boolean.TRUE;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/leastsquares.default";
        try {
            try {
                if (DefaultValue.class.getClassLoader().getResourceAsStream("properties/leastsquares.default") != null) {
                    bis = new BufferedInputStream(DefaultValue.class.getClassLoader().getResourceAsStream("properties/leastsquares.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultValue() {
    }

    public static EstimationType getEstimationType() {
        EstimationType value = null;
        try {
            value = EstimationType.valueOf(PROPERTIES.getProperty("ESTIMATION_TYPE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value != null ? value : ESTIMATION_TYPE;
    }

    public static int getMaximumNumberOfIterations() {
        int value = -1;
        try {
            value = Integer.parseInt(PROPERTIES.getProperty("MAXIMUM_ITERATIONS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0 ? value : 5000;
    }

    public static double getRobustEstimationLimit() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("ROBUST_ESTIMATION_LIMIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 ? value : 3.5;
    }

    public static boolean applyVarianceOfUnitWeight() {
        boolean value = APPLY_VARIANCE_OF_UNIT_WEIGHT;
        try {
            value = PROPERTIES.getProperty("APPLY_VARIANCE_OF_UNIT_WEIGHT") != null && PROPERTIES.getProperty("APPLY_VARIANCE_OF_UNIT_WEIGHT").equalsIgnoreCase("FALSE") ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static double getConfidenceLevel() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("CONFIDENCE_LEVEL"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 && value < 1.0 ? value : CONFIDENCE_LEVEL;
    }
}

