/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameters;

public class ConfidenceRegion {
    private final Matrix covarianceMatrix;
    private final int dimension;
    private double degreeOfFreedom;
    private double varianceOfUnitWeight;
    private double[] eigenvalues;
    private double[] minimalDetectableBias;
    private Matrix eigenvectors;
    private final int[] sortOrder;
    private double[] standardEllipseAxes = new double[2];
    private double standardEllipseAngle = 0.0;
    private TestStatisticParameters confidenceRegionParameters;

    public ConfidenceRegion(TestStatisticParameters confidenceRegionParameters, Matrix covarianceMatrix, double varianceOfUnitWeight, double degreeOfFreedom) throws IllegalArgumentException, NotConvergedException {
        this.confidenceRegionParameters = confidenceRegionParameters;
        this.degreeOfFreedom = degreeOfFreedom > 0.0 ? degreeOfFreedom : Double.POSITIVE_INFINITY;
        this.varianceOfUnitWeight = varianceOfUnitWeight > 0.0 ? varianceOfUnitWeight : 1.0;
        this.covarianceMatrix = covarianceMatrix;
        this.dimension = covarianceMatrix.numColumns();
        if (!covarianceMatrix.isSquare()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " Matrix must be a squared matrix!");
        }
        int i = 0;
        while (i < covarianceMatrix.numColumns()) {
            int j = 0;
            while (j < covarianceMatrix.numRows()) {
                if (Double.isInfinite(covarianceMatrix.get(i, j)) || Double.isNaN(covarianceMatrix.get(i, j))) {
                    throw new IllegalArgumentException(String.valueOf(this.getClass()) + " Matrix contains Inf or NaN values! " + i + "x" + j + " " + covarianceMatrix.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        this.SVD();
        this.sortOrder = this.getSortOrder();
        this.calculateStandardConfidenceEllipseParameters();
    }

    public ConfidenceRegion(Matrix covarianceMatrix) throws IllegalArgumentException, NotConvergedException {
        this(null, covarianceMatrix, 1.0, Double.POSITIVE_INFINITY);
    }

    public double getConfidenceRegionAxis(int index) {
        return Math.sqrt(this.varianceOfUnitWeight * this.getEigenvalue(index) * (double)this.dimension * this.getQuantile(this.dimension));
    }

    public double[] getEulerAngles() {
        if (this.dimension == 1) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double r32 = 0.0;
        double r31 = 0.0;
        double r22 = 0.0;
        double r21 = 0.0;
        double r33 = 0.0;
        double r23 = 0.0;
        double r13 = 0.0;
        double r12 = 0.0;
        double r11 = 0.0;
        double rz = 0.0;
        double ry = 0.0;
        double rx = 0.0;
        r11 = this.eigenvectors.get(0, this.sortOrder[0]);
        r12 = this.eigenvectors.get(0, this.sortOrder[1]);
        r21 = this.eigenvectors.get(1, this.sortOrder[0]);
        r22 = this.eigenvectors.get(1, this.sortOrder[1]);
        if (this.dimension == 2) {
            double det2 = r11 * r22 - r12 * r21;
            if (det2 < 0.0) {
                r11 = -r11;
                r21 = -r21;
            }
            rz = MathExtension.MOD(Math.atan2(-r12, r11), Math.PI * 2);
        } else if (this.dimension == 3) {
            r13 = this.eigenvectors.get(0, this.sortOrder[2]);
            r23 = this.eigenvectors.get(1, this.sortOrder[2]);
            r31 = this.eigenvectors.get(2, this.sortOrder[0]);
            r32 = this.eigenvectors.get(2, this.sortOrder[1]);
            r33 = this.eigenvectors.get(2, this.sortOrder[2]);
            double det3 = r11 * r22 * r33 + r12 * r23 * r31 + r13 * r21 * r32 - r13 * r22 * r31 - r12 * r21 * r33 - r11 * r23 * r32;
            if (det3 < 0.0) {
                r11 = -r11;
                r21 = -r21;
                r31 = -r31;
            }
            rx = MathExtension.MOD(Math.atan2(-r23, r33), Math.PI * 2);
            ry = MathExtension.MOD(Math.atan2(r13, Math.hypot(r23, r33)), Math.PI * 2);
            rz = MathExtension.MOD(Math.atan2(-r12, r11), Math.PI * 2);
        }
        return new double[]{rx, ry, rz};
    }

    public double getEigenvalue(int index) {
        return this.eigenvalues[this.sortOrder[index]];
    }

    public Vector getEigenVector(int index) {
        DenseVector eigenvector = new DenseVector(this.dimension);
        int i = 0;
        while (i < this.dimension) {
            eigenvector.set(i, this.eigenvectors.get(i, this.sortOrder[index]));
            ++i;
        }
        return eigenvector;
    }

    public double getMinimalDetectableBias(int index) {
        return this.minimalDetectableBias[index];
    }

    private void SVD() throws NotConvergedException {
        SVD uwv = SVD.factorize((Matrix)this.covarianceMatrix);
        this.eigenvectors = uwv.getU();
        this.eigenvalues = uwv.getS();
        double maxEval = 0.0;
        int indexMaxEval = 0;
        int i = 0;
        while (i < this.dimension) {
            double eval = Math.abs(this.eigenvalues[i]);
            if (eval > maxEval) {
                maxEval = eval;
                indexMaxEval = i;
            }
            ++i;
        }
        this.minimalDetectableBias = new double[this.dimension];
        i = 0;
        while (i < this.dimension) {
            this.minimalDetectableBias[i] = Math.sqrt(maxEval) * this.eigenvectors.get(i, indexMaxEval);
            ++i;
        }
    }

    private final int[] getSortOrder() {
        int[] order = new int[this.dimension];
        if (this.dimension == 2) {
            if (this.eigenvalues[0] > this.eigenvalues[1]) {
                order[0] = 0;
                order[1] = 1;
            } else {
                order[0] = 1;
                order[1] = 0;
            }
        }
        if (this.dimension == 3) {
            double maxValue = Math.max(this.eigenvalues[0], Math.max(this.eigenvalues[1], this.eigenvalues[2]));
            double minValue = Math.min(this.eigenvalues[0], Math.min(this.eigenvalues[1], this.eigenvalues[2]));
            int i = 0;
            while (i < this.dimension) {
                if (this.eigenvalues[i] == maxValue) {
                    order[0] = i;
                } else if (this.eigenvalues[i] == minValue) {
                    order[2] = i;
                } else {
                    order[1] = i;
                }
                ++i;
            }
        }
        return order;
    }

    public double getConfidenceEllipseAxis(int index) {
        int dimension = Math.min(this.dimension, 2);
        return this.standardEllipseAxes[index] * Math.sqrt(this.varianceOfUnitWeight * (double)dimension * this.getQuantile(dimension));
    }

    public double getConfidenceEllipseAngle() {
        return this.standardEllipseAngle;
    }

    private void calculateStandardConfidenceEllipseParameters() {
        if (this.dimension > 1) {
            double qxy;
            double w;
            double qyy;
            double qxx = this.covarianceMatrix.get(0, 0);
            double a = qxx + (qyy = this.covarianceMatrix.get(1, 1)) + (w = Math.sqrt((qxx - qyy) * (qxx - qyy) + 4.0 * (qxy = this.covarianceMatrix.get(0, 1)) * qxy)) > 0.0 ? Math.sqrt(0.5 * (qxx + qyy + w)) : 0.0;
            double b = qxx + qyy - w > 0.0 ? Math.sqrt(0.5 * (qxx + qyy - w)) : 0.0;
            this.standardEllipseAxes[0] = a;
            this.standardEllipseAxes[1] = b;
            this.standardEllipseAngle = MathExtension.MOD(0.5 * Math.atan2(2.0 * qxy, qxx - qyy), Math.PI * 2);
        } else {
            this.standardEllipseAxes[0] = Math.sqrt(this.covarianceMatrix.get(0, 0));
            this.standardEllipseAxes[1] = 0.0;
            this.standardEllipseAngle = 0.0;
        }
    }

    private double getQuantile(int dimension) {
        if (this.confidenceRegionParameters != null) {
            return this.confidenceRegionParameters.getTestStatisticParameter(dimension, this.degreeOfFreedom).getQuantile();
        }
        return 1.0;
    }
}

